% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_wider.R
\name{pivot_wider}
\alias{pivot_wider}
\title{Pivot data from long to wide}
\usage{
pivot_wider(
  data,
  id_cols = NULL,
  values_from = "Value",
  names_from = "Name",
  names_sep = "_",
  names_prefix = "",
  names_glue = NULL,
  values_fill = NULL,
  ...
)
}
\arguments{
\item{data}{\code{data.frame}. The data to pivot.}

\item{id_cols}{\code{character(1)}. The name of the column that identifies the rows. If \code{NULL}, it will use all the unique
rows.}

\item{values_from}{\code{character(n)}. The name of the column that contains the values to be used as future variable
values.}

\item{names_from}{\code{character(n)}. The name of the column(s) that contains the levels to be used as future column
names.}

\item{names_sep}{\code{character(1)}. If \code{names_from} or \code{values_from} contains multiple variables, this will be used to
join their values together into a single string to use as a column name.}

\item{names_prefix}{\code{character(1)}. String added to the start of every variable name. This is particularly useful if
\code{names_from} is a numeric vector and you want to create syntactic variable names.}

\item{names_glue}{\code{character(1)}. Instead of \code{names_sep} and \code{names_prefix}, you can supply a
\href{https://glue.tidyverse.org/index.html}{glue specification} that uses the \code{names_from} columns to create custom
column names. Note that the only delimiters supported by \code{names_glue} are curly brackets, \verb{\{} and \verb{\}}.}

\item{values_fill}{\code{numeric(n)}. Optionally, a (scalar) value that will be used to replace missing values in the new
columns created.}

\item{...}{Not used for now.}
}
\value{
If a tibble was provided as input, \code{pivot_wider()} also returns a
tibble. Otherwise, it returns a data frame.
}
\description{
\code{pivot_wider()} "widens" data, increasing the number of columns and decreasing the number of rows. The inverse
transformation is \code{\link[=pivot_longer]{pivot_longer()}}.
}
\examples{
data_long <- read.table(header = TRUE, text = "
 subject sex condition measurement
       1   M   control         7.9
       1   M     cond1        12.3
       1   M     cond2        10.7
       2   F   control         6.3
       2   F     cond1        10.6
       2   F     cond2        11.1
       3   F   control         9.5
       3   F     cond1        13.1
       3   F     cond2        13.8
       4   M   control        11.5
       4   M     cond1        13.4
       4   M     cond2        12.9")


pivot_wider(
  data_long,
  id_cols = "subject",
  names_from = "condition",
  values_from = "measurement"
)

pivot_wider(
  data_long,
  id_cols = "subject",
  names_from = "condition",
  values_from = "measurement",
  names_prefix = "Var.",
  names_sep = "."
)

production <- expand.grid(
  product = c("A", "B"),
  country = c("AI", "EI"),
  year = 2000:2014
) \%>\%
  filter((product == "A" & country == "AI") | product == "B") \%>\%
  mutate(production = rnorm(nrow(.)))

pivot_wider(
  production,
  names_from = c("product", "country"),
  values_from = "production",
  names_glue = "prod_{product}_{country}"
)

}
