% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range.R
\name{step_range}
\alias{step_range}
\title{Scaling Numeric Data to a Specific Range}
\usage{
step_range(recipe, ..., role = NA, trained = FALSE, min = 0, max = 1,
  ranges = NULL)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables will be
scaled. See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{min}{A single numeric value for the smallest value in the range}

\item{max}{A single numeric value for the largest value in the range}

\item{ranges}{A character vector of variables that will be normalized. Note
that this is ignored until the values are determined by
\code{\link{prep.recipe}}. Setting this value will be ineffective.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_range} creates a \emph{specification} of a recipe step that will
  normalize numeric data to have a standard deviation of one.
}
\details{
Scaling data means that the standard deviation of a variable is
  divided out of the data. \code{step_range} estimates the variable standard
  deviations from the data used in the \code{training} argument of
  \code{prep.recipe}. \code{bake.recipe} then applies the scaling to new
  data sets using these standard deviations.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

ranged_trans <- rec \%>\%
  step_range(carbon, hydrogen)

ranged_obj <- prep(ranged_trans, training = biomass_tr)

transformed_te <- bake(ranged_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te
}
\concept{
preprocessing normalization_methods
}
\keyword{datagen}
