% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design_set.R
\name{plot.TrialDesignSummaries}
\alias{plot.TrialDesignSummaries}
\title{Plot Trial Design Summaries}
\usage{
\method{plot}{TrialDesignSummaries}(x, ..., type = 1L, grid = 1)
}
\arguments{
\item{x}{a \code{TrialDesignSummaries} object to plot.}

\item{...}{further arguments passed to or from other methods.}

\item{type}{The plot type (default = \code{1}). The following plot types are available:
\itemize{
\item \code{1}: creates a 'Boundaries' plot
\item \code{3}: creates a 'Stage Levels' plot
\item \code{4}: creates a 'Error Spending' plot
\item \code{5}: creates a 'Power and Early Stopping' plot
\item \code{6}: creates an 'Average Sample Size and Power / Early Stop' plot
\item \code{7}: creates an 'Power' plot
\item \code{8}: creates an 'Early Stopping' plot
\item \code{9}: creates an 'Average Sample Size' plot
\item \code{"all"}: creates all available plots and returns it as a grid plot or list
}}

\item{grid}{An integer value specifying the output of multiple plots.
By default (\code{1}) a list of \code{ggplot} objects will be returned.
If a \code{grid} value > 1 was specified, a grid plot will be returned
if the number of plots is <= specified \code{grid} value;
a list of \code{ggplot} objects will be returned otherwise.
If \code{grid = 0} is specified, all plots will be created using \code{\link[base]{print}} command
and a list of \code{ggplot} objects will be returned invisible.
Note that one of the following packages must be installed to create a grid plot:
'ggpubr', 'gridExtra', or 'cowplot'.}
}
\description{
Generic function to plot a \code{TrialDesignSummaries} object.
}
