% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set-if-null}
\alias{set-if-null}
\alias{\%||\%}
\alias{\%iff\%}
\title{Set If or If Not \code{NULL}}
\usage{
x \%||\% y

x \%iff\% y
}
\arguments{
\item{x}{An object to test}

\item{y}{A default value}
}
\value{
For \code{\%||\%}: \code{y} if \code{x} is \code{NULL};
otherwise \code{x}

For \code{\%iff\%}: \code{y} if \code{x} is \strong{not}
\code{NULL}; otherwise \code{x}
}
\description{
Set a default value depending on if an object is \code{NULL}
}
\examples{
# Set if NULL
1 \%||\% 2
NULL \%||\% 2

# Set if *not* NULL
1 \%iff\% 2
NULL \%iff\% 2

}
\seealso{
\code{\link[rlang:op-null-default]{rlang::\%||\%}}
}
\author{
For \code{\%||\%}: \pkg{rlang} developers
}
\concept{utils}
