% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_and_capture.R
\name{run_and_capture}
\alias{run_and_capture}
\title{Run code and capture the output}
\usage{
run_and_capture(
  code,
  echo = TRUE,
  results = TRUE,
  output = results,
  capture_warnings = FALSE,
  capture_messages = results,
  muffle_warnings = FALSE,
  muffle_messages = TRUE
)
}
\arguments{
\item{code}{character vector or expression with the code to run}

\item{echo}{the code in \code{code} is repeated in the output.}

\item{results}{include the results of running the code in the output.}

\item{output}{include output that is explicitly written to the output, for
example using \code{print} statements.}

\item{capture_warnings}{include warnings in the output.}

\item{capture_messages}{include messages in the output.}

\item{muffle_warnings}{do not show warnings in the console.}

\item{muffle_messages}{do not show messages in the console.}
}
\value{
Returns a list. Each item of the list contains a list with elements
\code{input} and \code{output}. \code{input} contains the command/code and
\code{output} the corresponding output. These are empty vectors when there is
no output or when input and output are suppressed using one of the
\code{echo}/\code{results}/\code{output} statements.
}
\description{
Run code and capture the output
}
