% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gpt.R
\name{plot_gpt}
\alias{plot_gpt}
\title{Plot grouped proportional tables}
\usage{
plot_gpt(
  data,
  x,
  y,
  grp,
  colors = "metro",
  geom.size = 2.5,
  shape.fill.color = "#f0f0f0",
  shapes = c(15, 16, 17, 18, 21, 22, 23, 24, 25, 7, 8, 9, 10, 12),
  title = NULL,
  axis.labels = NULL,
  axis.titles = NULL,
  legend.title = NULL,
  legend.labels = NULL,
  wrap.title = 50,
  wrap.labels = 15,
  wrap.legend.title = 20,
  wrap.legend.labels = 20,
  axis.lim = NULL,
  grid.breaks = NULL,
  show.total = TRUE,
  annotate.total = TRUE,
  show.p = TRUE,
  show.n = TRUE
)
}
\arguments{
\item{data}{A data frame, or a grouped data frame.}

\item{x}{Categorical variable, where the proportion of each category in
\code{x} for the highest category of \code{y} will be printed
along the x-axis.}

\item{y}{Categorical or numeric variable. If not a binary variable, \code{y}
will be recoded into a binary variable, dichtomized at the highest
category and all remaining categories.}

\item{grp}{Grouping variable, which will define the y-axis}

\item{colors}{May be a character vector of color values in hex-format, valid
color value names (see \code{demo("colors")}) or a name of a pre-defined
color palette. Following options are valid for the \code{colors} argument:
\itemize{
  \item If not specified, a default color brewer palette will be used, which is suitable for the plot style.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{"bw"}, and plot-type is a line-plot, the plot is black/white and uses different line types to distinguish groups (see \href{https://strengejacke.github.io/sjPlot/articles/blackwhitefigures.html}{this package-vignette}).
  \item If \code{colors} is any valid color brewer palette name, the related palette will be used. Use \code{RColorBrewer::display.brewer.all()} to view all available palette names.
  \item There are some pre-defined color palettes in this package, see \code{\link{sjPlot-themes}} for details.
  \item Else specify own color values or names as vector (e.g. \code{colors = "#00ff00"} or \code{colors = c("firebrick", "blue")}).
}}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{shape.fill.color}{Optional color vector, fill-color for non-filled shapes}

\item{shapes}{Numeric vector with shape styles, used to map the different
categories of \code{x}.}

\item{title}{Character vector, used as plot title. By default,
\code{\link[sjlabelled]{response_labels}} is called to retrieve the label of
the dependent variable, which will be used as title. Use \code{title = ""}
to remove title.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{legend.title}{Character vector, used as legend title for plots that
have a legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{wrap.title}{Numeric, determines how many chars of the plot title are
displayed in one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{axis.lim}{Numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.
For multiple plot outputs (e.g., from \code{type = "eff"} or
\code{type = "slope"} in \code{\link{plot_model}}), \code{axis.lim} may
also be a list of vectors of length 2, defining axis limits for each
plot (only if non-faceted).}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis,
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{show.total}{Logical, if \code{TRUE}, a total summary line for all aggregated
\code{grp} is added.}

\item{annotate.total}{Logical, if \code{TRUE} and \code{show.total = TRUE},
the total-row in the figure will be highlighted with a slightly
shaded background.}

\item{show.p}{Logical, adds significance levels to values, or value and
variable labels.}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}
}
\value{
A ggplot-object.
}
\description{
Plot grouped proportional crosstables, where the proportion of
               each level of \code{x} for the highest category in \code{y}
               is plotted, for each subgroup of \code{grp}.
}
\details{
The p-values are based on \code{\link[stats]{chisq.test}} of \code{x}
           and \code{y} for each \code{grp}.
}
\examples{
data(efc)

# the proportion of dependency levels in female
# elderly, for each family carer's relationship
# to elderly
plot_gpt(efc, e42dep, e16sex, e15relat)

# proportion of educational levels in highest
# dependency category of elderly, for different
# care levels
plot_gpt(efc, c172code, e42dep, n4pstu)

}
