use strict;
use warnings;

use RT::Test tests => undef;

my ($base, $m) = RT::Test->started_ok;

my $user = RT::Test->load_or_create_user(
    Name            => 'ausername',
    EmailAddress    => 'user@example.com',
    Password        => 'password',
    Privileged      => 1,
);

ok $user->id, 'created user';

ok(
    RT::Test->set_rights(
        { Principal => 'privileged', Right => [qw(ModifySelf ShowTicket)] },
    ),
    "granted ModifySelf to privileged"
);

$m->login('ausername');

{
    $m->get_ok("$base/Prefs/Other.html");
    my $style = '../css/base';
    $m->submit_form_ok({
        with_fields => {
            WebDefaultStylesheet => $style,
        },
        button      => 'Update',
    }, 'update prefs');
    is(RT->Config->Get('WebDefaultStylesheet', $user), $style, 'set preference');

    SKIP: {
        skip "RT::User->Stylesheet wasn't backported", 1 unless $user->can("Stylesheet");
        is $user->Stylesheet, RT->Config->Get('WebDefaultStylesheet'), '$user->Stylesheet is the default';
    }

    $m->get_ok($base);
    $m->content_unlike(qr/<link.+?\Q$style\E/, "lack .. path in page <link>");
    $m->content_contains( RT->Config->Get('WebDefaultStylesheet') );
}

{
    $m->get_ok("$base/Prefs/Other.html");
    my $format = '/../../m/_elements/full_site_link';
    $m->submit_form_ok({
        form_name   => 'ModifyPreferences',
        fields      => {
            UsernameFormat => $format,
        },
        button      => 'Update',
    }, 'update prefs');
    $m->content_contains('saved');

    my $ticket = RT::Test->create_ticket(
        Queue       => 'General',
        Subject     => 'test ticket',
        Requestor   => 'user@example.com',
    );
    ok $ticket->id, 'created ticket';
    $m->get_ok($base . "/Ticket/Display.html?id=" . $ticket->id);
    $m->content_lacks('NotMobile', "lacks NotMobile");
    $m->next_warning_like(qr/UsernameFormat/, 'caught UsernameFormat warning');
}

{
    $m->get_ok("$base/Helpers/Toggle/ShowRequestor?Status=/../../../Elements/Logo;Requestor=root");
    $m->content_lacks('logo', "didn't display /Elements/Logo");
    $m->content_contains('Results.html', "found link to search results");
}

done_testing;
