#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# ----------------------------------------------------------------------
#  simple toolbar with mutually-exclusive tools
# ----------------------------------------------------------------------

proc toolbar_create {win {origin "top"} {command ""}} {
    global toolbar_data

    frame $win -class Toolbar

    set toolbar_data($win-current) ""
    set toolbar_data($win-origin) $origin
    set toolbar_data($win-command) $command
    return $win
}

proc toolbar_add {win tool image} {
    global toolbar_data

    set label "$win.tool-$tool"
    label $label -borderwidth 2 -relief raised -image $image
    pack $label -side $toolbar_data($win-origin) -fill both

    bind $label <ButtonPress-1> [list toolbar_select $win $tool]

    if {[llength [pack slaves $win]] == 1} {
        # after idle [list toolbar_select $win $tool]
        toolbar_select $win $tool
    }
    return $label
}

proc toolbar_configure {win tool} {
    global toolbar_data

    if {$toolbar_data($win-current) != ""} {
        set label "$win.tool-$toolbar_data($win-current)"
        $label configure -relief raised
    }
    set label "$win.tool-$tool"
    $label configure -relief sunken

    set toolbar_data($win-current) $tool
}

# use also callback
proc toolbar_select {win tool} {
    global toolbar_data

    toolbar_configure $win $tool

    if {$toolbar_data($win-command) != ""} {
        set cmd [percent_subst %t $toolbar_data($win-command) $tool]
        uplevel #0 $cmd
    }
}

proc toolbar_get {win} {
    global toolbar_data
    return $toolbar_data($win-current)
}
