#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

Float alpha = 0.5; // the singularity at r=0

Float u(const point& x)
{
    Float r = sqrt(x[0]*x[0] + x[1]*x[1]);
    if (1 + r == Float(1)) return 0;
    Float theta = atan2(x[1], x[0]);  // in ]-pi,pi]
    return pow(r,alpha)*sin(alpha*theta);
}   
int main(int argc, char**argv)
{
    // (a) load approximate solution from standard input
    field u_h;
    cin >> u_h;

    // (b) get finite-dimensional space
    space Vh = u_h.get_space();

    // (c) build interpolation of the exact solution
    field pi_h_u = interpolate(Vh, u);

    // (d) compute and print the error
    field eh = abs(pi_h_u - u_h);
    int digits10 = numeric_limits<Float>::digits10;
    cout << setprecision(digits10) << eh;

    // (e) build mass matrix for L2-norm and output the norms
    form m(Vh, Vh, "mass");
    cerr << "error_inf "  << eh.max_abs()       << endl;
    cerr << "error_l2  "  << sqrt(m(eh,eh)) << endl;
    return 0;
}
