#include "rheolef/geo_element.h"
#include <boost/numeric/ublas/matrix.hpp>
using namespace std;
using namespace rheolef;
namespace ublas = boost::numeric::ublas;

void dump (size_t order, int orient, size_t shift) 
{
  if (orient != 1 && orient != -1) {
    cerr << "invalid orientation " << orient << endl;
    exit (1);
  }
  if (shift > 3) {
    cerr << "invalid shift " << shift << endl;
    exit (1);
  }
  ublas::matrix<size_t> rot (order+1,order+1);
  size_t coord[4];
  for (size_t j = 1; j <= order-1; j++) {
    for (size_t i = 1; i <= order-1; i++) {
      size_t loc_iqua_j = (order-1)*(j-1) + (i-1);
      rot(i,j) = geo_element::fix_quadrangle_indirect (orient, shift, order, loc_iqua_j);
    }
  }
  cout << "order = "<<order<<", shift = " << shift << ", orientation = " << orient << endl;
  for (size_t j = order-1; j >= 1; j--) {
    for (size_t i = 1; i <= order-1; i++) {
      cout << setw(5) << rot(i,j) << " ";
    }
    cout << endl;
  }
  cout << endl;
}
int main(int argc, char**argv) {
  if (argc < 2) {
    cerr << "usage: prog order orient shift" << endl;
    exit (1);
  }
  size_t order  = argc > 1 ? atoi(argv[1]) : 5;
  for (size_t shift = 0; shift < 4; shift++) {
    dump (order,  1, shift);
    dump (order, -1, shift);
  }
}
