///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// 2D_s_D_s matrix on a surface, as defined by a level set
//
#include "2D_s_D_s.h"
#include "rheolef/ublas_matrix_range.h"
namespace rheolef {
extern void compute_matrix_2D_s_D_s (const geo_element& K, const ublas::vector<point>& x, const ublas::vector<Float>& f, ublas::matrix<Float>& mk);
} // namespace rheolef
using namespace rheolef;
using namespace std;
using namespace ublas;

void 
_2D_s_D_s::operator() (const geo_element& K, ublas::matrix<Float>& b) const
{
    size_type nloc = K.size();
    ublas::vector<point> x (nloc);
    ublas::vector<Float> f (nloc);
    tiny_vector<size_t> bgd_idof (nloc);
    size_type d = coordinate_dimension();
    b.resize (d*nloc, d*nloc);
    const space& Bh = get_first_space();
    Bh.set_global_dof (K, bgd_idof);
    const field& phi_h = _wh;
    const geo& bgd_lambda = phi_h.get_geo();
    for (size_t iloc = 0; iloc < nloc; iloc++) {
      x[iloc] = bgd_lambda.vertex(K[iloc]);
      f[iloc] = phi_h.at (bgd_idof[iloc]);
    }
    compute_matrix_2D_s_D_s (K, x, f, b);
}
void
_2D_s_D_s::check_after_initialize () const
{
  size_type d = coordinate_dimension();
  check_macro (
	d == get_second_space().n_component(),
	"unsupported non-vectorial second space for `2D_s_D_s' form");
  check_macro (
	d == get_first_space().n_component(),
	"unsupported non-vectorial first space for `2D_s_D_s' form");
  check_macro (get_first_space().get_approx()  == "P1", "`2D_s_D_s' form: P1 approx required");
  check_macro (get_second_space().get_approx() == "P1", "`2D_s_D_s' form: P1 approx required");
  check_macro (is_weighted(), "`2D_s_D_s' form may specify the level set function");
}
