#ifndef _RHEO_FORM_ASSEMBLY_H
#define _RHEO_FORM_ASSEMBLY_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// main assembly algorithm
//
// authors: Pierre.Saramito@imag.fr
//
// date: 7 july 1997
//
#include "rheolef/form.h"
#include "rheolef/form_element.h"
namespace rheolef { 

void
form_assembly (class form& a, const form_element& form_e, bool locked_boundaries=false);

void
form_assembly_discontinuous_galerkin (class form& a, const form_element& form_e);

void
form_assembly_discontinuous_galerkin_bdr (class form& a, const form_element& form_e);

void
form_bdr_assembly (class form& a, const form_element& form_e, const class domain& d);

void
form_hybrid_assembly (class form& a, const form_element& form_e, const class domain& d);

void
form_band_assembly (class form& a, const form_element& form_e, const class band& bh);

}// namespace rheolef
#endif // _RHEO_FORM_ASSEMBLY_H
