// Copyright 2016-2024 dbus-secret-service Contributors
//
// Licensed under the Apache License, Version 2.0, <LICENSE-APACHE or
// http://apache.org/licenses/LICENSE-2.0> or the MIT license <LICENSE-MIT or
// http://opensource.org/licenses/MIT>, at your option. This file may not be
// copied, modified, or distributed except according to those terms.

// This code generated by dbus-codegen-rust from xml generated by
// using dbus-send to introspect a collection object path.
// Generation command without --file argument:
// `dbus-codegen-rust -i org.freedesktop.Secret. --interfaces=org.freedesktop.Secret.Collection -c blocking`
// See https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

#[allow(dead_code)]
pub trait Collection {
    fn delete(&self) -> Result<dbus::Path<'static>, dbus::Error>;
    fn search_items(
        &self,
        attributes: ::std::collections::HashMap<&str, &str>,
    ) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn create_item(
        &self,
        properties: arg::PropMap,
        secret: (dbus::Path, Vec<u8>, Vec<u8>, &str),
        replace: bool,
    ) -> Result<(dbus::Path<'static>, dbus::Path<'static>), dbus::Error>;
    fn items(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
    fn label(&self) -> Result<String, dbus::Error>;
    fn set_label(&self, value: String) -> Result<(), dbus::Error>;
    fn locked(&self) -> Result<bool, dbus::Error>;
    fn created(&self) -> Result<u64, dbus::Error>;
    fn modified(&self) -> Result<u64, dbus::Error>;
}

#[derive(Debug)]
pub struct CollectionItemCreated {
    pub item: dbus::Path<'static>,
}

impl arg::AppendAll for CollectionItemCreated {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.item, i);
    }
}

impl arg::ReadAll for CollectionItemCreated {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(CollectionItemCreated { item: i.read()? })
    }
}

impl dbus::message::SignalArgs for CollectionItemCreated {
    const NAME: &'static str = "ItemCreated";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Collection";
}

#[derive(Debug)]
pub struct CollectionItemDeleted {
    pub item: dbus::Path<'static>,
}

impl arg::AppendAll for CollectionItemDeleted {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.item, i);
    }
}

impl arg::ReadAll for CollectionItemDeleted {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(CollectionItemDeleted { item: i.read()? })
    }
}

impl dbus::message::SignalArgs for CollectionItemDeleted {
    const NAME: &'static str = "ItemDeleted";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Collection";
}

#[derive(Debug)]
pub struct CollectionItemChanged {
    pub item: dbus::Path<'static>,
}

impl arg::AppendAll for CollectionItemChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.item, i);
    }
}

impl arg::ReadAll for CollectionItemChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(CollectionItemChanged { item: i.read()? })
    }
}

impl dbus::message::SignalArgs for CollectionItemChanged {
    const NAME: &'static str = "ItemChanged";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Collection";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> Collection
    for blocking::Proxy<'a, C>
{
    fn delete(&self) -> Result<dbus::Path<'static>, dbus::Error> {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call("org.freedesktop.Secret.Collection", "Delete", ())
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn search_items(
        &self,
        attributes: ::std::collections::HashMap<&str, &str>,
    ) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call(
            "org.freedesktop.Secret.Collection",
            "SearchItems",
            (attributes,),
        )
        .and_then(|r: (Vec<dbus::Path<'static>>,)| Ok(r.0))
    }

    fn create_item(
        &self,
        properties: arg::PropMap,
        secret: (dbus::Path, Vec<u8>, Vec<u8>, &str),
        replace: bool,
    ) -> Result<(dbus::Path<'static>, dbus::Path<'static>), dbus::Error> {
        self.method_call(
            "org.freedesktop.Secret.Collection",
            "CreateItem",
            (properties, secret, replace),
        )
    }

    fn items(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Collection",
            "Items",
        )
    }

    fn label(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Collection",
            "Label",
        )
    }

    fn locked(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Collection",
            "Locked",
        )
    }

    fn created(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Collection",
            "Created",
        )
    }

    fn modified(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Collection",
            "Modified",
        )
    }

    fn set_label(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(
            self,
            "org.freedesktop.Secret.Collection",
            "Label",
            value,
        )
    }
}
