// -------------------------------------------------------
// EGM96s 
// 
// Lemoine F.G., Kenyon S.C., Factor J.K., Trimmer R.G., Pavlis N.K.,
// Chinn D.S., Cox C.M., Klosko S.M., Luthcke S.B., Torrence M.H.,
// Wang Y.M., Williamson R.G., Pavlis E.C., Rapp R.H., Olson T.R.;
// The Development of the Joint NASA GSFC and the National
// Imagery and Mapping Agency (NIMA) Geopotential ModelEGM96;
// NASA Technical Paper NASA/TP1998206861,
// Goddard Space Flight Center, Greenbelt, USA, 1998
// -------------------------------------------------------
// Scilab syntax
// Original data from: http://icgem.gfz-potsdam.de/ICGEM
// -------------------------------------------------------

// gravitational constant (m^3/s^2)
data.mu = 0.3986004415E+15; 

// equatorial radius (m)
data.er = 0.6378136300E+07; 

// Cnm, Snm normalized coefficients
// 1: degree (n)
// 2: order (m)
// 3: Cnm 
// 4: Snm 

// NB: line 2 0 is originally: 
// 2    0 -.484165340e-03  .116275534e-10 
// (second term = drift => replaced by 0)
data.coef = [ ..
    0    0  .100000000e+01  .000000000e+00 
    1    0  .000000000e+00  .000000000e+00 
    2    0 -.484165340e-03  .000000000e+00 
    3    0  .957154670e-06  .000000000e+00 
    4    0  .539712300e-06  .000000000e+00 
    5    0  .686667580e-07  .000000000e+00 
    6    0 -.149275200e-06  .000000000e+00 
    7    0  .904496960e-07  .000000000e+00 
    8    0  .485720660e-07  .000000000e+00 
    9    0  .280813120e-07  .000000000e+00 
   10    0  .535731690e-07  .000000000e+00 
   11    0 -.513990330e-07  .000000000e+00 
   12    0  .373937420e-07  .000000000e+00 
   13    0  .420774770e-07  .000000000e+00 
   14    0 -.245245810e-07  .000000000e+00 
   15    0  .142148620e-08  .000000000e+00 
   16    0 -.371010320e-08  .000000000e+00 
   17    0  .199673750e-07  .000000000e+00 
   18    0  .712572500e-08  .000000000e+00 
   19    0 -.428509810e-08  .000000000e+00 
   20    0  .183759370e-07  .000000000e+00 
   21    0  .864617400e-08  .000000000e+00 
   22    0 -.111199390e-07  .000000000e+00 
   23    0 -.255120350e-07  .000000000e+00 
   24    0  .228891170e-08  .000000000e+00 
   25    0  .810295080e-08  .000000000e+00 
   26    0  .340876810e-09  .000000000e+00 
   27    0 -.262591510e-08  .000000000e+00 
   28    0 -.469504050e-08  .000000000e+00 
   29    0  .761399880e-09  .000000000e+00 
   30    0  .727687460e-08  .000000000e+00 
   31    0  .261836360e-08  .000000000e+00 
   32    0 -.534474480e-08  .000000000e+00 
   33    0  .126354820e-09  .000000000e+00 
   34    0 -.809631230e-08  .000000000e+00 
   35    0  .413813060e-08  .000000000e+00 
   36    0 -.506340130e-08  .000000000e+00 
   37    0 -.332834420e-08  .000000000e+00 
   38    0 -.497111100e-08  .000000000e+00 
   39    0 -.433661430e-08  .000000000e+00 
   40    0 -.200544800e-08  .000000000e+00 
   41    0  .116284170e-08  .000000000e+00 
   42    0  .136327870e-08  .000000000e+00 
   43    0  .619750990e-08  .000000000e+00 
   44    0  .113825390e-09  .000000000e+00 
   45    0  .659210860e-08  .000000000e+00 
   46    0 -.257025350e-08  .000000000e+00 
   47    0  .494162630e-08  .000000000e+00 
   48    0 -.215429380e-08  .000000000e+00 
   49    0  .189877780e-08  .000000000e+00 
   50    0 -.515034680e-09  .000000000e+00 
   51    0  .151498540e-08  .000000000e+00 
   52    0  .297569420e-08  .000000000e+00 
   53    0  .145932850e-08  .000000000e+00 
   54    0  .243075750e-08  .000000000e+00 
   55    0 -.107911020e-08  .000000000e+00 
   56    0 -.119319910e-08  .000000000e+00 
   57    0 -.208641720e-08  .000000000e+00 
   58    0 -.118493900e-08  .000000000e+00 
   59    0 -.115093630e-08  .000000000e+00 
   60    0 -.270842370e-09  .000000000e+00 
   61    0 -.105222880e-09  .000000000e+00 
   62    0  .567083350e-09  .000000000e+00 
   63    0 -.116599260e-09  .000000000e+00 
   64    0  .175568300e-09  .000000000e+00 
   65    0 -.234338120e-09  .000000000e+00 
   66    0 -.370897660e-09  .000000000e+00 
   67    0  .700660290e-10  .000000000e+00 
   68    0 -.226160670e-09  .000000000e+00 
   69    0  .351629950e-09  .000000000e+00 
   70    0  .197578750e-09  .000000000e+00 
    1    1  .000000000e+00  .000000000e+00 
    2    1 -.403371018e-11  .325062804e-10 
    3    1  .202992860e-05  .248453320e-06 
    4    1 -.536248860e-06 -.473399000e-06 
    5    1 -.621297740e-07 -.941990410e-07 
    6    1 -.762021070e-07  .260074250e-07 
    7    1  .279770010e-06  .947349390e-07 
    8    1  .238684940e-07  .596681920e-07 
    9    1  .142851540e-06  .233211820e-07 
   10    1  .826726920e-07 -.132566020e-06 
   11    1  .155612540e-07 -.295682470e-07 
   12    1 -.525231780e-07 -.424983280e-07 
   13    1 -.516812150e-07  .423529940e-07 
   14    1 -.208359840e-07  .293783860e-07 
   15    1  .963730700e-08  .810372420e-08 
   16    1  .293305140e-07  .312951290e-07 
   17    1 -.234115130e-07 -.292454260e-07 
   18    1  .270338780e-08 -.377670600e-07 
   19    1 -.117072130e-07 -.115668030e-08 
   20    1  .980910290e-08  .574353150e-08 
   21    1 -.131447900e-07  .326833420e-07 
   22    1  .128573170e-07 -.141963320e-08 
   23    1  .591309550e-08  .145092910e-07 
   24    1 -.134971310e-08 -.633511660e-08 
   25    1  .950313660e-08 -.885246770e-08 
   26    1 -.262412390e-08 -.271089350e-08 
   27    1 -.716178210e-10  .509046170e-08 
   28    1 -.481378380e-08  .564055560e-08 
   29    1  .564232550e-08 -.126971080e-07 
   30    1  .114887740e-08  .432424270e-09 
   31    1  .559399140e-08 -.151048760e-07 
   32    1 -.395068240e-08  .176438030e-09 
   33    1 -.348433110e-08 -.192314980e-08 
   34    1 -.102860530e-08  .985888660e-08 
   35    1 -.106480760e-07 -.594168510e-08 
   36    1  .826534080e-09  .325198900e-08 
   37    1 -.407509340e-08 -.245568160e-08 
   38    1  .158643790e-08  .118420980e-08 
   39    1 -.954247060e-09  .782937790e-09 
   40    1  .126690410e-08  .193599110e-08 
   41    1 -.189701540e-08  .952158370e-09 
   42    1  .906280080e-09 -.589298650e-09 
   43    1 -.111239710e-08 -.196844460e-08 
   44    1  .149959490e-08  .117299030e-09 
   45    1  .556736890e-09 -.118516900e-08 
   46    1  .213057080e-09  .199542110e-08 
   47    1  .104408880e-08 -.156860180e-09 
   48    1 -.287052530e-09  .148129060e-08 
   49    1 -.135821190e-09  .275397550e-09 
   50    1 -.851793040e-09  .515301920e-09 
   51    1 -.261512470e-09  .887957300e-09 
   52    1 -.851514190e-09  .118877660e-09 
   53    1  .186524660e-09  .333671660e-09 
   54    1 -.832985510e-10 -.272283750e-09 
   55    1  .199511830e-09  .476230450e-09 
   56    1  .257521240e-09 -.148448600e-09 
   57    1 -.704245010e-10  .187730640e-09 
   58    1  .263735340e-09  .247721300e-09 
   59    1 -.279408640e-09 -.520530510e-09 
   60    1  .117707370e-09 -.657675240e-10 
   61    1  .207918050e-10 -.275009810e-09 
   62    1  .690375260e-10 -.200239670e-09 
   63    1  .144923350e-09  .211530950e-10 
   64    1  .158381190e-10 -.533728870e-10 
   65    1  .946379910e-10  .763241240e-10 
   66    1 -.715582460e-10  .299703620e-10 
   67    1 -.354147180e-10  .605830190e-10 
   68    1 -.655959780e-10  .117500830e-09 
   69    1 -.598740320e-10  .631622460e-10 
   70    1 -.596097730e-10  .190295980e-10 
    2    2  .243920230e-05 -.140020060e-05 
    3    2  .904685220e-06 -.618942660e-06 
    4    2  .350533470e-06  .662728710e-06 
    5    2  .652584720e-06 -.323524050e-06 
    6    2  .486246280e-07 -.373765600e-06 
    7    2  .329373800e-06  .931313760e-07 
    8    2  .794472650e-07  .653817010e-07 
    9    2  .232591610e-07 -.320225350e-07 
   10    2 -.930069160e-07 -.509176350e-07 
   11    2  .176474920e-07 -.990417860e-07 
   12    2  .126723930e-07  .310501080e-07 
   13    2  .575390070e-07 -.627420400e-07 
   14    2 -.349604380e-07 -.451952820e-08 
   15    2 -.235815940e-07 -.315979500e-07 
   16    2 -.253909000e-07  .289765690e-07 
   17    2 -.167992910e-07  .870476840e-08 
   18    2  .151784270e-07  .109332580e-07 
   19    2  .332457770e-07 -.379892800e-08 
   20    2  .191131040e-07  .154877660e-07 
   21    2 -.534500760e-08  .365639550e-08 
   22    2 -.253195570e-07  .495623400e-09 
   23    2 -.124580910e-07 -.279345990e-08 
   24    2 -.104093910e-10  .149992150e-07 
   25    2  .174136430e-07  .784944700e-08 
   26    2 -.234383700e-08  .105924350e-07 
   27    2  .167637370e-08 -.207132850e-08 
   28    2 -.159247850e-07 -.567605450e-08 
   29    2 -.131353400e-08 -.220337200e-08 
   30    2 -.723295900e-08 -.157694640e-08 
   31    2  .835851890e-08  .370198570e-08 
   32    2  .723863780e-08 -.296413150e-08 
   33    2 -.107370310e-07  .149512000e-08 
   34    2  .836780560e-08  .247491690e-09 
   35    2 -.160831970e-07 -.270184390e-08 
   36    2  .876867650e-09  .839762450e-09 
   37    2 -.172857310e-08 -.260487160e-08 
   38    2  .107434700e-08 -.133938210e-08 
   39    2 -.234069690e-08 -.122347900e-08 
   40    2 -.110588960e-08 -.348239910e-09 
   41    2 -.107982570e-08  .434748690e-09 
   42    2 -.140437210e-08  .149746320e-08 
   43    2 -.525757780e-09  .404408760e-09 
   44    2 -.621011090e-09  .530292710e-09 
   45    2 -.155063410e-08 -.787280140e-09 
   46    2  .176192280e-09  .236266240e-09 
   47    2 -.179981190e-08 -.207874080e-09 
   48    2  .179440450e-08  .614153800e-09 
   49    2 -.818620170e-09  .185132470e-09 
   50    2  .151758850e-08 -.363612260e-09 
   51    2 -.721236320e-09  .403054490e-09 
   52    2  .313660080e-09 -.950117420e-09 
   53    2  .173411600e-09  .859114930e-09 
   54    2  .693846380e-10 -.589821280e-09 
   55    2  .731200950e-09  .103548100e-09 
   56    2  .145691090e-09 -.168471290e-09 
   57    2  .128416880e-09 -.174541520e-09 
   58    2 -.802496650e-10  .760162870e-10 
   59    2  .945418930e-10  .966750660e-11 
   60    2 -.563884940e-10  .754375270e-10 
   61    2 -.465197780e-10  .608870970e-10 
   62    2 -.204333900e-10 -.387138500e-10 
   63    2 -.213416990e-09 -.171004690e-10 
   64    2 -.307580790e-10  .738914670e-10 
   65    2  .107409380e-10 -.530529890e-10 
   66    2  .108515970e-09  .711649610e-10 
   67    2  .173643410e-10 -.228524710e-10 
   68    2  .580567300e-10 -.589873430e-10 
   69    2 -.451143480e-11  .409521700e-10 
   70    2 -.354511920e-10 -.783659750e-10 
    3    3  .721158450e-06  .141415390e-05 
    4    3  .990675820e-06 -.200968160e-06 
    5    3 -.452076690e-06 -.214963970e-06 
    6    3  .573509000e-07  .935459470e-08 
    7    3  .250828200e-06 -.217304970e-06 
    8    3 -.198426500e-07 -.869909960e-07 
    9    3 -.161574950e-06 -.746944860e-07 
   10    3 -.690604880e-08 -.152871490e-06 
   11    3 -.303702300e-07 -.147896400e-06 
   12    3  .395857800e-07  .230759970e-07 
   13    3 -.218690520e-07  .963546760e-07 
   14    3  .353150080e-07  .215844860e-07 
   15    3  .516690330e-07  .180029410e-07 
   16    3 -.328444360e-07 -.232464690e-07 
   17    3  .765772860e-08  .645607000e-08 
   18    3 -.497876730e-08 -.404195260e-08 
   19    3 -.925544220e-08 -.103969810e-08 
   20    3 -.386237720e-08  .352923920e-07 
   21    3  .188948510e-07  .240608560e-07 
   22    3  .813450580e-08  .124586470e-07 
   23    3 -.259846380e-07 -.183510380e-07 
   24    3  .111026320e-08 -.106536830e-07 
   25    3 -.867393010e-08 -.122164360e-07 
   26    3  .828615820e-08  .462050970e-08 
   27    3  .383158740e-08  .469762050e-08 
   28    3  .695752870e-08  .950482510e-08 
   29    3 -.281221070e-08 -.772501280e-08 
   30    3 -.437596170e-08 -.116128960e-07 
   31    3 -.380220100e-08 -.601515610e-08 
   32    3  .450478470e-08  .181628850e-08 
   33    3 -.413948700e-08  .296436250e-08 
   34    3  .223603880e-08  .314943120e-08 
   35    3 -.347715990e-08  .461264640e-09 
   36    3  .185032140e-08 -.707994910e-08 
   37    3 -.273583310e-08  .334401390e-08 
   38    3  .288745210e-08 -.274130550e-08 
   39    3 -.729028910e-09  .294366960e-08 
   40    3 -.115976300e-08 -.162469160e-08 
   41    3  .131305200e-08 -.876839840e-10 
   42    3  .364909630e-09 -.752128540e-09 
   43    3  .157406080e-08  .189911350e-08 
   44    3  .758929310e-09  .667556190e-09 
   45    3  .765835210e-09  .901704510e-09 
   46    3 -.815979160e-09 -.331064130e-09 
   47    3  .383432600e-09 -.107933480e-08 
   48    3 -.125375500e-08 -.267268010e-09 
   49    3  .496518430e-09  .859309520e-10 
   50    3 -.571983500e-09  .102488990e-08 
   51    3 -.647624560e-10  .250186820e-09 
   52    3 -.962937710e-10  .443267710e-09 
   53    3 -.355018210e-09 -.235855300e-09 
   54    3 -.364400660e-11 -.227823590e-09 
   55    3 -.426522060e-10  .146945130e-09 
   56    3 -.318338200e-10 -.401004220e-10 
   57    3  .139818020e-09  .290606530e-10 
   58    3 -.118099590e-09 -.188117720e-09 
   59    3  .224105560e-09 -.991876930e-10 
   60    3  .142352860e-09 -.448998370e-10 
   61    3  .393793110e-10  .109252510e-09 
   62    3  .150490020e-09  .127997320e-09 
   63    3 -.669548150e-10 -.517588530e-10 
   64    3 -.453269280e-10 -.427165600e-10 
   65    3 -.143923890e-10 -.778764710e-10 
   66    3 -.443257800e-10 -.881945170e-11 
   67    3  .219606740e-10  .290141700e-10 
   68    3 -.592120990e-10  .736974520e-10 
   69    3  .152930640e-10 -.898438890e-11 
   70    3 -.528752280e-11  .337770160e-11 
    4    4 -.188541610e-06  .308839950e-06 
    5    4 -.295228720e-06  .498925340e-07 
    6    4 -.861075950e-07 -.471536130e-06 
    7    4 -.275430050e-06 -.124153940e-06 
    8    4 -.244385230e-06  .704406470e-07 
    9    4 -.864862590e-08  .197510010e-07 
   10    4 -.844001830e-07 -.796817640e-07 
   11    4 -.391438100e-07 -.629242920e-07 
   12    4 -.694035660e-07  .521053750e-08 
   13    4 -.361122910e-08 -.137265830e-07 
   14    4  .302258050e-08 -.234601750e-07 
   15    4 -.403659180e-07  .933076820e-08 
   16    4  .403738730e-07  .490832350e-07 
   17    4  .695183640e-08  .221892460e-07 
   18    4  .523177760e-07 -.206688600e-09 
   19    4  .131325760e-07 -.334160500e-08 
   20    4  .774709030e-08 -.211652210e-07 
   21    4 -.123081620e-08  .135032850e-07 
   22    4 -.929243010e-08  .185657190e-07 
   23    4 -.286485370e-07  .115923290e-07 
   24    4  .106044260e-07  .276780620e-08 
   25    4  .131413120e-07  .144753090e-08 
   26    4  .129072580e-07 -.153502110e-07 
   27    4 -.565854400e-08  .513688850e-08 
   28    4  .596325360e-08  .686542140e-08 
   29    4 -.181838590e-07  .361747760e-08 
   30    4 -.645719510e-08  .499174220e-09 
   31    4  .603635520e-08 -.474089580e-08 
   32    4 -.284339870e-08 -.534339160e-08 
   33    4 -.202728990e-08  .391793910e-08 
   34    4 -.558122980e-08 -.645567960e-09 
   35    4  .113770760e-08  .423444310e-08 
   36    4  .271312010e-09 -.117164690e-08 
   37    4 -.652308940e-09  .482377000e-09 
   38    4  .329795230e-08  .482692560e-10 
   39    4 -.474817460e-08 -.309407620e-09 
   40    4  .342358020e-08  .745534570e-09 
   41    4 -.219095780e-08  .839058320e-09 
   42    4  .509268330e-08  .270075200e-09 
   43    4 -.732212060e-09  .156568100e-08 
   44    4  .243064080e-08  .120313960e-08 
   45    4 -.153993620e-08  .146374580e-08 
   46    4  .132537040e-08  .106643980e-08 
   47    4 -.145164050e-08  .103202160e-08 
   48    4 -.651746080e-10 -.708122980e-09 
   49    4  .669722420e-09  .341052050e-09 
   50    4 -.105899040e-08 -.897634740e-09 
   51    4  .229141350e-09  .634889120e-10 
   52    4 -.634089970e-09 -.495975060e-09 
   53    4  .562395650e-10 -.521003670e-09 
   54    4 -.229521530e-10 -.591371610e-09 
   55    4  .665798040e-10 -.385816310e-09 
   56    4  .324155700e-09 -.182577720e-09 
   57    4 -.481737350e-09  .675850550e-10 
   58    4  .139112190e-09 -.505656870e-10 
   59    4  .477877550e-10  .182846060e-10 
   60    4  .119578670e-09  .252038410e-11 
   61    4  .103753350e-09  .486275440e-10 
   62    4  .219438910e-10  .169805150e-09 
   63    4 -.901838280e-10  .128267850e-09 
   64    4  .558470140e-11  .915091290e-10 
   65    4 -.884408450e-11  .815848240e-10 
   66    4  .341619690e-10  .250840150e-10 
   67    4  .282609470e-10  .336798480e-10 
   68    4 -.716301140e-10 -.168404870e-11 
   69    4  .248369230e-10 -.350207850e-10 
   70    4 -.448043580e-10 -.302567400e-10 
    5    5  .174947930e-06 -.669381580e-06 
    6    5 -.267022950e-06 -.536453980e-06 
    7    5  .191384800e-08  .179102200e-07 
    8    5 -.256514140e-07  .890162610e-07 
    9    5 -.160297370e-07 -.545713630e-07 
   10    5 -.492047790e-07 -.502115840e-07 
   11    5  .374548440e-07  .505197460e-07 
   12    5  .315163330e-07  .782323590e-08 
   13    5  .597300760e-07  .655268480e-07 
   14    5  .289261170e-07 -.175524910e-07 
   15    5  .108459470e-07  .801846890e-08 
   16    5 -.114259000e-07 -.892164670e-09 
   17    5 -.117043740e-07  .671004730e-08 
   18    5  .653665470e-08  .235928940e-07 
   19    5  .520682520e-08  .266204930e-07 
   20    5 -.117427980e-07 -.512702130e-08 
   21    5  .754858180e-08  .311258000e-08 
   22    5  .169580640e-08 -.195080410e-08 
   23    5 -.232239790e-08 -.319272390e-08 
   24    5 -.557796000e-08 -.191810680e-07 
   25    5 -.740623370e-08  .305210180e-08 
   26    5  .125984580e-07  .729138970e-08 
   27    5  .966993000e-08  .875984950e-08 
   28    5  .106868570e-07 -.280659590e-08 
   29    5  .145828060e-08  .536770170e-08 
   30    5  .737465200e-09 -.423416570e-08 
   31    5 -.104895910e-07  .164293720e-08 
   32    5  .440642180e-08 -.152726700e-08 
   33    5 -.234772580e-08  .341183600e-08 
   34    5 -.524632870e-09  .577974820e-08 
   35    5 -.190439350e-08 -.701946550e-08 
   36    5 -.436581660e-08  .503843960e-08 
   37    5 -.208637340e-08 -.988384400e-09 
   38    5 -.168953360e-08  .524449060e-08 
   39    5  .260519320e-08 -.541591880e-09 
   40    5 -.438503970e-09  .247270680e-08 
   41    5  .703077300e-09 -.279261540e-09 
   42    5 -.115030430e-08 -.961645050e-09 
   43    5  .374368160e-09 -.236469580e-09 
   44    5 -.627747490e-10 -.461791890e-09 
   45    5  .543504010e-09 -.556656380e-09 
   46    5  .443327160e-09 -.186834120e-08 
   47    5 -.105791200e-08 -.357378710e-09 
   48    5  .696608150e-09 -.539427860e-09 
   49    5 -.329926050e-09 -.477820020e-09 
   50    5  .101850630e-08  .408498210e-09 
   51    5  .339109160e-09 -.140765750e-09 
   52    5 -.521727700e-10  .206057380e-09 
   53    5 -.648566080e-10 -.438219270e-09 
   54    5 -.165711030e-09  .273052330e-09 
   55    5  .661734690e-10  .820529440e-10 
   56    5  .718429630e-10  .103502600e-09 
   57    5  .352215730e-09  .184166150e-09 
   58    5 -.761820090e-10  .157278130e-09 
   59    5 -.860728100e-10 -.492507290e-10 
   60    5 -.488381290e-10 -.267505020e-10 
   61    5  .184094080e-10  .927192310e-10 
   62    5 -.478262640e-10 -.129681600e-09 
   63    5  .693985750e-10 -.300155120e-10 
   64    5 -.648745160e-10 -.102373930e-09 
   65    5 -.904372030e-10 -.149506550e-10 
   66    5  .118113370e-10 -.143927500e-11 
   67    5  .283058120e-10  .109157830e-10 
   68    5  .801131910e-10  .924542830e-10 
   69    5  .255248940e-10  .184270740e-11 
   70    5  .733890840e-11  .263868330e-11 
    6    6  .961098620e-08 -.237241640e-06 
    7    6 -.358820200e-06  .151728550e-06 
    8    6 -.658552160e-07  .308921060e-06 
    9    6  .627664680e-07  .222709070e-06 
   10    6 -.374060740e-07 -.791626230e-07 
   11    6 -.151594120e-08  .344598280e-07 
   12    6  .360367680e-08  .387070320e-07 
   13    6 -.355508380e-07 -.730445600e-08 
   14    6 -.189834730e-07  .339962830e-08 
   15    6  .331136290e-07 -.367044320e-07 
   16    6  .131693840e-07 -.363244080e-07 
   17    6 -.118472750e-07 -.293021020e-07 
   18    6  .159767750e-07 -.127602780e-07 
   19    6 -.357908770e-08  .182152150e-07 
   20    6  .106071840e-07 -.403118310e-08 
   21    6 -.157762880e-07 -.789573420e-09 
   22    6  .880207180e-08 -.365406320e-08 
   23    6 -.984525050e-08  .167436330e-07 
   24    6  .728653950e-08 -.773312370e-09 
   25    6  .148242550e-07  .221402630e-09 
   26    6  .103848420e-07 -.805259360e-08 
   27    6  .561829370e-08  .266203580e-08 
   28    6 -.898169170e-08  .938703560e-08 
   29    6  .106957820e-07  .871652180e-08 
   30    6  .219185110e-08  .249161950e-08 
   31    6 -.610100590e-09  .105834370e-08 
   32    6 -.632350280e-08 -.502666030e-08 
   33    6  .184838430e-08 -.340506170e-08 
   34    6  .113620270e-08  .351837730e-08 
   35    6  .262762520e-08  .445845320e-08 
   36    6  .407777750e-08 -.276199360e-08 
   37    6 -.849357350e-09  .470519390e-08 
   38    6 -.205234980e-08  .125786370e-08 
   39    6 -.182034540e-08  .446395380e-09 
   40    6 -.214971820e-08  .250450940e-08 
   41    6  .205539850e-08 -.904106270e-09 
   42    6  .997383380e-09  .159920820e-08 
   43    6  .189172730e-08 -.507098270e-09 
   44    6  .769581950e-09  .216730830e-08 
   45    6  .334883630e-09  .407381880e-09 
   46    6  .610039310e-09  .137357610e-08 
   47    6  .921594270e-09  .590877200e-10 
   48    6  .725980980e-09  .157378590e-09 
   49    6 -.238261870e-09 -.264660750e-09 
   50    6 -.646447000e-09 -.217431270e-09 
   51    6 -.280154830e-09 -.131785310e-09 
   52    6  .592131960e-10 -.296578080e-09 
   53    6 -.160566790e-09  .941842160e-10 
   54    6  .235424370e-09 -.646531200e-09 
   55    6 -.296429270e-09  .168403350e-09 
   56    6 -.684313980e-09 -.289348280e-09 
   57    6 -.108869550e-09 -.131852970e-09 
   58    6 -.732981600e-10  .209229910e-10 
   59    6  .144234930e-09 -.665488470e-10 
   60    6  .122234980e-09  .664519040e-10 
   61    6  .211020440e-10 -.120648870e-10 
   62    6  .389454330e-10  .244308310e-09 
   63    6  .723926920e-10  .190044650e-10 
   64    6  .102350410e-09  .273535090e-10 
   65    6  .809133990e-10  .336271460e-10 
   66    6  .231368910e-10 -.276644270e-10 
   67    6 -.473318120e-10 -.233644790e-10 
   68    6 -.772249180e-10  .230517720e-11 
   69    6 -.121840600e-10  .554871190e-12 
   70    6  .807465650e-11 -.275748590e-10 
    7    7  .136545050e-08  .242420350e-07 
    8    7  .673226560e-07  .748704820e-07 
    9    7 -.118101780e-06 -.967384470e-07 
   10    7  .834470130e-08 -.324172900e-08 
   11    7  .453779900e-08 -.897894750e-07 
   12    7 -.190940080e-07  .358890150e-07 
   13    7  .241240820e-08 -.735700830e-08 
   14    7  .378652870e-07 -.434049370e-08 
   15    7  .610006620e-07  .552157940e-08 
   16    7 -.760293890e-08 -.820560030e-08 
   17    7  .232006970e-07 -.549152140e-08 
   18    7  .563345320e-08  .628719550e-08 
   19    7  .664453890e-08 -.808117140e-08 
   20    7 -.198309870e-07  .101603110e-08 
   21    7 -.669612450e-08  .329880130e-08 
   22    7  .143770800e-07  .402931500e-08 
   23    7 -.530423240e-08 -.194990730e-08 
   24    7 -.659028250e-08  .469990850e-08 
   25    7  .598730330e-08 -.732426580e-08 
   26    7 -.165130760e-08  .542820160e-08 
   27    7 -.823783160e-08 -.570297390e-08 
   28    7 -.248295760e-09  .594985540e-08 
   29    7 -.525324740e-08 -.561289470e-08 
   30    7  .210211440e-08  .120969080e-08 
   31    7  .897808720e-09 -.191797580e-09 
   32    7  .373598980e-08  .280121500e-08 
   33    7 -.371144660e-08 -.160110730e-08 
   34    7  .222817530e-08 -.192047130e-08 
   35    7 -.593220330e-09  .322980140e-08 
   36    7 -.878677920e-09  .160097920e-08 
   37    7  .105932250e-08  .749927760e-09 
   38    7  .959722780e-09  .199046470e-08 
   39    7  .882712350e-09  .221773230e-08 
   40    7  .604713580e-10  .104112910e-08 
   41    7  .174488120e-09  .310167650e-08 
   42    7  .467411930e-10  .138152870e-08 
   43    7 -.822603210e-09  .100268330e-08 
   44    7 -.104401750e-09  .136661080e-09 
   45    7 -.970088230e-10  .316223000e-09 
   46    7 -.387024190e-09 -.193993300e-09 
   47    7  .428961460e-09  .602015250e-10 
   48    7  .258856840e-09 -.457629810e-09 
   49    7  .181368710e-09 -.281384480e-09 
   50    7  .245628870e-09 -.929778940e-09 
   51    7 -.117897130e-10 -.336461560e-09 
   52    7  .405577890e-10 -.164124760e-09 
   53    7  .138414850e-09 -.217692100e-09 
   54    7 -.977098330e-10  .214871290e-09 
   55    7  .938231750e-10 -.107152550e-09 
   56    7 -.602775770e-10  .967214830e-10 
   57    7 -.500415230e-10  .180124580e-09 
   58    7 -.127270520e-09  .289890760e-11 
   59    7 -.451212780e-10  .133596940e-09 
   60    7 -.269002320e-10 -.210569790e-11 
   61    7 -.790976060e-10  .528673150e-10 
   62    7  .521935800e-10  .885483610e-12 
   63    7 -.538799550e-10  .679401820e-10 
   64    7  .196527610e-10  .287638670e-10 
   65    7  .157753600e-10 -.348720620e-10 
   66    7  .835686950e-10 -.198793440e-10 
   67    7  .113563810e-12 -.587107300e-10 
   68    7  .963465960e-11 -.746107050e-10 
   69    7  .253390360e-12 -.243238870e-10 
   70    7 -.186974350e-10  .142711670e-10 
    8    8 -.123653520e-06  .120388820e-06 
    9    8  .188221900e-06 -.328085280e-08 
   10    8  .407447640e-07 -.919869350e-07 
   11    8 -.595889070e-08  .247079700e-07 
   12    8 -.250722970e-07  .165658890e-07 
   13    8 -.110856610e-07 -.106254460e-07 
   14    8 -.355103820e-07 -.153864220e-07 
   15    8 -.311875250e-07  .224857880e-07 
   16    8 -.195327740e-07  .456512130e-08 
   17    8  .380755130e-07  .333518370e-08 
   18    8  .294698690e-07  .384795900e-08 
   19    8  .292541830e-07 -.101232590e-07 
   20    8  .518063460e-08  .165204630e-08 
   21    8 -.154785990e-07  .382040780e-09 
   22    8 -.217906920e-07  .259983670e-08 
   23    8  .444906550e-08  .413100450e-08 
   24    8  .144331950e-07 -.243358490e-08 
   25    8  .206499600e-08 -.680515710e-08 
   26    8  .316069160e-08 -.945195040e-09 
   27    8 -.889927890e-08 -.764518900e-08 
   28    8 -.319088330e-08 -.135651090e-08 
   29    8 -.117336270e-07  .801136450e-08 
   30    8  .808557160e-08  .196387970e-09 
   31    8 -.698820840e-08  .171204910e-08 
   32    8  .512661220e-08  .702975810e-08 
   33    8 -.194871520e-08  .106699400e-07 
   34    8 -.447264790e-08  .303010460e-08 
   35    8 -.334587680e-08  .726536640e-08 
   36    8  .281766270e-08 -.282511260e-08 
   37    8 -.122895110e-08 -.131727870e-09 
   38    8  .113183380e-08 -.272985260e-09 
   39    8 -.130706960e-08 -.631942380e-09 
   40    8  .205119070e-08  .730332190e-09 
   41    8  .377842900e-10 -.176848600e-08 
   42    8  .192249580e-08 -.595405660e-09 
   43    8  .575568010e-09 -.221600550e-08 
   44    8 -.654272680e-09 -.299575990e-09 
   45    8  .128422420e-09  .143351920e-09 
   46    8 -.908410830e-09 -.217668280e-09 
   47    8 -.281340030e-09  .156026680e-09 
   48    8 -.138590870e-09 -.210824300e-09 
   49    8 -.332156760e-09  .239332540e-09 
   50    8 -.105566660e-08  .272317780e-09 
   51    8  .273885790e-09  .705437060e-09 
   52    8 -.388511850e-09  .101897490e-09 
   53    8  .131024860e-09 -.387452410e-09 
   54    8  .154039740e-09  .408527630e-11 
   55    8 -.122792110e-09 -.967444440e-10 
   56    8  .907193410e-10  .611481990e-10 
   57    8 -.131436130e-10  .225912780e-09 
   58    8  .303751710e-09 -.698774690e-10 
   59    8  .640419190e-10 -.270451100e-09 
   60    8  .713784610e-11  .287476780e-10 
   61    8  .945777280e-10 -.147051230e-09 
   62    8 -.134438410e-09  .730302130e-10 
   63    8 -.189533700e-10  .366278540e-10 
   64    8  .867146480e-11 -.262864260e-10 
   65    8 -.561715480e-10  .454498430e-10 
   66    8 -.830393660e-11 -.465854110e-10 
   67    8 -.539072330e-10  .935634920e-10 
   68    8 -.375000560e-10  .189229180e-10 
   69    8  .127632650e-10  .290872250e-10 
   70    8  .517597670e-11  .619906310e-11 
    9    9 -.479825140e-07  .967173480e-07 
   10    9  .125508390e-06 -.375846630e-07 
   11    9 -.316001410e-07  .416098220e-07 
   12    9  .420447190e-07  .252221860e-07 
   13    9  .247310020e-07  .461027190e-07 
   14    9  .316801140e-07  .291506090e-07 
   15    9  .121704130e-07  .363007160e-07 
   16    9 -.217326860e-07 -.395040600e-07 
   17    9  .443386350e-08 -.262067050e-07 
   18    9 -.195493270e-07  .372791600e-07 
   19    9  .181298820e-08  .492720650e-08 
   20    9  .167599970e-07 -.666284470e-08 
   21    9  .174400190e-07  .721899770e-08 
   22    9  .956447280e-08  .885989610e-08 
   23    9  .822265060e-09 -.913997180e-08 
   24    9 -.151372230e-07 -.145584810e-07 
   25    9 -.289222410e-07  .196614350e-07 
   26    9 -.774745040e-08  .262805170e-09 
   27    9  .543871490e-09  .847155140e-08 
   28    9  .553439800e-08 -.107622600e-07 
   29    9  .308972490e-08  .279426700e-08 
   30    9 -.299801650e-08 -.863807500e-08 
   31    9 -.565092510e-08  .547463940e-08 
   32    9  .113087600e-08  .179421830e-08 
   33    9  .619682080e-08  .557979340e-08 
   34    9  .371958490e-08  .197476890e-08 
   35    9 -.177716190e-08 -.304544060e-09 
   36    9  .572807940e-09 -.420379220e-09 
   37    9  .288868490e-08  .226615540e-08 
   38    9  .469633990e-09  .623642110e-09 
   39    9  .466695080e-08  .124604730e-09 
   40    9  .241175960e-08 -.284288150e-08 
   41    9  .333384680e-09 -.987296790e-09 
   42    9 -.970037570e-09  .193044070e-09 
   43    9 -.140873970e-08 -.139073290e-08 
   44    9 -.902754350e-10  .384112120e-09 
   45    9  .789458460e-10 -.151369720e-08 
   46    9 -.809900700e-09  .896846910e-09 
   47    9 -.942133670e-09 -.285242290e-09 
   48    9 -.126618410e-10  .325774370e-09 
   49    9 -.449546390e-09  .408273910e-09 
   50    9  .344260090e-10 -.777512700e-11 
   51    9  .442452300e-09  .193030820e-10 
   52    9 -.360467960e-10 -.248103120e-09 
   53    9  .204195830e-09  .639115400e-10 
   54    9 -.358148550e-09  .247752270e-09 
   55    9  .506593220e-09 -.555530840e-10 
   56    9  .653907310e-10  .785823400e-10 
   57    9  .159268030e-09 -.261786060e-10 
   58    9  .315429420e-10 -.182416200e-09 
   59    9 -.195131130e-09  .153707620e-09 
   60    9 -.228198270e-09  .744611250e-10 
   61    9 -.947294020e-10 -.482000070e-10 
   62    9  .539617940e-10  .220652160e-10 
   63    9 -.275945650e-10 -.127682690e-09 
   64    9 -.602912070e-10  .520564620e-10 
   65    9 -.346688720e-10  .370908380e-10 
   66    9  .143456490e-10 -.621430230e-11 
   67    9  .175820860e-11  .647551290e-10 
   68    9  .836126790e-10 -.797688590e-10 
   69    9  .674341680e-10  .300682380e-10 
   70    9 -.246319470e-11 -.374867370e-11 
   10   10  .100442620e-06 -.239473190e-07 
   11   10 -.521165230e-07 -.183564740e-07 
   12   10 -.624173090e-08  .309749430e-07 
   13   10  .408679220e-07 -.373150990e-07 
   14   10  .387529300e-07 -.146964690e-08 
   15   10  .108191050e-07  .154137180e-07 
   16   10 -.113193240e-07  .115519610e-07 
   17   10 -.435153120e-08  .163449190e-07 
   18   10  .408880730e-08 -.537238960e-08 
   19   10 -.335046220e-07 -.553055420e-08 
   20   10 -.308396830e-07 -.332701040e-08 
   21   10 -.102675300e-07 -.210271220e-08 
   22   10  .534042280e-08  .207662920e-07 
   23   10  .149691040e-07 -.360853980e-08 
   24   10  .943432320e-08  .209017570e-07 
   25   10  .941021720e-08 -.352656040e-08 
   26   10 -.112358540e-07 -.467103320e-08 
   27   10 -.126799720e-07  .475071410e-09 
   28   10 -.133853890e-07  .532543600e-08 
   29   10  .110364810e-07 -.145982480e-08 
   30   10  .679447600e-08 -.369118150e-08 
   31   10  .508845320e-08 -.727126980e-09 
   32   10 -.995759460e-09 -.272139570e-08 
   33   10 -.409968240e-08 -.155906160e-08 
   34   10 -.841952160e-08  .516519070e-09 
   35   10 -.154338840e-08  .821422160e-08 
   36   10 -.559650230e-09 -.830120740e-09 
   37   10 -.477942600e-09 -.319776090e-09 
   38   10 -.880469200e-09  .113853080e-08 
   39   10  .180088980e-08  .228301030e-08 
   40   10 -.826822090e-09  .831947900e-09 
   41   10  .401191400e-08  .166610220e-08 
   42   10  .675120850e-09  .100120810e-08 
   43   10 -.164401970e-08  .825396440e-09 
   44   10 -.704729930e-09 -.905087800e-09 
   45   10  .152436380e-08 -.301933880e-09 
   46   10 -.327670870e-09  .108818870e-08 
   47   10  .862983200e-09 -.117127290e-08 
   48   10  .568151960e-09 -.575380790e-09 
   49   10 -.275211760e-09 -.908223370e-09 
   50   10 -.619894490e-09  .146498200e-09 
   51   10  .685954740e-10  .454979380e-09 
   52   10  .277198700e-09 -.792459680e-09 
   53   10 -.383102190e-09  .629707720e-09 
   54   10 -.397841810e-10 -.294233150e-09 
   55   10 -.352869640e-10 -.164327800e-09 
   56   10 -.260342950e-09  .219389040e-09 
   57   10  .364239770e-09 -.771338950e-10 
   58   10  .342539180e-11  .146124540e-09 
   59   10  .727661170e-10 -.863280680e-10 
   60   10  .583868000e-10 -.159023090e-10 
   61   10 -.190917320e-09  .182512510e-09 
   62   10 -.307970090e-10 -.143797000e-09 
   63   10  .659195520e-10  .271318840e-10 
   64   10  .114114300e-10  .793498390e-10 
   65   10 -.173232750e-10 -.126277010e-09 
   66   10  .250554820e-10  .411600480e-10 
   67   10  .335765210e-10 -.739236980e-10 
   68   10 -.929245850e-10  .430206230e-10 
   69   10  .588603740e-10  .629250440e-10 
   70   10  .416584580e-10 -.659096660e-10 
   11   11  .458041090e-07 -.697865880e-07 
   12   11  .112485930e-07 -.647036070e-08 
   13   11 -.449768330e-07 -.488236370e-08 
   14   11  .156859470e-07 -.392926850e-07 
   15   11 -.140212710e-08  .180433220e-07 
   16   11  .187201380e-07 -.333375690e-08 
   17   11 -.156392270e-07  .111099720e-07 
   18   11 -.698853250e-08  .242027770e-08 
   19   11  .155150710e-07  .904188750e-08 
   20   11  .134877310e-07 -.207183150e-07 
   21   11  .728501640e-08 -.338342360e-07 
   22   11 -.432747190e-08 -.159287920e-07 
   23   11  .892880960e-08  .139204700e-07 
   24   11  .150666970e-07  .160748840e-07 
   25   11  .276241730e-08  .973258020e-08 
   26   11 -.505435050e-08  .112834430e-08 
   27   11  .339824880e-09 -.653485340e-08 
   28   11 -.311106700e-08  .190493670e-08 
   29   11 -.227055150e-08  .570202090e-08 
   30   11 -.115377840e-07  .528193010e-08 
   31   11 -.399607230e-08  .171807800e-07 
   32   11 -.402011560e-08  .628334120e-08 
   33   11  .621240550e-08 -.446501910e-08 
   34   11 -.260537890e-08  .375542050e-09 
   35   11  .479657700e-10 -.331600080e-08 
   36   11 -.284614110e-08  .487933600e-08 
   37   11  .165503610e-08  .192606880e-08 
   38   11  .263680070e-08  .288339910e-08 
   39   11  .843849350e-08 -.182036320e-09 
   40   11  .172054250e-08  .119993020e-08 
   41   11  .238374270e-08 -.211614370e-08 
   42   11  .174871530e-08 -.106985240e-08 
   43   11 -.937542040e-09  .277328880e-08 
   44   11 -.356297760e-10 -.264799780e-08 
   45   11  .500867730e-09  .333022990e-09 
   46   11 -.444665930e-09 -.723813780e-09 
   47   11  .304236550e-09  .210862610e-08 
   48   11 -.714099460e-09  .251866760e-10 
   49   11 -.371427360e-09 -.367363380e-10 
   50   11 -.403247980e-10  .495243560e-09 
   51   11 -.551378630e-09 -.499877040e-09 
   52   11 -.357316370e-09  .284217080e-09 
   53   11 -.574231920e-09 -.344174420e-09 
   54   11  .356012730e-10  .271861270e-09 
   55   11  .270426810e-10 -.834270140e-11 
   56   11  .290412980e-09 -.541299280e-09 
   57   11  .151028240e-09 -.299935100e-09 
   58   11 -.111180700e-09  .825210570e-10 
   59   11 -.124449030e-09 -.627431940e-11 
   60   11  .219169350e-09 -.227457020e-09 
   61   11  .108836610e-09  .186559520e-09 
   62   11  .344447790e-10 -.164838270e-09 
   63   11  .104219980e-09 -.340968170e-10 
   64   11 -.663814460e-10  .161135420e-11 
   65   11 -.403636690e-10  .181790010e-09 
   66   11  .234681960e-11 -.792392600e-11 
   67   11 -.676237600e-11 -.101216650e-09 
   68   11 -.865639760e-11  .131976050e-09 
   69   11 -.720461900e-10 -.116810980e-09 
   70   11 -.218124070e-10  .149152060e-10 
   12   12 -.250843280e-08 -.112140900e-07 
   13   12 -.313384190e-07  .878611000e-07 
   14   12  .833545460e-08 -.311507770e-07 
   15   12 -.325360060e-07  .156342460e-07 
   16   12  .196052130e-07  .674249480e-08 
   17   12  .285354500e-07  .203075610e-07 
   18   12 -.296858260e-07 -.165512810e-07 
   19   12 -.229975890e-08  .948172310e-08 
   20   12 -.666151900e-08  .183583530e-07 
   21   12 -.346536000e-08  .139163860e-07 
   22   12  .283263120e-08 -.885543280e-08 
   23   12  .159360320e-07 -.110405660e-07 
   24   12  .109675690e-07 -.458687540e-08 
   25   12 -.756254230e-08  .121866510e-07 
   26   12 -.163010720e-07  .668092320e-09 
   27   12 -.115361920e-07 -.759774990e-09 
   28   12  .109219690e-09  .970082500e-08 
   29   12 -.154138180e-08 -.413527820e-09 
   30   12  .145352220e-07 -.708142430e-08 
   31   12  .315248030e-08 -.360677670e-09 
   32   12 -.147532040e-07  .916056890e-08 
   33   12 -.432781390e-08  .113154730e-07 
   34   12  .134113640e-07  .296908410e-09 
   35   12  .783171790e-08 -.705554030e-08 
   36   12  .195248370e-08 -.914136530e-08 
   37   12 -.380028660e-08 -.165085050e-08 
   38   12 -.538981510e-08 -.579832000e-08 
   39   12 -.341075190e-08  .346216730e-08 
   40   12  .710933870e-08 -.208809960e-08 
   41   12  .307177070e-08  .660201970e-09 
   42   12  .252212880e-08 -.326817120e-08 
   43   12  .282935850e-09  .204321280e-08 
   44   12 -.166222770e-08 -.276499300e-08 
   45   12 -.143089840e-08 -.495634200e-09 
   46   12  .134073220e-08 -.490054730e-08 
   47   12  .245940480e-08  .100874670e-08 
   48   12 -.190429800e-08  .784801260e-09 
   49   12 -.125006260e-08  .127323380e-08 
   50   12  .112567500e-10  .840401240e-09 
   51   12 -.838846080e-10  .103639810e-08 
   52   12  .269255590e-09 -.542739690e-09 
   53   12  .163036820e-09  .198512830e-09 
   54   12 -.139367850e-08 -.806277390e-10 
   55   12 -.434382970e-09  .533481870e-09 
   56   12  .749435670e-10 -.940569630e-10 
   57   12  .181891320e-09 -.592188460e-09 
   58   12  .605631640e-09  .788863730e-10 
   59   12 -.568253970e-10 -.300023980e-10 
   60   12 -.232151440e-09 -.523255550e-10 
   61   12 -.140560100e-09  .129740680e-10 
   62   12  .784687930e-10 -.857310000e-11 
   63   12  .210496860e-09 -.158759630e-09 
   64   12  .472436560e-11 -.711156560e-10 
   65   12  .553530920e-10  .999174880e-10 
   66   12 -.158821030e-09  .137463440e-09 
   67   12 -.162806400e-09  .107727990e-10 
   68   12  .129808140e-09 -.238961640e-11 
   69   12  .131679880e-09 -.189248380e-10 
   70   12 -.804210580e-11 -.568681390e-12 
   13   13 -.614248770e-07  .684399520e-07 
   14   13  .322529640e-07  .451726700e-07 
   15   13 -.284045840e-07 -.441305340e-08 
   16   13  .138965990e-07  .100872870e-08 
   17   13  .162356870e-07  .203757360e-07 
   18   13 -.623456070e-08 -.348387610e-07 
   19   13 -.784680550e-08 -.282067310e-07 
   20   13  .277318500e-07  .670293510e-08 
   21   13 -.189984450e-07  .134377540e-07 
   22   13 -.174989520e-07  .199359010e-07 
   23   13 -.112076940e-07 -.475881950e-08 
   24   13 -.191874980e-08  .233991010e-08 
   25   13  .718105650e-08 -.123190160e-07 
   26   13 -.872842440e-09  .214636460e-08 
   27   13 -.519630350e-08 -.311732800e-08 
   28   13  .321136830e-08  .604372820e-08 
   29   13 -.262773270e-08 -.268857920e-08 
   30   13  .136515220e-07  .198545230e-08 
   31   13  .101549620e-07  .480023460e-08 
   32   13  .496463990e-08  .629337390e-08 
   33   13  .319102900e-08  .396924670e-08 
   34   13 -.431596530e-08 -.157083360e-09 
   35   13 -.179060660e-08  .443651830e-08 
   36   13 -.372912760e-08  .670957320e-08 
   37   13 -.918462930e-09 -.799386240e-08 
   38   13 -.197871010e-08 -.974095220e-08 
   39   13 -.254206820e-08 -.299230610e-08 
   40   13  .156150000e-08 -.476115770e-08 
   41   13 -.176716680e-08  .453702680e-08 
   42   13 -.981840930e-09  .814849960e-09 
   43   13  .397677890e-08 -.149696520e-08 
   44   13 -.906833530e-10 -.329080060e-08 
   45   13 -.805814300e-09  .186199400e-08 
   46   13 -.278534280e-08 -.352643340e-08 
   47   13 -.231651360e-08  .105928030e-08 
   48   13 -.707557000e-09 -.156241620e-08 
   49   13 -.921414280e-10  .519875330e-09 
   50   13  .489016900e-09 -.330550550e-09 
   51   13  .231309990e-09  .669295980e-09 
   52   13  .155370370e-08  .124607750e-08 
   53   13 -.688670490e-09 -.100197680e-09 
   54   13  .600422320e-09 -.704624710e-10 
   55   13  .146597660e-08  .157238750e-09 
   56   13  .362745610e-09 -.521150060e-10 
   57   13  .116429070e-09  .457463780e-10 
   58   13 -.225082650e-10  .581402160e-09 
   59   13 -.289157090e-09 -.460531500e-09 
   60   13  .125365590e-09  .161825200e-09 
   61   13 -.157469200e-09 -.175618950e-09 
   62   13  .259159390e-10 -.813193610e-10 
   63   13 -.171584590e-09  .156006340e-09 
   64   13 -.215906450e-09 -.165760030e-09 
   65   13 -.643626900e-10 -.146881820e-09 
   66   13 -.760412870e-10 -.933587970e-10 
   67   13 -.103221470e-10  .129666110e-09 
   68   13  .763283270e-10  .845359500e-10 
   69   13  .696655410e-10  .449871460e-10 
   70   13  .123143090e-09  .318626740e-10 
   14   14 -.518987330e-07 -.480042500e-08 
   15   14  .519104690e-08 -.243605220e-07 
   16   14 -.192319610e-07 -.386312580e-07 
   17   14 -.141828050e-07  .115464290e-07 
   18   14 -.805338360e-08 -.129379560e-07 
   19   14 -.486285610e-08 -.129798950e-07 
   20   14  .112858760e-07 -.140982260e-07 
   21   14  .206882090e-07  .769292230e-08 
   22   14  .118473380e-07  .769012090e-08 
   23   14  .624678450e-08 -.234691540e-08 
   24   14 -.215622620e-07 -.138073880e-08 
   25   14 -.190823430e-07  .772981190e-08 
   26   14  .948209930e-08  .752278050e-08 
   27   14  .149370710e-07  .104737880e-07 
   28   14 -.955939260e-08 -.126899110e-07 
   29   14 -.360626490e-08 -.398634000e-08 
   30   14  .473435850e-08  .794513780e-08 
   31   14 -.661535050e-08  .443516370e-08 
   32   14 -.317059910e-08  .225776930e-08 
   33   14  .357601070e-08  .373344620e-08 
   34   14 -.485392520e-08  .831756880e-08 
   35   14 -.516058010e-08 -.600014490e-08 
   36   14 -.972600320e-08 -.455392140e-08 
   37   14 -.441777520e-08  .751745660e-09 
   38   14 -.657142800e-08  .139501480e-08 
   39   14 -.302840060e-08 -.893379590e-09 
   40   14 -.158735080e-08  .389626040e-08 
   41   14  .233569460e-08  .879420170e-09 
   42   14 -.469678260e-08  .980508910e-09 
   43   14 -.272554080e-08  .154251580e-08 
   44   14 -.366296070e-08 -.157439000e-08 
   45   14 -.825681710e-10 -.466320560e-08 
   46   14 -.458045490e-08 -.699684520e-09 
   47   14  .145423400e-08 -.405445850e-08 
   48   14 -.224165010e-08  .104698270e-08 
   49   14 -.920008640e-10 -.730423740e-09 
   50   14 -.462304410e-08  .138759890e-08 
   51   14 -.633461340e-09 -.143262490e-08 
   52   14 -.197952530e-08  .689672200e-09 
   53   14  .116801180e-08 -.576943890e-09 
   54   14 -.196840450e-08  .119250180e-08 
   55   14 -.138300430e-09  .120549580e-09 
   56   14  .800786380e-09  .114750610e-08 
   57   14  .611696940e-09 -.546893530e-09 
   58   14  .215900520e-09 -.215790400e-10 
   59   14 -.603390950e-11  .479534340e-09 
   60   14  .125263520e-08 -.118440000e-09 
   61   14  .108887950e-09 -.203163750e-09 
   62   14  .114227090e-08 -.592562120e-09 
   63   14  .670221480e-10 -.170544530e-09 
   64   14  .107869930e-08 -.127559260e-09 
   65   14 -.642309120e-10 -.210266090e-10 
   66   14  .224888620e-09 -.140630830e-09 
   67   14 -.498297220e-10  .175320070e-10 
   68   14 -.423442440e-10  .677264690e-10 
   69   14  .172353400e-09 -.968403210e-10 
   70   14 -.363282120e-10  .133164500e-10 
   15   15 -.190406100e-07 -.468046920e-08 
   16   15 -.144565600e-07 -.328079270e-07 
   17   15  .538837760e-08  .526665810e-08 
   18   15 -.405427800e-07 -.203207900e-07 
   19   15 -.174094780e-07 -.139104270e-07 
   20   15 -.256958830e-07 -.730218690e-09 
   21   15  .174532370e-07  .102148940e-07 
   22   15  .254779510e-07  .400285160e-08 
   23   15  .189789030e-07 -.307088940e-08 
   24   15  .782162730e-08 -.146207490e-07 
   25   15 -.484784870e-08 -.871136170e-08 
   26   15 -.156589320e-07  .577802710e-08 
   27   15 -.113339590e-08  .347121000e-08 
   28   15 -.924709200e-08  .151883260e-09 
   29   15 -.852450170e-08 -.874814940e-08 
   30   15 -.169230390e-08 -.248532560e-08 
   31   15  .192533610e-08 -.245262570e-08 
   32   15  .473184700e-08 -.905809120e-08 
   33   15 -.363007480e-08 -.175291180e-08 
   34   15  .439368200e-08  .695661070e-08 
   35   15 -.138046760e-07  .596080460e-08 
   36   15 -.183045830e-08  .315932670e-08 
   37   15  .898866810e-08  .114911380e-08 
   38   15  .311612980e-08 -.563548460e-08 
   39   15 -.564447470e-08  .612166650e-10 
   40   15 -.371909700e-08  .290681470e-08 
   41   15  .229568400e-08  .431994950e-09 
   42   15 -.385766860e-09  .240230770e-08 
   43   15 -.977936340e-10  .335171780e-08 
   44   15  .706107490e-09 -.223242810e-08 
   45   15 -.318418300e-08  .250139900e-08 
   46   15  .415347390e-09 -.207249510e-08 
   47   15  .225836350e-08 -.515385100e-09 
   48   15  .131443690e-08  .833744600e-09 
   49   15  .279632880e-09  .547347970e-09 
   50   15  .112456570e-09 -.352283180e-09 
   51   15  .107338560e-08 -.125149280e-08 
   52   15  .648184660e-10  .707002180e-09 
   53   15  .119966840e-08 -.159648000e-09 
   54   15  .708832220e-09 -.829731440e-09 
   55   15 -.715768780e-09 -.107174360e-08 
   56   15 -.520889100e-09  .551753800e-09 
   57   15  .595496330e-09  .767121100e-10 
   58   15 -.346100690e-09 -.142435370e-09 
   59   15  .283324900e-09  .561940260e-10 
   60   15 -.409232770e-09  .580279050e-10 
   61   15 -.592677400e-09  .424406280e-09 
   62   15  .127269920e-09 -.287507300e-09 
   63   15 -.110866420e-09 -.368496180e-09 
   64   15 -.699110920e-10  .644366560e-10 
   65   15 -.159809360e-09  .226255200e-09 
   66   15  .253730770e-10 -.159372950e-09 
   67   15  .152360870e-09 -.726152490e-10 
   68   15 -.889775310e-10  .151613560e-09 
   69   15  .203535910e-09  .148231670e-10 
   70   15  .117073750e-09  .623395870e-10 
   16   16 -.378814020e-07  .279229860e-08 
   17   16 -.303791850e-07  .363560100e-08 
   18   16  .102268040e-07  .644971450e-08 
   19   16 -.216429470e-07 -.701321860e-08 
   20   16 -.124518690e-07 -.583478420e-09 
   21   16  .721828510e-08 -.659400770e-08 
   22   16 -.615914100e-11 -.746244510e-08 
   23   16  .562181910e-08  .107259120e-07 
   24   16  .873890630e-08  .314094490e-08 
   25   16  .153273270e-08 -.112138060e-07 
   26   16  .666701210e-09 -.713065630e-08 
   27   16  .230591430e-08 -.351603600e-09 
   28   16 -.353663020e-08 -.132977390e-07 
   29   16  .584784620e-09 -.927928120e-08 
   30   16 -.117126860e-07  .477817150e-08 
   31   16 -.744362400e-08  .180811360e-08 
   32   16  .431542470e-08  .166751510e-08 
   33   16  .515057340e-08  .491141530e-08 
   34   16 -.281581920e-08 -.120639740e-08 
   35   16 -.437081110e-08 -.246030530e-08 
   36   16  .302524100e-09  .898213700e-09 
   37   16  .334643250e-08  .118220630e-07 
   38   16 -.662267010e-08  .707002060e-08 
   39   16 -.206325410e-08 -.460672050e-08 
   40   16 -.406326370e-08 -.512272450e-08 
   41   16 -.129435840e-08 -.485562030e-09 
   42   16  .199607430e-08  .162792650e-09 
   43   16  .236700880e-08 -.236755430e-08 
   44   16  .103873490e-08  .163916750e-08 
   45   16  .158210160e-08 -.104450190e-08 
   46   16  .145433440e-08  .277954170e-08 
   47   16  .208799340e-08  .545700580e-09 
   48   16 -.420960430e-09  .137845590e-08 
   49   16  .740632840e-11 -.202233770e-08 
   50   16 -.421558580e-09 -.101904290e-08 
   51   16 -.387633710e-09 -.425283240e-09 
   52   16  .209065930e-09  .412604460e-09 
   53   16  .907543400e-09  .109459620e-08 
   54   16 -.548458590e-09  .133375820e-08 
   55   16  .307808840e-09 -.314830640e-09 
   56   16 -.127087370e-09 -.562059420e-09 
   57   16 -.127786920e-09  .370977410e-09 
   58   16  .331625080e-09  .313531190e-10 
   59   16 -.117404380e-09 -.472206340e-09 
   60   16  .439655080e-10 -.411774790e-09 
   61   16 -.135736270e-09 -.124285640e-09 
   62   16  .335775100e-10  .127553080e-09 
   63   16  .280142620e-09  .297297390e-09 
   64   16 -.971036030e-11  .103745630e-09 
   65   16 -.154897080e-10 -.413281170e-10 
   66   16 -.916487580e-10 -.192294180e-09 
   67   16 -.111514800e-09 -.249555530e-09 
   68   16  .946712530e-11 -.238545160e-09 
   69   16 -.117254820e-09  .129611380e-09 
   70   16 -.119501470e-10  .105189790e-09 
   17   17 -.344468940e-07 -.197317810e-07 
   18   17  .373662170e-08  .452400460e-08 
   19   17  .290060440e-07 -.152272370e-07 
   20   17  .439052400e-08 -.137237710e-07 
   21   17 -.757167330e-08 -.687976460e-08 
   22   17  .882303970e-08 -.139993760e-07 
   23   17 -.500084770e-08 -.131992350e-07 
   24   17 -.118473980e-07 -.634799580e-08 
   25   17 -.149171780e-07 -.279746580e-08 
   26   17 -.114737790e-07  .908109060e-08 
   27   17  .296263820e-08  .813325940e-10 
   28   17  .130673690e-07 -.735059420e-08 
   29   17  .779357000e-10 -.401409310e-08 
   30   17 -.589453350e-08 -.122485460e-08 
   31   17 -.604433230e-08  .770233500e-08 
   32   17 -.821596120e-08  .702165410e-08 
   33   17 -.206467940e-08  .107194000e-07 
   34   17 -.110493350e-08  .429864020e-08 
   35   17  .302238370e-08 -.943620720e-08 
   36   17  .548238620e-08 -.642831960e-08 
   37   17  .113940560e-08 -.873152330e-09 
   38   17  .116708160e-08 -.297700760e-09 
   39   17 -.760428870e-09 -.196172630e-08 
   40   17 -.610325060e-09  .579436650e-09 
   41   17  .182137410e-08  .485266980e-09 
   42   17  .147496130e-08  .586945220e-09 
   43   17  .649685230e-09 -.180807480e-09 
   44   17  .861625820e-09 -.116339700e-08 
   45   17  .271305560e-08 -.231589850e-09 
   46   17 -.200808860e-08 -.107434490e-08 
   47   17  .745397770e-09  .104707470e-08 
   48   17 -.635542440e-09  .556198590e-09 
   49   17 -.192497910e-09 -.137140880e-09 
   50   17  .189369120e-09 -.673462960e-09 
   51   17 -.693718520e-09  .785899530e-12 
   52   17  .474945000e-09 -.484484170e-09 
   53   17 -.169363970e-08 -.320636860e-10 
   54   17  .195270230e-09  .466129850e-10 
   55   17  .379666540e-09 -.230149850e-09 
   56   17 -.487644330e-09  .500484960e-09 
   57   17  .467909690e-09  .529052530e-10 
   58   17  .101830280e-11  .358664410e-09 
   59   17 -.131150370e-09  .646391820e-10 
   60   17  .180149140e-10 -.217624880e-09 
   61   17  .295518380e-10  .165522280e-10 
   62   17  .800799180e-10 -.149649680e-09 
   63   17 -.178513630e-09 -.358905880e-12 
   64   17 -.950437610e-10  .797133680e-10 
   65   17  .143793550e-09 -.392467210e-10 
   66   17 -.959614610e-10  .110637340e-09 
   67   17  .464658460e-10 -.378485750e-10 
   68   17  .519786120e-10 -.686161280e-10 
   69   17 -.244901060e-09  .868100140e-10 
   70   17  .660691250e-10 -.399780950e-10 
   18   18  .301511790e-08 -.110214980e-07 
   19   18  .349357680e-07 -.954074750e-08 
   20   18  .151686820e-07 -.489471930e-09 
   21   18  .264446470e-07 -.103292030e-07 
   22   18  .100958790e-07 -.166172590e-07 
   23   18  .777184160e-08 -.155396850e-07 
   24   18 -.475306610e-09 -.952569900e-08 
   25   18  .277760720e-08 -.144967880e-07 
   26   18 -.116952820e-07  .517149730e-08 
   27   18 -.450338820e-08  .762914790e-08 
   28   18  .170171370e-08 -.261676910e-08 
   29   18  .270487900e-09 -.126846740e-08 
   30   18 -.724430640e-08 -.837663310e-08 
   31   18 -.413573620e-08 -.287414760e-08 
   32   18  .773494970e-08 -.202041290e-08 
   33   18 -.835236840e-08 -.171678550e-08 
   34   18 -.851810370e-08 -.260228380e-08 
   35   18 -.343400880e-08 -.107565460e-07 
   36   18  .288938640e-08  .459631750e-08 
   37   18  .210038840e-08  .646643290e-08 
   38   18  .156352680e-09 -.239064540e-08 
   39   18  .256933190e-08 -.521847580e-09 
   40   18  .220631960e-08  .135356430e-08 
   41   18 -.118813790e-08  .273509350e-08 
   42   18 -.325148990e-08  .147516760e-08 
   43   18  .119503010e-08 -.117981760e-08 
   44   18  .158250280e-08 -.630979430e-09 
   45   18 -.126670290e-08 -.155904040e-08 
   46   18  .206651020e-09 -.615400950e-09 
   47   18  .955959630e-09  .123591150e-08 
   48   18 -.582294070e-09 -.819876360e-09 
   49   18  .347541050e-09 -.213030980e-09 
   50   18  .634762150e-09 -.295806780e-10 
   51   18 -.621662830e-09  .567121040e-09 
   52   18 -.733984940e-09 -.310578640e-09 
   53   18  .776061710e-09  .555920710e-09 
   54   18  .169852390e-09 -.295002990e-09 
   55   18  .255600560e-09  .135476200e-09 
   56   18  .594593900e-10 -.488725580e-10 
   57   18 -.191629250e-09  .409145800e-09 
   58   18 -.131527490e-09  .135683520e-09 
   59   18  .145495580e-10 -.274889900e-09 
   60   18  .186102960e-09  .831999820e-10 
   61   18 -.280096230e-09 -.203989930e-09 
   62   18 -.109999400e-09  .727752180e-10 
   63   18  .957784050e-10  .734472070e-10 
   64   18 -.696874570e-11 -.112700600e-09 
   65   18  .115225220e-09 -.300270750e-10 
   66   18  .878562090e-10  .596209170e-10 
   67   18 -.108689720e-09  .470358250e-10 
   68   18 -.107374100e-09  .204856000e-10 
   69   18 -.298475480e-11  .401471610e-11 
   70   18  .180872150e-10  .487685850e-11 
   19   19 -.223729950e-08  .476573510e-08 
   20   19 -.294052310e-08  .105917280e-07 
   21   19 -.262210410e-07  .166990480e-07 
   22   19  .141711790e-07 -.368100990e-08 
   23   19 -.607720540e-08  .104689600e-07 
   24   19 -.395377800e-08 -.868826610e-08 
   25   19  .875012520e-08  .977249710e-08 
   26   19 -.663894150e-09  .388939240e-08 
   27   19  .100279640e-08 -.105916180e-08 
   28   19  .410129550e-08  .221973290e-07 
   29   19 -.707946390e-08  .210019460e-08 
   30   19 -.108270680e-07  .334764360e-08 
   31   19  .285642420e-08  .829129740e-08 
   32   19  .546228200e-09 -.493876780e-08 
   33   19  .704856780e-08 -.247366500e-09 
   34   19 -.797737740e-09  .587384180e-08 
   35   19  .682198390e-09 -.281348530e-08 
   36   19 -.357775260e-08 -.404223040e-08 
   37   19 -.306890850e-08  .222091760e-08 
   38   19 -.758863690e-10 -.123715510e-08 
   39   19  .350712790e-08  .438316240e-09 
   40   19  .586258650e-10 -.365795830e-08 
   41   19 -.332903530e-08 -.269788110e-09 
   42   19  .993480600e-09 -.194511840e-08 
   43   19 -.107822950e-08  .544719800e-10 
   44   19 -.100751770e-08 -.687893870e-09 
   45   19 -.117998300e-08 -.268064220e-08 
   46   19 -.456241610e-09 -.227161130e-08 
   47   19  .330214930e-10  .167651370e-09 
   48   19 -.604618050e-09  .522292850e-09 
   49   19  .119244760e-08 -.754336030e-09 
   50   19 -.188696400e-10  .627919420e-09 
   51   19  .104106710e-11  .190562580e-09 
   52   19  .780082490e-10  .317710970e-09 
   53   19  .283798280e-09  .738514310e-09 
   54   19  .185123880e-09  .538427750e-09 
   55   19  .238994280e-09 -.547540700e-10 
   56   19  .225458600e-09 -.313907570e-10 
   57   19 -.318613110e-09  .374409800e-09 
   58   19  .844830070e-10  .195596320e-09 
   59   19  .837554120e-10 -.736502020e-10 
   60   19  .842913760e-11  .179619560e-10 
   61   19 -.669208550e-10 -.999849360e-10 
   62   19 -.231067110e-10 -.115417530e-09 
   63   19 -.103241180e-09  .408489180e-10 
   64   19 -.103953930e-09  .733991180e-10 
   65   19  .101554460e-09 -.870837250e-10 
   66   19  .391379960e-10 -.411147800e-10 
   67   19 -.795160180e-11  .250027850e-10 
   68   19 -.165361260e-10 -.192199960e-10 
   69   19  .359722360e-10  .459021740e-10 
   70   19  .773266980e-11  .479662220e-10 
   20   20  .370442380e-08 -.121028970e-07 
   21   20 -.266195180e-07  .163376850e-07 
   22   20 -.175193150e-07  .199189940e-07 
   23   20  .844319030e-08 -.527982270e-08 
   24   20 -.423803840e-08  .856872610e-08 
   25   20 -.674165310e-08 -.322971300e-09 
   26   20  .637763660e-08 -.113968090e-07 
   27   20 -.151848590e-08  .282527580e-08 
   28   20 -.203584200e-08  .831496180e-08 
   29   20 -.613025520e-08  .697759120e-08 
   30   20 -.376273290e-08  .108862900e-07 
   31   20 -.286827590e-08  .384155200e-08 
   32   20  .244866520e-08 -.578645480e-09 
   33   20 -.126752110e-08 -.375441970e-08 
   34   20  .604939490e-08 -.638700780e-08 
   35   20 -.880740610e-09 -.300139740e-08 
   36   20 -.658308940e-08  .269822270e-08 
   37   20 -.459180200e-08 -.219429970e-08 
   38   20  .282225700e-08 -.187717360e-08 
   39   20 -.162570320e-08 -.636247350e-08 
   40   20 -.424016660e-08  .341892460e-08 
   41   20  .302961160e-08  .112290510e-08 
   42   20  .471637130e-08 -.180729220e-08 
   43   20 -.208551520e-08 -.761600170e-09 
   44   20 -.267846730e-08  .223385330e-08 
   45   20  .175056000e-08  .161059800e-08 
   46   20  .214547140e-08 -.268562780e-08 
   47   20 -.108095870e-08  .356519930e-09 
   48   20 -.183984400e-09 -.216892400e-09 
   49   20  .654303790e-09 -.331428340e-09 
   50   20 -.774630070e-09  .685171030e-09 
   51   20  .207368920e-09  .265073280e-09 
   52   20  .897695370e-09  .174258910e-10 
   53   20 -.100199370e-08 -.489309990e-09 
   54   20 -.591849960e-09  .271016170e-09 
   55   20  .263792120e-09  .178820070e-10 
   56   20  .386248640e-09 -.508923810e-09 
   57   20 -.344507150e-09  .133564890e-09 
   58   20  .905872260e-10  .200816890e-09 
   59   20 -.811460080e-10 -.197957590e-09 
   60   20 -.212386130e-09  .170874730e-09 
   61   20  .108035380e-09  .673668120e-10 
   62   20  .232633830e-09 -.215905850e-09 
   63   20 -.120696790e-09  .854328590e-10 
   64   20 -.112236320e-09 -.325092300e-10 
   65   20  .922777560e-10 -.282322040e-11 
   66   20 -.898519800e-10  .377779770e-10 
   67   20  .421066730e-10  .351837890e-10 
   68   20  .691040100e-10  .527438690e-10 
   69   20 -.851939820e-10 -.709262970e-10 
   70   20 -.418332080e-10  .370026410e-10 
   21   21  .817913150e-08 -.394352730e-08 
   22   21 -.253478320e-07  .238956630e-07 
   23   21  .153603580e-07  .115417450e-07 
   24   21  .599344140e-08  .132528220e-07 
   25   21  .111591530e-07  .785710780e-08 
   26   21 -.937372120e-08  .360142430e-08 
   27   21  .366859340e-08 -.606905460e-08 
   28   21  .707710070e-08  .573153990e-08 
   29   21 -.902272170e-08 -.623717950e-08 
   30   21 -.122590760e-07 -.583029970e-08 
   31   21 -.967610920e-08  .963019580e-08 
   32   21 -.228285410e-08  .902583150e-08 
   33   21  .139446330e-08 -.172529530e-08 
   34   21  .439797280e-09 -.239055660e-08 
   35   21  .975274610e-08  .279805930e-08 
   36   21  .869819340e-08 -.534415310e-08 
   37   21  .122840310e-08 -.260993250e-08 
   38   21 -.197646060e-09 -.881491670e-09 
   39   21 -.552452520e-09  .910826860e-09 
   40   21 -.561090270e-09  .372911300e-09 
   41   21 -.187697580e-08  .110915260e-10 
   42   21 -.328583300e-08 -.824612290e-09 
   43   21  .108530860e-09  .377108130e-08 
   44   21 -.171793360e-08  .125787340e-08 
   45   21 -.199815630e-08 -.207242880e-08 
   46   21 -.270207950e-08  .137848230e-09 
   47   21 -.596491030e-09  .179530570e-08 
   48   21 -.488176730e-09  .648790700e-09 
   49   21 -.424892440e-09 -.839274020e-09 
   50   21  .361060600e-09 -.784231680e-09 
   51   21  .442474360e-09  .839616990e-14 
   52   21  .700817440e-09 -.132548710e-09 
   53   21  .931145680e-10  .837465370e-10 
   54   21  .508517640e-09 -.228501760e-09 
   55   21 -.460741750e-10 -.350707490e-09 
   56   21  .689149010e-10 -.231912160e-09 
   57   21  .372462760e-09  .566799830e-09 
   58   21  .200157380e-10  .114335150e-09 
   59   21  .152763410e-09 -.897319230e-10 
   60   21  .363145390e-10 -.574957010e-10 
   61   21 -.859318620e-10 -.615856850e-10 
   62   21  .404192700e-10  .170033210e-09 
   63   21 -.408566310e-10  .609704100e-10 
   64   21  .143064350e-10 -.171192720e-10 
   65   21 -.830877640e-10 -.122627280e-09 
   66   21 -.488048020e-10 -.345107800e-10 
   67   21  .844303070e-10  .422274500e-10 
   68   21  .109170180e-10  .240839240e-10 
   69   21  .292073450e-10  .105871910e-10 
   70   21  .415942940e-10 -.223883760e-10 
   22   22 -.897308450e-08  .298567500e-08 
   23   22 -.173172390e-07  .476550560e-08 
   24   22  .397034650e-08 -.286915940e-08 
   25   22 -.122701320e-07  .398497680e-08 
   26   22  .125912260e-07  .780504820e-08 
   27   22 -.604798090e-08  .325324630e-08 
   28   22 -.297872660e-08 -.819569640e-08 
   29   22  .132407410e-07 -.139326310e-08 
   30   22 -.334642060e-08 -.625093120e-08 
   31   22 -.619116540e-08 -.121083520e-07 
   32   22 -.928116650e-08 -.196364700e-08 
   33   22 -.922713420e-08 -.121923870e-07 
   34   22 -.168465230e-09  .556860090e-08 
   35   22  .497789040e-08  .321859300e-08 
   36   22 -.683073380e-09  .948270270e-09 
   37   22  .848612390e-08  .455153140e-09 
   38   22 -.949964850e-09  .153590190e-08 
   39   22 -.436001910e-08 -.961492850e-09 
   40   22 -.561935890e-08 -.540003940e-08 
   41   22 -.263495790e-08 -.488946570e-09 
   42   22  .428859340e-08 -.101363650e-08 
   43   22 -.212159690e-09 -.168216450e-08 
   44   22 -.678569150e-09 -.731516980e-09 
   45   22  .319292580e-08  .238908300e-08 
   46   22  .447455000e-08  .140429440e-08 
   47   22 -.168012020e-08 -.764762940e-09 
   48   22 -.197890160e-08  .754439300e-09 
   49   22  .313126320e-09  .163121130e-08 
   50   22  .792246230e-09  .615972350e-09 
   51   22  .951846140e-10 -.710808270e-09 
   52   22  .245830370e-10  .880482590e-09 
   53   22 -.268025820e-09  .921907250e-09 
   54   22 -.783294990e-09 -.237175450e-09 
   55   22  .146827000e-09 -.144086710e-09 
   56   22  .226042760e-09 -.442196340e-10 
   57   22 -.668952220e-09 -.193337730e-09 
   58   22 -.256747920e-09 -.236948290e-09 
   59   22  .231610920e-09  .151390350e-09 
   60   22  .296297140e-09 -.160153110e-09 
   61   22  .156812380e-09 -.259189840e-09 
   62   22  .147598380e-09  .949980420e-10 
   63   22 -.815552190e-10  .140795870e-09 
   64   22 -.185431130e-09 -.821077630e-10 
   65   22  .503652520e-10 -.311650880e-10 
   66   22  .103403340e-09  .566188320e-11 
   67   22 -.826649130e-10 -.671287170e-10 
   68   22 -.922086400e-11  .691993410e-10 
   69   22  .226650350e-10  .458768410e-10 
   70   22 -.171495470e-10 -.144938510e-10 
   23   23  .300291670e-08 -.119220490e-07 
   24   23 -.630682640e-08 -.778473390e-08 
   25   23  .832004200e-08 -.131141310e-07 
   26   23  .262916450e-08  .110441790e-07 
   27   23 -.530393730e-08 -.872399390e-08 
   28   23  .540669040e-08  .360336940e-08 
   29   23 -.306404830e-08 -.475250260e-09 
   30   23  .529624700e-08 -.850960560e-08 
   31   23  .773570560e-08  .528868520e-08 
   32   23  .794594700e-08 -.150669820e-08 
   33   23 -.311779440e-09 -.660919210e-08 
   34   23  .247737620e-08 -.112761530e-07 
   35   23 -.940961310e-08  .516120000e-09 
   36   23 -.358033420e-08  .256175630e-08 
   37   23 -.191431030e-08  .118585820e-08 
   38   23 -.108119490e-08  .574805640e-08 
   39   23 -.472944740e-08  .162797480e-08 
   40   23  .689961010e-09 -.726978290e-08 
   41   23  .166551540e-08 -.375736670e-08 
   42   23 -.146586610e-08 -.102221830e-08 
   43   23 -.283955510e-08 -.262110560e-08 
   44   23 -.147818810e-08  .221500590e-08 
   45   23  .348716770e-08 -.662990780e-09 
   46   23  .183406610e-08  .121719140e-08 
   47   23 -.329465210e-09  .120168740e-08 
   48   23 -.850493930e-09  .112257860e-08 
   49   23  .187812680e-08  .301918420e-09 
   50   23 -.159807760e-09 -.168448040e-08 
   51   23 -.265770060e-09  .138636790e-08 
   52   23 -.901518980e-09  .142909210e-08 
   53   23  .233746580e-09 -.204216790e-09 
   54   23  .358107160e-09 -.498026890e-09 
   55   23 -.204770840e-09  .340611620e-09 
   56   23  .419507050e-09 -.670728640e-09 
   57   23 -.216216210e-09 -.302808350e-09 
   58   23 -.334042860e-09  .378915410e-09 
   59   23 -.424227680e-10 -.232899580e-09 
   60   23  .179964200e-09 -.340608070e-09 
   61   23 -.227658800e-09 -.149742130e-09 
   62   23  .135261890e-09  .304948090e-09 
   63   23  .135806580e-09 -.200835530e-10 
   64   23  .138897140e-10 -.114833040e-11 
   65   23  .135447950e-10  .403079510e-10 
   66   23 -.358488040e-11 -.210191820e-09 
   67   23 -.321142390e-10 -.641337350e-10 
   68   23 -.810234980e-10  .199179470e-09 
   69   23  .353325450e-10  .634932040e-10 
   70   23  .170769430e-10 -.650005710e-10 
   24   24  .115917510e-07 -.347806380e-08 
   25   24  .505399800e-08 -.771397540e-08 
   26   24  .858924280e-08  .151842110e-07 
   27   24  .377280600e-09 -.126861980e-08 
   28   24  .999476320e-08 -.141388910e-07 
   29   24  .211024780e-08 -.179419350e-08 
   30   24 -.139354950e-08 -.173669090e-08 
   31   24 -.136713300e-08 -.276626570e-08 
   32   24 -.428082670e-08  .456961700e-09 
   33   24  .924360880e-08 -.536072610e-08 
   34   24  .843837730e-08  .215210040e-08 
   35   24  .549247680e-08  .244985600e-08 
   36   24 -.145223950e-08 -.392725650e-08 
   37   24 -.852726270e-08 -.514735440e-08 
   38   24 -.759940380e-08  .115682630e-08 
   39   24 -.586210840e-08  .448680090e-08 
   40   24  .101349280e-08  .394756850e-08 
   41   24  .547483280e-08  .134693530e-08 
   42   24  .375057900e-08 -.717696840e-09 
   43   24  .283041970e-08  .890542440e-10 
   44   24 -.258156990e-08 -.417217010e-08 
   45   24 -.373653110e-08  .143085740e-11 
   46   24  .137517190e-08  .567612650e-09 
   47   24  .722794120e-09 -.776665150e-09 
   48   24 -.158453590e-08 -.130851500e-08 
   49   24 -.311163470e-09  .208590200e-09 
   50   24  .308316030e-08  .749575570e-09 
   51   24  .137713870e-08 -.124976270e-08 
   52   24 -.147303390e-08 -.390165670e-09 
   53   24 -.199326010e-08  .109368980e-08 
   54   24  .114504060e-08  .118154930e-08 
   55   24  .864857560e-09 -.536501360e-09 
   56   24  .406237680e-10  .147091080e-09 
   57   24 -.416100360e-09  .666418040e-09 
   58   24 -.830582670e-10  .479245680e-10 
   59   24  .275320380e-09 -.228340460e-09 
   60   24  .153863430e-09 -.374840390e-10 
   61   24  .924227390e-10 -.885474180e-10 
   62   24 -.522773160e-09 -.247658070e-09 
   63   24 -.352431160e-09  .198960620e-09 
   64   24  .296699280e-09  .844569890e-10 
   65   24  .270386990e-09 -.225418740e-09 
   66   24 -.423257510e-11 -.396066410e-10 
   67   24 -.700717190e-10  .536204220e-10 
   68   24 -.140160280e-09 -.544530130e-10 
   69   24 -.687177020e-10 -.961565630e-11 
   70   24  .657509370e-10  .665060970e-10 
   25   25  .105126940e-07  .495070630e-08 
   26   25  .401512000e-08  .412533860e-09 
   27   25  .119033750e-07  .583346000e-08 
   28   25  .720099700e-08 -.159483960e-07 
   29   25  .534181930e-08  .930706710e-08 
   30   25  .394971270e-08 -.152042660e-07 
   31   25 -.165892060e-07 -.185717380e-08 
   32   25 -.192876140e-07 -.438081680e-08 
   33   25  .372777740e-08 -.110587170e-07 
   34   25  .787694810e-08 -.831744490e-08 
   35   25  .685719460e-08  .328267650e-08 
   36   25  .521120230e-08  .169626160e-07 
   37   25  .497338450e-08 -.279045030e-08 
   38   25 -.645266330e-09 -.341597510e-08 
   39   25 -.347366490e-08 -.428829900e-08 
   40   25 -.338671170e-08 -.171310780e-08 
   41   25 -.517945010e-08  .182484810e-08 
   42   25 -.231073390e-08  .587156520e-08 
   43   25  .191158570e-08  .400269880e-08 
   44   25  .482822470e-09  .669877770e-09 
   45   25  .203752300e-08 -.984404540e-09 
   46   25  .246130390e-08 -.633795260e-08 
   47   25 -.854548120e-09 -.191239740e-08 
   48   25  .101117170e-08  .797627140e-09 
   49   25  .160878240e-09 -.689038590e-09 
   50   25  .213802220e-08  .992375240e-09 
   51   25 -.582628700e-09  .956753560e-09 
   52   25  .776802210e-10  .847224450e-09 
   53   25  .238343460e-09  .286793040e-09 
   54   25 -.809972360e-10 -.655362000e-09 
   55   25 -.107327250e-08  .645062650e-09 
   56   25 -.116921120e-08  .414883360e-09 
   57   25  .112463980e-08  .232225110e-09 
   58   25 -.428476490e-09  .108542270e-09 
   59   25  .242007270e-09  .227747660e-09 
   60   25 -.211125030e-10 -.517044770e-09 
   61   25  .290287540e-09 -.274019780e-09 
   62   25 -.468938020e-10 -.572847020e-11 
   63   25  .470600460e-11 -.337766240e-09 
   64   25  .385657950e-10 -.947851810e-10 
   65   25 -.292516840e-09  .798796700e-10 
   66   25 -.349708450e-11  .115249870e-09 
   67   25  .175542100e-09  .649470370e-10 
   68   25  .470153340e-10  .848090440e-10 
   69   25 -.614071830e-10  .217863300e-10 
   70   25  .141239680e-10 -.753626450e-10 
   26   26  .601312930e-09  .251096630e-08 
   27   26 -.679400780e-08 -.245570740e-08 
   28   26  .120743600e-07  .474214280e-08 
   29   26  .763514980e-08 -.742259190e-08 
   30   26  .171981360e-08  .115220750e-07 
   31   26 -.121772110e-07  .144835450e-08 
   32   26  .404122380e-08 -.194371860e-08 
   33   26  .101247900e-07  .455461930e-08 
   34   26  .302130050e-08 -.119140380e-07 
   35   26 -.472047870e-08  .278017780e-08 
   36   26  .378377030e-08  .786193850e-08 
   37   26  .555000960e-08  .108200240e-07 
   38   26 -.288766100e-08  .524229580e-08 
   39   26 -.266432550e-08  .696349750e-08 
   40   26  .749013440e-08 -.208072780e-08 
   41   26  .659727600e-08 -.701264040e-08 
   42   26 -.482234100e-08 -.534337620e-08 
   43   26 -.460286690e-08  .272265590e-08 
   44   26  .886220280e-09  .190987100e-08 
   45   26  .235330540e-08  .338774290e-08 
   46   26  .213502440e-08  .679962830e-08 
   47   26  .502401070e-08  .221460530e-09 
   48   26  .966820960e-09 -.206168170e-08 
   49   26 -.185332860e-08  .510156880e-10 
   50   26 -.331509630e-08  .844571000e-09 
   51   26 -.154434040e-08  .226607190e-09 
   52   26 -.654666150e-09 -.962907690e-09 
   53   26  .811817930e-09 -.713356740e-09 
   54   26 -.936884440e-09 -.275242960e-09 
   55   26 -.124478890e-09 -.511185550e-09 
   56   26  .987282800e-09 -.152586420e-08 
   57   26 -.592041380e-09 -.940877130e-10 
   58   26 -.296671570e-09  .333798220e-09 
   59   26 -.261804960e-09  .491899450e-09 
   60   26  .554750090e-09  .379156050e-09 
   61   26  .329141190e-09 -.170595010e-09 
   62   26  .163910180e-09 -.413129200e-10 
   63   26  .134802140e-09  .521625920e-12 
   64   26 -.433168180e-10  .184559400e-09 
   65   26 -.141163020e-09 -.229871580e-10 
   66   26  .100416620e-09 -.174120530e-09 
   67   26 -.394959040e-10 -.156136530e-10 
   68   26 -.281040790e-09  .632578180e-10 
   69   26  .810058560e-10  .700542170e-10 
   70   26  .154385310e-10  .631726610e-10 
   27   27  .801205230e-08  .594453000e-09 
   28   27 -.745910120e-08  .993688740e-09 
   29   27 -.759248520e-08 -.110377570e-08 
   30   27 -.754661790e-08  .125752270e-07 
   31   27 -.722379630e-09  .109109250e-07 
   32   27 -.353631200e-08 -.690668000e-08 
   33   27 -.163113310e-08  .134013700e-08 
   34   27  .130368030e-07 -.433858490e-08 
   35   27  .117508770e-07 -.135327040e-07 
   36   27 -.806525280e-08  .917951780e-08 
   37   27 -.347754210e-08  .423029850e-08 
   38   27 -.120935630e-08  .839318900e-08 
   39   27 -.769680370e-08 -.150431530e-08 
   40   27 -.909255480e-09  .214718460e-08 
   41   27  .114789270e-08 -.756028880e-09 
   42   27  .542012780e-08 -.219856130e-08 
   43   27  .563605960e-08  .234787010e-08 
   44   27  .451189800e-08 -.500800140e-08 
   45   27 -.386162550e-08 -.322013370e-08 
   46   27 -.606829570e-08  .413100480e-08 
   47   27 -.362124280e-08  .203394030e-08 
   48   27 -.779457100e-09  .337658060e-08 
   49   27 -.208600540e-08  .721458550e-09 
   50   27  .212591620e-08 -.312537290e-08 
   51   27  .327968500e-09 -.388586460e-08 
   52   27 -.106417930e-08 -.115034410e-08 
   53   27  .136983310e-08 -.319604140e-09 
   54   27 -.969682370e-09  .462587090e-09 
   55   27  .811019580e-09  .660624990e-10 
   56   27 -.236617240e-09  .647366530e-09 
   57   27 -.110663410e-10 -.158363020e-10 
   58   27  .120499470e-08 -.845345390e-09 
   59   27  .280408800e-09 -.464664910e-09 
   60   27 -.421915710e-09  .178447090e-09 
   61   27 -.318026950e-09  .645098180e-09 
   62   27  .751915510e-10  .383156540e-09 
   63   27 -.417434220e-09  .515872200e-09 
   64   27 -.835793180e-10 -.331717520e-10 
   65   27 -.474573150e-10 -.159797580e-09 
   66   27  .282508760e-09 -.363489120e-10 
   67   27  .128393120e-09 -.378904650e-10 
   68   27  .995367750e-10 -.130059320e-09 
   69   27  .125149250e-09 -.135932320e-10 
   70   27 -.244965090e-09  .989364530e-10 
   28   28  .664409340e-08  .723545240e-08 
   29   28  .944545480e-08 -.564485820e-08 
   30   28 -.599268470e-08 -.766504130e-08 
   31   28  .102299340e-07  .279545040e-08 
   32   28  .164852390e-08 -.581140030e-08 
   33   28  .128729360e-08 -.805886620e-09 
   34   28 -.294178450e-09 -.202925930e-07 
   35   28  .737211750e-08 -.155094040e-07 
   36   28  .178185120e-08 -.490842280e-08 
   37   28  .125368320e-07  .400344760e-08 
   38   28 -.474030960e-08 -.450986860e-08 
   39   28 -.260525010e-08 -.975606420e-08 
   40   28  .201100000e-08  .498523980e-08 
   41   28 -.273511310e-08 -.533074830e-08 
   42   28 -.331850420e-08  .278937700e-08 
   43   28 -.166506750e-08  .770217080e-08 
   44   28 -.114055380e-08  .317896620e-08 
   45   28  .694100940e-08  .981449230e-09 
   46   28  .772664360e-09 -.646184760e-08 
   47   28  .353383920e-09 -.905782860e-08 
   48   28 -.305149720e-10 -.291400300e-08 
   49   28 -.135999590e-08 -.562438970e-08 
   50   28 -.444240560e-09  .998559450e-09 
   51   28  .153506860e-08  .131592520e-08 
   52   28  .545814950e-09  .203579050e-08 
   53   28  .119051860e-08  .243520970e-08 
   54   28  .127024900e-08 -.588580950e-09 
   55   28  .937997100e-09  .229283920e-08 
   56   28 -.456753630e-09  .624123670e-09 
   57   28 -.456811230e-09 -.989455990e-09 
   58   28 -.168172300e-09 -.618534610e-09 
   59   28  .192922490e-09  .675037050e-09 
   60   28 -.501893540e-09  .847888750e-09 
   61   28  .375379840e-09 -.864858210e-09 
   62   28 -.198495130e-09 -.737960960e-09 
   63   28 -.212453380e-09  .327979640e-09 
   64   28 -.319562890e-09  .298149740e-10 
   65   28 -.126627730e-09 -.350333460e-10 
   66   28  .865194500e-10  .940008740e-10 
   67   28 -.104828590e-09  .123036720e-09 
   68   28  .452144490e-10 -.561452810e-10 
   69   28  .223186730e-09  .144265120e-09 
   70   28 -.527435540e-11  .954654140e-10 
   29   29  .126310500e-07 -.524931720e-08 
   30   29  .403863550e-08  .179094570e-08 
   31   29 -.173112860e-08 -.219047440e-08 
   32   29  .430867290e-08  .248287910e-08 
   33   29 -.164768140e-07  .555673190e-08 
   34   29  .657353760e-08 -.411318880e-08 
   35   29  .758238700e-08  .354387540e-08 
   36   29  .244729250e-08 -.963914480e-10 
   37   29  .543515230e-08  .743055660e-08 
   38   29  .613815690e-08  .382293310e-08 
   39   29 -.220745070e-08 -.358186060e-08 
   40   29  .111402280e-08  .596026680e-09 
   41   29 -.208356190e-08  .606310690e-08 
   42   29 -.502885470e-08  .841599640e-09 
   43   29 -.475482140e-08  .103457470e-08 
   44   29 -.581958650e-08  .858267030e-09 
   45   29 -.306497140e-08 -.628079270e-10 
   46   29 -.171387540e-08 -.736812800e-09 
   47   29  .296232960e-08 -.229542690e-09 
   48   29  .197501960e-08 -.134123600e-08 
   49   29  .538718760e-09 -.105338810e-08 
   50   29  .873686060e-09 -.234673910e-08 
   51   29 -.228460660e-08  .199243690e-09 
   52   29 -.467266830e-09 -.196477930e-08 
   53   29 -.235790210e-08  .832126790e-09 
   54   29 -.161527340e-09  .792703600e-09 
   55   29 -.115089810e-08  .835173320e-09 
   56   29 -.284240000e-09  .366981260e-09 
   57   29 -.982356970e-09 -.123228430e-08 
   58   29 -.352437760e-09  .151867490e-08 
   59   29  .262968640e-09  .840477530e-09 
   60   29 -.673135680e-12 -.686071050e-09 
   61   29  .521541080e-10 -.638407160e-09 
   62   29 -.161202120e-09  .853103100e-09 
   63   29  .126864500e-08  .780932710e-09 
   64   29  .688800870e-10 -.682227320e-09 
   65   29 -.205364400e-09 -.787710250e-09 
   66   29 -.292192420e-09  .343739080e-09 
   67   29  .389946520e-09  .572090960e-09 
   68   29  .121597130e-09 -.479131970e-09 
   69   29 -.490369990e-09  .926692000e-10 
   70   29 -.219431130e-11  .873203290e-11 
   30   30  .259497230e-08  .815754700e-08 
   31   30 -.429963180e-09 -.729701830e-08 
   32   30 -.682033650e-08  .978982730e-09 
   33   30 -.710746530e-09 -.183996750e-07 
   34   30 -.201832010e-07 -.675744430e-09 
   35   30 -.488503720e-08  .382193550e-08 
   36   30 -.979448440e-08  .444881950e-08 
   37   30 -.617950410e-08  .124935190e-07 
   38   30  .135094430e-08  .197764160e-08 
   39   30  .461847740e-08 -.100818850e-07 
   40   30 -.420291290e-09  .760285810e-09 
   41   30 -.278084050e-09 -.176884640e-08 
   42   30  .610722130e-08  .177121300e-08 
   43   30 -.583827580e-08 -.397898630e-08 
   44   30  .164980120e-08 -.297011090e-08 
   45   30 -.297536390e-08 -.277547630e-08 
   46   30 -.216660020e-08 -.512341600e-08 
   47   30  .208654790e-09  .497318580e-08 
   48   30 -.181300850e-08  .124377330e-09 
   49   30  .855891540e-09  .213614790e-08 
   50   30  .656780920e-09  .103031840e-08 
   51   30 -.104984850e-08 -.323929320e-09 
   52   30 -.147242770e-08  .643009900e-10 
   53   30  .231847960e-08 -.815043960e-09 
   54   30  .216464320e-08  .394731020e-09 
   55   30 -.488670050e-09  .915962490e-09 
   56   30 -.220079990e-08 -.100747590e-09 
   57   30  .256753680e-08 -.517099130e-09 
   58   30  .249472950e-08  .266372660e-09 
   59   30 -.270753280e-08 -.152911090e-08 
   60   30 -.247787350e-08 -.519339180e-09 
   61   30  .982224070e-09  .424285220e-09 
   62   30  .191647550e-08  .948545670e-10 
   63   30 -.490422000e-09 -.399505270e-09 
   64   30 -.155553840e-08 -.108220030e-09 
   65   30  .209122270e-09  .109094170e-08 
   66   30  .893150070e-09  .282701850e-09 
   67   30  .312570860e-09 -.137406430e-08 
   68   30 -.245236230e-09 -.798368640e-10 
   69   30 -.965107040e-09  .917142020e-09 
   70   30 -.850453640e-10 -.217317440e-10 
   31   31 -.895446680e-08 -.142876160e-08 
   32   31 -.606707190e-08 -.117577540e-09 
   33   31  .408107150e-08  .264989860e-08 
   34   31 -.416353530e-08 -.159752460e-08 
   35   31  .776952150e-08  .305057260e-08 
   36   31 -.841058330e-08 -.590930180e-08 
   37   31  .352054590e-08 -.634677420e-08 
   38   31  .422549360e-08 -.714585150e-08 
   39   31 -.470732890e-10 -.884009670e-08 
   40   31 -.468813250e-08 -.116179840e-08 
   41   31  .990388480e-08  .167035850e-08 
   42   31  .456126090e-08  .475536960e-09 
   43   31 -.194453050e-08 -.243510970e-08 
   44   31  .466173680e-10  .350490750e-08 
   45   31 -.190809920e-08 -.758296880e-11 
   46   31 -.189600630e-08 -.247106960e-08 
   47   31  .616983250e-09 -.630923970e-09 
   48   31 -.988222100e-10 -.230196110e-08 
   49   31 -.413966400e-09 -.464275950e-09 
   50   31  .450300160e-09  .363624500e-09 
   51   31 -.165595920e-08  .155044090e-08 
   52   31 -.298469750e-09 -.250415820e-09 
   53   31 -.186240890e-09  .183877030e-08 
   54   31 -.878272390e-09 -.344454680e-09 
   55   31  .339790580e-10  .540315310e-09 
   56   31  .830716850e-09  .814524240e-09 
   57   31 -.316398090e-10 -.458451150e-09 
   58   31 -.375641070e-09  .218630650e-09 
   59   31 -.454296020e-09  .110957650e-08 
   60   31  .415330410e-09 -.574474880e-09 
   61   31  .502725850e-09 -.688210670e-09 
   62   31 -.987006040e-09 -.685280180e-09 
   63   31  .978680540e-10  .300154230e-09 
   64   31  .712054590e-09  .185272420e-09 
   65   31  .162409060e-09 -.836177400e-09 
   66   31 -.587838470e-09  .948726740e-10 
   67   31 -.211474400e-09  .750881460e-09 
   68   31  .492479020e-09 -.135072900e-09 
   69   31  .131319060e-09 -.442980410e-09 
   70   31 -.331174760e-09 -.541354530e-10 
   32   32  .203573750e-08 -.825157220e-09 
   33   32  .673689480e-08 -.417549580e-08 
   34   32  .819304790e-08  .818761590e-09 
   35   32 -.384122580e-08 -.688235710e-08 
   36   32  .947841820e-08  .219900840e-08 
   37   32  .235248880e-08  .312540690e-08 
   38   32  .906617930e-08 -.690238240e-09 
   39   32  .136924950e-08  .391426800e-08 
   40   32 -.465431360e-08 -.495154500e-08 
   41   32 -.103881000e-08  .485851570e-08 
   42   32  .280666730e-08  .498932520e-08 
   43   32 -.229484860e-08  .403740270e-08 
   44   32 -.138228130e-08 -.401108890e-09 
   45   32 -.556939020e-09 -.668609380e-09 
   46   32 -.277003410e-08 -.228234090e-08 
   47   32  .560348340e-10 -.169969210e-08 
   48   32  .670453550e-09  .941809780e-09 
   49   32  .122771410e-08 -.229278960e-08 
   50   32 -.594326330e-09  .215409170e-09 
   51   32  .161816490e-08 -.954096640e-09 
   52   32 -.705301750e-09 -.145245990e-08 
   53   32  .853570960e-09  .853811060e-09 
   54   32  .221154170e-12  .887421340e-11 
   55   32 -.125222240e-09  .333758290e-09 
   56   32  .112153990e-08  .115221370e-08 
   57   32 -.263958800e-09 -.243646010e-10 
   58   32 -.384593340e-10  .182236110e-09 
   59   32 -.545648030e-09 -.134826460e-10 
   60   32  .148333200e-09 -.418001680e-09 
   61   32 -.322636620e-09  .375185790e-09 
   62   32 -.492395530e-09  .253290130e-09 
   63   32 -.903754850e-11 -.270975310e-09 
   64   32  .489753960e-09  .190881160e-09 
   65   32  .405338600e-10 -.365576310e-10 
   66   32 -.353379240e-09 -.562099450e-10 
   67   32  .990883830e-10 -.137740530e-09 
   68   32  .260465510e-09 -.294460630e-09 
   69   32 -.670109740e-10  .311469860e-09 
   70   32 -.247967600e-09 -.338126100e-10 
   33   33 -.146714170e-08  .905403400e-08 
   34   33  .122615580e-07  .359945220e-08 
   35   33  .720117470e-08 -.410791540e-08 
   36   33  .216958140e-08 -.250457550e-08 
   37   33 -.474650850e-10 -.136931620e-07 
   38   33  .215241640e-08  .985844760e-08 
   39   33 -.195356630e-08  .160562710e-08 
   40   33 -.534453850e-08  .746723890e-09 
   41   33 -.156055920e-08  .781145910e-08 
   42   33  .516557380e-08  .528132650e-08 
   43   33  .358550850e-08 -.328773240e-09 
   44   33 -.187870850e-08 -.496542530e-09 
   45   33  .375295420e-09  .566879480e-09 
   46   33  .641930430e-08  .171869070e-08 
   47   33 -.255098550e-08 -.200820310e-08 
   48   33  .751109160e-09 -.802446870e-09 
   49   33 -.451786100e-09 -.121186160e-08 
   50   33 -.242269990e-08 -.121907630e-08 
   51   33 -.220705190e-09 -.116027320e-09 
   52   33 -.417908680e-10  .444878720e-09 
   53   33 -.173382520e-09  .298638420e-09 
   54   33 -.130751820e-09 -.924682570e-10 
   55   33  .322132580e-09  .417096290e-09 
   56   33 -.766578090e-09 -.313615010e-10 
   57   33  .630356280e-09  .407880680e-09 
   58   33  .244564690e-09 -.187541480e-09 
   59   33  .195667890e-10  .306862300e-10 
   60   33  .304903640e-09  .289720000e-09 
   61   33  .164673800e-10 -.158512280e-09 
   62   33  .306883730e-09 -.508646870e-09 
   63   33 -.262378940e-09 -.146028640e-09 
   64   33 -.387143280e-09  .406857820e-09 
   65   33  .126286020e-09 -.231471210e-10 
   66   33  .306201460e-09 -.318017720e-09 
   67   33 -.299217630e-09 -.100578300e-09 
   68   33 -.282060640e-09  .478105920e-09 
   69   33  .200968400e-09  .754491990e-10 
   70   33  .173858140e-09 -.303500960e-09 
   34   34 -.646347900e-08  .318086250e-08 
   35   34 -.150415440e-08  .139052420e-09 
   36   34 -.842173490e-08  .426766490e-08 
   37   34  .240578640e-08 -.888933190e-09 
   38   34 -.540817090e-08 -.114648460e-08 
   39   34 -.248286660e-08 -.136403050e-08 
   40   34 -.274834430e-09  .519437460e-09 
   41   34 -.341570030e-08  .230346660e-08 
   42   34  .231071150e-08  .361450220e-08 
   43   34  .305060380e-08 -.117745400e-09 
   44   34 -.489126010e-10  .810534440e-09 
   45   34 -.723080550e-10  .164253950e-08 
   46   34  .924969380e-09  .135136600e-08 
   47   34  .122654890e-08 -.331198840e-09 
   48   34 -.140335810e-08  .596450990e-09 
   49   34  .373354070e-09 -.874490230e-09 
   50   34  .623405920e-09 -.101775860e-08 
   51   34 -.144720260e-08 -.276351580e-09 
   52   34  .766850060e-09 -.857912210e-09 
   53   34 -.631473760e-09 -.579226790e-09 
   54   34 -.393850940e-10 -.223582140e-09 
   55   34  .624886230e-10 -.370851140e-09 
   56   34 -.132316310e-09 -.258941920e-09 
   57   34 -.280933990e-09  .376083210e-09 
   58   34  .217071470e-09  .914247640e-10 
   59   34  .148105970e-09  .215327540e-09 
   60   34 -.174810710e-09  .168877360e-09 
   61   34  .288500150e-09  .143730290e-09 
   62   34 -.344090570e-09  .302494340e-09 
   63   34  .358659720e-09 -.859605140e-10 
   64   34  .105716690e-09 -.186725410e-09 
   65   34 -.256303490e-09  .202293310e-09 
   66   34  .444370810e-10  .929595810e-10 
   67   34  .115936690e-09 -.183599090e-09 
   68   34  .629301450e-10 -.155583090e-09 
   69   34 -.172061170e-09  .986155120e-10 
   70   34 -.134284900e-09  .144313790e-09 
   35   35 -.583608220e-11 -.466353950e-08 
   36   35 -.188310220e-09 -.111662830e-07 
   37   35 -.439063560e-08 -.875365350e-08 
   38   35  .396716250e-08  .393560960e-08 
   39   35 -.595442530e-08 -.273538480e-08 
   40   35  .698366610e-08 -.484455060e-08 
   41   35 -.408430200e-08  .257893220e-08 
   42   35 -.445305130e-08 -.110398000e-08 
   43   35  .209568280e-10 -.215946790e-10 
   44   35 -.923646260e-08 -.219274880e-08 
   45   35  .214315380e-08  .435535650e-08 
   46   35 -.347938860e-08  .207032210e-08 
   47   35 -.760158030e-09  .124074770e-08 
   48   35 -.235281220e-09 -.125425890e-08 
   49   35  .118063320e-08  .166183430e-08 
   50   35  .148340190e-08  .122126570e-08 
   51   35  .531121460e-10  .129379790e-09 
   52   35  .247573070e-08  .354909280e-09 
   53   35 -.367295250e-09 -.136210690e-08 
   54   35  .133364200e-08 -.109618340e-08 
   55   35  .537886140e-09 -.773321610e-09 
   56   35 -.587832870e-09 -.236199310e-09 
   57   35  .539972860e-09 -.819340150e-09 
   58   35 -.405652700e-09  .334939450e-09 
   59   35 -.382390500e-09 -.394771410e-09 
   60   35 -.757221830e-10 -.362121020e-09 
   61   35 -.138400300e-09  .477145360e-10 
   62   35 -.124739050e-09 -.171898440e-09 
   63   35  .236283020e-09  .137572740e-09 
   64   35 -.170643880e-09  .285918050e-09 
   65   35 -.125433900e-09  .102312730e-09 
   66   35  .187980910e-09 -.578438700e-10 
   67   35  .857840310e-12  .165737890e-09 
   68   35  .140021070e-09  .599993120e-11 
   69   35 -.218760500e-09  .111905170e-09 
   70   35  .193977460e-10 -.151481930e-09 
   36   36  .348104050e-08 -.574150580e-08 
   37   36 -.500179400e-08 -.257510390e-08 
   38   36 -.368188180e-10  .765101280e-09 
   39   36  .376238970e-08 -.172459430e-08 
   40   36  .326542430e-08  .542519460e-08 
   41   36  .185106030e-08 -.540055720e-09 
   42   36  .387394230e-08 -.417609760e-08 
   43   36  .186604380e-08 -.293135930e-08 
   44   36  .178643720e-08 -.435865260e-08 
   45   36 -.412986930e-08  .465147890e-08 
   46   36 -.116172390e-08  .326573560e-09 
   47   36  .490870390e-08 -.103686960e-08 
   48   36 -.230495340e-08  .139679120e-09 
   49   36 -.188666840e-08  .628532620e-09 
   50   36 -.996583570e-09  .977496080e-09 
   51   36 -.119147610e-08 -.529143230e-09 
   52   36 -.287750240e-10  .910412890e-09 
   53   36  .744207640e-09 -.101400550e-08 
   54   36  .832999140e-09 -.193909550e-10 
   55   36 -.128062430e-09  .315157600e-09 
   56   36  .683824930e-09 -.651169260e-09 
   57   36 -.161935920e-09  .245751590e-09 
   58   36 -.617832630e-11 -.197098390e-09 
   59   36  .399779940e-09 -.158539000e-09 
   60   36 -.364904380e-10 -.376994700e-10 
   61   36  .159072710e-09 -.104741250e-09 
   62   36 -.135054450e-09 -.930401130e-10 
   63   36 -.143118900e-09  .145818770e-09 
   64   36  .269795170e-11  .109890490e-09 
   65   36  .463757240e-10 -.878874050e-10 
   66   36 -.123717100e-09  .138072860e-09 
   67   36  .979462840e-11  .125663160e-10 
   68   36  .133744540e-09  .111381340e-09 
   69   36  .103872800e-09 -.904673310e-10 
   70   36 -.479358510e-10 -.110803290e-09 
   37   37  .352765750e-08  .195892100e-08 
   38   37 -.251359520e-08  .514373530e-09 
   39   37 -.760301030e-09 -.274388740e-08 
   40   37 -.685167240e-08 -.165435500e-08 
   41   37  .189891260e-09 -.507289220e-08 
   42   37 -.118555390e-08  .185649500e-08 
   43   37  .137164520e-08  .222411380e-08 
   44   37  .576674500e-08  .400705950e-08 
   45   37 -.406516010e-08  .354828380e-08 
   46   37 -.152217190e-08  .343807850e-08 
   47   37  .378649530e-08  .111965420e-08 
   48   37  .234772500e-08 -.597992380e-10 
   49   37 -.980123430e-09 -.189926860e-08 
   50   37 -.172690770e-08 -.441313290e-09 
   51   37  .138296180e-08 -.170781320e-08 
   52   37 -.130975550e-08 -.137376490e-08 
   53   37  .551149200e-09 -.119051100e-09 
   54   37  .855712390e-09 -.591449480e-09 
   55   37 -.915706370e-09  .385090730e-09 
   56   37  .421357800e-09  .457809220e-09 
   57   37 -.105655320e-09  .556181590e-09 
   58   37 -.391826420e-09  .162142010e-09 
   59   37  .113018830e-09  .646023550e-09 
   60   37  .137929640e-09  .881731370e-10 
   61   37 -.238104060e-09  .204579930e-09 
   62   37  .130533330e-09  .276046520e-10 
   63   37 -.113467400e-09 -.208007100e-09 
   64   37 -.164604740e-09 -.435878330e-10 
   65   37  .882466120e-10 -.148031300e-09 
   66   37 -.151769550e-09 -.149292020e-09 
   67   37  .842933040e-10 -.104035550e-09 
   68   37  .963960780e-10 -.527833430e-13 
   69   37 -.506200510e-10 -.198779160e-10 
   70   37  .725918990e-10  .430943680e-11 
   38   38  .178406930e-08 -.110053690e-08 
   39   38  .359772060e-08  .604948220e-08 
   40   38 -.795938170e-09  .607446870e-08 
   41   38 -.364076410e-08 -.353447490e-08 
   42   38  .495387830e-08 -.103190280e-07 
   43   38 -.360602100e-08  .190941200e-08 
   44   38  .364403640e-08 -.927349930e-09 
   45   38 -.952736160e-09  .165012270e-08 
   46   38 -.731893010e-09  .851259290e-09 
   47   38  .192573760e-08  .231881890e-09 
   48   38 -.425542930e-08  .167552530e-08 
   49   38  .129974740e-08 -.134957960e-08 
   50   38 -.977061990e-09 -.325893280e-08 
   51   38  .471093350e-09  .123876380e-09 
   52   38  .269585620e-09  .553449090e-09 
   53   38 -.699274950e-09  .206474620e-09 
   54   38  .113393790e-08  .138483700e-08 
   55   38 -.355918250e-09  .150245700e-09 
   56   38  .129394140e-08  .527932190e-09 
   57   38 -.156506280e-09  .243213820e-09 
   58   38  .320390870e-09  .139962070e-09 
   59   38 -.121987880e-09  .247337340e-09 
   60   38 -.499550260e-09  .226426630e-10 
   61   38  .558275330e-10 -.335022080e-10 
   62   38 -.361081520e-09 -.358685820e-09 
   63   38  .104236710e-09 -.648337980e-10 
   64   38 -.733828530e-10 -.234264430e-09 
   65   38 -.444910310e-12  .242849670e-10 
   66   38  .174945420e-10  .204042780e-10 
   67   38 -.401763580e-10 -.104670350e-09 
   68   38  .657141650e-10  .590872190e-10 
   69   38 -.180044870e-11 -.252971250e-10 
   70   38  .577587440e-10 -.147438600e-10 
   39   39  .197206690e-08  .567544130e-09 
   40   39  .247676440e-08  .132368890e-09 
   41   39 -.482192250e-08 -.101011660e-08 
   42   39 -.204124620e-08  .794947400e-08 
   43   39  .304039350e-08 -.475182530e-08 
   44   39  .344722180e-08 -.174969200e-10 
   45   39 -.257072020e-08 -.258246700e-08 
   46   39  .200548710e-08 -.423100400e-08 
   47   39  .534726900e-10  .630675690e-08 
   48   39  .111740030e-08 -.432400200e-08 
   49   39  .364136660e-09 -.680829040e-09 
   50   39 -.310123110e-08  .422575210e-08 
   51   39  .126904100e-08  .234250950e-08 
   52   39 -.169455220e-08 -.712297060e-09 
   53   39 -.145972820e-09 -.137266750e-08 
   54   39  .770859170e-09  .156225830e-08 
   55   39 -.855149640e-10 -.773435530e-10 
   56   39  .255295700e-09  .575673940e-09 
   57   39 -.449687230e-09  .391804220e-09 
   58   39  .795370710e-09 -.452417930e-09 
   59   39 -.408924210e-09 -.405360350e-09 
   60   39  .450426100e-09 -.365937150e-09 
   61   39 -.110899210e-09 -.265336290e-09 
   62   39  .168283280e-09 -.108607830e-09 
   63   39  .681298700e-10 -.658670350e-10 
   64   39 -.356516090e-09 -.763456360e-10 
   65   39  .362929200e-10  .106806590e-09 
   66   39 -.110896870e-09 -.608708060e-10 
   67   39  .400361850e-10 -.105275820e-09 
   68   39  .150458520e-10  .176887710e-09 
   69   39 -.786240780e-11  .597909830e-10 
   70   39 -.308886350e-10  .397091780e-10 
   40   40  .942295920e-09 -.228458390e-09 
   41   40  .768057240e-09 -.622999550e-08 
   42   40  .239930250e-08 -.380799910e-08 
   43   40  .833462910e-08 -.173720890e-08 
   44   40 -.214689760e-08  .351846900e-08 
   45   40  .724234580e-09 -.146671010e-08 
   46   40  .955981790e-09 -.216058380e-08 
   47   40 -.686290680e-08  .512625740e-08 
   48   40 -.648922740e-10  .449815560e-09 
   49   40 -.201689560e-08  .189460810e-08 
   50   40  .300329050e-08  .141790760e-08 
   51   40 -.144457980e-09  .489365000e-09 
   52   40 -.529192860e-08 -.116612600e-08 
   53   40  .133438270e-08 -.320957840e-08 
   54   40  .192230260e-08  .824999700e-09 
   55   40  .305081360e-08 -.204720550e-08 
   56   40 -.122682070e-08 -.517417370e-09 
   57   40  .357281200e-10 -.469962970e-09 
   58   40  .618331940e-09 -.250837720e-09 
   59   40  .865672080e-10 -.725739200e-09 
   60   40  .768393350e-10  .399401510e-09 
   61   40 -.902822880e-10  .955968200e-09 
   62   40  .590848040e-09  .510007830e-10 
   63   40 -.368631160e-09  .335976840e-09 
   64   40 -.215603040e-09 -.976443620e-10 
   65   40 -.301368990e-09  .180274760e-09 
   66   40 -.380420550e-11  .840058970e-10 
   67   40  .109499570e-10  .602154050e-10 
   68   40  .180753040e-11  .100628800e-09 
   69   40  .183129880e-09 -.153853790e-09 
   70   40 -.142129270e-09 -.491395960e-10 
   41   41  .368576120e-08  .935705160e-08 
   42   41 -.419589920e-09  .449441340e-08 
   43   41  .928642060e-10  .352103420e-08 
   44   41  .214399130e-08  .214102700e-08 
   45   41  .837456630e-09  .369020460e-08 
   46   41  .138733210e-08 -.109287690e-08 
   47   41 -.169716340e-08  .514586090e-08 
   48   41 -.578191640e-08 -.587790920e-08 
   49   41  .196189920e-09 -.262147250e-08 
   50   41 -.408250980e-08 -.349669700e-08 
   51   41  .653212050e-09  .379174480e-08 
   52   41  .450572830e-10 -.140067700e-08 
   53   41  .302214530e-08 -.366039370e-08 
   54   41  .339428400e-08  .489748980e-08 
   55   41  .109216000e-08 -.573966180e-09 
   56   41 -.355908230e-08  .100449320e-08 
   57   41 -.904453150e-09  .100913320e-08 
   58   41  .127012910e-08  .999066240e-09 
   59   41  .166686570e-08  .843948060e-09 
   60   41  .133490770e-08  .482073080e-09 
   61   41 -.650817030e-09 -.359131890e-09 
   62   41 -.123033440e-08 -.583924090e-09 
   63   41 -.951139360e-09  .288531190e-09 
   64   41 -.317660980e-09 -.439115550e-09 
   65   41  .300313200e-09  .402678070e-09 
   66   41  .405356660e-09  .323574170e-09 
   67   41  .238325410e-09 -.211085850e-09 
   68   41 -.157925680e-09  .327665250e-11 
   69   41 -.379123270e-09 -.337510310e-09 
   70   41 -.227711640e-09 -.112042270e-09 
   42   42 -.647255430e-08  .230508500e-08 
   43   42 -.570052820e-08  .685042340e-08 
   44   42 -.838990620e-09 -.153767620e-08 
   45   42  .295111640e-09 -.943419210e-08 
   46   42  .722554110e-09  .620059310e-08 
   47   42  .675563460e-09 -.274319020e-08 
   48   42  .899002730e-09  .325946200e-08 
   49   42 -.143462190e-08  .197118010e-08 
   50   42  .483883400e-08 -.374887490e-08 
   51   42  .320960130e-08  .169958920e-08 
   52   42 -.812879440e-09 -.654820940e-08 
   53   42  .109206820e-08  .154202500e-08 
   54   42  .347743030e-08  .526516850e-08 
   55   42  .114681920e-08 -.872412170e-09 
   56   42 -.400110170e-08 -.464839140e-10 
   57   42 -.266107300e-08  .142975810e-09 
   58   42  .680126310e-09  .591362060e-09 
   59   42 -.259721370e-08 -.992458300e-09 
   60   42  .283788380e-09  .420707280e-09 
   61   42 -.737571780e-09 -.470263510e-09 
   62   42 -.129034420e-08 -.123445890e-08 
   63   42 -.295171890e-09  .281555490e-09 
   64   42 -.173146500e-11 -.645612350e-09 
   65   42  .619650840e-10 -.560549510e-10 
   66   42  .281166850e-09 -.960522920e-10 
   67   42  .346091940e-09 -.190280750e-09 
   68   42 -.704304990e-10 -.233517120e-10 
   69   42  .253849050e-09  .375216410e-10 
   70   42 -.112257560e-10  .110350040e-09 
   43   43 -.266351990e-08 -.773022060e-08 
   44   43  .215676660e-08 -.393118820e-08 
   45   43  .416543910e-08  .277526290e-08 
   46   43 -.168225710e-08  .111094750e-07 
   47   43  .262263920e-08  .133662000e-08 
   48   43  .213896370e-08  .415809090e-08 
   49   43  .473003230e-08 -.477798440e-08 
   50   43  .197767600e-08 -.120445130e-08 
   51   43 -.419887410e-08  .156667140e-08 
   52   43  .583105000e-08 -.231441230e-08 
   53   43 -.323031840e-09  .515181740e-08 
   54   43 -.485067310e-08  .162417310e-08 
   55   43  .215097190e-09 -.268746340e-09 
   56   43 -.347483240e-08 -.328662950e-08 
   57   43 -.504313100e-10 -.305718780e-08 
   58   43  .387510380e-08  .119247420e-08 
   59   43 -.110227310e-08 -.227523790e-08 
   60   43  .616560910e-08  .145584800e-09 
   61   43 -.389965000e-09  .220657380e-10 
   62   43  .857652570e-09 -.153749070e-08 
   63   43  .240772440e-09  .629619220e-09 
   64   43 -.366479880e-08 -.562833890e-09 
   65   43  .611264040e-10  .344501260e-09 
   66   43 -.421872670e-08 -.132926670e-09 
   67   43  .710850750e-10  .416517330e-09 
   68   43 -.134653180e-08  .259443690e-09 
   69   43  .175543050e-09  .260807430e-09 
   70   43  .104382990e-08  .589925630e-09 
   44   44  .203721160e-08 -.740287750e-09 
   45   44  .115651110e-07 -.129079570e-09 
   46   44  .167478180e-08 -.208472610e-08 
   47   44 -.329043710e-08  .729454600e-08 
   48   44  .105589710e-08 -.766528180e-09 
   49   44  .451605140e-08  .566320320e-08 
   50   44 -.134805500e-08 -.131732160e-08 
   51   44 -.397025990e-09  .902204190e-11 
   52   44 -.330974310e-08 -.377217290e-09 
   53   44 -.219251930e-09  .942439420e-10 
   54   44 -.138364420e-09  .133751780e-08 
   55   44  .281703920e-08 -.709781840e-09 
   56   44  .682188990e-09  .236703530e-08 
   57   44  .150516110e-08  .577526110e-09 
   58   44  .165333110e-08 -.763059860e-09 
   59   44  .915555410e-09 -.439088790e-10 
   60   44  .749734790e-09 -.626810860e-09 
   61   44 -.605173700e-09  .442660040e-09 
   62   44 -.325366100e-09  .353888550e-10 
   63   44 -.100893340e-08  .121798500e-09 
   64   44 -.429208780e-09 -.190576840e-09 
   65   44 -.245220790e-09 -.283767870e-09 
   66   44 -.405457230e-09 -.143322920e-11 
   67   44  .136960100e-09 -.172118590e-09 
   68   44 -.230256430e-09  .296926660e-09 
   69   44  .278009320e-09 -.169323500e-10 
   70   44  .385560580e-10  .107311840e-09 
   45   45 -.389577000e-08  .133109640e-08 
   46   45 -.128017850e-08  .103813350e-08 
   47   45  .718634860e-08  .309273140e-08 
   48   45  .488831940e-08  .144566920e-08 
   49   45  .222619680e-08 -.275737550e-08 
   50   45 -.241307110e-08  .903655070e-09 
   51   45 -.440101350e-08 -.451541500e-08 
   52   45 -.145477260e-08 -.607175850e-09 
   53   45 -.324891570e-08  .217521770e-08 
   54   45 -.176479570e-08 -.204946460e-08 
   55   45  .114443050e-08  .323531960e-08 
   56   45  .143239580e-08 -.137456540e-08 
   57   45  .200756810e-08  .252402990e-08 
   58   45 -.363988140e-09  .179911750e-08 
   59   45  .686788210e-09 -.607419420e-09 
   60   45  .712704240e-09  .791374530e-10 
   61   45 -.639871990e-09 -.926147770e-09 
   62   45  .886921820e-10  .498987540e-10 
   63   45 -.241457980e-09 -.803914360e-09 
   64   45 -.264794620e-09  .134608050e-09 
   65   45 -.108630290e-09 -.254218940e-09 
   66   45 -.341886920e-11 -.260005520e-09 
   67   45 -.770401360e-10  .200491680e-09 
   68   45  .838131190e-10 -.477866920e-10 
   69   45  .231081920e-09  .274717030e-09 
   70   45  .104472330e-10  .165411410e-09 
   46   46  .128425520e-08 -.406271090e-08 
   47   46 -.134086050e-08 -.158730970e-08 
   48   46 -.792164440e-09  .487970430e-08 
   49   46  .174340570e-08  .363934670e-08 
   50   46 -.175942920e-08  .177389960e-08 
   51   46 -.156068560e-09 -.930232690e-09 
   52   46 -.194571500e-09 -.690249810e-09 
   53   46 -.481382610e-08 -.235504200e-08 
   54   46  .951604250e-09 -.117950450e-08 
   55   46  .285886750e-09 -.863544020e-09 
   56   46  .321740740e-09 -.244494390e-08 
   57   46 -.138776230e-08  .366979730e-09 
   58   46  .502037760e-09  .166146780e-08 
   59   46  .262302640e-08  .159351020e-08 
   60   46 -.834026090e-10 -.160325090e-08 
   61   46 -.521685390e-09 -.107940910e-09 
   62   46 -.324802900e-09  .116822520e-08 
   63   46  .212917970e-09  .135064160e-10 
   64   46  .170257200e-09  .389087560e-09 
   65   46  .396906530e-09 -.321952900e-10 
   66   46 -.435547520e-10 -.792099720e-09 
   67   46 -.676214870e-09 -.344308010e-09 
   68   46 -.131019150e-09  .334237000e-09 
   69   46 -.316264810e-09  .172507280e-11 
   70   46  .873977710e-10  .333095190e-09 
   47   47 -.908068720e-09 -.665542720e-09 
   48   47  .387591100e-08  .458023480e-08 
   49   47  .348640970e-09  .221137220e-10 
   50   47 -.393961720e-08 -.807017810e-08 
   51   47  .134159800e-08 -.139327600e-08 
   52   47 -.165853930e-08  .723607580e-09 
   53   47 -.274061260e-09  .176946180e-08 
   54   47 -.134584060e-09  .187982630e-08 
   55   47  .404673960e-09  .306409010e-09 
   56   47  .234940160e-08  .108307300e-08 
   57   47 -.252333930e-08 -.477884150e-09 
   58   47 -.586992410e-09 -.519850160e-09 
   59   47  .202987220e-08  .248699670e-09 
   60   47  .643224070e-09 -.408104520e-09 
   61   47 -.104422750e-08 -.151779060e-09 
   62   47 -.455720970e-09 -.189504950e-09 
   63   47  .440823650e-09  .965014370e-10 
   64   47 -.430297840e-09  .106875890e-09 
   65   47  .618990720e-09  .188774550e-09 
   66   47  .311284210e-09  .170229580e-09 
   67   47 -.578539870e-09 -.105407690e-09 
   68   47  .136611430e-09  .811153340e-11 
   69   47 -.121983500e-09 -.160126440e-09 
   70   47 -.138787770e-09 -.635360580e-10 
   48   48  .257666840e-09  .882918510e-11 
   49   48 -.131920760e-08  .281067900e-09 
   50   48 -.133086870e-08 -.111343160e-08 
   51   48  .365435150e-08  .145637480e-08 
   52   48  .182258250e-08  .118600380e-08 
   53   48 -.230894770e-08 -.203076760e-08 
   54   48  .106187270e-08  .455347300e-09 
   55   48 -.223657010e-08 -.956608510e-09 
   56   48 -.918183720e-09 -.298505070e-09 
   57   48 -.148120320e-09  .691145240e-09 
   58   48 -.225900750e-10 -.107169660e-08 
   59   48  .413471770e-09  .192549440e-09 
   60   48 -.121134410e-08  .300326150e-09 
   61   48  .102699740e-08  .495871050e-09 
   62   48  .431053770e-09 -.994019610e-10 
   63   48  .544176690e-11 -.216960160e-09 
   64   48  .170353020e-09  .311519580e-09 
   65   48 -.192801870e-09 -.874476010e-10 
   66   48 -.867647690e-10  .264309440e-09 
   67   48 -.240706050e-10  .663260530e-10 
   68   48  .322006220e-09 -.106497450e-09 
   69   48 -.222361580e-09 -.753567220e-10 
   70   48  .682964890e-10 -.608933570e-10 
   49   49  .127636310e-08  .629627840e-09 
   50   49  .320378440e-08 -.244364280e-08 
   51   49 -.202823290e-08 -.607124610e-09 
   52   49 -.438598410e-08  .207653100e-08 
   53   49  .666320280e-10 -.212796850e-08 
   54   49 -.313483370e-09 -.512520760e-10 
   55   49  .118940350e-08  .105394000e-09 
   56   49  .177473050e-08 -.541375170e-09 
   57   49 -.362673180e-09  .849585140e-09 
   58   49  .314942650e-09  .185959760e-10 
   59   49  .620209900e-09  .845654900e-09 
   60   49  .354554860e-09 -.298366690e-09 
   61   49 -.256707840e-09  .419359100e-10 
   62   49 -.109878200e-08  .264149570e-09 
   63   49  .214685110e-09 -.979168480e-10 
   64   49  .665110410e-11 -.645287900e-10 
   65   49 -.185402380e-09 -.169402450e-09 
   66   49  .306153840e-10 -.100824520e-09 
   67   49 -.836911970e-10 -.136593480e-09 
   68   49 -.293652020e-10  .959336410e-10 
   69   49  .161982660e-09  .491313430e-11 
   70   49  .177833930e-09 -.420214820e-10 
   50   50  .650554910e-09  .402198150e-09 
   51   50 -.288050600e-08  .732542030e-09 
   52   50 -.656567150e-09  .868708350e-10 
   53   50  .560304970e-08  .252335750e-09 
   54   50  .342634720e-09 -.102595390e-08 
   55   50 -.924221260e-09 -.129271840e-08 
   56   50 -.243743820e-09  .466878060e-09 
   57   50 -.155321880e-08 -.914038720e-09 
   58   50 -.114234510e-10  .169116480e-09 
   59   50 -.132776260e-09  .491429090e-11 
   60   50  .239287600e-09  .576494940e-09 
   61   50  .353091590e-09  .361472270e-09 
   62   50  .175621950e-09 -.425404440e-09 
   63   50  .549406690e-09  .173002780e-09 
   64   50 -.121419020e-09  .127678580e-09 
   65   50 -.102537200e-09  .127129990e-09 
   66   50 -.783939440e-10 -.208172090e-09 
   67   50 -.126842250e-09 -.621366110e-10 
   68   50 -.176962150e-10 -.609169330e-10 
   69   50 -.162445890e-09 -.223245770e-10 
   70   50 -.165832510e-10  .823082790e-10 
   51   51 -.294725260e-09 -.199732830e-09 
   52   51 -.175004720e-08 -.504643170e-09 
   53   51  .105868340e-08 -.424394820e-09 
   54   51  .187155220e-08  .756775970e-09 
   55   51  .199355730e-09  .952069540e-09 
   56   51  .849184670e-09 -.310269220e-09 
   57   51 -.465489940e-09 -.577118950e-09 
   58   51 -.377392390e-09 -.391018080e-09 
   59   51 -.254120550e-09 -.152801260e-09 
   60   51 -.450616040e-09  .178856830e-10 
   61   51 -.958199150e-10  .230919140e-09 
   62   51 -.123887620e-09 -.568664980e-10 
   63   51 -.498022620e-10 -.113749400e-09 
   64   51  .159673300e-09  .269830470e-09 
   65   51  .131313060e-09  .186067490e-09 
   66   51  .855469780e-10 -.136514970e-09 
   67   51  .533733690e-10 -.149330840e-09 
   68   51  .634874470e-10  .100554690e-09 
   69   51 -.683615200e-10 -.348281090e-10 
   70   51 -.557484970e-10 -.660584220e-10 
   52   52 -.281989950e-09  .673617730e-09 
   53   52  .278262390e-08  .159575150e-08 
   54   52  .142709280e-08 -.173179580e-08 
   55   52 -.170216900e-08 -.485943860e-09 
   56   52 -.155716320e-08  .343284730e-09 
   57   52 -.165450150e-09 -.755162140e-09 
   58   52 -.264838540e-09  .403816970e-09 
   59   52 -.108889320e-09  .962368260e-10 
   60   52  .411069890e-09  .354758220e-09 
   61   52 -.162249860e-09  .269318520e-09 
   62   52  .418721190e-09 -.456237710e-10 
   63   52  .375731580e-09  .193290280e-10 
   64   52  .188381300e-09 -.439714080e-10 
   65   52 -.258709100e-09  .722964020e-10 
   66   52 -.281419930e-09 -.982404970e-10 
   67   52  .557743230e-09 -.387855510e-10 
   68   52 -.871843340e-10 -.479834920e-10 
   69   52 -.108545940e-09  .396998320e-10 
   70   52 -.732475110e-10 -.525479070e-10 
   53   53  .105097870e-09 -.498381230e-09 
   54   53  .195230450e-08  .121986890e-08 
   55   53 -.294926300e-09  .502408210e-09 
   56   53 -.227126980e-08 -.123762740e-08 
   57   53  .141506270e-08 -.313210010e-09 
   58   53 -.322410250e-09 -.940431290e-10 
   59   53  .237375010e-09 -.189990270e-09 
   60   53  .312983730e-09  .333886460e-09 
   61   53 -.737708150e-09 -.338714570e-10 
   62   53  .306657110e-09  .678179940e-10 
   63   53 -.272356460e-09  .185643060e-09 
   64   53  .268789040e-09  .138068100e-09 
   65   53 -.228897950e-09 -.529633970e-10 
   66   53 -.251701780e-09 -.163136250e-09 
   67   53  .387499810e-09  .295278460e-10 
   68   53  .144705980e-09  .177261940e-09 
   69   53 -.741193780e-10 -.118408010e-09 
   70   53 -.638849490e-10 -.946978750e-10 
   54   54  .209168150e-09  .464559530e-09 
   55   54  .220971400e-09 -.166599490e-08 
   56   54 -.102602860e-08 -.570296760e-09 
   57   54 -.124340230e-08  .238009160e-08 
   58   54  .257550930e-09 -.463619150e-09 
   59   54  .459959750e-09 -.398275150e-09 
   60   54  .194265040e-09  .660265950e-10 
   61   54  .630302430e-09 -.561417940e-09 
   62   54  .317546390e-09  .568777460e-09 
   63   54 -.133317200e-09 -.962710100e-10 
   64   54 -.292522480e-09  .240455790e-09 
   65   54 -.735266750e-10  .281890100e-09 
   66   54  .438071200e-09  .554902200e-10 
   67   54 -.430700640e-09  .147691660e-09 
   68   54 -.623516430e-09 -.327070820e-09 
   69   54  .218762020e-09 -.169159170e-09 
   70   54  .356337310e-09 -.301637310e-10 
   55   55 -.643971160e-09 -.121258120e-08 
   56   55  .309016060e-09  .118380970e-08 
   57   55  .177190000e-08  .810205680e-09 
   58   55 -.414192210e-09 -.125168060e-08 
   59   55  .140991560e-09  .298891570e-09 
   60   55  .768163820e-11  .312991620e-09 
   61   55 -.280164030e-09 -.701505270e-09 
   62   55  .179775800e-09  .693605810e-09 
   63   55 -.784465920e-09  .274999390e-09 
   64   55  .242132110e-09  .728604020e-11 
   65   55 -.119280500e-09 -.129030520e-08 
   66   55 -.614700280e-09 -.190152350e-10 
   67   55  .123145220e-09  .241570330e-08 
   68   55  .770241010e-09 -.502414620e-09 
   69   55  .162160560e-09 -.286753340e-08 
   70   55 -.783500900e-09  .342728760e-09 
   56   56 -.155328940e-09 -.156536370e-08 
   57   56 -.179033920e-08  .504381390e-09 
   58   56  .604268510e-09  .108087070e-08 
   59   56  .186538100e-08 -.213333550e-08 
   60   56 -.377741250e-09 -.138529290e-08 
   61   56  .284944670e-09  .570276120e-09 
   62   56 -.302873280e-09 -.573299690e-11 
   63   56  .140671290e-10  .409772600e-09 
   64   56  .894598550e-10  .616330400e-09 
   65   56 -.269963380e-09 -.274466250e-09 
   66   56  .188093090e-09  .372257870e-09 
   67   56 -.378857030e-09 -.193345090e-09 
   68   56  .114032860e-09 -.294213140e-09 
   69   56  .191336160e-09  .903960050e-10 
   70   56 -.566225040e-10  .290586490e-10 
   57   57 -.246304010e-08 -.253277580e-09 
   58   57 -.966298360e-09  .178476020e-08 
   59   57  .709868500e-09 -.250282480e-08 
   60   57 -.513593960e-09  .663891420e-09 
   61   57  .386877430e-08  .378356840e-08 
   62   57 -.701353080e-09 -.384892400e-08 
   63   57 -.481990080e-09  .175311870e-08 
   64   57 -.913079990e-09 -.429678570e-09 
   65   57 -.182022630e-08 -.218390210e-08 
   66   57  .915046910e-09  .185569910e-08 
   67   57 -.453459310e-09 -.147173160e-08 
   68   57  .121942500e-08  .138449260e-08 
   69   57 -.942073320e-10  .463653170e-10 
   70   57  .260460150e-09  .263383480e-09 
   58   58  .582010460e-09 -.227292770e-09 
   59   58  .904877160e-09 -.234549310e-08 
   60   58 -.113713000e-08  .716746380e-09 
   61   58 -.147893760e-08  .400376640e-08 
   62   58  .128113320e-09 -.108003440e-08 
   63   58  .735579200e-09 -.179311840e-08 
   64   58  .135540640e-08  .251726750e-09 
   65   58  .238942170e-09 -.126205450e-08 
   66   58 -.590613250e-09  .140796190e-09 
   67   58  .238926720e-09  .287133430e-09 
   68   58 -.121336840e-08 -.191144490e-10 
   69   58 -.125865040e-09  .930775570e-09 
   70   58  .128666000e-09  .109630570e-09 
   59   59  .679140200e-09 -.185997240e-09 
   60   59 -.208579390e-08  .665307740e-09 
   61   59 -.140982810e-08  .224228130e-09 
   62   59  .307165840e-08 -.144319010e-08 
   63   59  .993021230e-09 -.411539090e-10 
   64   59 -.415235300e-09  .713123700e-09 
   65   59  .311489310e-09 -.859980720e-10 
   66   59 -.321002960e-09  .750084770e-09 
   67   59 -.300325140e-09 -.136458150e-09 
   68   59  .160452670e-09  .318535720e-10 
   69   59 -.210570580e-09 -.772297950e-10 
   70   59 -.127923420e-09 -.532168180e-09 
   60   60 -.154721340e-09 -.646810870e-09 
   61   60 -.131480130e-09 -.271834440e-11 
   62   60  .562304870e-09  .170954550e-08 
   63   60  .289932690e-09  .993814750e-10 
   64   60 -.137107150e-09 -.494554560e-09 
   65   60 -.121366080e-09 -.140354150e-10 
   66   60 -.261042600e-09 -.553140210e-09 
   67   60 -.549247660e-10 -.167485260e-09 
   68   60  .387113810e-11 -.224987550e-10 
   69   60 -.495608330e-10  .866710640e-10 
   70   60  .100281340e-09  .125968260e-09 
   61   61  .188730160e-09 -.133415660e-09 
   62   61  .199668780e-09  .785303580e-10 
   63   61 -.314740550e-09  .416041360e-09 
   64   61 -.699561210e-09 -.345429400e-09 
   65   61  .860872960e-10 -.123593480e-09 
   66   61  .679418540e-09  .237795260e-09 
   67   61  .279683520e-10 -.123321700e-09 
   68   61  .320856890e-09  .186475950e-09 
   69   61  .101125150e-09 -.108634550e-09 
   70   61 -.136874420e-09 -.658696020e-10 
   62   62 -.424514850e-10  .964941670e-10 
   63   62 -.145132300e-09  .153520760e-10 
   64   62 -.486327780e-10 -.223285060e-09 
   65   62  .229355270e-09 -.116163350e-10 
   66   62  .338981340e-09  .303110090e-09 
   67   62 -.544396380e-10 -.140319150e-10 
   68   62 -.438024340e-10  .338449370e-10 
   69   62 -.123171100e-09 -.371523260e-11 
   70   62 -.271338960e-09 -.102991640e-09 
   63   63 -.118871100e-11  .706767500e-10 
   64   63 -.733855040e-10 -.260043330e-09 
   65   63 -.148646700e-10 -.285425910e-09 
   66   63  .112651210e-09  .531871730e-09 
   67   63 -.350352330e-10  .269929060e-09 
   68   63  .113565160e-09 -.238850180e-09 
   69   63  .107797410e-10  .586456640e-10 
   70   63 -.648449410e-10 -.166437450e-09 
   64   64 -.147599900e-11  .133883310e-10 
   65   64 -.357097960e-10 -.392192280e-11 
   66   64  .117390920e-09 -.594496340e-10 
   67   64  .181073490e-10 -.716996510e-10 
   68   64 -.109162150e-09  .100937750e-10 
   69   64  .430906870e-10  .866021660e-10 
   70   64 -.199246780e-10  .794600480e-11 
   65   65 -.557499590e-11  .687781620e-11 
   66   65 -.979649690e-10  .102628770e-09 
   67   65  .664079050e-10  .741660860e-10 
   68   65  .178536440e-09 -.825457840e-10 
   69   65 -.217425740e-12 -.555793650e-11 
   70   65 -.755692800e-10 -.251001430e-10 
   66   66  .822062970e-11 -.489063390e-10 
   67   66  .565262440e-10 -.397904200e-10 
   68   66 -.858411590e-11  .116731660e-09 
   69   66 -.921844500e-10  .750509190e-10 
   70   66 -.475366450e-11 -.181642960e-10 
   67   67  .961383820e-11  .220424710e-10 
   68   67  .592962130e-10  .689128380e-10 
   69   67 -.347730530e-10 -.136585800e-10 
   70   67 -.417144130e-10 -.512199760e-10 
   68   68  .399079880e-10 -.447479770e-11 
   69   68 -.469443230e-11  .540790000e-10 
   70   68 -.139317540e-09  .321930480e-10 
   69   69  .870499080e-11 -.402356790e-10 
   70   69  .311836400e-10 -.119777210e-09 
   70   70  .529963800e-10  .675556790e-10 
]
