# Banker tests for s51 -t 517

# Registers are banked under control of sfr[0xd0][4:3] as standard.
# See test-C51.cmd for tests.

# There are 8 dptr banks under control of sfr[0x92][2:0] each consisting
# of two successive bytes from dptr_chip. Each pair of bytes is mapped
# to both sfr[0x82]..sfr[0x83] and dptr[0x00]..dptr[0x01].
info mem

# Label and fill
var bank sfr[0x92][2:0]
var sfr_curr sfr[0x82]
var dptr_curr dptr[0x00]
var dptr0 dptr_chip[0x00]
var dptr1 dptr_chip[0x02]
var dptr2 dptr_chip[0x04]
var dptr3 dptr_chip[0x06]
var dptr4 dptr_chip[0x08]
var dptr5 dptr_chip[0x0a]
var dptr6 dptr_chip[0x0c]
var dptr7 dptr_chip[0x0e]
set mem dptr_chip 0x00 0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07
set mem dptr_chip 0x08 0x08 0x09 0x0a 0x0b 0x0c 0x0d 0x0e 0x0f

# Bank 0 should be current
dump bank

# Contents should be 0x00 0x01
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

# Check all the other banks
set mem bank 1
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

set mem bank 2
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

set mem bank 3
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

set mem bank 4
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

set mem bank 5
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

set mem bank 6
dump sfr 0x82 0x83
#dump dptr 0x00 0x01

set mem bank 7
dump sfr 0x82 0x83
#dump dptr 0x00 0x01
