#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    utils
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Screen
  class Color
    attr_accessor :off,:marker,:bold,:underline,:invert,:darkgrey_hi,:grey_hi,:pink_hi,:fuchsia_hi,:red_hi,:orange_hi,:yellow_hi,:brown_hi,:lightgreen_hi,:green_hi,:cyan_hi,:blue_hi,:navy_hi,:white,:white_bold,:grey,:pink,:fuchsia,:ruby,:red,:orange,:yellow,:brown,:green,:darkgreen,:cyan,:blue,:navy,:black
    def initialize(&block)
      instance_eval &block
    end
  end
  class Ansi < Color
    attr_reader :cX
    def initialize(color_state,*txt)
      @color_state,@txt=color_state,txt
      @color_instruct=txt[0]
      @cX=if color_state==:on
        Color.new do
          self.off=self.white=self.white_bold=self.marker=self.bold=self.underline=self.invert=self.darkgrey_hi=self.grey_hi=self.pink_hi=self.fuchsia_hi=self.red_hi=self.orange_hi=self.yellow_hi=self.brown_hi=self.lightgreen_hi=self.green_hi=self.cyan_hi=self.blue_hi=self.navy_hi=self.grey=self.pink=self.fuchsia=self.ruby=self.red=self.orange=self.yellow=self.brown=self.green=self.darkgreen=self.cyan=self.blue=self.navy=self.black=''
        end
      else                                                                       #default set to colors on
        Color.new do
          self.off           = "\033[0m"
          self.white         = "\033[37m"
          self.white_bold    = "\033[1m"
          self.marker        = "\033[42m"
          self.bold          = "\033[1m"
          self.underline     = "\033[4m"
          self.invert        = "\033[7m"
          self.darkgrey_hi   = "\033[100m"
          self.grey_hi       = "\033[47m"
          self.pink_hi       = "\033[105m"
          self.fuchsia_hi    = "\033[45m"
          self.red_hi        = "\033[41m"
          self.orange_hi     = "\033[101m"
          self.yellow_hi     = "\033[103m"
          self.brown_hi      = "\033[43m"
          self.lightgreen_hi = "\033[102m"
          self.green_hi      = "\033[42m"
          self.cyan_hi       = "\033[106m"
          self.blue_hi       = "\033[104m"
          self.navy_hi       = "\033[44m"
          self.grey          = "\033[90m"
          self.pink          = "\033[95m"
          self.fuchsia       = "\033[35m"
          self.ruby          = "\033[31m"
          self.red           = "\033[91m" #check
          self.orange        = "\033[91m"
          self.yellow        = "\033[93m"
          self.brown         = "\033[33m"
          self.green         = "\033[92m"
          self.darkgreen     = "\033[32m"
          self.cyan          = "\033[36m"
          self.blue          = "\033[94m"
          self.navy          = "\033[34m"
          self.black         = "\033[30m"
        end
      end
    end
    def colors
      0.upto(109) {|i| print "\033[#{i}m 33[#{i}m \033[m"}
      puts ''
    end
    def color
      case @color_instruct
      when /invert/        then @cX.invert
      when /darkgrey_hi/   then @cX.darkgrey_hi
      when /grey_hi/       then @cX.grey_hi
      when /pink_hi/       then @cX.pink_hi
      when /fuchsia_hi/    then @cX.fuchsia_hi
      when /red_hi/        then @cX.red_hi
      when /orange_hi/     then @cX.orange_hi
      when /yellow_hi/     then @cX.yellow_hi
      when /brown_hi/      then @cX.brown_hi
      when /lightgreen_hi/ then @cX.lightgreen_hi
      when /green_hi/      then @cX.green_hi
      when /cyan_hi/       then @cX.cyan_hi
      when /blue_hi/       then @cX.blue_hi
      when /navy_hi/       then @cX.navy_hi
      when /white/         then @cX.white
      when /grey/          then @cX.grey
      when /pink/          then @cX.pink
      when /fuchsia/       then @cX.fuchsia
      when /ruby/          then @cX.ruby
      when /red/           then @cX.red
      when /orange/        then @cX.orange
      when /yellow/        then @cX.yellow
      when /brown/         then @cX.brown
      when /green/         then @cX.green
      when /darkgreen/     then @cX.darkgreen
      when /cyan/          then @cX.cyan
      when /blue/          then @cX.blue
      when /navy/          then @cX.navy
      when /close/         then @cX.off
      when /off/           then @cX.off
      end
    end
    def colorize
      case @color_instruct
      when /invert/        then puts "#{@cX.invert}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /darkgrey_hi/   then puts "#{@cX.darkgrey_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /grey_hi/       then puts "#{@cX.grey_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /pink_hi/       then puts "#{@cX.pink_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /fuchsia_hi/    then puts "#{@cX.fuchsia_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /red_hi/        then puts "#{@cX.red_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /orange_hi/     then puts "#{@cX.orange_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /yellow_hi/     then puts "#{@cX.yellow_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /brown_hi/      then puts "#{@cX.brown_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /lightgreen_hi/ then puts "#{@cX.lightgreen_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /green_hi/      then puts "#{@cX.green_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /cyan_hi/       then puts "#{@cX.cyan_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /blue_hi/       then puts "#{@cX.blue_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /navy_hi/       then puts "#{@cX.navy_hi}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off} #{@cX.grey}#{@txt[3]}#{@cX.off}"
      when /bold/          then puts "#{@cX.bold}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /white/         then puts "#{@cX.off}#{@txt[1]} #{@txt[2]}"
      when /grey/          then puts "#{@cX.grey}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /pink/          then puts "#{@cX.pink}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /fuchsia/       then puts "#{@cX.fuchsia}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /ruby/          then puts "#{@cX.ruby}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /red/           then puts "#{@cX.red}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /orange/        then puts "#{@cX.orange}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /yellow/        then puts "#{@cX.yellow}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /brown/         then puts "#{@cX.brown}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /green/         then puts "#{@cX.green}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /darkgreen/     then puts "#{@cX.darkgreen}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /cyan/          then puts "#{@cX.cyan}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /blue/          then puts "#{@cX.blue}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      when /navy/          then puts "#{@cX.navy}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
      end
    end
    def sourcename(sourcefilename)
      @sourcefilename=sourcefilename
    end
    def basename(sourcefilename)
      @basename=sourcefilename.sub(/\.(?:(?:-|ssm\.)?sst|ssm)$/,'')
    end
    def sisu
    end
    def rescue
      STDERR.puts %{\t   #{@cX.orange}Rescued#{@cX.off} #{@cX.grey}#{yield if block_given?}\n\t   An#{@cX.off} #{@cX.fuchsia}ERROR#{@cX.off} #{@cX.grey}occurred, message:#{@cX.off} #{@cX.fuchsia}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off} #{@cX.brown}#{@txt[2]}#{@cX.off}}
    end
    def warn
      STDERR.puts "\t  #{@cX.brown}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}"
    end
    def error
      STDERR.puts "\t  #{@cX.fuchsia}#{@txt[0]}#{@cX.off} #{@cX.brown}#{@txt[1]}#{@cX.off}"
    end
    def error2
      STDERR.puts "\t  #{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.fuchsia}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
    end
    def version
      puts "#{@cX.blue_hi}#{@txt[0]} #{@txt[1]}#{@cX.off} #{@cX.grey} (#{@txt[3]} [#{@txt[2]}])#{@txt[4]} &#{@cX.off} #{@cX.ruby}Ruby#{@cX.off} #{@cX.grey}(#{@txt[5]})#{@cX.off}\n"
    end
    def html3numbers
      puts %{\t#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.cyan}files processed#{@cX.off}. } +
        %{#{@cX.grey}} +
        %{scroll only: #{@txt[1]}, seg only: #{@txt[2]},} +
        %{#{@cX.off} } +
        %{#{@cX.cyan}joint scroll & seg: #{@txt[3]},#{@cX.off}} +
        %{#{@cX.grey} } +
        %{nav only: #{@txt[4]}} +
        %{#{@cX.off}}
    end
    def html2numbers
      puts %{\t#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.cyan}files processed#{@cX.off}. } +
        %{#{@cX.grey}} +
        %{scroll only: #{@txt[1]},} +
        %{#{@cX.off} } +
        %{#{@cX.cyan}seg only: #{@txt[2]},#{@cX.off}} +
        %{#{@cX.grey} } +
        %{joint scroll & seg: #{@txt[3]}, nav only: #{@n_files_nav}} +
        %{#{@cX.off}}
    end
    def html1numbers
      puts %{\t#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.cyan}files processed#{@cX.off}. } +
        %{#{@cX.cyan}scroll only: #{@txt[1]},#{@cX.off}} +
        %{#{@cX.grey} } +
        %{seg only: #{@txt[2]}, } +
        %{joint scroll & seg: #{@txt[3]}, nav only: #{@n_files_nav}} +
        %{#{@cX.off}}
    end
    def html0_numbers
      puts %{\t#{@cX.ruby}#{@txt[0]} files processed#{@cX.off}. } +
        %{#{@cX.grey}} +
        %{scroll only: #{@txt[1]}, seg only: #{@txt[2]}, joint scroll & seg: #{@txt[3]},} +
        %{#{@cX.off} } +
        %{#{@cX.cyan}nav only: #{@txt[4]}#{@cX.off}.}
    end
    def grey
      puts "#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.cyan}#{@txt[1]}#{@cX.off}"
    end
    def txt_white
      puts "\t#{@cX.white}#{@txt[0]}#{@cX.off} #{@cX.white}#{@txt[1]}#{@cX.off}"
    end
    def txt_grey
      puts "\t#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.cyan}#{@txt[1]}#{@cX.off}"
    end
    def txt_cyan
      puts "\t#{@cX.cyan}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}"
    end
    def txt_blue
      puts "\t#{@cX.blue}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}"
    end
    def txt_red
      puts "\t#{@cX.red}#{@txt[0]}#{@cX.off} #{@cX.cyan}#{@txt[1]}#{@cX.off}"
    end
    def txt_green
      puts "\t#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}"
    end
    def url #clean
      blue
    end
    def result
      puts "\t#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.green}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off}"
    end
    def maintenance
      puts "\t#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.brown}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off}"
    end
    def instruct
      puts %{\t  #{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.cyan}#{@txt[1]}#{@cX.off} #{@cX.grey}#{@txt[2]}#{@cX.off} #{@cX.cyan}#{@txt[3]}#{@cX.off} #{@cX.grey}#{@txt[4]}#{@cX.off} "#{@cX.brown}#{@f}#{@cX.off}"}
    end
    def grey_open
      print @cX.grey
    end
    def p_off
      print @cX.off
    end
    def p_close
      print @cX.off
    end
    def flow
      puts %{\t#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.ruby}->#{@cX.off}\n\t  #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def output
      puts %{\t#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.ruby}->#{@cX.off}\n\t  #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def generic
      puts %{\t#{@cX.navy}#{@txt[0]} #{@txt[1]}#{@cX.off}. }
    end
    def files_processed
      puts %{\t#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}}
    end
    def print_blue
      print "#{@cX.blue}#{@txt[0]} #{@txt[1]}#{@cX.off}"
    end
    def puts_blue
      puts "#{@cX.blue}#{@txt[0]} #{@txt[1]}#{@cX.off}"
    end
    def print_brown
      print "#{@cX.brown}#{@txt[0]}#{@cX.off}"
    end
    def blue_tab
      print  "\t#{@cX.blue}#{@txt[0]}#{@cX.off}\n"
    end
    def print_grey
      print "#{@cX.grey}#{@txt[0]} #{@txt[1]}#{@cX.off}"
    end
    def puts_grey
      puts "#{@cX.grey}#{@txt[0]} #{@txt[1]}#{@cX.off}"
    end
    def puts_brown
      puts "#{@cX.brown}#{@txt[0]} #{@txt[1]}#{@cX.off}"
    end
    def grey_tab
      print "\t#{@cX.grey}#{@txt[0]}#{@cX.off}\n"
    end
    def green_title
      puts %{#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}}
    end
    def green_title_hi
      puts %{#{@cX.green_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.grey}#{@txt[1]}#{@cX.off}}
    end
    def green_hi_blue
      puts %{#{@cX.green_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def blue_title_hi
      puts %{#{@cX.blue_hi}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def grey_title_hi
      puts %{#{@cX.grey_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def grey_title_grey_blue
      puts %{#{@cX.grey_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.grey}#{@txt[1]}#{@cX.off} #{@cX.blue}#{@txt[2]}#{@cX.off}}
    end
    def dark_grey_title_hi
      puts %{#{@cX.darkgrey_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def cyan_title_hi
      puts %{#{@cX.cyan_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def cyan_hi_blue
      puts %{#{@cX.cyan_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def dbi_title
      puts %{#{@cX.blue_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.cyan}#{@cX.grey}#{@txt[1]}#{@cX.off*2} #{@cX.green}#{@txt[2]}#{@cX.off}}
    end
    def yellow_title_hi
      puts %{#{@cX.yellow_hi}#{@cX.black}#{@txt[0]}#{@cX.off*2} #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def term_sheet_title
      puts %{\t#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.red_hi}#{@cX.black}#{@txt[1]}.#{@cX.off*2} }
    end
    def generic_number
      puts "#{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.grey}#{@txt[1]}#{@cX.off}"
    end
    def tex_numbers
      puts %{  #{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.cyan}tex/pdf files processed#{@cX.off}.}
    end
    def tex_info_numbers
      puts %{  #{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.cyan}texinfo files processed#{@cX.off}.}
    end
    def lout_numbers
      puts %{  #{@cX.green}#{@n_lout}#{@cX.off} #{@cX.cyan}lout/pdf files processed#{@cX.off}.}
    end
    def parameters
    end
    def reserved
      puts %{ #{@cX.grey_hi}#{@cX.black}reserved#{@cX.off*2}}
    end
    def meta_verse_title
      puts %{#{@cX.green_hi}#{@cX.black}MetaVerse#{@cX.off*2} }
    end
    def meta_verse_title_v
      b=sourcename(@txt[0])
      puts %{#{@cX.green_hi}#{@cX.black}MetaVerse#{@cX.off*2} } +
        %{#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.ruby}->#{@cX.off}\n\t  #{@cX.blue}~meta/#{b}.meta#{@cX.off}}
    end
    def meta_verse
      puts "\t#{@cX.grey}MetaVerse#{@cX.off}"
    end
    def meta_verse_skipped
      puts %{\t#{@cX.grey}MetaVerse: MarshalLoad (creation of metaVerse skipped)#{@cX.off}}
    end
    def meta_verse_load
      puts %{\t[ MetaVerse: MarshalLoad ]}
    end
    def html_title
      puts %{#{@cX.green_hi}#{@cX.black}HTML#{@cX.off*2}}
    end
    def html_output
      puts %{\t#{@cX.grey}#{@txt[0]}#{@cX.off} #{@cX.ruby}->#{@cX.off}\n\t  #{@cX.blue}#{@txt[1]}#{@cX.off}}
    end
    def segmented
      puts "\t#{@cX.grey}Seg#{@cX.off} #{@cX.green}#{@txt[0]}#{@cX.off} #{@cX.grey}segments#{@cX.off}"
    end
  end
end
__END__
        Color.new do
          self.off           = "\033[0m"
          self.white         = "\033[37m"
          self.white_bold    = "\033[1m"
          self.marker        = "\033[42m"
          self.bold          = "\033[1m"
          self.underline     = "\033[4m"
          self.invert        = "\033[7m"
          self.darkgrey_hi   = "\033[100m"
          self.grey_hi       = "\033[47m"
          self.pink_hi       = "\033[105m"
          self.fuchsia_hi    = "\033[45m"
          self.red_hi        = "\033[41m"
          self.orange_hi     = "\033[101m"
          self.yellow_hi     = "\033[103m"
          self.brown_hi      = "\033[43m"
          self.lightgreen_hi = "\033[102m"
          self.green_hi      = "\033[42m"
          self.cyan_hi       = "\033[106m"
          self.blue_hi       = "\033[104m"
          self.navy_hi       = "\033[44m"
          self.grey          = "\033[90m"
          self.pink          = "\033[95m"
          self.fuchsia       = "\033[35m"
          self.ruby          = "\033[31m"
          self.red           = "\033[91m" #check
          self.orange        = "\033[91m"
          self.yellow        = "\033[93m"
          self.brown         = "\033[33m"
          self.green         = "\033[92m"
          self.darkgreen     = "\033[32m"
          self.cyan          = "\033[36m"
          self.blue          = "\033[94m"
          self.navy          = "\033[34m"
          self.black         = "\033[30m"
        end
# fewer colors
        Color.new do
          self.off           = "\033[0m"
          self.white         = "\033[0m"
          self.marker        = "\033[42m"
          self.bold          = "\033[1m"
          self.underline     = "\033[4m"
          self.invert        = "\033[7m"
          self.darkgrey_hi   = "\033[100m"
          self.grey_hi       = "\033[47m"
          self.pink_hi       = "\033[105m"
          self.fuchsia_hi    = "\033[45m"
          self.red_hi        = "\033[41m"
          self.orange_hi     = "\033[101m"
          self.yellow_hi     = "\033[103m"
          self.brown_hi      = "\033[43m"
          self.lightgreen_hi = "\033[102m"
          self.green_hi      = "\033[42m"
          self.cyan_hi       = "\033[106m"
          self.blue_hi       = "\033[104m"
          self.navy_hi       = "\033[44m"
          self.grey          = "\033[90m"
          self.pink          = "\033[95m"
          self.fuchsia       = "\033[35m"
          self.ruby          = "\033[31m"
          self.red           = "\033[31m" #check
          self.orange        = "\033[91m"
          self.yellow        = "\033[33m"
          self.brown         = "\033[33m"
          self.green         = "\033[32m"
          self.darkgreen     = "\033[32m"
          self.cyan          = "\033[36m"
          self.blue          = "\033[34m"
          self.navy          = "\033[34m"
          self.black         = "\033[30m"
        end
