#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    xml
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/sisu>
#    <https://git.sisudoc.org/projects/sisu-markup>
module SiSU_Tables
  class Table #_xml
    @@tablehead=0
    @@tablefoot=[] #watch #bug??? #check was @@tablefoot
    def initialize(one,ocn='')
      @one,@parablock,@ocn=one,one,ocn
    end
    def table_split                                                            #% used but, no longer operational, revisit
      @new_content=[]
      @one.split(/\n/).each do |parablock|
        table=TableXML.new("#{parablock}\n")
        @new_content << table.table
      end
      @new_content.join
    end
  end
  class TableXML <Table
    @@tablehead=0
    @@tablefoot=[]
    def initialize(one,ocn='')
      @one,@parablock,@ocn=one,one,ocn
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      @parablock=@parablock.gsub(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/#{Mx[:gr_o]}Th#{Mx[:tc_p]}/u
      if @parablock =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}/u
        @parablock=@parablock.gsub(/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}.+?#{Mx[:tc_p]}~(\d+);\w\d+;\w\d+#{Mx[:gr_c]}/u,
          %{\n<ocn>#{@ocn}</ocn><table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">})
      end
      if @parablock =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        tablefoot=[]
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
      end
      if @@tablehead==1
        if @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}/u
          @parablock=@parablock.gsub(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,
            %{<tr>
  <td width="\\1%" valign="top"><b>}).
            gsub(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,
              %{</b></td><td width="\\1%" valign="top"><b>}).
            gsub(/#{Mx[:tc_c]}/,"</b>\n</td>\n</tr>")
          @@tablehead=0
        end
        @parablock
      else
        @parablock=@parablock.gsub(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,
          %{<tr>
  <td width="\\1%" valign="top">}).
          gsub(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,
            %{
  </td>
  <td width="\\1%" valign="top">}).
          gsub(/#{Mx[:tc_c]}/,"\n</td>\n</tr>\n")
      end
      @parablock
    end
  end
  class TableXMLdocbook
    @@tablehead=0
    @@tablefoot=[] #watch
    def initialize(table,id='')
      @table_obj,@id=table,id
    end
    def spaces
      Ax[:spaces]
    end
    def table
      table_obj=@table_obj
      if table_obj.obj !~/^<table\s/m
        table_obj=table_rows_and_columns_array(table_obj)
      else p __LINE__; p caller
      end
      table_obj
    end
    def table_rows_and_columns_array(table_obj) # provides basic (x)html table
      table_rows,nr=[],0
      table_obj.obj.split(Mx[:tc_c]).each do |table_row|
        table_row_with_columns=table_row.split(Mx[:tc_p])
        trc,nc=[],0
        table_row_with_columns.each do |c|
          c=c.gsub(/^(?:~|&nbsp;)$/,''). # tilde / empty cell
            gsub(/&nbsp;/,' ').
            gsub(/<:br>/,'<br />')
          trc <<= if table_obj.head_ and nr==0
            %{#{spaces*6}<entry>#{c}</entry>\n}
          else %{#{spaces*6}<entry>#{c}</entry>\n}
          end
          nc+=1
        end
        trc=(trc.is_a?(Array)) ? trc.flatten.join : trc
        trc = if table_obj.head_ and nr==0
          "#{spaces*4}<thead>\n#{spaces*5}<row>\n#{trc}#{spaces*5}</row>\n#{spaces*4}</thead>\n#{spaces*4}<tbody>\n"
        else
          "#{spaces*5}<row>\n#{trc}#{spaces*5}</row>\n"
        end
        nr+=1
        table_rows << trc
      end
      tbody_close=if table_obj.head_
        "#{spaces*4}</tbody>"
      else ''
      end
      table_rows=table_rows.flatten.join
      # include table_id <table id=''>
      table_obj.obj=%{#{spaces*3}<para #{@id}>
#{spaces*4}<table>
#{spaces*4}<tgroup cols="#{table_obj.cols}" align="char">
#{table_rows}#{tbody_close}
#{spaces*4}</tgroup>
#{spaces*4}</table>
#{spaces*3}</para>}
      table_obj
    end
  end
  class TableXMLexp <Table
    @@tablehead=0
    @@tablefoot=[]
    def initialize(one)
      @one,@parablock=one,one
    end
    def table_close
      '</td></tr>
</table>'
    end
    def margin_numless
      '</td><td width="4%" align="right" valign="top">'
    end
    def table_head(inf)
      %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
  <tr>
    <td valign="top" align="justify">
      <a name="#{inf}"></a>
    </td>
    <td>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">}
    end
    def table_end(tablefoot='')
      %{</table>#{the_margin_numless}#{the_margin_numless}&nbsp;#{the_table_close}
#{tablefoot}}
    end
    def table_row(inf,h=false)
      bold=h ? '<b>' : ''
      %{
<tr>
  <td width="#{inf}%" valign="top">#{bold}}
    end
    def table_cell(inf,h=false)
      if h; %{</b></td><td width="#{inf}%" valign="top"><b>}
      else  %{</td><td width="#{inf}%" valign="top">}
      end
    end
    def table_row_close(h=false)
      bold_close=h ? '<b>' : ''
      "#{bold_close}</td></tr>"
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      @parablock=@parablock.gsub(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/#{Mx[:gr_o]}Th#{Mx[:tc_p]}/u
      if @parablock =~/#{Mx[:gr_o]}Th?#{Mx[:tc_p]}.+?#{Mx[:tc_p]}~(\d+);\w\d+;\w\d+#{Mx[:gr_c]}/u
        @parablock=table_head($1)
      end
      if @parablock =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
        tablefoot=[]
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
        if @parablock =~/#{Mx[:gr_o]}TZ#{Mx[:gr_c]}/
          @parablock=table_end
        end
      end
      if @@tablehead==1
        if @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}/u
          if @parablock =~/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
            @parablock=@parablock.gsub(/#{Mx[:tc_o]}#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_row($1,true))
          end
          if @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
            @parablock=@parablock.gsub(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_cell($1,true))
          end
          if @parablock =~/#{Mx[:tc_c]}/
            @parablock=@parablock.gsub(/#{Mx[:tc_c]}/,table_row_close(true))
          end
          @@tablehead=0
        end
        @parablock
      else
        if @parablock =~/^#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
          @parablock=@parablock.gsub(/^#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_row($1))
        end
        if @parablock =~/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u
          @parablock=@parablock.gsub(/#{Mx[:tc_p]}#{Mx[:tc_p]}(\d+?)#{Mx[:tc_p]}/u,table_cell($1))
        end
        if @parablock =~/#{Mx[:tc_c]}/
          @parablock=@parablock.gsub(/#{Mx[:tc_c]}/,table_row_close)
        end
        @parablock
      end
      @parablock
    end
  end
end
__END__
