/*
 * Parse appinfo information
 */
#include "common.h"
#include "cmdline.h"

/* Top-level print routines */
extern void apstat_a(const uint8_t *ai_buf, struct basil_inventory *inv,
		     uint64_t apid, unsigned verbosity);
extern void apstat_r(const uint8_t *ai_buf, struct basil_inventory *inv,
		     uint32_t resid, unsigned verbosity);
extern void apstat_n(const uint8_t *ai_buf, struct basil_inventory *inv,
		     unsigned verbosity);

int main(int argc, char **argv)
{
	struct gengetopt_args_info args;
	struct basil_inventory	*inv;
	enum basil_version	version = get_basil_version();
	uint8_t			*ai_buf = basil_get_appinfo();

	if (cmdline_parser(argc, argv, &args) != 0)
		exit(EXIT_FAILURE);

	if (ai_buf == NULL) {
		err(1, "failed to obtain appinfo information");
	} else if (args.resid_arg && !appinfo_by_resid(ai_buf, args.resid_arg)) {
		fprintf(stderr, "Invalid resid: %ld\n", args.resid_arg);
		exit(1);
	} else if (args.apid_arg && !appinfo_by_apid(ai_buf, args.apid_arg)) {
		fprintf(stderr, "Invalid resid: %ld\n", args.resid_arg);
		exit(1);
	}

	inv = get_full_inventory(version);
	if (inv == NULL)
		errx(1, "failed to get an INVENTORY");

	if (args.apids_flag) {
		apstat_a(ai_buf, inv, args.apid_arg, args.verbose_given);
	} else if (args.reservations_flag) {
		apstat_r(ai_buf, inv, args.resid_arg, args.verbose_given);
	} else if (args.nodes_flag) {
		apstat_n(ai_buf, inv, args.alps_nid_order_flag ? 2 : 1);
	} else {
		apstat_n(ai_buf, inv, false);

		printf("\nNo pending applications are present\n\n");	 /* XXX */

		apstat_a(ai_buf, inv, 0, false);
	}
	free(ai_buf);
	free_inv(inv);

	return EXIT_SUCCESS;
}
