/*
  File autogenerated by gengetopt version 2.22.1
  generated with the following command:
  gengetopt 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "List unoccupied and available batch nodes on Cray XT/XE systems.";

const char *gengetopt_args_info_usage = "Usage: get_free_nodes [OPTIONS]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_detailed_help[] = {
  "  -h, --help              Print help and exit",
  "      --detailed-help     Print help, including all details and hidden options, \n                            and exit",
  "      --full-help         Print help, including hidden options, and exit",
  "  -V, --version           Print version and exit",
  "\nFlags:",
  "  -n, --nodename          prepend nid00.* to node ID  (default=on)",
  "  -u, --uncompressed      do not compress ranges of type 'a-b'  (default=off)",
  "  -c, --count             print a node count to stderr  (default=off)",
  "  -e, --engine            show ALPS engine version and exit  (default=off)",
  "\nParameters:",
  "  -s, --separator=STRING  list separator  (default=`,')",
  "  Separator string for listing nodes.",
    0
};
static void
init_full_help_array(void)
{
  gengetopt_args_info_full_help[0] = gengetopt_args_info_detailed_help[0];
  gengetopt_args_info_full_help[1] = gengetopt_args_info_detailed_help[1];
  gengetopt_args_info_full_help[2] = gengetopt_args_info_detailed_help[2];
  gengetopt_args_info_full_help[3] = gengetopt_args_info_detailed_help[3];
  gengetopt_args_info_full_help[4] = gengetopt_args_info_detailed_help[4];
  gengetopt_args_info_full_help[5] = gengetopt_args_info_detailed_help[5];
  gengetopt_args_info_full_help[6] = gengetopt_args_info_detailed_help[6];
  gengetopt_args_info_full_help[7] = gengetopt_args_info_detailed_help[7];
  gengetopt_args_info_full_help[8] = gengetopt_args_info_detailed_help[8];
  gengetopt_args_info_full_help[9] = gengetopt_args_info_detailed_help[9];
  gengetopt_args_info_full_help[10] = gengetopt_args_info_detailed_help[10];
  gengetopt_args_info_full_help[11] = 0; 
  
}

const char *gengetopt_args_info_full_help[12];

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_detailed_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_detailed_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_detailed_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_detailed_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_detailed_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_detailed_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_detailed_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_detailed_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_detailed_help[9];
  gengetopt_args_info_help[9] = gengetopt_args_info_detailed_help[10];
  gengetopt_args_info_help[10] = 0; 
  
}

const char *gengetopt_args_info_help[11];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->nodename_given = 0 ;
  args_info->uncompressed_given = 0 ;
  args_info->count_given = 0 ;
  args_info->engine_given = 0 ;
  args_info->separator_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->nodename_flag = 1;
  args_info->uncompressed_flag = 0;
  args_info->count_flag = 0;
  args_info->engine_flag = 0;
  args_info->separator_arg = gengetopt_strdup (",");
  args_info->separator_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = gengetopt_args_info_detailed_help[0] ;
  args_info->detailed_help_help = gengetopt_args_info_detailed_help[1] ;
  args_info->full_help_help = gengetopt_args_info_detailed_help[2] ;
  args_info->version_help = gengetopt_args_info_detailed_help[3] ;
  args_info->nodename_help = gengetopt_args_info_detailed_help[5] ;
  args_info->uncompressed_help = gengetopt_args_info_detailed_help[6] ;
  args_info->count_help = gengetopt_args_info_detailed_help[7] ;
  args_info->engine_help = gengetopt_args_info_detailed_help[8] ;
  args_info->separator_help = gengetopt_args_info_detailed_help[10] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_detailed_help[i])
    printf("%s\n", gengetopt_args_info_detailed_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->separator_arg));
  free_string_field (&(args_info->separator_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, char *values[])
{
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->nodename_given)
    write_into_file(outfile, "nodename", 0, 0 );
  if (args_info->uncompressed_given)
    write_into_file(outfile, "uncompressed", 0, 0 );
  if (args_info->count_given)
    write_into_file(outfile, "count", 0, 0 );
  if (args_info->engine_given)
    write_into_file(outfile, "engine", 0, 0 );
  if (args_info->separator_given)
    write_into_file(outfile, "separator", args_info->separator_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "nodename",	0, NULL, 'n' },
        { "uncompressed",	0, NULL, 'u' },
        { "count",	0, NULL, 'c' },
        { "engine",	0, NULL, 'e' },
        { "separator",	1, NULL, 's' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVnuces:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'n':	/* prepend nid00.* to node ID.  */
        
        
          if (update_arg((void *)&(args_info->nodename_flag), 0, &(args_info->nodename_given),
              &(local_args_info.nodename_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "nodename", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* do not compress ranges of type 'a-b'.  */
        
        
          if (update_arg((void *)&(args_info->uncompressed_flag), 0, &(args_info->uncompressed_given),
              &(local_args_info.uncompressed_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "uncompressed", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* print a node count to stderr.  */
        
        
          if (update_arg((void *)&(args_info->count_flag), 0, &(args_info->count_given),
              &(local_args_info.count_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "count", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* show ALPS engine version and exit.  */
        
        
          if (update_arg((void *)&(args_info->engine_flag), 0, &(args_info->engine_given),
              &(local_args_info.engine_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "engine", 'e',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* list separator.  */
        
        
          if (update_arg( (void *)&(args_info->separator_arg), 
               &(args_info->separator_orig), &(args_info->separator_given),
              &(local_args_info.separator_given), optarg, 0, ",", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "separator", 's',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            cmdline_parser_print_detailed_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
