-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body SparkFormatCommandLineData is

   Ada_Extension : constant String := "ada";

   procedure Initialize is
   begin
      Content :=
        Command_Line_Contents'
        (Valid                 => True,
         Source_Extension      => E_Strings.Copy_String (Str => Ada_Extension),
         Exclude_Export        => E_Strings.Empty_String,
         Number_Source         => 0,
         Source_File_List      => Source_File_Lists'(others => Source_File_Entry'(Source_Filename => E_Strings.Empty_String)),
         Operation             => Compress,
         Add_Modes             => False,
         Global_Indent         => Inline,
         Export_Indent         => Inline,
         Import_Indent         => Inline,
         Inherit_Indent        => Inline,
         Own_Indent            => Inline,
         Refinement_Indent     => Inline,
         Constituent_Indent    => Inline,
         Initialization_Indent => Inline,
         Separator_Indent      => Inline,
         Properties_Indent     => Inline,
         Help                  => False,
         Version               => False,
         Default_Function_Mode => Unmoded);
   end Initialize;

end SparkFormatCommandLineData;
