/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REPOSITORYDIALOG_H
#define _SC_REPOSITORYDIALOG_H

// sc
#include "util/String.h"
class RepoModel;

// qt
#include <QtGui/QDialog>
class Q3ListView;
class Q3ListViewItem;
class Q3ProgressBar;
class QPushButton;
class QComboBox;
class QPixmap;
class QTimer;


/**
 * Dialog for selecting a repository url.
 */
class RepositoryDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  RepositoryDialog( RepoModel* model, QWidget *parent = 0 );
  virtual ~RepositoryDialog();

  bool showDirsOnly();
  void setDirsOnly( bool );

  sc::String getSelection() const;

public slots:
  void editChanged();
  void selectionChanged( Q3ListViewItem* lvi );
  void expanded( Q3ListViewItem* );

  void rooted();
  void listed( const sc::String& url );

  void parent();
  void timeout();

private:
  const QPixmap& getFolderPixmap() const;

  RepoModel*      _model;
  bool            _dirsOnly;
  QComboBox*      _edit;
  Q3ListView*     _list;
  Q3ListViewItem* _expanded;   ///< last expanded item;
  Q3ProgressBar*  _progress;
  QPushButton*    _parent;

  QPixmap*        _folder;
  QTimer*         _timer;
};

#endif // _SC_REPOSITORYDIALOG_H
