/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_WCVIEW_ITEMMODEL_H
#define _SC_WCVIEW_ITEMMODEL_H

// sc
#include "subcommander/WcViewItem.h"
#include "util/String.h"

// qt
#include <QtCore/QAbstractItemModel>

namespace wcview {
class Item;

/**
 * Item model for WcViewTree.
 */
class ItemModel : public QAbstractItemModel
{
  typedef QAbstractItemModel super;
  Q_OBJECT

public:
  ItemModel( const sc::String& root, const WcViewItemData* data );
  virtual ~ItemModel();

  // QAbstractItemModel
  QModelIndex index(
    int row, int column, const QModelIndex& parent ) const;
  QModelIndex parent( const QModelIndex& index ) const;
  int columnCount( const QModelIndex& parent ) const;
  int rowCount( const QModelIndex& parent ) const;
  QVariant headerData( 
    int section, Qt::Orientation orientation, int role ) const;
  QVariant data( const QModelIndex& index, int role ) const;
  Qt::ItemFlags flags( const QModelIndex &index ) const;

  // ItemModel
  QModelIndex index( const sc::String& name ) const;

public slots:
  // ItemModel
  void insert( const WcViewItemPtr& );
  void remove( const WcViewItemPtr& );
  void update( const WcViewItemPtr& );

private:
  bool isInvisibleRoot (const QModelIndex& idx) const;
  bool hasParent (const QModelIndex& parent) const;

  Item* getItem (const QModelIndex& index) const;
  void checkRootItem( const WcViewItemPtr& item ) const;

  sc::String            _rootPath;
  Item*                 _root;
  const WcViewItemData* _data;
};

} // namespace

#endif // _SC_WCVIEW_ITEMMODEL_H
