C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE INITMP
C                       *****************
C
C      --------------------------------------------------
     * (NDIM,NPOINS,NELEMS,NDMATS,NODES,
     *  COORDS,NREFS,NREFE,TMPSA,TMPS)
C      --------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            INITIALISATION DE LA TEMPERATURE DANS LE SOLIDE           *
C                                                                      *
C            (Sous-programme utilisateur)                              *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS SOLIDES               !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  TMPSA    ! TR ! R  ! TEMPERATURE INITIALE DANS LE SOLIDE          !
C !  TMPS     ! TR ! R  ! TEMPERATURE INITIALE DANS LE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : INISOL,RESSOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NELEMS,NDMATS
      INTEGER NREFS(NPOINS),NREFE(NELEMS),NODES(NELEMS,NDMATS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM)
      DOUBLE PRECISION  TMPSA(NPOINS),TMPS(NPOINS)
C
C.. Variables internes
      DOUBLE PRECISION  XX,YY,ZZ
      INTEGER N,I,NUMREF
C
C***********************************************************************
C
C     1- INTERVENTION UTILISATEUR A PARTIR DE CETTE LIGNE
C     ===================================================
C    
C Methode 1 : boucle sur les noeuds
C ---------------------------------
C     La temperature du solide est stockee dans TMPS(...)
C
C     Pour chaque point solide
C     DO N=1,NPOINS
C   
C        Coordonnees du noeud courant
CUTI     XX = COORDS(N,1)
CUTI     YY = COORDS(N,2)
CUTI     IF (NDIM.EQ.3) ZZ = COORDS(N,3)
C
C        Numero de reference du noeud
CUTI     NUMREF = NREFS(N)
C
C        Si le noeud courant porte la reference 4
CUTI     IF (NUMREF.EQ.4 ) THEN
CUTI       TMPS(N)  = 20.D0
CUTI     ELSE
CUTI       TMPS(N)  = 10.D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C Methode 2 : boucle sur les elements
C -----------------------------------
C     La temperature du solide est stockee dans TMPS(...)
C
C     Pour chaque element solide
C     DO N=1,NELEMS
C
C        
C        Numero de materiau de l'element
CUTI     NUMREF=NREFE(N)
C   
C        Si l'elements porte la reference 4, on met 20 degres sur tous
C        les noeuds de l'element sinon on met 10 degres
CUTI     IF (NUMREF.EQ.4 ) THEN
CUTI       DO I=1,NDMATS
CUTI          TMPS(NODES(N,I))  = 20.D0
CUTI       ENDDO
CUTI     ELSE
CUTI       DO I=1,NDMATS
CUTI          TMPS(NODES(N,I))  = 10.D0
CUTI       ENDDO
CUTI     ENDIF
C
CUTI  ENDDO
C
C     FIN D'INTERVENTION UTILISATEUR
C     ------------------------------
C***********************************************************************
C
      DO N=1,NPOINS
         TMPSA(N)=TMPS(N)
      ENDDO
C
C----
C FIN
C----
      END
