from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


blocking = _Mock()

channels = _Mock()

channelsabc = _Mock()

client = _Mock()

clientabc = _Mock()

comm = _Mock()

connect = _Mock()

connect_qtconsole = _Mock()

find_connection_file = _Mock()

get_connection_file = _Mock()

get_connection_info = _Mock()

inprocess = _Mock()

launch_kernel = _Mock()

launcher = _Mock()

make_ipkernel_cmd = _Mock()

manager = _Mock()

managerabc = _Mock()

multikernelmanager = _Mock()

swallow_argv = _Mock()

tunnel_to_kernel = _Mock()

write_connection_file = _Mock()

zmq = _Mock()



class BlockingKernelClient(_Mock):
  pass


class KernelClient(_Mock):
  pass


class KernelManager(_Mock):
  pass


class MultiKernelManager(_Mock):
  pass


