from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       






class QAbstractNetworkCache(_Mock):
  pass


class QAbstractSocket(_Mock):
  pass
  AddressInUseError = 8
  Append = 4
  BoundState = 4
  ClosingState = 6
  ConnectedState = 3
  ConnectingState = 2
  ConnectionRefusedError = 0
  DatagramTooLargeError = 6
  HostLookupState = 1
  HostNotFoundError = 2
  IPv4Protocol = 0
  IPv6Protocol = 1
  KeepAliveOption = 1
  ListeningState = 5
  LowDelayOption = 0
  MulticastLoopbackOption = 3
  MulticastTtlOption = 2
  NetworkError = 7
  NotOpen = 0
  ProxyAuthenticationRequiredError = 12
  ProxyConnectionClosedError = 15
  ProxyConnectionRefusedError = 14
  ProxyConnectionTimeoutError = 16
  ProxyNotFoundError = 17
  ProxyProtocolError = 18
  ReadOnly = 1
  ReadWrite = 3
  RemoteHostClosedError = 1
  SocketAccessError = 3
  SocketAddressNotAvailableError = 9
  SocketResourceError = 4
  SocketTimeoutError = 5
  SslHandshakeFailedError = 13
  TcpSocket = 0
  Text = 16
  Truncate = 8
  UdpSocket = 1
  Unbuffered = 32
  UnconnectedState = 0
  UnfinishedSocketOperationError = 11
  UnknownNetworkLayerProtocol = -1
  UnknownSocketError = -1
  UnknownSocketType = -1
  UnsupportedSocketOperationError = 10
  WriteOnly = 2

class QAuthenticator(_Mock):
  pass


class QFtp(_Mock):
  pass
  Active = 0
  Ascii = 1
  Binary = 0
  Cd = 7
  Close = 5
  Closing = 5
  ConnectToHost = 3
  Connected = 3
  Connecting = 2
  ConnectionRefused = 3
  Get = 8
  HostLookup = 1
  HostNotFound = 2
  List = 6
  LoggedIn = 4
  Login = 4
  Mkdir = 11
  NoError = 0
  None_ = 0
  NotConnected = 4
  Passive = 1
  Put = 9
  RawCommand = 14
  Remove = 10
  Rename = 13
  Rmdir = 12
  SetProxy = 2
  SetTransferMode = 1
  Unconnected = 0
  UnknownError = 1

class QHostAddress(_Mock):
  pass
  Any = 4
  AnyIPv6 = 5
  Broadcast = 1
  LocalHost = 2
  LocalHostIPv6 = 3
  Null = 0

class QHostInfo(_Mock):
  pass
  HostNotFound = 1
  NoError = 0
  UnknownError = 2

class QHttp(_Mock):
  pass
  Aborted = 7
  AuthenticationRequiredError = 8
  Closing = 6
  Connected = 5
  Connecting = 2
  ConnectionModeHttp = 0
  ConnectionModeHttps = 1
  ConnectionRefused = 3
  HostLookup = 1
  HostNotFound = 2
  InvalidResponseHeader = 5
  NoError = 0
  ProxyAuthenticationRequiredError = 9
  Reading = 4
  Sending = 3
  Unconnected = 0
  UnexpectedClose = 4
  UnknownError = 1
  WrongContentLength = 6

class QHttpHeader(_Mock):
  pass


class QHttpMultiPart(_Mock):
  pass
  AlternativeType = 3
  FormDataType = 2
  MixedType = 0
  RelatedType = 1

class QHttpPart(_Mock):
  pass


class QHttpRequestHeader(_Mock):
  pass


class QHttpResponseHeader(_Mock):
  pass


class QLocalServer(_Mock):
  pass


class QLocalSocket(_Mock):
  pass
  Append = 4
  ClosingState = 6
  ConnectedState = 3
  ConnectingState = 2
  ConnectionError = 7
  ConnectionRefusedError = 0
  DatagramTooLargeError = 6
  NotOpen = 0
  PeerClosedError = 1
  ReadOnly = 1
  ReadWrite = 3
  ServerNotFoundError = 2
  SocketAccessError = 3
  SocketResourceError = 4
  SocketTimeoutError = 5
  Text = 16
  Truncate = 8
  Unbuffered = 32
  UnconnectedState = 0
  UnknownSocketError = -1
  UnsupportedSocketOperationError = 10
  WriteOnly = 2

class QNetworkAccessManager(_Mock):
  pass
  Accessible = 1
  CustomOperation = 6
  DeleteOperation = 5
  GetOperation = 2
  HeadOperation = 1
  NotAccessible = 0
  PostOperation = 4
  PutOperation = 3
  UnknownAccessibility = -1

class QNetworkAddressEntry(_Mock):
  pass


class QNetworkCacheMetaData(_Mock):
  pass


class QNetworkConfiguration(_Mock):
  pass
  Active = 14
  Bearer2G = 3
  BearerBluetooth = 7
  BearerCDMA2000 = 4
  BearerEthernet = 1
  BearerHSPA = 6
  BearerUnknown = 0
  BearerWCDMA = 5
  BearerWLAN = 2
  BearerWiMAX = 8
  Defined = 2
  Discovered = 6
  InternetAccessPoint = 0
  Invalid = 3
  PrivatePurpose = 2
  PublicPurpose = 1
  ServiceNetwork = 1
  ServiceSpecificPurpose = 3
  Undefined = 1
  UnknownPurpose = 0
  UserChoice = 2

class QNetworkConfigurationManager(_Mock):
  pass
  ApplicationLevelRoaming = 8
  CanStartAndStopInterfaces = 1
  DataStatistics = 32
  DirectConnectionRouting = 2
  ForcedRoaming = 16
  NetworkSessionRequired = 64
  SystemSessionSupport = 4

class QNetworkCookie(_Mock):
  pass
  Full = 1
  NameAndValueOnly = 0

class QNetworkCookieJar(_Mock):
  pass


class QNetworkDiskCache(_Mock):
  pass


class QNetworkInterface(_Mock):
  pass
  CanBroadcast = 4
  CanMulticast = 32
  IsLoopBack = 8
  IsPointToPoint = 16
  IsRunning = 2
  IsUp = 1

class QNetworkProxy(_Mock):
  pass
  CachingCapability = 8
  DefaultProxy = 0
  FtpCachingProxy = 5
  HostNameLookupCapability = 16
  HttpCachingProxy = 4
  HttpProxy = 3
  ListeningCapability = 2
  NoProxy = 2
  Socks5Proxy = 1
  TunnelingCapability = 1
  UdpTunnelingCapability = 4

class QNetworkProxyFactory(_Mock):
  pass


class QNetworkProxyQuery(_Mock):
  pass
  TcpServer = 100
  TcpSocket = 0
  UdpSocket = 1
  UrlRequest = 101

class QNetworkReply(_Mock):
  pass
  Append = 4
  AuthenticationRequiredError = 204
  ConnectionRefusedError = 1
  ContentAccessDenied = 201
  ContentNotFoundError = 203
  ContentOperationNotPermittedError = 202
  ContentReSendError = 205
  HostNotFoundError = 3
  NoError = 0
  NotOpen = 0
  OperationCanceledError = 5
  ProtocolFailure = 399
  ProtocolInvalidOperationError = 302
  ProtocolUnknownError = 301
  ProxyAuthenticationRequiredError = 105
  ProxyConnectionClosedError = 102
  ProxyConnectionRefusedError = 101
  ProxyNotFoundError = 103
  ProxyTimeoutError = 104
  ReadOnly = 1
  ReadWrite = 3
  RemoteHostClosedError = 2
  SslHandshakeFailedError = 6
  TemporaryNetworkFailureError = 7
  Text = 16
  TimeoutError = 4
  Truncate = 8
  Unbuffered = 32
  UnknownContentError = 299
  UnknownNetworkError = 99
  UnknownProxyError = 199
  WriteOnly = 2

class QNetworkRequest(_Mock):
  pass
  AlwaysCache = 3
  AlwaysNetwork = 0
  AuthenticationReuseAttribute = 12
  Automatic = 0
  CacheLoadControlAttribute = 4
  CacheSaveControlAttribute = 5
  ConnectionEncryptedAttribute = 3
  ContentDispositionHeader = 6
  ContentLengthHeader = 1
  ContentTypeHeader = 0
  CookieHeader = 4
  CookieLoadControlAttribute = 11
  CookieSaveControlAttribute = 13
  CustomVerbAttribute = 10
  DoNotBufferUploadDataAttribute = 7
  HighPriority = 1
  HttpPipeliningAllowedAttribute = 8
  HttpPipeliningWasUsedAttribute = 9
  HttpReasonPhraseAttribute = 1
  HttpStatusCodeAttribute = 0
  LastModifiedHeader = 3
  LocationHeader = 2
  LowPriority = 5
  Manual = 1
  NormalPriority = 3
  PreferCache = 2
  PreferNetwork = 1
  RedirectionTargetAttribute = 2
  SetCookieHeader = 5
  SourceIsFromCacheAttribute = 6
  User = 1000
  UserMax = 32767

class QNetworkSession(_Mock):
  pass
  Closing = 4
  Connected = 3
  Connecting = 2
  Disconnected = 5
  Invalid = 0
  InvalidConfigurationError = 4
  NotAvailable = 1
  OperationNotSupportedError = 3
  Roaming = 6
  RoamingError = 2
  SessionAbortedError = 1
  UnknownSessionError = 0

class QSsl(_Mock):
  pass
  AnyProtocol = 3
  Der = 1
  DnsEntry = 1
  Dsa = 1
  EmailEntry = 0
  Pem = 0
  PrivateKey = 0
  PublicKey = 1
  Rsa = 0
  SecureProtocols = 5
  SslOptionDisableCompression = 4
  SslOptionDisableEmptyFragments = 1
  SslOptionDisableLegacyRenegotiation = 16
  SslOptionDisableServerNameIndication = 8
  SslOptionDisableSessionTickets = 2
  SslV2 = 1
  SslV3 = 0
  TlsV1 = 2
  TlsV1SslV3 = 4
  UnknownProtocol = -1

class QSslCertificate(_Mock):
  pass
  CommonName = 1
  CountryName = 4
  LocalityName = 2
  Organization = 0
  OrganizationalUnitName = 3
  StateOrProvinceName = 5

class QSslCipher(_Mock):
  pass


class QSslConfiguration(_Mock):
  pass


class QSslError(_Mock):
  pass
  AuthorityIssuerSerialNumberMismatch = 20
  CertificateBlacklisted = 24
  CertificateExpired = 6
  CertificateNotYetValid = 5
  CertificateRejected = 18
  CertificateRevoked = 13
  CertificateSignatureFailed = 4
  CertificateUntrusted = 17
  HostNameMismatch = 22
  InvalidCaCertificate = 14
  InvalidNotAfterField = 8
  InvalidNotBeforeField = 7
  InvalidPurpose = 16
  NoError = 0
  NoPeerCertificate = 21
  NoSslSupport = 23
  PathLengthExceeded = 15
  SelfSignedCertificate = 9
  SelfSignedCertificateInChain = 10
  SubjectIssuerMismatch = 19
  UnableToDecodeIssuerPublicKey = 3
  UnableToDecryptCertificateSignature = 2
  UnableToGetIssuerCertificate = 1
  UnableToGetLocalIssuerCertificate = 11
  UnableToVerifyFirstCertificate = 12
  UnspecifiedError = -1

class QSslKey(_Mock):
  pass


class QSslSocket(_Mock):
  pass
  AddressInUseError = 8
  Append = 4
  AutoVerifyPeer = 3
  BoundState = 4
  ClosingState = 6
  ConnectedState = 3
  ConnectingState = 2
  ConnectionRefusedError = 0
  DatagramTooLargeError = 6
  HostLookupState = 1
  HostNotFoundError = 2
  IPv4Protocol = 0
  IPv6Protocol = 1
  KeepAliveOption = 1
  ListeningState = 5
  LowDelayOption = 0
  MulticastLoopbackOption = 3
  MulticastTtlOption = 2
  NetworkError = 7
  NotOpen = 0
  ProxyAuthenticationRequiredError = 12
  ProxyConnectionClosedError = 15
  ProxyConnectionRefusedError = 14
  ProxyConnectionTimeoutError = 16
  ProxyNotFoundError = 17
  ProxyProtocolError = 18
  QueryPeer = 1
  ReadOnly = 1
  ReadWrite = 3
  RemoteHostClosedError = 1
  SocketAccessError = 3
  SocketAddressNotAvailableError = 9
  SocketResourceError = 4
  SocketTimeoutError = 5
  SslClientMode = 1
  SslHandshakeFailedError = 13
  SslServerMode = 2
  TcpSocket = 0
  Text = 16
  Truncate = 8
  UdpSocket = 1
  Unbuffered = 32
  UnconnectedState = 0
  UnencryptedMode = 0
  UnfinishedSocketOperationError = 11
  UnknownNetworkLayerProtocol = -1
  UnknownSocketError = -1
  UnknownSocketType = -1
  UnsupportedSocketOperationError = 10
  VerifyNone = 0
  VerifyPeer = 2
  WriteOnly = 2

class QTcpServer(_Mock):
  pass


class QTcpSocket(_Mock):
  pass
  AddressInUseError = 8
  Append = 4
  BoundState = 4
  ClosingState = 6
  ConnectedState = 3
  ConnectingState = 2
  ConnectionRefusedError = 0
  DatagramTooLargeError = 6
  HostLookupState = 1
  HostNotFoundError = 2
  IPv4Protocol = 0
  IPv6Protocol = 1
  KeepAliveOption = 1
  ListeningState = 5
  LowDelayOption = 0
  MulticastLoopbackOption = 3
  MulticastTtlOption = 2
  NetworkError = 7
  NotOpen = 0
  ProxyAuthenticationRequiredError = 12
  ProxyConnectionClosedError = 15
  ProxyConnectionRefusedError = 14
  ProxyConnectionTimeoutError = 16
  ProxyNotFoundError = 17
  ProxyProtocolError = 18
  ReadOnly = 1
  ReadWrite = 3
  RemoteHostClosedError = 1
  SocketAccessError = 3
  SocketAddressNotAvailableError = 9
  SocketResourceError = 4
  SocketTimeoutError = 5
  SslHandshakeFailedError = 13
  TcpSocket = 0
  Text = 16
  Truncate = 8
  UdpSocket = 1
  Unbuffered = 32
  UnconnectedState = 0
  UnfinishedSocketOperationError = 11
  UnknownNetworkLayerProtocol = -1
  UnknownSocketError = -1
  UnknownSocketType = -1
  UnsupportedSocketOperationError = 10
  WriteOnly = 2

class QUdpSocket(_Mock):
  pass
  AddressInUseError = 8
  Append = 4
  BoundState = 4
  ClosingState = 6
  ConnectedState = 3
  ConnectingState = 2
  ConnectionRefusedError = 0
  DatagramTooLargeError = 6
  DefaultForPlatform = 0
  DontShareAddress = 2
  HostLookupState = 1
  HostNotFoundError = 2
  IPv4Protocol = 0
  IPv6Protocol = 1
  KeepAliveOption = 1
  ListeningState = 5
  LowDelayOption = 0
  MulticastLoopbackOption = 3
  MulticastTtlOption = 2
  NetworkError = 7
  NotOpen = 0
  ProxyAuthenticationRequiredError = 12
  ProxyConnectionClosedError = 15
  ProxyConnectionRefusedError = 14
  ProxyConnectionTimeoutError = 16
  ProxyNotFoundError = 17
  ProxyProtocolError = 18
  ReadOnly = 1
  ReadWrite = 3
  RemoteHostClosedError = 1
  ReuseAddressHint = 4
  ShareAddress = 1
  SocketAccessError = 3
  SocketAddressNotAvailableError = 9
  SocketResourceError = 4
  SocketTimeoutError = 5
  SslHandshakeFailedError = 13
  TcpSocket = 0
  Text = 16
  Truncate = 8
  UdpSocket = 1
  Unbuffered = 32
  UnconnectedState = 0
  UnfinishedSocketOperationError = 11
  UnknownNetworkLayerProtocol = -1
  UnknownSocketError = -1
  UnknownSocketType = -1
  UnsupportedSocketOperationError = 10
  WriteOnly = 2

class QUrlInfo(_Mock):
  pass
  ExeGroup = 8
  ExeOther = 1
  ExeOwner = 64
  ReadGroup = 32
  ReadOther = 4
  ReadOwner = 256
  WriteGroup = 16
  WriteOther = 2
  WriteOwner = 128

