from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ANCHORS = _Mock()

CONF = _Mock()

_ = _Mock()

assert_interfaces_valid = _Mock()

to_text_string = _Mock()

update_dataset = _Mock()

LEGEND_SPACEH = 5

LEGEND_SPACEV = 3

LEGEND_WIDTH = 30

SIG_ITEM_MOVED = '2item_moved(PyQt_PyObject,double,double,double,double)'

class AbstractLabelItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class CurveItem(_Mock):
  pass
  AutoScale = 2
  ClipPolygons = 2
  Dots = 4
  Fitted = 2
  Inverted = 1
  Legend = 1
  Lines = 1
  NoCurve = 0
  PaintFiltered = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  Steps = 3
  Sticks = 2
  UserCurve = 100
  Xfy = 1
  Yfx = 0
  _private = False
  _readonly = False

class DataInfoLabel(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class IBasePlotItem(_Mock):
  pass
  _can_move = True
  _can_resize = True
  _can_rotate = True
  _can_select = True
  _private = False
  _readonly = False
  selected = False

class ISerializableType(_Mock):
  pass


class IShapeItemType(_Mock):
  pass


class LabelItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class LabelParam(_Mock):
  pass
  _legend = False
  _multiselection = False
  _no_contents = True

class LegendBoxItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

class ObjectInfo(_Mock):
  pass


class QColor(_Mock):
  pass
  Cmyk = 3
  Hsl = 4
  Hsv = 2
  Invalid = 0
  Rgb = 1

class QPen(_Mock):
  pass


class QRectF(_Mock):
  pass


class QTextDocument(_Mock):
  pass
  DocumentTitle = 0
  DocumentUrl = 1
  FindBackward = 1
  FindCaseSensitively = 2
  FindWholeWords = 4
  HtmlResource = 1
  ImageResource = 2
  RedoStack = 2
  StyleSheetResource = 3
  UndoAndRedoStacks = 3
  UndoStack = 1
  UserResource = 100

class QwtPlotItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000

class RangeComputation(_Mock):
  pass


class RangeComputation2d(_Mock):
  pass


class RangeInfo(_Mock):
  pass


class SelectedLegendBoxItem(_Mock):
  pass
  AutoScale = 2
  Legend = 1
  RenderAntialiased = 1
  Rtti_PlotCurve = 4
  Rtti_PlotGrid = 1
  Rtti_PlotHistogram = 5
  Rtti_PlotItem = 0
  Rtti_PlotMarker = 3
  Rtti_PlotSVG = 7
  Rtti_PlotScale = 2
  Rtti_PlotSpectrogram = 6
  Rtti_PlotUserItem = 1000
  _private = False
  _readonly = False

