from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


SIGNAL = _Mock()

SIG_ACTIVE_ITEM_CHANGED = '2active_item_changed(PyQt_PyObject)'

SIG_ANNOTATION_CHANGED = '2annotation_changed(PyQt_PyObject)'

SIG_APPLIED_MASK_TOOL = '2applied_mask_tool()'

SIG_AXES_CHANGED = '2axes_changed(PyQt_PyObject)'

SIG_AXIS_DIRECTION_CHANGED = '2axis_direction_changed(PyQt_PyObject,PyQt_PyObject)'

SIG_CLICK_EVENT = '2click_event'

SIG_CS_CURVE_CHANGED = '2cs_curve_changed(PyQt_PyObject)'

SIG_END_RECT = '2end_rect'

SIG_ITEMS_CHANGED = '2items_changed(PyQt_PyObject)'

SIG_ITEM_MOVED = '2item_moved(PyQt_PyObject,double,double,double,double)'

SIG_ITEM_REMOVED = '2item_removed(PyQt_PyObject)'

SIG_ITEM_SELECTION_CHANGED = '2item_selection_changed(PyQt_PyObject)'

SIG_LUT_CHANGED = '2lut_changed(PyQt_PyObject)'

SIG_MARKER_CHANGED = '2marker_changed(PyQt_PyObject)'

SIG_MASK_CHANGED = '2mask_changed(PyQt_PyObject)'

SIG_MOVE = '2move'

SIG_PLOT_AXIS_CHANGED = '2plot_axis_changed(PyQt_PyObject)'

SIG_PLOT_LABELS_CHANGED = '2plot_labels_changed(PyQt_PyObject)'

SIG_RANGE_CHANGED = '2range_changed(PyQt_PyObject,double,double)'

SIG_START_TRACKING = '2start_tracking'

SIG_STOP_MOVING = '2stop_moving'

SIG_STOP_NOT_MOVING = '2stop_notmoving'

SIG_TOOL_JOB_FINISHED = '2tool_job_finished'

SIG_VALIDATE_TOOL = '2validate_tool'

SIG_VISIBILITY_CHANGED = '2visibility_changed(bool)'

SIG_VOI_CHANGED = '2voi_changed()'



