'\"
'\" Generated from file 'tqueue\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "transfer::copy::queue" n 0\&.1 tcllib "Data transfer facilities"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
transfer::copy::queue \- Queued transfers
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBsnit  ?1\&.0?\fR
.sp
package require \fBstruct::queue  ?1\&.4?\fR
.sp
package require \fBtransfer::copy  ?0\&.2?\fR
.sp
package require \fBtransfer::copy::queue  ?0\&.1?\fR
.sp
\fBtransfer::copy::queue\fR \fIobjectName\fR \fIoutchannel\fR ?\fIoptions\fR\&.\&.\&.?
.sp
\fIobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBbusy\fR
.sp
\fIobjectName\fR \fBpending\fR
.sp
\fIobjectName\fR \fBput\fR \fIrequest\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides objects which serialize transfer requests for a
single channel by means of a fifo queue\&. Accumulated requests are
executed in order of entrance, with the first request reaching an idle
object starting the execution in general\&. New requests can be added
while the object is active and are defered until all requests entered
before them have been completed successfully\&.
.PP
When a request causes a transfer error execution stops and all
requests coming after it are not served\&. Currently this means that
their completion callbacks are never triggered at all\&.
.PP
\fINOTE\fR:
Not triggering the completion callbacks of the unserved
requests after an error stops the queue object is something I
am not fully sure that it makes sense\&. It forces the user of
the queue to remember the callbacks as well and run
them\&. Because otherwise everything in the system which depends
on getting a notification about the status of a request will
hang in the air\&. I am slowly convincing myself that it is more
sensible to trigger the relevant completion callbacks with an
error message about the queue abort, and 0 bytes transfered\&.
.PP
All transfer requests are of the form
.PP
.CS


	{type data options\&.\&.\&.}

.CE
.PP
where \fItype\fR is in {\fBchan\fR, \fBstring\fR}, and \fIdata\fR
specifies the information to transfer\&.
For \fBchan\fR the data is the handle of the channel containing the
actual information to transfer, whereas for \fBstring\fR \fIdata\fR
contains directly the information to transfer\&.
The \fIoptions\fR are a list of them and their values, and are the
same as are accepted by the low-level copy operations of the package
\fBtransfer::copy\fR\&.
Note how just prepending the request with \fBtransfer::copy::do\fR and
inserting a channel handle in between \fIdata\fR and \fIoptions\fR
easily transforms it from a pure data structure into a command whose
evaluation will perform the request\&.
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fBtransfer::copy::queue\fR \fIobjectName\fR \fIoutchannel\fR ?\fIoptions\fR\&.\&.\&.?
This command creates a new queue object for the management of the
channel \fIoutchannel\fR, with an associated Tcl command whose name is
\fIobjectName\fR\&.
This \fIobject\fR command is explained in full detail in the sections
\fBObject command\fR and \fBObject methods\fR\&. The set of
supported \fIoptions\fR is explained in section \fBOptions\fR\&.
.sp
The object command will be created under the current namespace if the
\fIobjectName\fR is not fully qualified, and in the specified
namespace otherwise\&.
The fully qualified name of the object command is returned as the
result of the command\&.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::transfer::copy::queue\fR command have
the following general form:
.TP
\fIobjectName\fR \fBmethod\fR ?\fIarg arg \&.\&.\&.\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command\&.
See section \fBObject methods\fR for the detailed
specifications\&.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object\&. Doing so while the object is busy
will cause errors later on, when the currently executed request
completes and tries to access the now missing data structures of the
destroyed object\&.
.TP
\fIobjectName\fR \fBbusy\fR
This method returns a boolean value telling us if the object is
currently serving a request (i\&.e\&. \fIbusy\fR, value \fBTrue\fR), or
not (i\&.e\&. \fIidle\fR, value \fBFalse\fR)\&.
.TP
\fIobjectName\fR \fBpending\fR
This method returns the number of requests currently waiting in the
queue for their execution\&. A request currently served is not counted
as waiting\&.
.TP
\fIobjectName\fR \fBput\fR \fIrequest\fR
This method enters the transfer \fIrequest\fR into the object's queue
of waiting requests\&.
If the object is \fIidle\fR it will become \fIbusy\fR, immediately
servicing the request\&. Otherwise servicing the new request will be
defered until all preceding requests have been served\&.
.PP
.SH OPTIONS
The only option known is \fB-on-status-change\fR\&. It is optional
and defaults to the empty list, disabling the reporting of status
changes\&. Otherwise its argument is a command prefix which is invoked
whenever the internal status of the object changed\&. The callback is
invoked with two additional arguments, the result of the methods
\fBpending\fR and \fBbusy\fR, in this order\&. This allows any
user to easily know, for example, when the object has processed all
outstanding requests\&.
.SH USE
A possible application of this package and class is within a HTTP 1\&.1
server, managing the results waiting for transfer to the client\&.
.PP
It should be noted that in this application the system also needs an
additional data structure which keeps track of outstanding results as
they may come back in a different order than the requests from the
client, and releases them to the actual queue in the proper order\&.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItransfer\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
channel, copy, queue, transfer
.SH CATEGORY
Transfer module
.SH COPYRIGHT
.nf
Copyright (c) 2006 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi