/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#ifndef INDII_CLUSTER_EUCLIDEANDISTANCE_HPP
#define INDII_CLUSTER_EUCLIDEANDISTANCE_HPP

#include "ClusterVector.hpp"

namespace indii {
/**
 * Euclidean distance.
 *
 * @tparam T Datum element type.
 */
template<class T = float>
class EuclideanDistance {
public:
  /**
   * Calculate distance.
   *
   * @param x1 First point.
   * @param x2 Second point, should have same size as first.
   *
   * @return %Distance between the two points.
   */
  static T distance(const typename ClusterVector<T>::type& x1,
      const typename ClusterVector<T>::type& x2);

};
}

T indii::EuclideanDistance::distance(
    const typename ClusterVector<T>::type& x1,
    const typename ClusterVector<T>::type& x2) {
  /* pre-condition */
  assert (x1.size() == x2.size());

  return boost::numeric::ublas::norm_2(x2 - x1);
}

#endif
