#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 243
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 46
#define ALIAS_COUNT 0
#define TOKEN_COUNT 21
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 14

enum {
  anon_sym_DOT = 1,
  anon_sym_DQUOTE = 2,
  aux_sym__string_token1 = 3,
  sym_escape_sequence = 4,
  anon_sym_STAR = 5,
  anon_sym_PLUS = 6,
  anon_sym_QMARK = 7,
  sym_identifier = 8,
  aux_sym__immediate_identifier_token1 = 9,
  anon_sym__ = 10,
  anon_sym_AT = 11,
  sym_comment = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_LPAREN = 15,
  anon_sym_RPAREN = 16,
  anon_sym_COLON = 17,
  anon_sym_BANG = 18,
  anon_sym_POUND = 19,
  sym_predicate_type = 20,
  sym_program = 21,
  sym__definition = 22,
  sym__group_expression = 23,
  sym__named_node_expression = 24,
  sym__string = 25,
  sym_quantifier = 26,
  sym__immediate_identifier = 27,
  sym__node_identifier = 28,
  sym_capture = 29,
  sym_string = 30,
  sym_parameters = 31,
  sym_list = 32,
  sym_grouping = 33,
  sym_anonymous_node = 34,
  sym_named_node = 35,
  sym__field_name = 36,
  sym_field_definition = 37,
  sym_negated_field = 38,
  sym_predicate = 39,
  aux_sym_program_repeat1 = 40,
  aux_sym__string_repeat1 = 41,
  aux_sym_parameters_repeat1 = 42,
  aux_sym_list_repeat1 = 43,
  aux_sym_grouping_repeat1 = 44,
  aux_sym_named_node_repeat1 = 45,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DOT] = ".",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__string_token1] = "_string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_QMARK] = "\?",
  [sym_identifier] = "identifier",
  [aux_sym__immediate_identifier_token1] = "identifier",
  [anon_sym__] = "_",
  [anon_sym_AT] = "@",
  [sym_comment] = "comment",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [sym_predicate_type] = "predicate_type",
  [sym_program] = "program",
  [sym__definition] = "_definition",
  [sym__group_expression] = "_group_expression",
  [sym__named_node_expression] = "_named_node_expression",
  [sym__string] = "_string",
  [sym_quantifier] = "quantifier",
  [sym__immediate_identifier] = "_immediate_identifier",
  [sym__node_identifier] = "_node_identifier",
  [sym_capture] = "capture",
  [sym_string] = "string",
  [sym_parameters] = "parameters",
  [sym_list] = "list",
  [sym_grouping] = "grouping",
  [sym_anonymous_node] = "anonymous_node",
  [sym_named_node] = "named_node",
  [sym__field_name] = "_field_name",
  [sym_field_definition] = "field_definition",
  [sym_negated_field] = "negated_field",
  [sym_predicate] = "predicate",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym__string_repeat1] = "_string_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_grouping_repeat1] = "grouping_repeat1",
  [aux_sym_named_node_repeat1] = "named_node_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__string_token1] = aux_sym__string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_identifier] = sym_identifier,
  [aux_sym__immediate_identifier_token1] = sym_identifier,
  [anon_sym__] = anon_sym__,
  [anon_sym_AT] = anon_sym_AT,
  [sym_comment] = sym_comment,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_predicate_type] = sym_predicate_type,
  [sym_program] = sym_program,
  [sym__definition] = sym__definition,
  [sym__group_expression] = sym__group_expression,
  [sym__named_node_expression] = sym__named_node_expression,
  [sym__string] = sym__string,
  [sym_quantifier] = sym_quantifier,
  [sym__immediate_identifier] = sym__immediate_identifier,
  [sym__node_identifier] = sym__node_identifier,
  [sym_capture] = sym_capture,
  [sym_string] = sym_string,
  [sym_parameters] = sym_parameters,
  [sym_list] = sym_list,
  [sym_grouping] = sym_grouping,
  [sym_anonymous_node] = sym_anonymous_node,
  [sym_named_node] = sym_named_node,
  [sym__field_name] = sym__field_name,
  [sym_field_definition] = sym_field_definition,
  [sym_negated_field] = sym_negated_field,
  [sym_predicate] = sym_predicate,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym__string_repeat1] = aux_sym__string_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_grouping_repeat1] = aux_sym_grouping_repeat1,
  [aux_sym_named_node_repeat1] = aux_sym_named_node_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__immediate_identifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_predicate_type] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym__group_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__named_node_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__node_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_capture] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_grouping] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_node] = {
    .visible = true,
    .named = true,
  },
  [sym_named_node] = {
    .visible = true,
    .named = true,
  },
  [sym__field_name] = {
    .visible = false,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_field] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grouping_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_node_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_name = 1,
  field_parameters = 2,
  field_quantifier = 3,
  field_type = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_quantifier] = "quantifier",
  [field_type] = "type",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 2},
  [4] = {.index = 1, .length = 2},
  [5] = {.index = 3, .length = 1},
  [6] = {.index = 4, .length = 1},
  [7] = {.index = 5, .length = 1},
  [8] = {.index = 6, .length = 2},
  [9] = {.index = 8, .length = 2},
  [10] = {.index = 10, .length = 4},
  [11] = {.index = 14, .length = 2},
  [12] = {.index = 16, .length = 2},
  [13] = {.index = 18, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 0},
    {field_quantifier, 1},
  [3] =
    {field_name, 1},
  [4] =
    {field_quantifier, 2},
  [5] =
    {field_quantifier, 3},
  [6] =
    {field_name, 1},
    {field_quantifier, 3},
  [8] =
    {field_name, 1},
    {field_quantifier, 4},
  [10] =
    {field_name, 1},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 3},
  [14] =
    {field_name, 1},
    {field_quantifier, 5},
  [16] =
    {field_name, 1},
    {field_quantifier, 6},
  [18] =
    {field_name, 1},
    {field_quantifier, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__string, 2,
    sym__string,
    sym_identifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 6,
  [10] = 5,
  [11] = 7,
  [12] = 7,
  [13] = 5,
  [14] = 6,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 15,
  [20] = 18,
  [21] = 18,
  [22] = 17,
  [23] = 16,
  [24] = 17,
  [25] = 16,
  [26] = 15,
  [27] = 27,
  [28] = 28,
  [29] = 27,
  [30] = 30,
  [31] = 27,
  [32] = 32,
  [33] = 33,
  [34] = 32,
  [35] = 33,
  [36] = 36,
  [37] = 33,
  [38] = 38,
  [39] = 39,
  [40] = 32,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 54,
  [56] = 54,
  [57] = 48,
  [58] = 41,
  [59] = 47,
  [60] = 41,
  [61] = 51,
  [62] = 42,
  [63] = 46,
  [64] = 48,
  [65] = 50,
  [66] = 45,
  [67] = 49,
  [68] = 50,
  [69] = 42,
  [70] = 53,
  [71] = 49,
  [72] = 45,
  [73] = 52,
  [74] = 47,
  [75] = 53,
  [76] = 51,
  [77] = 46,
  [78] = 52,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 79,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 80,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 117,
  [119] = 119,
  [120] = 120,
  [121] = 80,
  [122] = 79,
  [123] = 117,
  [124] = 99,
  [125] = 108,
  [126] = 98,
  [127] = 89,
  [128] = 95,
  [129] = 92,
  [130] = 91,
  [131] = 88,
  [132] = 97,
  [133] = 90,
  [134] = 87,
  [135] = 86,
  [136] = 113,
  [137] = 85,
  [138] = 106,
  [139] = 81,
  [140] = 110,
  [141] = 111,
  [142] = 115,
  [143] = 116,
  [144] = 84,
  [145] = 114,
  [146] = 105,
  [147] = 102,
  [148] = 83,
  [149] = 104,
  [150] = 112,
  [151] = 93,
  [152] = 94,
  [153] = 153,
  [154] = 96,
  [155] = 101,
  [156] = 82,
  [157] = 103,
  [158] = 158,
  [159] = 96,
  [160] = 107,
  [161] = 107,
  [162] = 162,
  [163] = 108,
  [164] = 112,
  [165] = 113,
  [166] = 103,
  [167] = 83,
  [168] = 102,
  [169] = 105,
  [170] = 114,
  [171] = 116,
  [172] = 115,
  [173] = 111,
  [174] = 110,
  [175] = 81,
  [176] = 106,
  [177] = 82,
  [178] = 86,
  [179] = 101,
  [180] = 87,
  [181] = 90,
  [182] = 99,
  [183] = 97,
  [184] = 91,
  [185] = 92,
  [186] = 95,
  [187] = 98,
  [188] = 104,
  [189] = 84,
  [190] = 85,
  [191] = 88,
  [192] = 89,
  [193] = 93,
  [194] = 94,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 197,
  [200] = 200,
  [201] = 196,
  [202] = 200,
  [203] = 197,
  [204] = 196,
  [205] = 200,
  [206] = 206,
  [207] = 162,
  [208] = 208,
  [209] = 209,
  [210] = 153,
  [211] = 162,
  [212] = 212,
  [213] = 153,
  [214] = 214,
  [215] = 208,
  [216] = 208,
  [217] = 206,
  [218] = 206,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 221,
  [223] = 221,
  [224] = 224,
  [225] = 225,
  [226] = 225,
  [227] = 225,
  [228] = 228,
  [229] = 229,
  [230] = 229,
  [231] = 228,
  [232] = 229,
  [233] = 228,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 235,
  [240] = 235,
  [241] = 234,
  [242] = 234,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(15);
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '"') ADVANCE(17);
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '(') ADVANCE(34);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '+') ADVANCE(25);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == ':') ADVANCE(36);
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '?') ADVANCE(26);
      if (lookahead == '@') ADVANCE(30);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '"') ADVANCE(17);
      if (lookahead == '(') ADVANCE(34);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '+') ADVANCE(25);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == ':') ADVANCE(36);
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '?') ADVANCE(26);
      if (lookahead == '@') ADVANCE(30);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(17);
      if (lookahead == ';') ADVANCE(18);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 3:
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      END_STATE();
    case 4:
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 5:
      if (lookahead == 'u') ADVANCE(6);
      if (lookahead == 'x') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(23);
      if (lookahead != 0) ADVANCE(21);
      END_STATE();
    case 6:
      if (lookahead == '{') ADVANCE(11);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 7:
      if (lookahead == '}') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '!' ||
          lookahead == '?') ADVANCE(39);
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 9:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 10:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 11:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(7);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(10);
      END_STATE();
    case 13:
      if (eof) ADVANCE(15);
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '"') ADVANCE(17);
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '(') ADVANCE(34);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '+') ADVANCE(25);
      if (lookahead == '.') ADVANCE(16);
      if (lookahead == ':') ADVANCE(36);
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '?') ADVANCE(26);
      if (lookahead == '@') ADVANCE(30);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 14:
      if (eof) ADVANCE(15);
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '"') ADVANCE(17);
      if (lookahead == '#') ADVANCE(38);
      if (lookahead == '(') ADVANCE(34);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == '*') ADVANCE(24);
      if (lookahead == '+') ADVANCE(25);
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == '?') ADVANCE(26);
      if (lookahead == '@') ADVANCE(30);
      if (lookahead == '[') ADVANCE(32);
      if (lookahead == ']') ADVANCE(33);
      if (lookahead == '_') ADVANCE(29);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == '\n') ADVANCE(20);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(18);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == ';') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(19);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(20);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(21);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(22);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(aux_sym__immediate_identifier_token1);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_predicate_type);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 14},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 14},
  [6] = {.lex_state = 14},
  [7] = {.lex_state = 14},
  [8] = {.lex_state = 14},
  [9] = {.lex_state = 14},
  [10] = {.lex_state = 14},
  [11] = {.lex_state = 14},
  [12] = {.lex_state = 14},
  [13] = {.lex_state = 14},
  [14] = {.lex_state = 14},
  [15] = {.lex_state = 14},
  [16] = {.lex_state = 14},
  [17] = {.lex_state = 14},
  [18] = {.lex_state = 14},
  [19] = {.lex_state = 14},
  [20] = {.lex_state = 14},
  [21] = {.lex_state = 14},
  [22] = {.lex_state = 14},
  [23] = {.lex_state = 14},
  [24] = {.lex_state = 14},
  [25] = {.lex_state = 14},
  [26] = {.lex_state = 14},
  [27] = {.lex_state = 14},
  [28] = {.lex_state = 14},
  [29] = {.lex_state = 14},
  [30] = {.lex_state = 14},
  [31] = {.lex_state = 14},
  [32] = {.lex_state = 14},
  [33] = {.lex_state = 14},
  [34] = {.lex_state = 14},
  [35] = {.lex_state = 14},
  [36] = {.lex_state = 14},
  [37] = {.lex_state = 14},
  [38] = {.lex_state = 14},
  [39] = {.lex_state = 14},
  [40] = {.lex_state = 14},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 14},
  [43] = {.lex_state = 1},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 1},
  [54] = {.lex_state = 14},
  [55] = {.lex_state = 14},
  [56] = {.lex_state = 14},
  [57] = {.lex_state = 14},
  [58] = {.lex_state = 14},
  [59] = {.lex_state = 14},
  [60] = {.lex_state = 14},
  [61] = {.lex_state = 14},
  [62] = {.lex_state = 14},
  [63] = {.lex_state = 14},
  [64] = {.lex_state = 14},
  [65] = {.lex_state = 14},
  [66] = {.lex_state = 14},
  [67] = {.lex_state = 14},
  [68] = {.lex_state = 14},
  [69] = {.lex_state = 14},
  [70] = {.lex_state = 14},
  [71] = {.lex_state = 14},
  [72] = {.lex_state = 14},
  [73] = {.lex_state = 14},
  [74] = {.lex_state = 14},
  [75] = {.lex_state = 14},
  [76] = {.lex_state = 14},
  [77] = {.lex_state = 14},
  [78] = {.lex_state = 14},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 1},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 14},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 14},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 14},
  [118] = {.lex_state = 14},
  [119] = {.lex_state = 14},
  [120] = {.lex_state = 14},
  [121] = {.lex_state = 14},
  [122] = {.lex_state = 14},
  [123] = {.lex_state = 14},
  [124] = {.lex_state = 14},
  [125] = {.lex_state = 14},
  [126] = {.lex_state = 14},
  [127] = {.lex_state = 14},
  [128] = {.lex_state = 14},
  [129] = {.lex_state = 14},
  [130] = {.lex_state = 14},
  [131] = {.lex_state = 14},
  [132] = {.lex_state = 14},
  [133] = {.lex_state = 14},
  [134] = {.lex_state = 14},
  [135] = {.lex_state = 14},
  [136] = {.lex_state = 14},
  [137] = {.lex_state = 14},
  [138] = {.lex_state = 14},
  [139] = {.lex_state = 14},
  [140] = {.lex_state = 14},
  [141] = {.lex_state = 14},
  [142] = {.lex_state = 14},
  [143] = {.lex_state = 14},
  [144] = {.lex_state = 14},
  [145] = {.lex_state = 14},
  [146] = {.lex_state = 14},
  [147] = {.lex_state = 14},
  [148] = {.lex_state = 14},
  [149] = {.lex_state = 14},
  [150] = {.lex_state = 14},
  [151] = {.lex_state = 14},
  [152] = {.lex_state = 14},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 14},
  [155] = {.lex_state = 14},
  [156] = {.lex_state = 14},
  [157] = {.lex_state = 14},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 14},
  [160] = {.lex_state = 14},
  [161] = {.lex_state = 14},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 14},
  [164] = {.lex_state = 14},
  [165] = {.lex_state = 14},
  [166] = {.lex_state = 14},
  [167] = {.lex_state = 14},
  [168] = {.lex_state = 14},
  [169] = {.lex_state = 14},
  [170] = {.lex_state = 14},
  [171] = {.lex_state = 14},
  [172] = {.lex_state = 14},
  [173] = {.lex_state = 14},
  [174] = {.lex_state = 14},
  [175] = {.lex_state = 14},
  [176] = {.lex_state = 14},
  [177] = {.lex_state = 14},
  [178] = {.lex_state = 14},
  [179] = {.lex_state = 14},
  [180] = {.lex_state = 14},
  [181] = {.lex_state = 14},
  [182] = {.lex_state = 14},
  [183] = {.lex_state = 14},
  [184] = {.lex_state = 14},
  [185] = {.lex_state = 14},
  [186] = {.lex_state = 14},
  [187] = {.lex_state = 14},
  [188] = {.lex_state = 14},
  [189] = {.lex_state = 14},
  [190] = {.lex_state = 14},
  [191] = {.lex_state = 14},
  [192] = {.lex_state = 14},
  [193] = {.lex_state = 14},
  [194] = {.lex_state = 14},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 14},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 14},
  [211] = {.lex_state = 14},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 14},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 14},
  [216] = {.lex_state = 14},
  [217] = {.lex_state = 14},
  [218] = {.lex_state = 14},
  [219] = {.lex_state = 14},
  [220] = {.lex_state = 14},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 2},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 2},
  [228] = {.lex_state = 8},
  [229] = {.lex_state = 8},
  [230] = {.lex_state = 8},
  [231] = {.lex_state = 8},
  [232] = {.lex_state = 8},
  [233] = {.lex_state = 8},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 8},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 4},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 8},
  [240] = {.lex_state = 8},
  [241] = {.lex_state = 0},
  [242] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_predicate_type] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(238),
    [sym__definition] = STATE(35),
    [sym__string] = STATE(58),
    [sym_list] = STATE(35),
    [sym_grouping] = STATE(35),
    [sym_anonymous_node] = STATE(35),
    [sym_named_node] = STATE(35),
    [sym__field_name] = STATE(55),
    [sym_field_definition] = STATE(35),
    [sym_predicate] = STATE(35),
    [aux_sym_program_repeat1] = STATE(35),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_DOT,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(13), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(202), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [48] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(31), 1,
      anon_sym_DOT,
    ACTIONS(33), 1,
      anon_sym_RPAREN,
    STATE(9), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(205), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [96] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(35), 1,
      anon_sym_DOT,
    ACTIONS(37), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(200), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [144] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      anon_sym_DQUOTE,
    ACTIONS(42), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym__,
    ACTIONS(48), 1,
      anon_sym_LBRACK,
    ACTIONS(51), 1,
      anon_sym_LPAREN,
    ACTIONS(54), 1,
      anon_sym_RPAREN,
    ACTIONS(56), 1,
      anon_sym_BANG,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(209), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [189] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(196), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [234] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym__,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    ACTIONS(67), 1,
      anon_sym_POUND,
    STATE(3), 1,
      sym__node_identifier,
    STATE(31), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [281] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym__,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    ACTIONS(71), 1,
      anon_sym_POUND,
    STATE(4), 1,
      sym__node_identifier,
    STATE(29), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [328] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(204), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [373] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(203), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [418] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(199), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [463] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(197), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [508] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(5), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(201), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [553] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(63), 1,
      anon_sym__,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    ACTIONS(85), 1,
      anon_sym_POUND,
    STATE(2), 1,
      sym__node_identifier,
    STATE(27), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [600] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(87), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [642] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(89), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [684] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(10), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(204), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [726] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [768] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [810] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [852] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(12), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(201), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [894] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [936] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [978] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [1020] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(11), 1,
      aux_sym_named_node_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(196), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [1062] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [1104] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    STATE(28), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1145] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(104), 1,
      sym_identifier,
    ACTIONS(107), 1,
      anon_sym__,
    ACTIONS(110), 1,
      anon_sym_LBRACK,
    ACTIONS(113), 1,
      anon_sym_LPAREN,
    ACTIONS(116), 1,
      anon_sym_RPAREN,
    STATE(28), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1186] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(118), 1,
      anon_sym_RPAREN,
    STATE(28), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1227] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(195), 9,
      sym__definition,
      sym__named_node_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_negated_field,
      sym_predicate,
  [1266] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(120), 1,
      anon_sym_RPAREN,
    STATE(28), 1,
      aux_sym_grouping_repeat1,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(214), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1307] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(128), 1,
      anon_sym_RBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(36), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1345] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    ACTIONS(132), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(32), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1383] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    ACTIONS(134), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(36), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1421] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym__,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(136), 1,
      ts_builtin_sym_end,
    STATE(55), 1,
      sym__field_name,
    STATE(58), 1,
      sym__string,
    STATE(38), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1459] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(138), 1,
      anon_sym_DQUOTE,
    ACTIONS(141), 1,
      sym_identifier,
    ACTIONS(144), 1,
      anon_sym__,
    ACTIONS(147), 1,
      anon_sym_LBRACK,
    ACTIONS(150), 1,
      anon_sym_RBRACK,
    ACTIONS(152), 1,
      anon_sym_LPAREN,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(36), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1497] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    ACTIONS(155), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(34), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1535] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(141), 1,
      sym_identifier,
    ACTIONS(150), 1,
      ts_builtin_sym_end,
    ACTIONS(157), 1,
      anon_sym_DQUOTE,
    ACTIONS(160), 1,
      anon_sym__,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(166), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym__field_name,
    STATE(58), 1,
      sym__string,
    STATE(38), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1573] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    ACTIONS(169), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(36), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1611] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    ACTIONS(171), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(39), 8,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
      aux_sym_program_repeat1,
  [1649] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(100), 1,
      sym_quantifier,
    STATE(95), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(173), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(175), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1680] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(212), 8,
      sym__definition,
      sym__group_expression,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1715] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(107), 1,
      sym_quantifier,
    STATE(106), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(181), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(183), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1746] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(97), 1,
      sym_quantifier,
    STATE(98), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(185), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(187), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1777] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(114), 1,
      sym_quantifier,
    STATE(115), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(189), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(191), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1808] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(93), 1,
      sym_quantifier,
    STATE(92), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(193), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(195), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1839] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(84), 1,
      sym_quantifier,
    STATE(91), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(197), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(199), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1870] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(86), 1,
      sym_quantifier,
    STATE(85), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(201), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(203), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1901] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(94), 1,
      sym_quantifier,
    STATE(108), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(205), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(207), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1932] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(104), 1,
      sym_quantifier,
    STATE(87), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(209), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(211), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1963] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(113), 1,
      sym_quantifier,
    STATE(112), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(213), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(215), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [1994] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(113), 1,
      sym_quantifier,
    STATE(112), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(217), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(219), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2025] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(102), 1,
      sym_quantifier,
    STATE(96), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(177), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(221), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(223), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2056] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(124), 1,
      anon_sym__,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(130), 1,
      anon_sym_LPAREN,
    STATE(54), 1,
      sym__field_name,
    STATE(75), 1,
      sym__string,
    STATE(217), 7,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2090] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym__,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym__field_name,
    STATE(58), 1,
      sym__string,
    STATE(218), 7,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2124] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(21), 1,
      anon_sym__,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    STATE(43), 1,
      sym__string,
    STATE(56), 1,
      sym__field_name,
    STATE(206), 7,
      sym__definition,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2158] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(181), 1,
      sym_quantifier,
    ACTIONS(189), 2,
      sym_identifier,
      anon_sym__,
    STATE(180), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(191), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2187] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(125), 1,
      sym_quantifier,
    ACTIONS(181), 2,
      sym_identifier,
      anon_sym__,
    STATE(160), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(183), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2216] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(146), 1,
      sym_quantifier,
    ACTIONS(209), 2,
      sym_identifier,
      anon_sym__,
    STATE(147), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(211), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2245] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(141), 1,
      sym_quantifier,
    ACTIONS(205), 2,
      sym_identifier,
      anon_sym__,
    STATE(142), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(207), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2274] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(138), 1,
      sym_quantifier,
    ACTIONS(197), 2,
      sym_identifier,
      anon_sym__,
    STATE(139), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(199), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2303] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(133), 1,
      sym_quantifier,
    ACTIONS(189), 2,
      sym_identifier,
      anon_sym__,
    STATE(134), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(191), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2332] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(128), 1,
      sym_quantifier,
    ACTIONS(185), 2,
      sym_identifier,
      anon_sym__,
    STATE(129), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(187), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2361] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(182), 1,
      sym_quantifier,
    ACTIONS(221), 2,
      sym_identifier,
      anon_sym__,
    STATE(126), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(223), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2390] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(136), 1,
      sym_quantifier,
    ACTIONS(213), 2,
      sym_identifier,
      anon_sym__,
    STATE(150), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(215), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2419] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(137), 1,
      sym_quantifier,
    ACTIONS(201), 2,
      sym_identifier,
      anon_sym__,
    STATE(144), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(203), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2448] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(187), 1,
      sym_quantifier,
    ACTIONS(221), 2,
      sym_identifier,
      anon_sym__,
    STATE(124), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(223), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2477] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(190), 1,
      sym_quantifier,
    ACTIONS(201), 2,
      sym_identifier,
      anon_sym__,
    STATE(189), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(203), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2506] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(179), 1,
      sym_quantifier,
    ACTIONS(173), 2,
      sym_identifier,
      anon_sym__,
    STATE(159), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(175), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2535] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(173), 1,
      sym_quantifier,
    ACTIONS(205), 2,
      sym_identifier,
      anon_sym__,
    STATE(172), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(207), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2564] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(152), 1,
      sym_quantifier,
    ACTIONS(193), 2,
      sym_identifier,
      anon_sym__,
    STATE(151), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(195), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2593] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(176), 1,
      sym_quantifier,
    ACTIONS(197), 2,
      sym_identifier,
      anon_sym__,
    STATE(175), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(199), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2622] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(155), 1,
      sym_quantifier,
    ACTIONS(173), 2,
      sym_identifier,
      anon_sym__,
    STATE(154), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(175), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2651] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(194), 1,
      sym_quantifier,
    ACTIONS(193), 2,
      sym_identifier,
      anon_sym__,
    STATE(193), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(195), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2680] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(163), 1,
      sym_quantifier,
    ACTIONS(181), 2,
      sym_identifier,
      anon_sym__,
    STATE(161), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(183), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2709] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(165), 1,
      sym_quantifier,
    ACTIONS(213), 2,
      sym_identifier,
      anon_sym__,
    STATE(164), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(215), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [2738] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(186), 1,
      sym_quantifier,
    ACTIONS(185), 2,
      sym_identifier,
      anon_sym__,
    STATE(185), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(187), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2767] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    STATE(169), 1,
      sym_quantifier,
    ACTIONS(209), 2,
      sym_identifier,
      anon_sym__,
    STATE(168), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(211), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [2796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(235), 9,
      anon_sym_DQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(239), 9,
      anon_sym_DQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2836] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(241), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(243), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2859] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(245), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(247), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2882] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(249), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(251), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2905] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(110), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(253), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(255), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2928] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(257), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(259), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2951] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(81), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(261), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(263), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2974] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(265), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(267), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2997] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(269), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(271), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3020] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(273), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(275), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3043] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(277), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(279), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3066] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(205), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(207), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3089] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(185), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(187), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3112] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(83), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(283), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3135] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(105), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(287), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3158] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(201), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(203), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3181] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(189), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(191), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3204] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(116), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(289), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(291), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3227] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(293), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(295), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3250] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(239), 9,
      anon_sym_DQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3269] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(89), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(297), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(299), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3292] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(301), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(303), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3315] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(111), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(308), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(310), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3338] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(312), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(314), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3361] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(88), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(316), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(318), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3384] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(320), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(322), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3407] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(324), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(326), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3430] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(90), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(328), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(330), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3453] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(209), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(211), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(235), 9,
      anon_sym_DQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [3495] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(332), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(334), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3518] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(336), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(338), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3541] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(340), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(342), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3564] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(82), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(344), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(346), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3587] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(103), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(348), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(350), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3610] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(197), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(199), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3633] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 1,
      anon_sym_AT,
    STATE(101), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(352), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(354), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3656] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(220), 1,
      sym__string,
    STATE(234), 1,
      sym_parameters,
    ACTIONS(356), 2,
      sym_identifier,
      anon_sym__,
    STATE(119), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [3682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(239), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3700] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(360), 1,
      anon_sym_RPAREN,
    STATE(220), 1,
      sym__string,
    ACTIONS(358), 2,
      sym_identifier,
      anon_sym__,
    STATE(122), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [3726] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(220), 1,
      sym__string,
    STATE(242), 1,
      sym_parameters,
    ACTIONS(356), 2,
      sym_identifier,
      anon_sym__,
    STATE(119), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [3752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(235), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3770] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(362), 1,
      anon_sym_DQUOTE,
    ACTIONS(368), 1,
      anon_sym_AT,
    ACTIONS(371), 1,
      anon_sym_RPAREN,
    STATE(220), 1,
      sym__string,
    ACTIONS(365), 2,
      sym_identifier,
      anon_sym__,
    STATE(122), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [3796] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 1,
      anon_sym_DQUOTE,
    ACTIONS(231), 1,
      anon_sym_AT,
    STATE(220), 1,
      sym__string,
    STATE(241), 1,
      sym_parameters,
    ACTIONS(356), 2,
      sym_identifier,
      anon_sym__,
    STATE(119), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [3822] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(189), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(191), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3843] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(328), 2,
      sym_identifier,
      anon_sym__,
    STATE(192), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(330), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3864] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(189), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(191), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3885] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(277), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(279), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3906] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(289), 2,
      sym_identifier,
      anon_sym__,
    STATE(135), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(291), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3927] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(293), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(295), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3948] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(241), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(243), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3969] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(273), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(275), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3990] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(336), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(338), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4011] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(348), 2,
      sym_identifier,
      anon_sym__,
    STATE(140), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(350), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4032] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(197), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(199), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4053] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(352), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(354), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4074] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(344), 2,
      sym_identifier,
      anon_sym__,
    STATE(166), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(346), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4095] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(261), 2,
      sym_identifier,
      anon_sym__,
    STATE(130), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(263), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4116] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(253), 2,
      sym_identifier,
      anon_sym__,
    STATE(143), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(255), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4137] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(205), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(207), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4158] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(312), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(314), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4179] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(285), 2,
      sym_identifier,
      anon_sym__,
    STATE(145), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(287), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4200] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(209), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(211), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4221] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(332), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(334), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4242] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(257), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(259), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4263] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(320), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(322), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4284] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(316), 2,
      sym_identifier,
      anon_sym__,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(318), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4305] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(265), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(267), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4326] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(269), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(271), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4347] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(249), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(251), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4368] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(340), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(342), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4389] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(185), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(187), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4410] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(281), 2,
      sym_identifier,
      anon_sym__,
    STATE(149), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(283), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(375), 6,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4448] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(201), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(203), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4469] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(297), 2,
      sym_identifier,
      anon_sym__,
    STATE(131), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(299), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4490] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 1,
      anon_sym_AT,
    ACTIONS(301), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(303), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4511] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(245), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(247), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4532] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 1,
      anon_sym_COLON,
    ACTIONS(217), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(219), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4551] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(201), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(203), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4572] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(324), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(326), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4593] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(324), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(326), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4614] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(384), 6,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4631] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(328), 2,
      sym_identifier,
      anon_sym__,
    STATE(127), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(330), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4652] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(340), 2,
      sym_identifier,
      anon_sym__,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(342), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4673] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(344), 2,
      sym_identifier,
      anon_sym__,
    STATE(157), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(346), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4694] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(245), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(247), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4715] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(269), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(271), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4736] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(265), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(267), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4757] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(316), 2,
      sym_identifier,
      anon_sym__,
    STATE(167), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(318), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4778] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(320), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(322), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4799] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(332), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(334), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4820] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(209), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(211), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4841] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(285), 2,
      sym_identifier,
      anon_sym__,
    STATE(170), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(287), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4862] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(312), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(314), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4883] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(205), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(207), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4904] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(253), 2,
      sym_identifier,
      anon_sym__,
    STATE(171), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(255), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4925] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_AT,
    ACTIONS(301), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(303), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4946] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(352), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(354), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4967] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(297), 2,
      sym_identifier,
      anon_sym__,
    STATE(191), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(299), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4988] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(197), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(199), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5009] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(348), 2,
      sym_identifier,
      anon_sym__,
    STATE(174), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(350), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5030] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 1,
      anon_sym_AT,
    ACTIONS(308), 2,
      sym_identifier,
      anon_sym__,
    STATE(132), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(310), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5051] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(336), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(338), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5072] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(241), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(243), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5093] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(293), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(295), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5114] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(289), 2,
      sym_identifier,
      anon_sym__,
    STATE(178), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(291), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5135] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(308), 2,
      sym_identifier,
      anon_sym__,
    STATE(183), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(310), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5156] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(249), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(251), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5177] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(257), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(259), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5198] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(261), 2,
      sym_identifier,
      anon_sym__,
    STATE(184), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(263), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5219] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(273), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(275), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5240] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(277), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(279), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5261] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(185), 2,
      sym_identifier,
      anon_sym__,
    STATE(177), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(187), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5282] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(227), 1,
      anon_sym_AT,
    ACTIONS(281), 2,
      sym_identifier,
      anon_sym__,
    STATE(188), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(283), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(391), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5319] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5337] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(399), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(403), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5371] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5389] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(407), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5407] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5425] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(411), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5443] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5461] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(415), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5479] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5497] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(421), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5513] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(384), 6,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [5529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(425), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5545] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(427), 1,
      anon_sym_DOT,
    ACTIONS(397), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(395), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(375), 5,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5578] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(384), 5,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(431), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [5608] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(375), 5,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 1,
      anon_sym_DOT,
    ACTIONS(437), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(435), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [5640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(425), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5654] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(423), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(425), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5668] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(421), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(421), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5696] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(439), 3,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(443), 3,
      anon_sym_DQUOTE,
      anon_sym_AT,
      anon_sym_RPAREN,
  [5722] = 4,
    ACTIONS(447), 1,
      anon_sym_DQUOTE,
    ACTIONS(451), 1,
      sym_comment,
    STATE(227), 1,
      aux_sym__string_repeat1,
    ACTIONS(449), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5736] = 4,
    ACTIONS(451), 1,
      sym_comment,
    ACTIONS(453), 1,
      anon_sym_DQUOTE,
    STATE(225), 1,
      aux_sym__string_repeat1,
    ACTIONS(455), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5750] = 4,
    ACTIONS(451), 1,
      sym_comment,
    ACTIONS(457), 1,
      anon_sym_DQUOTE,
    STATE(226), 1,
      aux_sym__string_repeat1,
    ACTIONS(459), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5764] = 4,
    ACTIONS(451), 1,
      sym_comment,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    STATE(224), 1,
      aux_sym__string_repeat1,
    ACTIONS(463), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5778] = 4,
    ACTIONS(451), 1,
      sym_comment,
    ACTIONS(466), 1,
      anon_sym_DQUOTE,
    STATE(224), 1,
      aux_sym__string_repeat1,
    ACTIONS(468), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5792] = 4,
    ACTIONS(451), 1,
      sym_comment,
    ACTIONS(470), 1,
      anon_sym_DQUOTE,
    STATE(224), 1,
      aux_sym__string_repeat1,
    ACTIONS(468), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5806] = 4,
    ACTIONS(451), 1,
      sym_comment,
    ACTIONS(472), 1,
      anon_sym_DQUOTE,
    STATE(224), 1,
      aux_sym__string_repeat1,
    ACTIONS(468), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [5820] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 1,
      aux_sym__immediate_identifier_token1,
    STATE(162), 1,
      sym__immediate_identifier,
  [5830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      aux_sym__immediate_identifier_token1,
    STATE(235), 1,
      sym__immediate_identifier,
  [5840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 1,
      aux_sym__immediate_identifier_token1,
    STATE(240), 1,
      sym__immediate_identifier,
  [5850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 1,
      aux_sym__immediate_identifier_token1,
    STATE(211), 1,
      sym__immediate_identifier,
  [5860] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 1,
      aux_sym__immediate_identifier_token1,
    STATE(239), 1,
      sym__immediate_identifier,
  [5870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 1,
      aux_sym__immediate_identifier_token1,
    STATE(207), 1,
      sym__immediate_identifier,
  [5880] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 1,
      anon_sym_RPAREN,
  [5887] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 1,
      sym_predicate_type,
  [5894] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 1,
      anon_sym_COLON,
  [5901] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 1,
      sym_identifier,
  [5908] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 1,
      ts_builtin_sym_end,
  [5915] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 1,
      sym_predicate_type,
  [5922] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 1,
      sym_predicate_type,
  [5929] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 1,
      anon_sym_RPAREN,
  [5936] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 48,
  [SMALL_STATE(4)] = 96,
  [SMALL_STATE(5)] = 144,
  [SMALL_STATE(6)] = 189,
  [SMALL_STATE(7)] = 234,
  [SMALL_STATE(8)] = 281,
  [SMALL_STATE(9)] = 328,
  [SMALL_STATE(10)] = 373,
  [SMALL_STATE(11)] = 418,
  [SMALL_STATE(12)] = 463,
  [SMALL_STATE(13)] = 508,
  [SMALL_STATE(14)] = 553,
  [SMALL_STATE(15)] = 600,
  [SMALL_STATE(16)] = 642,
  [SMALL_STATE(17)] = 684,
  [SMALL_STATE(18)] = 726,
  [SMALL_STATE(19)] = 768,
  [SMALL_STATE(20)] = 810,
  [SMALL_STATE(21)] = 852,
  [SMALL_STATE(22)] = 894,
  [SMALL_STATE(23)] = 936,
  [SMALL_STATE(24)] = 978,
  [SMALL_STATE(25)] = 1020,
  [SMALL_STATE(26)] = 1062,
  [SMALL_STATE(27)] = 1104,
  [SMALL_STATE(28)] = 1145,
  [SMALL_STATE(29)] = 1186,
  [SMALL_STATE(30)] = 1227,
  [SMALL_STATE(31)] = 1266,
  [SMALL_STATE(32)] = 1307,
  [SMALL_STATE(33)] = 1345,
  [SMALL_STATE(34)] = 1383,
  [SMALL_STATE(35)] = 1421,
  [SMALL_STATE(36)] = 1459,
  [SMALL_STATE(37)] = 1497,
  [SMALL_STATE(38)] = 1535,
  [SMALL_STATE(39)] = 1573,
  [SMALL_STATE(40)] = 1611,
  [SMALL_STATE(41)] = 1649,
  [SMALL_STATE(42)] = 1680,
  [SMALL_STATE(43)] = 1715,
  [SMALL_STATE(44)] = 1746,
  [SMALL_STATE(45)] = 1777,
  [SMALL_STATE(46)] = 1808,
  [SMALL_STATE(47)] = 1839,
  [SMALL_STATE(48)] = 1870,
  [SMALL_STATE(49)] = 1901,
  [SMALL_STATE(50)] = 1932,
  [SMALL_STATE(51)] = 1963,
  [SMALL_STATE(52)] = 1994,
  [SMALL_STATE(53)] = 2025,
  [SMALL_STATE(54)] = 2056,
  [SMALL_STATE(55)] = 2090,
  [SMALL_STATE(56)] = 2124,
  [SMALL_STATE(57)] = 2158,
  [SMALL_STATE(58)] = 2187,
  [SMALL_STATE(59)] = 2216,
  [SMALL_STATE(60)] = 2245,
  [SMALL_STATE(61)] = 2274,
  [SMALL_STATE(62)] = 2303,
  [SMALL_STATE(63)] = 2332,
  [SMALL_STATE(64)] = 2361,
  [SMALL_STATE(65)] = 2390,
  [SMALL_STATE(66)] = 2419,
  [SMALL_STATE(67)] = 2448,
  [SMALL_STATE(68)] = 2477,
  [SMALL_STATE(69)] = 2506,
  [SMALL_STATE(70)] = 2535,
  [SMALL_STATE(71)] = 2564,
  [SMALL_STATE(72)] = 2593,
  [SMALL_STATE(73)] = 2622,
  [SMALL_STATE(74)] = 2651,
  [SMALL_STATE(75)] = 2680,
  [SMALL_STATE(76)] = 2709,
  [SMALL_STATE(77)] = 2738,
  [SMALL_STATE(78)] = 2767,
  [SMALL_STATE(79)] = 2796,
  [SMALL_STATE(80)] = 2816,
  [SMALL_STATE(81)] = 2836,
  [SMALL_STATE(82)] = 2859,
  [SMALL_STATE(83)] = 2882,
  [SMALL_STATE(84)] = 2905,
  [SMALL_STATE(85)] = 2928,
  [SMALL_STATE(86)] = 2951,
  [SMALL_STATE(87)] = 2974,
  [SMALL_STATE(88)] = 2997,
  [SMALL_STATE(89)] = 3020,
  [SMALL_STATE(90)] = 3043,
  [SMALL_STATE(91)] = 3066,
  [SMALL_STATE(92)] = 3089,
  [SMALL_STATE(93)] = 3112,
  [SMALL_STATE(94)] = 3135,
  [SMALL_STATE(95)] = 3158,
  [SMALL_STATE(96)] = 3181,
  [SMALL_STATE(97)] = 3204,
  [SMALL_STATE(98)] = 3227,
  [SMALL_STATE(99)] = 3250,
  [SMALL_STATE(100)] = 3269,
  [SMALL_STATE(101)] = 3292,
  [SMALL_STATE(102)] = 3315,
  [SMALL_STATE(103)] = 3338,
  [SMALL_STATE(104)] = 3361,
  [SMALL_STATE(105)] = 3384,
  [SMALL_STATE(106)] = 3407,
  [SMALL_STATE(107)] = 3430,
  [SMALL_STATE(108)] = 3453,
  [SMALL_STATE(109)] = 3476,
  [SMALL_STATE(110)] = 3495,
  [SMALL_STATE(111)] = 3518,
  [SMALL_STATE(112)] = 3541,
  [SMALL_STATE(113)] = 3564,
  [SMALL_STATE(114)] = 3587,
  [SMALL_STATE(115)] = 3610,
  [SMALL_STATE(116)] = 3633,
  [SMALL_STATE(117)] = 3656,
  [SMALL_STATE(118)] = 3682,
  [SMALL_STATE(119)] = 3700,
  [SMALL_STATE(120)] = 3726,
  [SMALL_STATE(121)] = 3752,
  [SMALL_STATE(122)] = 3770,
  [SMALL_STATE(123)] = 3796,
  [SMALL_STATE(124)] = 3822,
  [SMALL_STATE(125)] = 3843,
  [SMALL_STATE(126)] = 3864,
  [SMALL_STATE(127)] = 3885,
  [SMALL_STATE(128)] = 3906,
  [SMALL_STATE(129)] = 3927,
  [SMALL_STATE(130)] = 3948,
  [SMALL_STATE(131)] = 3969,
  [SMALL_STATE(132)] = 3990,
  [SMALL_STATE(133)] = 4011,
  [SMALL_STATE(134)] = 4032,
  [SMALL_STATE(135)] = 4053,
  [SMALL_STATE(136)] = 4074,
  [SMALL_STATE(137)] = 4095,
  [SMALL_STATE(138)] = 4116,
  [SMALL_STATE(139)] = 4137,
  [SMALL_STATE(140)] = 4158,
  [SMALL_STATE(141)] = 4179,
  [SMALL_STATE(142)] = 4200,
  [SMALL_STATE(143)] = 4221,
  [SMALL_STATE(144)] = 4242,
  [SMALL_STATE(145)] = 4263,
  [SMALL_STATE(146)] = 4284,
  [SMALL_STATE(147)] = 4305,
  [SMALL_STATE(148)] = 4326,
  [SMALL_STATE(149)] = 4347,
  [SMALL_STATE(150)] = 4368,
  [SMALL_STATE(151)] = 4389,
  [SMALL_STATE(152)] = 4410,
  [SMALL_STATE(153)] = 4431,
  [SMALL_STATE(154)] = 4448,
  [SMALL_STATE(155)] = 4469,
  [SMALL_STATE(156)] = 4490,
  [SMALL_STATE(157)] = 4511,
  [SMALL_STATE(158)] = 4532,
  [SMALL_STATE(159)] = 4551,
  [SMALL_STATE(160)] = 4572,
  [SMALL_STATE(161)] = 4593,
  [SMALL_STATE(162)] = 4614,
  [SMALL_STATE(163)] = 4631,
  [SMALL_STATE(164)] = 4652,
  [SMALL_STATE(165)] = 4673,
  [SMALL_STATE(166)] = 4694,
  [SMALL_STATE(167)] = 4715,
  [SMALL_STATE(168)] = 4736,
  [SMALL_STATE(169)] = 4757,
  [SMALL_STATE(170)] = 4778,
  [SMALL_STATE(171)] = 4799,
  [SMALL_STATE(172)] = 4820,
  [SMALL_STATE(173)] = 4841,
  [SMALL_STATE(174)] = 4862,
  [SMALL_STATE(175)] = 4883,
  [SMALL_STATE(176)] = 4904,
  [SMALL_STATE(177)] = 4925,
  [SMALL_STATE(178)] = 4946,
  [SMALL_STATE(179)] = 4967,
  [SMALL_STATE(180)] = 4988,
  [SMALL_STATE(181)] = 5009,
  [SMALL_STATE(182)] = 5030,
  [SMALL_STATE(183)] = 5051,
  [SMALL_STATE(184)] = 5072,
  [SMALL_STATE(185)] = 5093,
  [SMALL_STATE(186)] = 5114,
  [SMALL_STATE(187)] = 5135,
  [SMALL_STATE(188)] = 5156,
  [SMALL_STATE(189)] = 5177,
  [SMALL_STATE(190)] = 5198,
  [SMALL_STATE(191)] = 5219,
  [SMALL_STATE(192)] = 5240,
  [SMALL_STATE(193)] = 5261,
  [SMALL_STATE(194)] = 5282,
  [SMALL_STATE(195)] = 5303,
  [SMALL_STATE(196)] = 5319,
  [SMALL_STATE(197)] = 5337,
  [SMALL_STATE(198)] = 5355,
  [SMALL_STATE(199)] = 5371,
  [SMALL_STATE(200)] = 5389,
  [SMALL_STATE(201)] = 5407,
  [SMALL_STATE(202)] = 5425,
  [SMALL_STATE(203)] = 5443,
  [SMALL_STATE(204)] = 5461,
  [SMALL_STATE(205)] = 5479,
  [SMALL_STATE(206)] = 5497,
  [SMALL_STATE(207)] = 5513,
  [SMALL_STATE(208)] = 5529,
  [SMALL_STATE(209)] = 5545,
  [SMALL_STATE(210)] = 5563,
  [SMALL_STATE(211)] = 5578,
  [SMALL_STATE(212)] = 5593,
  [SMALL_STATE(213)] = 5608,
  [SMALL_STATE(214)] = 5623,
  [SMALL_STATE(215)] = 5640,
  [SMALL_STATE(216)] = 5654,
  [SMALL_STATE(217)] = 5668,
  [SMALL_STATE(218)] = 5682,
  [SMALL_STATE(219)] = 5696,
  [SMALL_STATE(220)] = 5709,
  [SMALL_STATE(221)] = 5722,
  [SMALL_STATE(222)] = 5736,
  [SMALL_STATE(223)] = 5750,
  [SMALL_STATE(224)] = 5764,
  [SMALL_STATE(225)] = 5778,
  [SMALL_STATE(226)] = 5792,
  [SMALL_STATE(227)] = 5806,
  [SMALL_STATE(228)] = 5820,
  [SMALL_STATE(229)] = 5830,
  [SMALL_STATE(230)] = 5840,
  [SMALL_STATE(231)] = 5850,
  [SMALL_STATE(232)] = 5860,
  [SMALL_STATE(233)] = 5870,
  [SMALL_STATE(234)] = 5880,
  [SMALL_STATE(235)] = 5887,
  [SMALL_STATE(236)] = 5894,
  [SMALL_STATE(237)] = 5901,
  [SMALL_STATE(238)] = 5908,
  [SMALL_STATE(239)] = 5915,
  [SMALL_STATE(240)] = 5922,
  [SMALL_STATE(241)] = 5929,
  [SMALL_STATE(242)] = 5936,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [39] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(222),
  [42] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(236),
  [45] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(51),
  [48] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(33),
  [51] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(14),
  [54] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2),
  [56] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(237),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [101] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2), SHIFT_REPEAT(222),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_grouping_repeat1, 2), SHIFT_REPEAT(236),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_grouping_repeat1, 2), SHIFT_REPEAT(51),
  [110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2), SHIFT_REPEAT(33),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2), SHIFT_REPEAT(14),
  [116] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2),
  [118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [124] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1),
  [138] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(221),
  [141] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(236),
  [144] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(76),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(40),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(7),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [157] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(223),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(65),
  [163] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(37),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2), SHIFT_REPEAT(8),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [173] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [181] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 1, .production_id = 2),
  [183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 1, .production_id = 2),
  [185] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 3),
  [187] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 3),
  [189] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 4, .production_id = 5),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 4, .production_id = 5),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 2),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 2),
  [197] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, .production_id = 5),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, .production_id = 5),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [203] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [205] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, .production_id = 5),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, .production_id = 5),
  [209] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, .production_id = 5),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, .production_id = 5),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 1, .production_id = 1),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 1, .production_id = 1),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node_identifier, 1),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node_identifier, 1),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 3, .production_id = 5),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 3, .production_id = 5),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string, 3),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string, 3),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string, 2),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string, 2),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5, .production_id = 7),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5, .production_id = 7),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 3, .production_id = 3),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 3, .production_id = 3),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 4, .production_id = 6),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 4, .production_id = 6),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, .production_id = 11),
  [255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, .production_id = 11),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, .production_id = 7),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, .production_id = 7),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, .production_id = 5),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, .production_id = 5),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 9, .production_id = 13),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 9, .production_id = 13),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, .production_id = 6),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, .production_id = 6),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 3, .production_id = 4),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 3, .production_id = 4),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 3, .production_id = 6),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 3, .production_id = 6),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, .production_id = 12),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, .production_id = 12),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 4, .production_id = 7),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 4, .production_id = 7),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 4),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 4),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, .production_id = 6),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, .production_id = 6),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_repeat1, 2),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2),
  [305] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(228),
  [308] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 4, .production_id = 8),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 4, .production_id = 8),
  [312] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, .production_id = 9),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, .production_id = 9),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, .production_id = 13),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, .production_id = 13),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, .production_id = 12),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, .production_id = 12),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 2, .production_id = 2),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 2, .production_id = 2),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 2, .production_id = 4),
  [330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 2, .production_id = 4),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, .production_id = 11),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, .production_id = 11),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, .production_id = 8),
  [338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, .production_id = 8),
  [340] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 2, .production_id = 1),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 2, .production_id = 1),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 2, .production_id = 3),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 2, .production_id = 3),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, .production_id = 9),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, .production_id = 9),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 5, .production_id = 7),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 5, .production_id = 7),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 1),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2), SHIFT_REPEAT(221),
  [365] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2), SHIFT_REPEAT(122),
  [368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2), SHIFT_REPEAT(233),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quantifier, 1),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantifier, 1),
  [377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(233),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture, 2, .production_id = 5),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture, 2, .production_id = 5),
  [386] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(231),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_node_expression, 3),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_node_expression, 3),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 1),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 1),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(18),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_field, 2),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_field, 2),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_definition, 2, .production_id = 1),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_definition, 2, .production_id = 1),
  [423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 6, .production_id = 10),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 6, .production_id = 10),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__group_expression, 3),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__group_expression, 3),
  [433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 1),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_grouping_repeat1, 1),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_name, 2),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__field_name, 2),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [451] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [453] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [457] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_repeat1, 2),
  [463] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__string_repeat1, 2), SHIFT_REPEAT(224),
  [466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [470] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [472] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [492] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_query(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
