C    Copyright(C) 1999-2020 National Technology & Engineering Solutions
C    of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
C    NTESS, the U.S. Government retains certain rights in this software.
C
C    See packages/seacas/LICENSE for details

      SUBROUTINE BMSCHM (NPER, KKK, LLL, NNN, ML, MS, NSPR, ISLIST,
     &   NINT, IFLINE, NLPS, ILLIST, LINKL, LINKS, MXNPER, MAXPRM, MAX3,
     &   MXND, X, Y, NID, NNPS, ANGLE, XN, YN, NUID, LXK, KXL, NXL, LXN,
     &   XSUB, YSUB, NIDSUB, INDX, IAVAIL, NAVAIL, CCW, HALFC, ERR)
C***********************************************************************

C  BMSCHM - "B" MESH SCHEME; CALCULATE A "TRANSITION" MAPPED MESH
C      (2 TRIANGULAR SUBREGIONS WITH 3 RECTANGULAR SUBREGIONS/TRIANGLE)

C***********************************************************************

      DIMENSION ISLIST(NSPR), NINT(ML), IFLINE(MS), NLPS(MS)
      DIMENSION ILLIST(MS*3), LINKL(2, ML), LINKS(2, MS)
      DIMENSION X(MXNPER), Y(MXNPER), NID(MXNPER*MAXPRM), NNPS(MAX3)
      DIMENSION ANGLE(MXNPER), XN(MXND), YN(MXND), NUID(MXND)
      DIMENSION LXK(4, MXND), KXL(2, 3*MXND), NXL(2, 3*MXND)
      DIMENSION LXN(4, MXND)
      DIMENSION XSUB(MXNPER), YSUB(MXNPER), NIDSUB(MXNPER), INDX(MXND)

      LOGICAL CCW, ERR, FINAL, HALFC

C  SET UP THE TRIANGLE DIVISIONS, AND FIND THE CENTER POINT

      CALL GETTRN (ML, MS, MAX3, NSPR, ISLIST, NINT, IFLINE, NLPS,
     &   ILLIST, LINKL, LINKS, X, Y, NID, NNPS, ANGLE, NPER, I1, I2,
     &   I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2, XMID1,
     &   YMID1, XMID2, YMID2, CCW, HALFC, ERR)
      FINAL = .FALSE.

C  SET UP THE FIRST SUBREGION, AND SEND IT OFF TO BE GENERATED

      IF (.NOT.ERR) THEN
         CALL SUBTRN (NPER, NEWPER, 1, X, Y, NID, XSUB, YSUB, NIDSUB,
     &      I1, I2, I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2,
     &      XMID1, YMID1, XMID2, YMID2, CCW, ERR)
         NNNOLD = NNN
         KKKOLD = KKK
         LLLOLD = LLL
         M1 = I2 - I1
         M2 = NPER - I8 + 1
         CALL RMESH (NEWPER, MXND, XSUB, YSUB, NIDSUB, XN, YN, NUID,
     &      LXK, KXL, NXL, LXN, M1, M2, KKK, KKKOLD, NNN, NNNOLD, LLL,
     &      LLLOLD, IAVAIL, NAVAIL, ERR)
      END IF

C  SET UP THE SECOND SUBREGION, AND SEND IT OFF TO BE GENERATED

      IF (.NOT.ERR) THEN
         CALL SUBTRN (NPER, NEWPER, 2, X, Y, NID, XSUB, YSUB, NIDSUB,
     &      I1, I2, I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2,
     &      XMID1, YMID1, XMID2, YMID2, CCW, ERR)
         NNNOLD = NNN
         KKKOLD = KKK
         LLLOLD = LLL
         M1 = I8 - I7
         M2 = I2 - I1
         CALL RMESH (NEWPER, MXND, XSUB, YSUB, NIDSUB, XN, YN, NUID,
     &      LXK, KXL, NXL, LXN, M1, M2, KKK, KKKOLD, NNN, NNNOLD, LLL,
     &      LLLOLD, IAVAIL, NAVAIL, ERR)
         CALL FIXSUB (MXND, NNNOLD, NNN, LLLOLD, LLL, KKKOLD, KKK, XN,
     &      YN, NUID, LXK, KXL, NXL, LXN, INDX, IAVAIL, NAVAIL, FINAL)
      END IF

C  SET UP THE THIRD SUBREGION, AND SEND IT OFF TO BE GENERATED

      IF (.NOT.ERR) THEN
         CALL SUBTRN (NPER, NEWPER, 3, X, Y, NID, XSUB, YSUB, NIDSUB,
     &      I1, I2, I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2,
     &      XMID1, YMID1, XMID2, YMID2, CCW, ERR)
         NNNOLD = NNN
         KKKOLD = KKK
         LLLOLD = LLL
         M1 = NPER - I8 + 1
         M2 = I3 - I2
         CALL RMESH (NEWPER, MXND, XSUB, YSUB, NIDSUB, XN, YN, NUID,
     &      LXK, KXL, NXL, LXN, M1, M2, KKK, KKKOLD, NNN, NNNOLD, LLL,
     &      LLLOLD, IAVAIL, NAVAIL, ERR)
         CALL FIXSUB (MXND, NNNOLD, NNN, LLLOLD, LLL, KKKOLD, KKK, XN,
     &      YN, NUID, LXK, KXL, NXL, LXN, INDX, IAVAIL, NAVAIL, FINAL)
      END IF

C  SET UP THE FOURTH SUBREGION, AND SEND IT OFF TO BE GENERATED

      IF (.NOT.ERR) THEN
         CALL SUBTRN (NPER, NEWPER, 4, X, Y, NID, XSUB, YSUB, NIDSUB,
     &      I1, I2, I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2,
     &      XMID1, YMID1, XMID2, YMID2, CCW, ERR)
         NNNOLD = NNN
         KKKOLD = KKK
         LLLOLD = LLL
         M1 = I5 - I4
         M2 = I6 - I5
         CALL RMESH (NEWPER, MXND, XSUB, YSUB, NIDSUB, XN, YN, NUID,
     &      LXK, KXL, NXL, LXN, M1, M2, KKK, KKKOLD, NNN, NNNOLD, LLL,
     &      LLLOLD, IAVAIL, NAVAIL, ERR)
         CALL FIXSUB (MXND, NNNOLD, NNN, LLLOLD, LLL, KKKOLD, KKK, XN,
     &      YN, NUID, LXK, KXL, NXL, LXN, INDX, IAVAIL, NAVAIL, FINAL)
      END IF

C  SET UP THE FIFTH SUBREGION, AND SEND IT OFF TO BE GENERATED

      IF (.NOT.ERR) THEN
         CALL SUBTRN (NPER, NEWPER, 5, X, Y, NID, XSUB, YSUB, NIDSUB,
     &      I1, I2, I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2,
     &      XMID1, YMID1, XMID2, YMID2, CCW, ERR)
         NNNOLD = NNN
         KKKOLD = KKK
         LLLOLD = LLL
         M1 = I7 - I6
         M2 = I5 - I4
         CALL RMESH (NEWPER, MXND, XSUB, YSUB, NIDSUB, XN, YN, NUID,
     &      LXK, KXL, NXL, LXN, M1, M2, KKK, KKKOLD, NNN, NNNOLD, LLL,
     &      LLLOLD, IAVAIL, NAVAIL, ERR)
         CALL FIXSUB (MXND, NNNOLD, NNN, LLLOLD, LLL, KKKOLD, KKK, XN,
     &      YN, NUID, LXK, KXL, NXL, LXN, INDX, IAVAIL, NAVAIL, FINAL)
      END IF

C  SET UP THE SIXTH SUBREGION, AND SEND IT OFF TO BE GENERATED

      IF (.NOT.ERR) THEN
         CALL SUBTRN (NPER, NEWPER, 6, X, Y, NID, XSUB, YSUB, NIDSUB,
     &      I1, I2, I3, I4, I5, I6, I7, I8, XCEN1, YCEN1, XCEN2, YCEN2,
     &      XMID1, YMID1, XMID2, YMID2, CCW, ERR)
         NNNOLD = NNN
         KKKOLD = KKK
         LLLOLD = LLL
         M1 = I6 - I5
         M2 = I4 - I3
         CALL RMESH (NEWPER, MXND, XSUB, YSUB, NIDSUB, XN, YN, NUID,
     &      LXK, KXL, NXL, LXN, M1, M2, KKK, KKKOLD, NNN, NNNOLD, LLL,
     &      LLLOLD, IAVAIL, NAVAIL, ERR)
         FINAL = .TRUE.
         CALL FIXSUB (MXND, NNNOLD, NNN, LLLOLD, LLL, KKKOLD, KKK, XN,
     &      YN, NUID, LXK, KXL, NXL, LXN, INDX, IAVAIL, NAVAIL, FINAL)
      END IF

      RETURN
      END
