
/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>
    and authors of web browser Links 0.96

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.
*/


/*#define SYST_UNIX    1
#define SYST_OS2     2
#define SYST_WIN32   3
#define SYST_BEOS    4*/

/* hardcoded limit of 10 OSes in default.c */

#if defined(__EMX__)
#define OS2
#elif defined(_WIN32)
#ifndef WIN32
#define WIN32
#endif
#elif defined(__BEOS__)
#define BEOS
#else
#define UNIX
#endif

#ifdef __EMX__
#define strcasecmp stricmp
#define strncasecmp strnicmp
#define read _read
#define write _write
#endif

#if defined(UNIX)

static inline int dir_sep(char x) { return x == '/'; }
#define NEWLINE "\n"
#include <pwd.h>
#include <grp.h>
#define SYSTEM_ID SYS_UNIX
#define SYSTEM_NAME "Unix"
#define DEFAULT_SHELL "/bin/sh"
#define GETSHELL getenv("SHELL")

#elif defined(OS2)

static inline int dir_sep(char x) { return x == '/' || x == '\\'; }
#define NEWLINE "\r\n"
#define SYSTEM_ID SYS_OS2
#define SYSTEM_NAME "OS/2"
#define DEFAULT_SHELL "cmd.exe"
#define GETSHELL getenv("COMSPEC")
#define NO_FG_EXEC
#define NO_FILE_SECURITY
#define NO_FORK_ON_EXIT

#elif defined(WIN32)

static inline int dir_sep(char x) { return x == '/' || x == '\\'; }
#define NEWLINE "\r\n"
#define SYSTEM_ID SYS_WIN32
#define SYSTEM_NAME "Win32"
#define DEFAULT_SHELL "command.com"
#define GETSHELL getenv("COMSPEC")
#define NO_FG_EXEC
#define NO_FORK_ON_EXIT

#endif

/*#if !defined(HAVE_BEGINTHREAD) && !defined(BEOS) && !defined(HAVE_PTHREADS) && !defined(HAVE_CLONE)
#define THREAD_SAFE_LOOKUP
#endif*/


#ifndef HAVE_F_TLOCK
# define F_ULOCK 0  /* Unlock a previously locked region.  */
# define F_LOCK  1  /* Lock a region for exclusive use.  */
# define F_TLOCK 2  /* Test and lock a region for exclusive use.  */
# define F_TEST  3  /* Test a region for other processes locks.  */
#endif

#ifndef HAVE_LOCKF
int lockf(int,int,off_t);
#endif

#ifdef UNIX
#define tmkdir(dir, mode) mkdir(dir, mode)
#define sock_errno errno
#define sock_strerror_r strerror_r
#define SO4
#define closesocket close
static inline char *wokna(char *file) { return file; }
#endif

int mkdir_p(const char *s, mode_t mode);
int save_screen(void);
int restore_screen(void);

gchar * get_mp(gchar *device);
int floppy_is_mounted(gchar *floppydev, gchar *path_to_floppy);
int is_in_mtab(gchar *mp);


extern int sound_pid;
int init_sound(void);
int free_sound(void);
int abort_sound(void);
int sound(int freq);
double fdf(int fd);

