/* mx-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Mx", gir_namespace = "Mx", gir_version = "1.0", lower_case_cprefix = "mx_")]
namespace Mx {
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_action_get_type ()")]
	public class Action : GLib.InitiallyUnowned, GLib.Action {
		[CCode (has_construct_function = false)]
		public Action ();
		[CCode (has_construct_function = false)]
		public Action.full (string name, string display_name, [CCode (scope = "async")] owned Mx.ActionCallbackFunc? activated_cb);
		public bool get_active ();
		public unowned string get_display_name ();
		public unowned string get_icon ();
		public void set_active (bool active);
		public void set_display_name (string name);
		public void set_icon (string name);
		public void set_name (string name);
		[CCode (has_construct_function = false)]
		public Action.stateful (string name, GLib.VariantType? parameter_type, GLib.Variant state);
		[CCode (has_construct_function = false)]
		public Action.with_parameter (string name, GLib.VariantType? parameter_type);
		[Deprecated (since = "1.4")]
		public bool active { get; set; }
		public string display_name { get; set; }
		public string icon { get; set; }
		public signal void activate (GLib.Variant? parameter);
		[Deprecated (since = "1.4")]
		public virtual signal void activated ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_actor_manager_get_type ()")]
	public class ActorManager : GLib.Object {
		[CCode (has_construct_function = false)]
		public ActorManager (Clutter.Stage stage);
		public ulong add_actor (Clutter.Container container, Clutter.Actor actor);
		public void cancel_operation (ulong id);
		public void cancel_operations (Clutter.Actor actor);
		public static unowned Mx.ActorManager get_for_stage (Clutter.Stage stage);
		public uint get_n_operations ();
		public unowned Clutter.Stage get_stage ();
		public uint get_time_slice ();
		public ulong remove_actor (Clutter.Container container, Clutter.Actor actor);
		public void remove_container (Clutter.Container container);
		public void set_time_slice (uint msecs);
		public uint n_operations { get; }
		public Clutter.Stage stage { get; construct; }
		public uint time_slice { get; set; }
		public virtual signal void actor_added (ulong id, Clutter.Actor container, Clutter.Actor actor);
		public virtual signal void actor_created (ulong id, Clutter.Actor actor);
		public virtual signal void actor_finished (Clutter.Actor actor);
		public virtual signal void actor_removed (ulong id, Clutter.Actor container, Clutter.Actor actor);
		public virtual signal void operation_cancelled (ulong id);
		public virtual signal void operation_completed (ulong id);
		public virtual signal void operation_failed (ulong id, GLib.Error error);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_adjustment_get_type ()")]
	public class Adjustment : GLib.Object {
		[CCode (has_construct_function = false)]
		public Adjustment ();
		public bool get_clamp_value ();
		public bool get_elastic ();
		public double get_lower ();
		public double get_page_increment ();
		public double get_page_size ();
		public double get_step_increment ();
		public double get_upper ();
		public double get_value ();
		public void get_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public void interpolate (double value, uint duration, ulong mode);
		public void interpolate_relative (double offset, uint duration, ulong mode);
		public void set_clamp_value (bool clamp);
		public void set_elastic (bool elastic);
		public void set_lower (double lower);
		public void set_page_increment (double increment);
		public void set_page_size (double page_size);
		public void set_step_increment (double increment);
		public void set_upper (double upper);
		public void set_value (double value);
		public void set_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		[CCode (has_construct_function = false)]
		public Adjustment.with_values (double value, double lower, double upper, double step_increment, double page_increment, double page_size);
		public bool clamp_value { get; set; }
		public bool elastic { get; set; }
		public double lower { get; set construct; }
		public double page_increment { get; set construct; }
		public double page_size { get; set construct; }
		public double step_increment { get; set construct; }
		public double upper { get; set construct; }
		public double value { get; set construct; }
		public virtual signal void changed ();
		public virtual signal void interpolation_completed ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_application_get_type ()")]
	public class Application : GLib.Object {
		[CCode (has_construct_function = false)]
		public Application ([CCode (array_length_cname = "argc", array_length_pos = 0.5)] ref unowned string[]? argv, string name, Mx.ApplicationFlags flags);
		public void add_action (Mx.Action action);
		public void add_window (owned Mx.Window window);
		public virtual unowned Mx.Window create_window ();
		public GLib.List<weak Mx.Action> get_actions ();
		public Mx.ApplicationFlags get_flags ();
		public unowned GLib.List<Mx.Window> get_windows ();
		public void invoke_action (string name);
		public void invoke_action_with_parameter (string name, GLib.Variant variant);
		public bool is_running ();
		public void quit ();
		[NoWrapper]
		public virtual void raise ();
		public void remove_action (string name);
		public void remove_window (Mx.Window window);
		public void run ();
		[NoAccessorMethod]
		public string application_name { owned get; construct; }
		public uint flags { get; construct; }
		public virtual signal void actions_changed ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_bin_get_type ()")]
	public abstract class Bin : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected Bin ();
		public void allocate_child (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public void get_alignment (out Mx.Align x_align, out Mx.Align y_align);
		public unowned Clutter.Actor get_child ();
		public void get_fill (out bool x_fill, out bool y_fill);
		public void set_alignment (Mx.Align x_align, Mx.Align y_align);
		public void set_child (Clutter.Actor child);
		public void set_fill (bool x_fill, bool y_fill);
		public Clutter.Actor child { get; set; }
		[NoAccessorMethod]
		public Mx.Align x_align { get; set; }
		[NoAccessorMethod]
		public bool x_fill { get; set; }
		[NoAccessorMethod]
		public Mx.Align y_align { get; set; }
		[NoAccessorMethod]
		public bool y_fill { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "mx_border_image_get_type ()")]
	[Compact]
	public class BorderImage {
		public int bottom;
		public int left;
		public int right;
		public int top;
		public weak string uri;
		public static void set_from_string (GLib.Value value, string str, string filename);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_box_layout_get_type ()")]
	public class BoxLayout : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Scrollable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public BoxLayout ();
		public void add_actor_with_properties (Clutter.Actor actor, int position, ...);
		[CCode (cname = "mx_box_layout_add_actor")]
		public void add_child (Clutter.Actor actor, int position);
		public bool child_get_expand (Clutter.Actor child);
		public Mx.Align child_get_x_align (Clutter.Actor child);
		public bool child_get_x_fill (Clutter.Actor child);
		public Mx.Align child_get_y_align (Clutter.Actor child);
		public bool child_get_y_fill (Clutter.Actor child);
		public void child_set_expand (Clutter.Actor child, bool expand);
		public void child_set_x_align (Clutter.Actor child, Mx.Align x_align);
		public void child_set_x_fill (Clutter.Actor child, bool x_fill);
		public void child_set_y_align (Clutter.Actor child, Mx.Align y_align);
		public void child_set_y_fill (Clutter.Actor child, bool y_fill);
		public bool get_enable_animations ();
		public Mx.Orientation get_orientation ();
		public bool get_scroll_to_focused ();
		public uint get_spacing ();
		public void set_enable_animations (bool enable_animations);
		public void set_orientation (Mx.Orientation orientation);
		public void set_scroll_to_focused (bool scroll_to_focused);
		public void set_spacing (uint spacing);
		public bool enable_animations { get; set; }
		public Mx.Orientation orientation { get; set; }
		public bool scroll_to_focused { get; set; }
		public uint spacing { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_box_layout_child_get_type ()")]
	public class BoxLayoutChild : Clutter.ChildMeta {
		[CCode (has_construct_function = false)]
		protected BoxLayoutChild ();
		[Deprecated (replacement = "BoxLayout.child_get_expand", since = "vala-0.14")]
		public static bool get_expand (Mx.BoxLayout box_layout, Clutter.Actor child);
		[Deprecated (replacement = "BoxLayout.child_get_x_align", since = "vala-0.14")]
		public static Mx.Align get_x_align (Mx.BoxLayout box_layout, Clutter.Actor child);
		[Deprecated (replacement = "BoxLayout.child_get_x_fill", since = "vala-0.14")]
		public static bool get_x_fill (Mx.BoxLayout box_layout, Clutter.Actor child);
		[Deprecated (replacement = "BoxLayout.child_get_y_align", since = "vala-0.14")]
		public static Mx.Align get_y_align (Mx.BoxLayout box_layout, Clutter.Actor child);
		[Deprecated (replacement = "BoxLayout.child_get_y_fill", since = "vala-0.14")]
		public static bool get_y_fill (Mx.BoxLayout box_layout, Clutter.Actor child);
		[Deprecated (replacement = "BoxLayout.child_set_expand", since = "vala-0.14")]
		public static void set_expand (Mx.BoxLayout box_layout, Clutter.Actor child, bool expand);
		[Deprecated (replacement = "BoxLayout.child_set_x_align", since = "vala-0.14")]
		public static void set_x_align (Mx.BoxLayout box_layout, Clutter.Actor child, Mx.Align x_align);
		[Deprecated (replacement = "BoxLayout.child_set_x_fill", since = "vala-0.14")]
		public static void set_x_fill (Mx.BoxLayout box_layout, Clutter.Actor child, bool x_fill);
		[Deprecated (replacement = "BoxLayout.child_set_y_align", since = "vala-0.14")]
		public static void set_y_align (Mx.BoxLayout box_layout, Clutter.Actor child, Mx.Align y_align);
		[Deprecated (replacement = "BoxLayout.child_set_y_fill", since = "vala-0.14")]
		public static void set_y_fill (Mx.BoxLayout box_layout, Clutter.Actor child, bool y_fill);
		[NoAccessorMethod]
		public bool expand { get; set; }
		[NoAccessorMethod]
		public Mx.Align x_align { get; set; }
		[NoAccessorMethod]
		public bool x_fill { get; set; }
		[NoAccessorMethod]
		public Mx.Align y_align { get; set; }
		[NoAccessorMethod]
		public bool y_fill { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_button_get_type ()")]
	public class Button : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Button ();
		public unowned Mx.Action get_action ();
		public unowned string get_icon_name ();
		public Mx.Position get_icon_position ();
		public uint get_icon_size ();
		public bool get_icon_visible ();
		public bool get_is_toggle ();
		public unowned string get_label ();
		public bool get_label_visible ();
		public bool get_toggled ();
		public void set_action (Mx.Action action);
		public void set_icon_name (string? icon_name);
		public void set_icon_position (Mx.Position position);
		public void set_icon_size (uint icon_size);
		public void set_icon_visible (bool visible);
		public void set_is_toggle (bool toggle);
		public void set_label (string text);
		public void set_label_visible (bool visible);
		public void set_toggled (bool toggled);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Button.with_label (string text);
		public Mx.Action action { get; set; }
		public string icon_name { get; set; }
		public Mx.Position icon_position { get; set; }
		public uint icon_size { get; set; }
		public bool icon_visible { get; set; }
		public bool is_toggle { get; set; }
		public string label { get; set; }
		public bool label_visible { get; set; }
		public bool toggled { get; set; }
		public virtual signal void clicked ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_button_group_get_type ()")]
	public class ButtonGroup : GLib.InitiallyUnowned {
		[CCode (has_construct_function = false)]
		public ButtonGroup ();
		public void add (Mx.Button button);
		public void @foreach (Clutter.Callback callback);
		public unowned Mx.Button get_active_button ();
		public bool get_allow_no_active ();
		public unowned GLib.SList<Mx.Button> get_buttons ();
		public void remove (Mx.Button button);
		public void set_active_button (Mx.Button? button);
		public void set_allow_no_active (bool allow_no_active);
		public Mx.Button active_button { get; set; }
		public bool allow_no_active { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_clipboard_get_type ()")]
	public class Clipboard : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Clipboard ();
		public static unowned Mx.Clipboard get_default ();
		public void get_text ([CCode (scope = "async")] owned Mx.ClipboardCallbackFunc callback);
		public void set_text (string text);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_combo_box_get_type ()")]
	public class ComboBox : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ComboBox ();
		public void append_text (string text);
		public unowned string get_active_icon_name ();
		public unowned string get_active_text ();
		public int get_index ();
		public void insert_text (int position, string text);
		public void insert_text_with_icon (int position, string text, string icon);
		public void prepend_text (string text);
		public void remove_all ();
		public void remove_text (int position);
		public void set_active_icon_name (string? icon_name);
		public void set_active_text (string text);
		public void set_index (int index);
		public string active_icon_name { get; set; }
		public string active_text { get; set; }
		public int index { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_deform_bow_tie_get_type ()")]
	public class DeformBowTie : Mx.DeformTexture, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public DeformBowTie ();
		public bool get_flip_back ();
		public double get_period ();
		public void set_flip_back (bool flip_back);
		public void set_period (double period);
		public bool flip_back { get; set; }
		public double period { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_deform_page_turn_get_type ()")]
	public class DeformPageTurn : Mx.DeformTexture, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public DeformPageTurn ();
		public double get_angle ();
		public double get_period ();
		public double get_radius ();
		public void set_angle (double angle);
		public void set_period (double period);
		public void set_radius (double radius);
		public double angle { get; set; }
		public double period { get; set; }
		public double radius { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_deform_texture_get_type ()")]
	public abstract class DeformTexture : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected DeformTexture ();
		[NoWrapper]
		public virtual void deform (Cogl.TextureVertex vertex, float width, float height);
		public void get_resolution (out int tiles_x, out int tiles_y);
		public void get_textures (out unowned Clutter.Texture front, out unowned Clutter.Texture back);
		public void invalidate ();
		public void set_resolution (int tiles_x, int tiles_y);
		public void set_textures (Clutter.Texture? front, Clutter.Texture? back);
		[NoAccessorMethod]
		public Clutter.Texture back { owned get; set; }
		[NoAccessorMethod]
		public Clutter.Texture front { owned get; set; }
		[NoAccessorMethod]
		public int tiles_x { get; set; }
		[NoAccessorMethod]
		public int tiles_y { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_deform_waves_get_type ()")]
	public class DeformWaves : Mx.DeformTexture, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public DeformWaves ();
		public double get_amplitude ();
		public double get_angle ();
		public double get_period ();
		public double get_radius ();
		public void set_amplitude (double amplitude);
		public void set_angle (double angle);
		public void set_period (double period);
		public void set_radius (double radius);
		public double amplitude { get; set; }
		public double angle { get; set; }
		public double period { get; set; }
		public double radius { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_dialog_get_type ()")]
	public class Dialog : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Dialog ();
		public void add_action (Mx.Action action);
		public GLib.List<weak Mx.Action> get_actions ();
		public void remove_action (Mx.Action action);
		public void set_transient_parent (Clutter.Actor actor);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_entry_get_type ()")]
	public class Entry : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Entry ();
		public unowned Clutter.Actor get_clutter_text ();
		public unowned string get_hint_text ();
		public unowned string get_icon_highlight_suffix ();
		public unichar get_password_char ();
		public unowned string get_text ();
		public void set_hint_text (string text);
		public void set_icon_highlight_suffix (string suffix);
		public void set_password_char (unichar password_char);
		public void set_primary_icon_from_file (string filename);
		public void set_primary_icon_tooltip_text (string text);
		public void set_secondary_icon_from_file (string filename);
		public void set_secondary_icon_tooltip_text (string text);
		public void set_text (string text);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Entry.with_text (string text);
		public Clutter.Text clutter_text { get; }
		public string hint_text { get; set; }
		public string icon_highlight_suffix { get; set; }
		public uint password_char { get; set; }
		[NoAccessorMethod]
		public string primary_icon_tooltip_text { owned get; set; }
		[NoAccessorMethod]
		public string secondary_icon_tooltip_text { owned get; set; }
		public string text { get; set; }
		public virtual signal void primary_icon_clicked ();
		public virtual signal void secondary_icon_clicked ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_expander_get_type ()")]
	public class Expander : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Expander ();
		public bool get_expanded ();
		public void set_expanded (bool expanded);
		public void set_label (string label);
		public bool expanded { get; set; }
		[NoAccessorMethod]
		public string label { owned get; set; }
		public virtual signal void expand_complete ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_fade_effect_get_type ()")]
	public class FadeEffect : Clutter.OffscreenEffect {
		[CCode (has_construct_function = false, type = "ClutterEffect*")]
		public FadeEffect ();
		public void get_border (out uint top, out uint right, out uint bottom, out uint left);
		public void get_bounds (out int x, out int y, out uint width, out uint height);
		public Clutter.Color get_color ();
		public void set_border (uint top, uint right, uint bottom, uint left);
		public void set_bounds (int x, int y, uint width, uint height);
		public void set_color (Clutter.Color color);
		[NoAccessorMethod]
		public uint border_bottom { get; set; }
		[NoAccessorMethod]
		public uint border_left { get; set; }
		[NoAccessorMethod]
		public uint border_right { get; set; }
		[NoAccessorMethod]
		public uint border_top { get; set; }
		[NoAccessorMethod]
		public uint bounds_height { get; set; }
		[NoAccessorMethod]
		public uint bounds_width { get; set; }
		[NoAccessorMethod]
		public int bounds_x { get; set; }
		[NoAccessorMethod]
		public int bounds_y { get; set; }
		public Clutter.Color color { get; set; }
		[NoAccessorMethod]
		public bool freeze_update { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_floating_widget_get_type ()")]
	public abstract class FloatingWidget : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected FloatingWidget ();
		[NoWrapper]
		public virtual void floating_paint (Clutter.Actor actor);
		[NoWrapper]
		public virtual void floating_pick (Clutter.Actor actor, Clutter.Color color);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_focus_manager_get_type ()")]
	public class FocusManager : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FocusManager ();
		public unowned Mx.Focusable get_focused ();
		public static unowned Mx.FocusManager get_for_stage (Clutter.Stage stage);
		public unowned Clutter.Stage get_stage ();
		public void move_focus (Mx.FocusDirection direction);
		public void push_focus (Mx.Focusable focusable);
		public void push_focus_with_hint (Mx.Focusable focusable, Mx.FocusHint hint);
		public Clutter.Actor focused { get; }
		public Clutter.Stage stage { get; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_frame_get_type ()")]
	public class Frame : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Frame ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_grid_get_type ()")]
	public class Grid : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Scrollable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Grid ();
		public Mx.Align get_child_x_align ();
		public Mx.Align get_child_y_align ();
		public float get_column_spacing ();
		public bool get_homogenous_columns ();
		public bool get_homogenous_rows ();
		public bool get_line_alignment ();
		public int get_max_stride ();
		public Mx.Orientation get_orientation ();
		public float get_row_spacing ();
		public void set_child_x_align (Mx.Align value);
		public void set_child_y_align (Mx.Align value);
		public void set_column_spacing (float value);
		public void set_homogenous_columns (bool value);
		public void set_homogenous_rows (bool value);
		public void set_line_alignment (Mx.Align value);
		public void set_max_stride (int value);
		public void set_orientation (Mx.Orientation orientation);
		public void set_row_spacing (float value);
		public Mx.Align child_x_align { get; set construct; }
		public Mx.Align child_y_align { get; set construct; }
		public float column_spacing { get; set construct; }
		public bool homogenous_columns { get; set construct; }
		public bool homogenous_rows { get; set construct; }
		public Mx.Align line_alignment { get; set construct; }
		public int max_stride { get; set construct; }
		public Mx.Orientation orientation { get; set construct; }
		public float row_spacing { get; set construct; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_icon_get_type ()")]
	public class Icon : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Icon ();
		public unowned string get_icon_name ();
		public int get_icon_size ();
		public void set_icon_name (string icon_name);
		public void set_icon_size (int size);
		public string icon_name { get; set; }
		public int icon_size { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_icon_theme_get_type ()")]
	public class IconTheme : GLib.Object {
		[CCode (has_construct_function = false)]
		public IconTheme ();
		public static unowned Mx.IconTheme get_default ();
		public unowned GLib.List<string> get_search_paths ();
		public unowned string get_theme_name ();
		public bool has_icon (string icon_name);
		public unowned Cogl.Handle lookup (string icon_name, int size);
		public unowned Clutter.Texture lookup_texture (string icon_name, int size);
		public void set_search_paths (GLib.List<string> paths);
		public void set_theme_name (string theme_name);
		public string theme_name { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_image_get_type ()")]
	public class Image : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Image ();
		public void animate_scale_mode (ulong mode, uint duration, Mx.ImageScaleMode scale_mode);
		public void clear ();
		public bool get_allow_upscale ();
		public float get_image_rotation ();
		public bool get_load_async ();
		public uint get_scale_height_threshold ();
		public Mx.ImageScaleMode get_scale_mode ();
		public uint get_scale_width_threshold ();
		public uint get_transition_duration ();
		public void set_allow_upscale (bool allow);
		public bool set_from_buffer ([CCode (array_length_cname = "buffer_size", array_length_pos = 1.5, array_length_type = "gsize")] owned uint8[]? buffer, GLib.DestroyNotify? buffer_free_func) throws GLib.Error;
		public bool set_from_buffer_at_size ([CCode (array_length_cname = "buffer_size", array_length_pos = 1.5, array_length_type = "gsize")] owned uint8[]? buffer, GLib.DestroyNotify? buffer_free_func, int width, int height) throws GLib.Error;
		public bool set_from_cogl_texture (Cogl.Handle texture);
		public bool set_from_data ([CCode (array_length = false)] uint8[]? data, Cogl.PixelFormat pixel_format, int width, int height, int rowstride) throws GLib.Error;
		public bool set_from_file (string filename) throws GLib.Error;
		public bool set_from_file_at_size (string filename, int width, int height) throws GLib.Error;
		public void set_image_rotation (float rotation);
		public void set_load_async (bool load_async);
		public void set_scale_height_threshold (uint pixels);
		public void set_scale_mode (Mx.ImageScaleMode mode);
		public void set_scale_width_threshold (uint pixels);
		public void set_transition_duration (uint duration);
		public bool allow_upscale { get; set; }
		public float image_rotation { get; set; }
		public bool load_async { get; set; }
		public uint scale_height_threshold { get; set; }
		public Mx.ImageScaleMode scale_mode { get; set; }
		public uint scale_width_threshold { get; set; }
		public uint transition_duration { get; set; }
		public virtual signal void image_load_error (GLib.Error error);
		public virtual signal void image_loaded ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_item_view_get_type ()")]
	public class ItemView : Mx.Grid, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Scrollable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ItemView ();
		public void add_attribute (string attribute, int column);
		public void freeze ();
		public unowned Mx.ItemFactory get_factory ();
		public GLib.Type get_item_type ();
		public unowned Clutter.Model get_model ();
		public void set_factory (Mx.ItemFactory? factory);
		public void set_item_type (GLib.Type item_type);
		public void set_model (Clutter.Model model);
		public void thaw ();
		public GLib.Object factory { get; set; }
		public GLib.Type item_type { get; set; }
		public Clutter.Model model { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_kinetic_scroll_view_get_type ()")]
	public class KineticScrollView : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Scrollable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public KineticScrollView ();
		public double get_acceleration_factor ();
		public uint get_clamp_duration ();
		public ulong get_clamp_mode ();
		public bool get_clamp_to_center ();
		public double get_deceleration ();
		public uint32 get_mouse_button ();
		public double get_overshoot ();
		public Mx.ScrollPolicy get_scroll_policy ();
		public bool get_use_captured ();
		public void set_acceleration_factor (double acceleration_factor);
		public void set_clamp_duration (uint clamp_duration);
		public void set_clamp_mode (ulong clamp_mode);
		public void set_clamp_to_center (bool clamp_to_center);
		public void set_deceleration (double rate);
		public void set_mouse_button (uint32 button);
		public void set_overshoot (double overshoot);
		public void set_scroll_policy (Mx.ScrollPolicy policy);
		public void set_use_captured (bool use_captured);
		public void stop ();
		public double acceleration_factor { get; set; }
		public uint clamp_duration { get; set; }
		public ulong clamp_mode { get; set; }
		public bool clamp_to_center { get; set; }
		public double deceleration { get; set; }
		public uint mouse_button { get; set; }
		public double overshoot { get; set; }
		public Mx.ScrollPolicy scroll_policy { get; set; }
		[NoAccessorMethod]
		public Mx.KineticScrollViewState state { get; }
		public bool use_captured { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_label_get_type ()")]
	public class Label : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Label ();
		public unowned Clutter.Actor get_clutter_text ();
		public bool get_fade_out ();
		public bool get_line_wrap ();
		public bool get_show_tooltip ();
		public unowned string get_text ();
		public bool get_use_markup ();
		public Mx.Align get_x_align ();
		public Mx.Align get_y_align ();
		public void set_fade_out (bool fade);
		public void set_line_wrap (bool line_wrap);
		public void set_show_tooltip (bool show_tooltip);
		public void set_text (string text);
		public void set_use_markup (bool use_markup);
		public void set_x_align (Mx.Align align);
		public void set_y_align (Mx.Align align);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Label.with_text (string text);
		public Clutter.Text clutter_text { get; }
		public bool fade_out { get; set; }
		public bool line_wrap { get; set; }
		public bool show_tooltip { get; set; }
		public string text { get; set; }
		public bool use_markup { get; set; }
		public Mx.Align x_align { get; set; }
		public Mx.Align y_align { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_list_view_get_type ()")]
	public class ListView : Mx.BoxLayout, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Scrollable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ListView ();
		public void add_attribute (string attribute, int column);
		public void freeze ();
		public unowned Mx.ItemFactory get_factory ();
		public GLib.Type get_item_type ();
		public unowned Clutter.Model get_model ();
		public void set_factory (Mx.ItemFactory? factory);
		public void set_item_type (GLib.Type item_type);
		public void set_model (Clutter.Model model);
		public void thaw ();
		public GLib.Object factory { get; set; }
		public GLib.Type item_type { get; set; }
		public Clutter.Model model { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_menu_get_type ()")]
	public class Menu : Mx.FloatingWidget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Menu ();
		public void add_action (Mx.Action action);
		public void remove_action (Mx.Action action);
		public void remove_all ();
		public void show_with_position (float x, float y);
		public virtual signal void action_activated (Mx.Action action);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_notebook_get_type ()")]
	public class Notebook : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Notebook ();
		public unowned Clutter.Actor get_current_page ();
		public bool get_enable_gestures ();
		public void set_current_page (Clutter.Actor page);
		public void set_enable_gestures (bool enabled);
		public Clutter.Actor current_page { get; set; }
		public bool enable_gestures { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_offscreen_get_type ()")]
	public class Offscreen : Clutter.Texture, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Offscreen ();
		public bool get_accumulation_enabled ();
		public unowned Cogl.Handle get_accumulation_material ();
		public bool get_auto_update ();
		public unowned Cogl.Handle get_buffer ();
		public unowned Clutter.Actor get_child ();
		public bool get_pick_child ();
		public bool get_redirect_enabled ();
		[NoWrapper]
		public virtual void paint_child ();
		public void set_accumulation_enabled (bool enable);
		public void set_auto_update (bool auto_update);
		public void set_child (Clutter.Actor actor);
		public void set_pick_child (bool pick);
		public void set_redirect_enabled (bool enabled);
		public void update ();
		public bool accumulation_enabled { get; set; }
		public void* accumulation_material { get; }
		public bool auto_update { get; set; }
		public Cogl.Handle buffer { get; }
		public Clutter.Actor child { get; set; }
		public bool pick_child { get; set; }
		public bool redirect_enabled { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_path_bar_get_type ()")]
	public class PathBar : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public PathBar ();
		public void clear ();
		public bool get_clear_on_change ();
		public bool get_editable ();
		public unowned Mx.Entry get_entry ();
		public unowned string get_label (int level);
		public int get_level ();
		public unowned string get_text ();
		public int pop ();
		public int push (string name);
		public void set_clear_on_change (bool clear_on_change);
		public void set_editable (bool editable);
		public void set_label (int level, string label);
		public void set_text (string text);
		public bool clear_on_change { get; set; }
		public bool editable { get; set; }
		public Mx.Entry entry { get; }
		public int level { get; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_progress_bar_get_type ()")]
	public class ProgressBar : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ProgressBar ();
		public double get_progress ();
		public void set_progress (double progress);
		public double progress { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_scroll_bar_get_type ()")]
	public class ScrollBar : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ScrollBar ();
		public unowned Mx.Adjustment get_adjustment ();
		public Mx.Orientation get_orientation ();
		public void set_adjustment (Mx.Adjustment adjustment);
		public void set_orientation (Mx.Orientation orientation);
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ScrollBar.with_adjustment (Mx.Adjustment adjustment);
		public Mx.Adjustment adjustment { get; set; }
		public Mx.Orientation orientation { get; set; }
		public virtual signal void scroll_start ();
		public virtual signal void scroll_stop ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_scroll_view_get_type ()")]
	public class ScrollView : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public ScrollView ();
		public void ensure_visible (Clutter.Geometry geometry);
		public bool get_enable_gestures ();
		public bool get_enable_mouse_scrolling ();
		public Mx.ScrollPolicy get_scroll_policy ();
		public void set_enable_gestures (bool enabled);
		public void set_enable_mouse_scrolling (bool enabled);
		public void set_scroll_policy (Mx.ScrollPolicy policy);
		public bool enable_gestures { get; set; }
		public bool enable_mouse_scrolling { get; set; }
		public Mx.ScrollPolicy scroll_policy { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_settings_get_type ()")]
	public class Settings : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Settings ();
		public static unowned Mx.Settings get_default ();
		[NoAccessorMethod]
		public uint drag_threshold { get; set; }
		[NoAccessorMethod]
		public string font_name { owned get; set; }
		[NoAccessorMethod]
		public string icon_theme { owned get; set; }
		[NoAccessorMethod]
		public uint long_press_timeout { get; set; }
		[NoAccessorMethod]
		public bool small_screen { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h")]
	[Compact]
	public class SettingsProvider {
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_slider_get_type ()")]
	public class Slider : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Slider ();
		public double get_buffer_value ();
		public double get_value ();
		public void set_buffer_value (double value);
		public void set_value (double value);
		public double buffer_value { get; set; }
		public double value { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_spinner_get_type ()")]
	public class Spinner : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Spinner ();
		public bool get_animating ();
		public void set_animating (bool animating);
		public bool animating { get; set; }
		public virtual signal void looped ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_stack_get_type ()")]
	public class Stack : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Stack ();
		public bool child_get_crop (Clutter.Actor child);
		public bool child_get_fit (Clutter.Actor child);
		public Mx.Align child_get_x_align (Clutter.Actor child);
		public bool child_get_x_fill (Clutter.Actor child);
		public Mx.Align child_get_y_align (Clutter.Actor child);
		public bool child_get_y_fill (Clutter.Actor child);
		public void child_set_crop (Clutter.Actor child, bool crop);
		public void child_set_fit (Clutter.Actor child, bool fit);
		public void child_set_x_align (Clutter.Actor child, Mx.Align x_align);
		public void child_set_x_fill (Clutter.Actor child, bool x_fill);
		public void child_set_y_align (Clutter.Actor child, Mx.Align y_align);
		public void child_set_y_fill (Clutter.Actor child, bool y_fill);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_stack_child_get_type ()")]
	public class StackChild : Clutter.ChildMeta {
		[CCode (has_construct_function = false)]
		protected StackChild ();
		[NoAccessorMethod]
		public bool crop { get; set; }
		[NoAccessorMethod]
		public bool fit { get; set; }
		[NoAccessorMethod]
		public Mx.Align x_align { get; set; }
		[NoAccessorMethod]
		public bool x_fill { get; set; }
		[NoAccessorMethod]
		public Mx.Align y_align { get; set; }
		[NoAccessorMethod]
		public bool y_fill { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_style_get_type ()")]
	public class Style : GLib.Object {
		[CCode (has_construct_function = false)]
		public Style ();
		public void @get (Mx.Stylable stylable, ...);
		public static unowned Mx.Style get_default ();
		public GLib.Value get_property (Mx.Stylable stylable, GLib.ParamSpec pspec);
		public void get_valist (Mx.Stylable stylable, string first_property_name, va_list va_args);
		public bool load_from_file (string filename) throws GLib.Error;
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_table_get_type ()")]
	public class Table : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Table ();
		public void add_actor_with_properties (Clutter.Actor actor, int row, int column, ...);
		[CCode (cname = "mx_table_add_actor")]
		public void add_child (Clutter.Actor actor, int row, int column);
		public int child_get_column (Clutter.Actor child);
		public int child_get_column_span (Clutter.Actor child);
		public int child_get_row (Clutter.Actor child);
		public int child_get_row_span (Clutter.Actor child);
		public Mx.Align child_get_x_align (Clutter.Actor child);
		public bool child_get_x_expand (Clutter.Actor child);
		public bool child_get_x_fill (Clutter.Actor child);
		public Mx.Align child_get_y_align (Clutter.Actor child);
		public bool child_get_y_expand (Clutter.Actor child);
		public bool child_get_y_fill (Clutter.Actor child);
		public void child_set_column (Clutter.Actor child, int col);
		public void child_set_column_span (Clutter.Actor child, int span);
		public void child_set_row (Clutter.Actor child, int row);
		public void child_set_row_span (Clutter.Actor child, int span);
		public void child_set_x_align (Clutter.Actor child, Mx.Align align);
		public void child_set_x_expand (Clutter.Actor child, bool expand);
		public void child_set_x_fill (Clutter.Actor child, bool fill);
		public void child_set_y_align (Clutter.Actor child, Mx.Align align);
		public void child_set_y_expand (Clutter.Actor child, bool expand);
		public void child_set_y_fill (Clutter.Actor child, bool fill);
		public int get_column_count ();
		public int get_column_spacing ();
		public int get_row_count ();
		public int get_row_spacing ();
		public void set_column_spacing (int spacing);
		public void set_row_spacing (int spacing);
		public int column_count { get; }
		public int column_spacing { get; set; }
		public int row_count { get; }
		public int row_spacing { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_table_child_get_type ()")]
	public class TableChild : Clutter.ChildMeta {
		[CCode (has_construct_function = false)]
		protected TableChild ();
		[Deprecated (replacement = "Table.child_get_column", since = "vala-0.14")]
		public static int get_column (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_column_span", since = "vala-0.14")]
		public static int get_column_span (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_row", since = "vala-0.14")]
		public static int get_row (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_row_span", since = "vala-0.14")]
		public static int get_row_span (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_x_align", since = "vala-0.14")]
		public static Mx.Align get_x_align (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_x_expand", since = "vala-0.14")]
		public static bool get_x_expand (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_x_fill", since = "vala-0.14")]
		public static bool get_x_fill (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_y_align", since = "vala-0.14")]
		public static Mx.Align get_y_align (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_y_expand", since = "vala-0.14")]
		public static bool get_y_expand (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_get_y_fill", since = "vala-0.14")]
		public static bool get_y_fill (Mx.Table table, Clutter.Actor child);
		[Deprecated (replacement = "Table.child_set_column", since = "vala-0.14")]
		public static void set_column (Mx.Table table, Clutter.Actor child, int col);
		[Deprecated (replacement = "Table.child_set_column_span", since = "vala-0.14")]
		public static void set_column_span (Mx.Table table, Clutter.Actor child, int span);
		[Deprecated (replacement = "Table.child_set_row", since = "vala-0.14")]
		public static void set_row (Mx.Table table, Clutter.Actor child, int row);
		[Deprecated (replacement = "Table.child_set_row_span", since = "vala-0.14")]
		public static void set_row_span (Mx.Table table, Clutter.Actor child, int span);
		[Deprecated (replacement = "Table.child_set_x_align", since = "vala-0.14")]
		public static void set_x_align (Mx.Table table, Clutter.Actor child, Mx.Align align);
		[Deprecated (replacement = "Table.child_set_x_expand", since = "vala-0.14")]
		public static void set_x_expand (Mx.Table table, Clutter.Actor child, bool expand);
		[Deprecated (replacement = "Table.child_set_x_fill", since = "vala-0.14")]
		public static void set_x_fill (Mx.Table table, Clutter.Actor child, bool fill);
		[Deprecated (replacement = "Table.child_set_y_align", since = "vala-0.14")]
		public static void set_y_align (Mx.Table table, Clutter.Actor child, Mx.Align align);
		[Deprecated (replacement = "Table.child_set_y_expand", since = "vala-0.14")]
		public static void set_y_expand (Mx.Table table, Clutter.Actor child, bool expand);
		[Deprecated (replacement = "Table.child_set_y_fill", since = "vala-0.14")]
		public static void set_y_fill (Mx.Table table, Clutter.Actor child, bool fill);
		[NoAccessorMethod]
		public int column { get; set; }
		[NoAccessorMethod]
		public int column_span { get; set; }
		[NoAccessorMethod]
		public int row { get; set; }
		[NoAccessorMethod]
		public int row_span { get; set; }
		[NoAccessorMethod]
		public Mx.Align x_align { get; set; }
		[NoAccessorMethod]
		public bool x_expand { get; set; }
		[NoAccessorMethod]
		public bool x_fill { get; set; }
		[NoAccessorMethod]
		public Mx.Align y_align { get; set; }
		[NoAccessorMethod]
		public bool y_expand { get; set; }
		[NoAccessorMethod]
		public bool y_fill { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_texture_cache_get_type ()")]
	public class TextureCache : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TextureCache ();
		public bool contains (string uri);
		public bool contains_meta (string uri, void* ident);
		[NoWrapper]
		public virtual void error_loading (GLib.Error error);
		public unowned Clutter.Actor get_actor (string uri);
		public unowned Cogl.Handle get_cogl_texture (string uri);
		public static unowned Mx.TextureCache get_default ();
		public Cogl.Handle get_meta_cogl_texture (string uri, void* ident);
		public Clutter.Texture get_meta_texture (string uri, void* ident);
		public int get_size ();
		public unowned Clutter.Texture get_texture (string uri);
		public void insert (string uri, Cogl.Handle texture);
		public void insert_meta (string uri, void* ident, Cogl.Handle texture, GLib.DestroyNotify destroy_func);
		public void load_cache (string filename);
		[NoWrapper]
		public virtual void loaded (string uri, Clutter.Texture texture);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_texture_frame_get_type ()")]
	public class TextureFrame : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public TextureFrame (Clutter.Texture texture, float top, float right, float bottom, float left);
		public void get_border_values (float top, float right, float bottom, float left);
		public unowned Clutter.Texture get_parent_texture ();
		public void set_border_values (float top, float right, float bottom, float left);
		public void set_parent_texture (Clutter.Texture texture);
		[NoAccessorMethod]
		public float bottom { get; set construct; }
		[NoAccessorMethod]
		public float left { get; set construct; }
		public Clutter.Texture parent_texture { get; set construct; }
		[NoAccessorMethod]
		public float right { get; set construct; }
		[NoAccessorMethod]
		public float top { get; set construct; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_toggle_get_type ()")]
	public class Toggle : Mx.Widget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Toggle ();
		public bool get_active ();
		public void set_active (bool active);
		public bool active { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_toolbar_get_type ()")]
	public class Toolbar : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Toolbar ();
		public bool get_has_close_button ();
		public void set_has_close_button (bool has_close_button);
		public bool has_close_button { get; set; }
		public virtual signal bool close_button_clicked ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_tooltip_get_type ()")]
	public class Tooltip : Mx.FloatingWidget, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected Tooltip ();
		public unowned string get_text ();
		public unowned Clutter.Geometry? get_tip_area ();
		public void hide ();
		public static bool is_in_browse_mode ();
		public void set_text (string text);
		public void set_tip_area (Clutter.Geometry area);
		public void set_tip_area_from_actor (Clutter.Actor actor);
		public void show ();
		public string text { get; set; }
		public Clutter.Geometry tip_area { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_viewport_get_type ()")]
	public class Viewport : Mx.Bin, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Focusable, Mx.Scrollable, Mx.Stylable {
		[CCode (has_construct_function = false, type = "ClutterActor*")]
		public Viewport ();
		public void get_origin (float x, float y, float z);
		public bool get_sync_adjustments ();
		public void set_origin (float x, float y, float z);
		public void set_sync_adjustments (bool sync);
		public bool sync_adjustments { get; set; }
		[NoAccessorMethod]
		public float x_origin { get; set; }
		[NoAccessorMethod]
		public float y_origin { get; set; }
		[NoAccessorMethod]
		public float z_origin { get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_widget_get_type ()")]
	public abstract class Widget : Clutter.Actor, Atk.Implementor, Clutter.Animatable, Clutter.Container, Clutter.Scriptable, Mx.Stylable {
		[CCode (has_construct_function = false)]
		protected Widget ();
		public virtual void apply_style (Mx.Style style);
		public void get_available_area (Clutter.ActorBox allocation, Clutter.ActorBox area);
		public unowned Clutter.Actor get_background_image ();
		public unowned Clutter.Actor get_border_image ();
		public bool get_disabled ();
		public unowned Mx.Menu get_menu ();
		public Mx.Padding get_padding ();
		public uint get_tooltip_delay ();
		public unowned string get_tooltip_text ();
		public void hide_tooltip ();
		public void long_press_cancel ();
		public void long_press_query (Clutter.ButtonEvent event);
		[NoWrapper]
		public virtual void paint_background (Clutter.Actor background, Clutter.Color color);
		[CCode (cname = "mx_widget_paint_background")]
		public void paint_background_with_defaults ();
		public void set_disabled (bool disabled);
		public void set_menu (Mx.Menu menu);
		public void set_tooltip_delay (uint delay);
		public void set_tooltip_text (string text);
		public void show_tooltip ();
		public bool disabled { get; set; }
		public Mx.Menu menu { get; set; }
		public int tooltip_delay { get; set construct; }
		public string tooltip_text { get; set; }
		public virtual signal bool long_press (float action, float x, Mx.LongPressAction y);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_window_get_type ()")]
	public class Window : GLib.Object {
		[CCode (has_construct_function = false)]
		public Window ();
		public unowned Clutter.Actor get_child ();
		public unowned Clutter.Stage get_clutter_stage ();
		public static unowned Mx.Window get_for_stage (Clutter.Stage stage);
		public bool get_fullscreen ();
		public bool get_has_toolbar ();
		public unowned string get_icon_name ();
		public bool get_small_screen ();
		public unowned string get_title ();
		public unowned Mx.Toolbar get_toolbar ();
		public void get_window_position (out int x, out int y);
		public Mx.WindowRotation get_window_rotation ();
		public void get_window_size (out int width, out int height);
		public void hide ();
		public void present ();
		public void set_child (Clutter.Actor actor);
		public void set_fullscreen (bool fullscreen);
		public void set_has_toolbar (bool toolbar);
		public void set_icon_from_cogl_texture (Cogl.Handle texture);
		public void set_icon_name (string? icon_name);
		public void set_small_screen (bool small_screen);
		public void set_title (string title);
		public void set_toolbar (Mx.Toolbar toolbar);
		public void set_window_position (int x, int y);
		public void set_window_rotation (Mx.WindowRotation rotation);
		public void set_window_size (int width, int height);
		public void show ();
		[CCode (has_construct_function = false)]
		public Window.with_clutter_stage (Clutter.Stage stage);
		public Clutter.Actor child { get; set; }
		public Clutter.Stage clutter_stage { get; construct; }
		public bool fullscreen { get; set; }
		public bool has_toolbar { get; set; }
		[NoAccessorMethod]
		public string icon_cogl_texture { owned get; set; }
		public string icon_name { get; set; }
		public bool small_screen { get; set; }
		public string title { get; set; }
		public Mx.Toolbar toolbar { get; set; }
		public Mx.WindowRotation window_rotation { get; set; }
		[NoAccessorMethod]
		public float window_rotation_angle { get; }
		[NoAccessorMethod]
		public Clutter.Timeline window_rotation_timeline { owned get; }
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_draggable_get_type ()")]
	public interface Draggable : Clutter.Actor {
		public virtual void disable ();
		public virtual void enable ();
		public Mx.DragAxis get_axis ();
		public unowned Clutter.Actor get_drag_actor ();
		public uint get_drag_threshold ();
		public bool is_enabled ();
		public void set_axis (Mx.DragAxis axis);
		public void set_drag_actor (Clutter.Actor actor);
		public void set_drag_threshold (uint threshold);
		[ConcreteAccessor]
		public abstract Mx.DragAxis axis { get; set; }
		[ConcreteAccessor]
		public abstract Clutter.Actor drag_actor { get; set; }
		[NoAccessorMethod]
		public abstract bool drag_enabled { get; set; }
		[ConcreteAccessor]
		public abstract uint drag_threshold { get; set; }
		public virtual signal void drag_begin (float event_x, float event_y, int event_button, Clutter.ModifierType modifiers);
		public virtual signal void drag_end (float event_x, float event_y);
		public virtual signal void drag_motion (float delta_x, float delta_y);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_droppable_get_type ()")]
	public interface Droppable : Clutter.Actor {
		public virtual bool accept_drop (Mx.Draggable draggable);
		public virtual void disable ();
		public virtual void enable ();
		public bool is_enabled ();
		[NoAccessorMethod]
		public abstract bool drop_enabled { get; set; }
		public virtual signal void drop (Clutter.Actor draggable, float event_x, float event_y, int button, Clutter.ModifierType modifiers);
		public virtual signal void over_in (Clutter.Actor draggable);
		public virtual signal void over_out (Clutter.Actor draggable);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_focusable_get_type ()")]
	public interface Focusable : GLib.Object {
		public abstract unowned Mx.Focusable accept_focus (Mx.FocusHint hint);
		public abstract unowned Mx.Focusable move_focus (Mx.FocusDirection direction, Mx.Focusable from);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_item_factory_get_type ()")]
	public interface ItemFactory : GLib.Object {
		public abstract Clutter.Actor create ();
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_scrollable_get_type ()")]
	public interface Scrollable : GLib.Object {
		public abstract void get_adjustments (out unowned Mx.Adjustment? hadjustment, out unowned Mx.Adjustment? vadjustment);
		public abstract void set_adjustments (Mx.Adjustment hadjustment, Mx.Adjustment vadjustment);
		[NoAccessorMethod]
		public abstract Mx.Adjustment horizontal_adjustment { owned get; set; }
		[NoAccessorMethod]
		public abstract Mx.Adjustment vertical_adjustment { owned get; set; }
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_stylable_get_type ()")]
	public interface Stylable : GLib.Object {
		public void apply_clutter_text_attributes (Clutter.Text text);
		public void connect_change_notifiers ();
		public unowned GLib.ParamSpec find_property (string property_name);
		public void @get (...);
		public bool get_default_value (string property_name, out GLib.Value value_out);
		public GLib.Value get_property (string property_name);
		public abstract unowned Mx.Style get_style ();
		public abstract unowned string get_style_class ();
		public abstract unowned string get_style_pseudo_class ();
		[CCode (array_length_pos = 0.1, array_length_type = "guint")]
		public GLib.ParamSpec[] list_properties ();
		public abstract void set_style (Mx.Style style);
		public abstract void set_style_class (string style_class);
		public abstract void set_style_pseudo_class (string pseudo_class);
		public void style_pseudo_class_add (string new_class);
		public bool style_pseudo_class_contains (string pseudo_class);
		public void style_pseudo_class_remove (string remove_class);
		public abstract Mx.Style style { get; set; }
		public abstract string style_class { get; set; }
		public abstract string style_pseudo_class { get; set; }
		[HasEmitter]
		public virtual signal void style_changed (Mx.StyleChangedFlags flags);
	}
	[CCode (cheader_filename = "mx/mx.h", type_id = "mx_padding_get_type ()")]
	public struct Padding {
		public float top;
		public float right;
		public float bottom;
		public float left;
	}
	[CCode (cheader_filename = "mx/mx.h", has_type_id = false)]
	public struct SettingsProviderIface {
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_ACTOR_MANAGER_", type_id = "mx_actor_manager_error_get_type ()")]
	public enum ActorManagerError {
		CONTAINER_DESTROYED,
		ACTOR_DESTROYED,
		CREATION_FAILED,
		UNKNOWN_OPERATION
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_ALIGN_", type_id = "mx_align_get_type ()")]
	public enum Align {
		START,
		MIDDLE,
		END
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_APPLICATION_", type_id = "mx_application_flags_get_type ()")]
	[Flags]
	public enum ApplicationFlags {
		SINGLE_INSTANCE,
		KEEP_ALIVE
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_DRAG_AXIS_", type_id = "mx_drag_axis_get_type ()")]
	public enum DragAxis {
		NONE,
		X,
		Y
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_FOCUS_DIRECTION_", type_id = "mx_focus_direction_get_type ()")]
	public enum FocusDirection {
		OUT,
		UP,
		DOWN,
		LEFT,
		RIGHT,
		NEXT,
		PREVIOUS
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_FOCUS_HINT_", type_id = "mx_focus_hint_get_type ()")]
	public enum FocusHint {
		FIRST,
		LAST,
		PRIOR,
		FROM_ABOVE,
		FROM_BELOW,
		FROM_LEFT,
		FROM_RIGHT;
		public static Mx.FocusHint from_direction (Mx.FocusDirection direction);
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_FONT_WEIGHT_", type_id = "mx_font_weight_get_type ()")]
	public enum FontWeight {
		NORMAL,
		BOLD,
		BOLDER,
		LIGHTER;
		public static void set_from_string (GLib.Value value, string str);
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_IMAGE_SCALE_", type_id = "mx_image_scale_mode_get_type ()")]
	public enum ImageScaleMode {
		NONE,
		FIT,
		CROP
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_KINETIC_SCROLL_VIEW_STATE_", type_id = "mx_kinetic_scroll_view_state_get_type ()")]
	public enum KineticScrollViewState {
		IDLE,
		PANNING,
		SCROLLING,
		CLAMPING
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_LONG_PRESS_", type_id = "mx_long_press_action_get_type ()")]
	public enum LongPressAction {
		QUERY,
		ACTION,
		CANCEL
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_ORIENTATION_", type_id = "mx_orientation_get_type ()")]
	public enum Orientation {
		HORIZONTAL,
		VERTICAL
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_POSITION_", type_id = "mx_position_get_type ()")]
	public enum Position {
		TOP,
		RIGHT,
		BOTTOM,
		LEFT
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_SCROLL_POLICY_", type_id = "mx_scroll_policy_get_type ()")]
	public enum ScrollPolicy {
		NONE,
		HORIZONTAL,
		VERTICAL,
		BOTH
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_STYLE_CHANGED_", type_id = "mx_style_changed_flags_get_type ()")]
	[Flags]
	public enum StyleChangedFlags {
		NONE,
		FORCE,
		INVALIDATE_CACHE
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_STYLE_ERROR_INVALID_")]
	public enum StyleError {
		[Deprecated (replacement = "StyleError.INVALID_FILE", since = "vala-0.14")]
		FILE,
		[CCode (cname = "MX_STYLE_ERROR_INVALID_FILE")]
		INVALID_FILE
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_TOOLTIP_ANIMATION_", type_id = "mx_tooltip_animation_get_type ()")]
	public enum TooltipAnimation {
		BOUNCE,
		FADE
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_WINDOW_", type_id = "mx_window_rotation_get_type ()")]
	public enum WindowRotation {
		[CCode (cname = "MX_WINDOW_ROTATION_0")]
		@0,
		[CCode (cname = "MX_WINDOW_ROTATION_90")]
		@90,
		[CCode (cname = "MX_WINDOW_ROTATION_180")]
		@180,
		[CCode (cname = "MX_WINDOW_ROTATION_270")]
		@270
	}
	[CCode (cheader_filename = "mx/mx.h", cprefix = "MX_IMAGE_ERROR_")]
	public errordomain ImageError {
		BAD_FORMAT,
		NO_ASYNC,
		INTERNAL,
		INVALID_PARAMETER;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "mx/mx.h", instance_pos = 1.9)]
	public delegate void ActionCallbackFunc (Mx.Action action);
	[CCode (cheader_filename = "mx/mx.h", instance_pos = 2.9)]
	public delegate void ClipboardCallbackFunc (Mx.Clipboard clipboard, string text);
	[CCode (cheader_filename = "mx/mx.h", cname = "MX_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "mx/mx.h", cname = "MX_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "mx/mx.h", cname = "MX_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "mx/mx.h", cname = "MX_PARAM_TRANSLATEABLE")]
	public const int PARAM_TRANSLATEABLE;
	[CCode (cheader_filename = "mx/mx.h", cname = "MX_VERSION_HEX")]
	public const int VERSION_HEX;
	[CCode (cheader_filename = "mx/mx.h", cname = "MX_VERSION_S")]
	public const string VERSION_S;
	[CCode (cheader_filename = "mx/mx.h")]
	public static void actor_box_clamp_to_pixels (Clutter.ActorBox box);
	[CCode (cheader_filename = "mx/mx.h")]
	public static void allocate_align_fill (Clutter.Actor child, Clutter.ActorBox childbox, Mx.Align x_alignment, Mx.Align y_alignment, bool x_fill, bool y_fill);
	[CCode (cheader_filename = "mx/mx.h")]
	[Deprecated (replacement = "FontWeight.set_from_string", since = "vala-0.14")]
	public static void font_weight_set_from_string (GLib.Value value, string str);
	[CCode (cheader_filename = "mx/mx.h")]
	public static void set_locale ();
	[CCode (cheader_filename = "mx/mx.h")]
	public static string utils_format_time (GLib.TimeVal time_);
}
