/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Level;
import spec.jbb.Company;
import spec.jbb.Customer;
import spec.jbb.District;
import spec.jbb.JBButil;
import spec.jbb.Order;
import spec.jbb.Orderline;
import spec.jbb.Transaction;
import spec.jbb.Warehouse;
import spec.jbb.infra.Util.TransactionLogBuffer;
import spec.jbb.infra.Util.XMLTransactionLog;

class OrderStatusTransaction
extends Transaction {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Company company;
    private short warehouseId;
    private byte districtId;
    private String cust_last_name;
    private boolean use_customerId;
    private short customerId;
    private Customer customerPtr;
    private BigDecimal customerBalance;
    private String customerFirstName;
    private String customerMiddleName;
    private String customerLastName;
    private Warehouse warehousePtr;
    private District districtPtr;
    private Order currentOrderPtr;
    private int orderId;
    private Date orderEntryDate;
    private short orderCarrierId;
    private int orderLineCount;
    private short[] ol_supplying_warehouse;
    private int[] ol_item_id;
    private String[] ol_item_name;
    private short[] ol_quantity;
    private int[] ol_stock;
    private char[] ol_b_g;
    private BigDecimal[] ol_item_price;
    private BigDecimal[] ol_amount;
    private Date[] ol_delivery_date;
    private TransactionLogBuffer orderLog;
    private TransactionLogBuffer initLog;
    private XMLTransactionLog xmlOrderLog;
    String[] validationLog = new String[]{"                                  Order-Status", "Warehouse:    1   District:  5", "Customer:    4    Name:wo8iWcPkuJ5Fy    OE BARBARPRI       ", "Cust-Balance:     -/0.00", "", "Order-Number:        4   Entry-Date: 13-04-2000 11:03:13   Carrier-Number: 10", "Supply-W     Item-Id    Qty      Amount     Delivery-Date   ", "     1        12578      5        $402.55  ", "     1         1515      5        $385.90  ", "     1        11638      5        $285.00  ", "     1          318      5         $84.70  ", "     1        13417      5        $388.25  ", "     1        16614      5        $286.60  ", "     1        10277      5        $415.45  ", "     1         7598      5        $263.10  ", "     1        18812      5        $239.95  ", "     1         2304      5        $333.45  ", "     1        12801      5         $61.30  ", "     1          852      5        $105.35  ", "     1         4282      5         $77.10  ", "     1        11977      5        $341.55  ", "     1         7411      5        $418.35  ", "", ""};
    boolean[] checkLine = new boolean[]{true, true, true, false, true, false, true, true, true, true, false, true, true, true, true, true, true, false, true, false, true, true, true, true};

    public OrderStatusTransaction(Company company, short s) {
        this.company = company;
        this.warehouseId = s;
        this.ol_supplying_warehouse = new short[30];
        this.ol_item_id = new int[30];
        this.ol_item_name = new String[30];
        this.ol_quantity = new short[30];
        this.ol_stock = new int[30];
        this.ol_b_g = new char[30];
        this.ol_item_price = new BigDecimal[30];
        this.ol_amount = new BigDecimal[30];
        this.ol_delivery_date = new Date[30];
        this.orderLog = new TransactionLogBuffer();
        this.setupOrderLog();
        this.xmlOrderLog = new XMLTransactionLog();
        this.initLog = new TransactionLogBuffer(this.orderLog);
        this.setupInitLog();
    }

    private void setupOrderLog() {
        this.orderLog.putText("Order-Status", 34, 0, 12);
        this.orderLog.putText("Warehouse:", 0, 1, 10);
        this.orderLog.putInt(this.warehouseId, 11, 1, 4);
        this.orderLog.putText("District:", 18, 1, 9);
        this.orderLog.putText("Customer:", 0, 2, 10);
        this.orderLog.putText("Name:", 18, 2, 5);
        this.orderLog.putText("Cust-Balance:", 0, 3, 14);
        this.orderLog.putText("Order-Number:", 0, 5, 14);
        this.orderLog.putText("Entry-Date:", 25, 5, 12);
        this.orderLog.putText("Carrier-Number:", 59, 5, 16);
        this.orderLog.putText("Supply-W     Item-Id    Qty      Amount     Delivery-Date", 0, 6, 60);
    }

    private void setupInitLog() {
        this.initLog.putCharFill('9', 28, 1, 2);
        this.initLog.putCharFill('9', 10, 2, 4);
        this.initLog.putCharFill('X', 23, 2, 16);
        this.initLog.putCharFill('X', 40, 2, 2);
        this.initLog.putCharFill('X', 43, 2, 16);
        this.initLog.putText("$-99999.99", 14, 3, 10);
        this.initLog.putCharFill('9', 14, 5, 8);
        this.initLog.putText("DD-MM-YYYY", 37, 5, 10);
        this.initLog.putText("hh:mm:ss", 48, 5, 8);
        this.initLog.putCharFill('9', 75, 5, 2);
        for (int i = 7; i < 22; ++i) {
            this.initLog.putCharFill('9', 2, i, 4);
            this.initLog.putCharFill('9', 13, i, 6);
            this.initLog.putCharFill('9', 24, i, 2);
            this.initLog.putText("$99999.99", 32, i, 9);
            this.initLog.putText("DD-MM-YYYY", 46, i, 10);
        }
    }

    public String getMenuName() {
        return "Order-Status";
    }

    public synchronized void delete() {
    }

    public synchronized void init() {
        JBButil.getLog().entering("spec.jbb.OrderStatusTransaction", "init");
        this.districtId = (byte)JBButil.random(1, (int)this.company.getMaxDistrictsPerWarehouse(), this.warehouseId);
        int n = JBButil.random(1, 100, this.warehouseId);
        if (n <= 60) {
            this.cust_last_name = JBButil.choose_random_last_name(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
            this.use_customerId = false;
        } else {
            this.customerId = JBButil.create_random_customer_id(this.company.getMaxCustomersPerDistrict(), this.warehouseId);
            this.use_customerId = true;
        }
        JBButil.getLog().exiting("spec.jbb.OrderStatusTransaction", "init");
    }

    public boolean process() {
        JBButil.getLog().entering("spec.jbb.OrderStatusTransaction", "process");
        int n = 0;
        if (this.use_customerId) {
            long l = this.company.buildUniqueCustomerKey(this.warehouseId, this.districtId, this.customerId);
            this.customerPtr = this.company.getCustomer(l, false);
        } else {
            this.customerPtr = this.company.getCustomerByLastName(this.warehouseId, this.districtId, this.cust_last_name);
        }
        if (this.customerPtr != null) {
            this.customerId = this.customerPtr.getId();
            this.customerBalance = this.customerPtr.getBalance();
            this.customerFirstName = this.customerPtr.getFirstName();
            this.customerMiddleName = this.customerPtr.getMiddleName();
            this.customerLastName = this.customerPtr.getLastName();
            this.currentOrderPtr = this.customerPtr.getLatestOrder();
            if (this.currentOrderPtr != null) {
                this.orderId = this.currentOrderPtr.getId();
                this.orderEntryDate = this.currentOrderPtr.getEntryTime();
                this.orderCarrierId = this.currentOrderPtr.getCarrierId();
                this.orderLineCount = this.currentOrderPtr.getOrderlineCount();
                Orderline[] orderlineArray = this.currentOrderPtr.getOrderlineList();
                if (JBButil.getLog().isLoggable(Level.FINEST)) {
                    JBButil.getLog().finest("OrderStatusTransaction::process orderlineList=" + orderlineArray + " orderLineCount=" + this.orderLineCount);
                }
                for (int i = 0; i < this.orderLineCount; ++i) {
                    Orderline orderline = orderlineArray[i];
                    if (JBButil.getLog().isLoggable(Level.FINEST)) {
                        JBButil.getLog().finest(" i=" + i + " line_number=" + n + " orderline=" + orderline);
                    }
                    this.ol_supplying_warehouse[n] = orderline.getSupplyWarehouse();
                    this.ol_item_id[n] = orderline.getItemId();
                    this.warehousePtr = this.company.getWarehousePtr(this.warehouseId, false);
                    this.ol_item_name[n] = this.warehousePtr.retrieveItem(orderline.getItemId()).getName();
                    this.ol_quantity[n] = orderline.getQuantity();
                    this.ol_stock[n] = orderline.getStockQuantity();
                    this.ol_b_g[n] = orderline.getBrandGeneric();
                    this.ol_item_price[n] = orderline.getItemPrice();
                    this.ol_amount[n] = orderline.getAmount();
                    this.ol_delivery_date[n] = orderline.getDeliveryDateTime();
                    ++n;
                }
                JBButil.getLog().exiting("spec.jbb.OrderStatusTransaction", "process");
                return true;
            }
            JBButil.getLog().exiting("spec.jbb.OrderStatusTransaction", "process");
            return false;
        }
        this.customerId = 0;
        this.customerFirstName = "";
        this.customerMiddleName = "";
        this.customerLastName = this.cust_last_name;
        this.customerBalance = BigDecimal.valueOf(0L, 2);
        this.currentOrderPtr = null;
        JBButil.getLog().exiting("spec.jbb.OrderStatusTransaction", "process");
        return false;
    }

    public synchronized void display() {
        System.out.println("OrderStatus Display **********************");
        System.out.println("Warehouse ID is " + this.warehouseId);
        System.out.println("District  ID is " + this.districtId);
        System.out.println("Customer  ID is " + this.customerId);
        System.out.println("**************************************************");
    }

    public synchronized void initializeTransactionLog() {
        JBButil.getLog().entering("spec.jbb.OrderStatusTransaction", "initializeTransactionLog");
        Date date = new Date();
        this.orderLog.putDate(date, 37, 5, 10);
        if (Transaction.enableLogWrite) {
            this.initLog.display();
        }
        JBButil.getLog().exiting("spec.jbb.OrderStatusTransaction", "initializeTransactionLog");
    }

    public synchronized void processTransactionLog() {
        Object object;
        int n;
        JBButil.getLog().entering("spec.jbb.OrderStatusTransaction", "processTransactionLog");
        Date date = new Date();
        this.orderLog.clearBuffer();
        this.xmlOrderLog.clear();
        this.setupOrderLog();
        this.orderLog.putInt(this.districtId, 28, 1, 2);
        this.orderLog.putInt(this.customerId, 10, 2, 4);
        this.orderLog.putText(this.customerFirstName, 23, 2, 16);
        this.orderLog.putText(this.customerMiddleName, 40, 2, 2);
        this.orderLog.putText(this.customerLastName, 43, 2, 16);
        this.orderLog.putDollars(this.customerBalance, 14, 3, 10);
        if (this.currentOrderPtr != null) {
            this.orderLog.putInt(this.orderId, 14, 5, 8);
            if (this.orderEntryDate != null) {
                this.orderLog.putDate(this.orderEntryDate, 37, 5, 10);
                this.orderLog.putTime(this.orderEntryDate, 48, 5, 8);
            }
            this.orderLog.putInt(this.orderCarrierId, 75, 5, 2);
            for (n = 0; n < this.orderLineCount; ++n) {
                int n2 = n + 7;
                if (n >= 15) {
                    n2 = 22;
                }
                this.orderLog.putInt(this.ol_supplying_warehouse[n], 2, n2, 4);
                this.orderLog.putInt(this.ol_item_id[n], 13, n2, 6);
                this.orderLog.putInt(this.ol_quantity[n], 24, n2, 2);
                this.orderLog.putDollars(this.ol_amount[n], 34, n2, 9);
                object = this.ol_delivery_date[n];
                if (object == null) continue;
                this.orderLog.putDate((Date)object, 46, n2, 10);
            }
        } else if (this.customerPtr == null) {
            this.orderLog.putText("No customer found for last name.", 2, 4, 32);
        } else {
            this.orderLog.putText("No orders pending.", 2, 7, 20);
        }
        this.xmlOrderLog.populateXML(this.orderLog);
        if (Transaction.enableLogWrite) {
            this.orderLog.display();
        }
        if (Transaction.validationFlag) {
            object = this.orderLog.validate();
            if (((String[])object).length != this.validationLog.length) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  mismatch in screen lengths for OrderStatusTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length should be:  " + this.validationLog.length);
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Screen length is:  " + ((String[])object).length);
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
            for (n = 0; n < this.validationLog.length; ++n) {
                if (!this.checkLine[n] || object[n].equals(this.validationLog[n])) continue;
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("VALIDATION ERROR:  incorrect output for OrderStatusTransaction");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (n + 1) + " should be:  |" + this.validationLog[n] + "|");
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append("    Line " + (n + 1) + " is:  |" + object[n] + "|");
                JBButil.getLog().warning(stringBuffer.toString());
                Transaction.invalidateRun();
            }
        }
        JBButil.getLog().exiting("spec.jbb.OrderStatusTransaction", "processTransactionLog");
    }
}

