/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import ptolemy.util.FileUtilities;

public class StringUtilities {
    public static final int ELLIPSIS_LENGTH_LONG = 2000;
    public static final int ELLIPSIS_LENGTH_SHORT = 400;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static String PREFERENCES_DIRECTORY = ".ptolemyII";
    private static boolean _printedCygwinWarning = false;
    private static String _ptolemyPtIIDir = null;

    private StringUtilities() {
    }

    public static String abbreviate(String string) {
        if (string == null) {
            return "<Unnamed>";
        }
        if (string.length() <= 80) {
            return string;
        }
        return string.substring(0, 37) + ". . ." + string.substring(string.length() - 38);
    }

    public static String ellipsis(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string = StringUtilities.split(string, 160), LINE_SEPARATOR, true);
        if (stringTokenizer.countTokens() > 42) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < 42 && stringTokenizer.hasMoreTokens(); ++i) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            stringBuffer.append("...");
            string = stringBuffer.toString();
        }
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static String escapeForXML(String string) {
        string = StringUtilities.substitute(string, "&", "&amp;");
        string = StringUtilities.substitute(string, "\"", "&quot;");
        string = StringUtilities.substitute(string, "<", "&lt;");
        string = StringUtilities.substitute(string, ">", "&gt;");
        string = StringUtilities.substitute(string, "\n", "&#10;");
        string = StringUtilities.substitute(string, "\r", "&#13;");
        return string;
    }

    public static String escapeString(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\"", "\\\\\"");
        string = string.replaceAll("\n", "\\\\n");
        string = string.replaceAll("\t", "\\\\t");
        string = string.replaceAll("\b", "\\\\b");
        string = string.replaceAll("\r", "\\\\r");
        return string;
    }

    public static void exit(int n) {
        if (StringUtilities.getProperty("ptolemy.ptII.exitAfterWrapup").length() > 0) {
            throw new RuntimeException("Normally, we would exit here because Manager.exitAfterWrapup() was called.  However, because the ptolemy.ptII.exitAfterWrapup property is set, we throw this exception instead.");
        }
        System.exit(n);
    }

    public static String getIndentPrefix(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        return stringBuffer.toString();
    }

    public static String getProperty(String string) {
        String string2;
        block25: {
            string2 = null;
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {
                if (string.equals("ptolemy.ptII.dir")) break block25;
                SecurityException securityException2 = new SecurityException("Could not find '" + string + "' System property");
                securityException2.initCause(securityException);
                throw securityException2;
            }
        }
        if (string.equals("user.dir")) {
            try {
                File file = new File(string2);
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return string2;
            }
        }
        if (string2 != null) {
            if (string.equals("ptolemy.ptII.dir") && string2.startsWith("/cygdrive") && !_printedCygwinWarning) {
                _printedCygwinWarning = true;
                System.err.println("ptolemy.ptII.dir property = \"" + string2 + "\", which contains \"cygdrive\". " + "This is almost always an error under Cygwin that " + "is occurs when one does PTII=`pwd`.  Instead, do " + "PTII=c:/foo/ptII");
            }
            return string2;
        }
        if (string.equals("ptolemy.ptII.dirAsURL")) {
            File file = new File(StringUtilities.getProperty("ptolemy.ptII.dir"));
            try {
                URI uRI = file.toURI();
                URL uRL = uRI.toURL();
                return uRL.toString();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("While trying to find '" + string + "', could not convert '" + file + "' to a URL", malformedURLException);
            }
        }
        if (string.equals("ptolemy.ptII.dir")) {
            if (_ptolemyPtIIDir != null) {
                return _ptolemyPtIIDir;
            }
            String string3 = "ptolemy/util/StringUtilities.class";
            URL uRL = Thread.currentThread().getContextClassLoader().getResource(string3);
            if (uRL != null) {
                String string4;
                String string5;
                String string6 = uRL.getFile();
                if (string6.startsWith("file:")) {
                    string6 = string6.startsWith("file:/") || string6.startsWith("file:\\") ? string6.substring(6) : string6.substring(5);
                }
                if ((_ptolemyPtIIDir = new File(string5 = string6.substring(0, string6.length() - string3.length())).toString()).endsWith("/!") || _ptolemyPtIIDir.endsWith("\\!")) {
                    _ptolemyPtIIDir = _ptolemyPtIIDir.substring(0, _ptolemyPtIIDir.length() - 1);
                }
                if (_ptolemyPtIIDir.endsWith(string4 = File.separator + "DMptolemy" + File.separator + "RMptsupport.jar")) {
                    _ptolemyPtIIDir = _ptolemyPtIIDir.substring(0, _ptolemyPtIIDir.length() - string4.length());
                } else {
                    string4 = "/DMptolemy/XMptsupport.jar";
                    if (_ptolemyPtIIDir.lastIndexOf(string4) != -1) {
                        _ptolemyPtIIDir = _ptolemyPtIIDir.substring(0, _ptolemyPtIIDir.lastIndexOf(string4));
                    } else {
                        string4 = File.separator + "ptolemy" + File.separator + "ptsupport.jar";
                        if (_ptolemyPtIIDir.lastIndexOf(string4) != -1) {
                            _ptolemyPtIIDir = _ptolemyPtIIDir.substring(0, _ptolemyPtIIDir.lastIndexOf(string4));
                        }
                    }
                }
            }
            if (_ptolemyPtIIDir != null) {
                _ptolemyPtIIDir = StringUtilities.substitute(_ptolemyPtIIDir, "%20", " ");
            }
            if (_ptolemyPtIIDir == null) {
                throw new RuntimeException("Could not find 'ptolemy.ptII.dir' property.  Also tried loading '" + string3 + "' as a resource and working from that. " + "Vergil should be " + "invoked with -Dptolemy.ptII.dir" + "=\"$PTII\"");
            }
            try {
                System.setProperty("ptolemy.ptII.dir", _ptolemyPtIIDir);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return _ptolemyPtIIDir;
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static void mergePropertiesFile() throws IOException {
        Properties properties = System.getProperties();
        Properties properties2 = new Properties();
        String string = "$CLASSPATH/lib/ptII.properties";
        URL uRL = FileUtilities.nameToURL("xxxxxxCLASSPATHxxxxxx/lib/ptII.properties", null, null);
        if (uRL == null) {
            throw new IOException("Could not find " + string);
        }
        properties2.load(uRL.openStream());
        properties2.putAll((Map<?, ?>)properties);
        System.setProperties(properties2);
    }

    public static String objectToSourceFileName(Object object) {
        String string = object.getClass().getName().replace('.', '/');
        if (string.indexOf("$") != -1) {
            string = string.substring(0, string.indexOf("$"));
        }
        return string + ".java";
    }

    public static String preferencesDirectory() throws IOException {
        String string = StringUtilities.getProperty("user.home") + File.separator + PREFERENCES_DIRECTORY + File.separator;
        File file = new File(string);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("Could not create user preferences directory '" + string + "'");
        }
        return string;
    }

    public static String propertiesFileName() throws IOException {
        return StringUtilities.preferencesDirectory() + "ptII.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList readLines(String string) throws IOException {
        BufferedReader bufferedReader = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() == 0 || string2.startsWith("/*") || string2.startsWith("//")) continue;
                linkedList.add(string2);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return linkedList;
    }

    public static String sanitizeName(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            cArray[i] = 95;
        }
        if (cArray.length == 0) {
            return "";
        }
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return "_" + new String(cArray);
        }
        return new String(cArray);
    }

    public static String split(String string) {
        return StringUtilities.split(string, 79);
    }

    public static String split(String string, int n) {
        if (string == null) {
            return "<Unnamed>";
        }
        if (string.length() <= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = 0;
            while (n2 < string2.length() - n) {
                int n3 = string2.substring(n2, n2 + n).lastIndexOf(" ");
                if (n3 < 0) {
                    stringBuffer.append(string2.substring(n2, n2 + n) + LINE_SEPARATOR);
                    n2 += n;
                    continue;
                }
                stringBuffer.append(string2.substring(n2, n2 + n3) + LINE_SEPARATOR);
                n2 += n3 + 1;
            }
            stringBuffer.append(string2.substring(n2));
        }
        return stringBuffer.toString();
    }

    public static URL stringToURL(String string, URI uRI, ClassLoader classLoader) throws IOException {
        return FileUtilities.nameToURL(string, uRI, classLoader);
    }

    public static String substitute(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.delete(n, n + string2.length());
            stringBuffer.insert(n, string3);
            string = new String(stringBuffer);
            n = string.indexOf(string2, n + string3.length());
        }
        return string;
    }

    public static String substituteFilePrefix(String string, String string2, String string3) {
        if (string2.startsWith(string)) {
            return string3 + string2.substring(string.length());
        }
        try {
            String string4 = new File(string).getCanonicalPath();
            String string5 = new File(string2).getCanonicalPath();
            if (string5.startsWith(string4)) {
                return string3 + string5.substring(string4.length());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public static String[] tokenizeForExec(String string) throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 127);
        streamTokenizer.ordinaryChar(34);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        block5: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    if (bl) {
                        if (string2.length() > 0) {
                            string2 = string2 + " ";
                        }
                        string2 = string2 + string3 + streamTokenizer.sval;
                    } else {
                        string2 = string3 + streamTokenizer.sval;
                        linkedList.add(string2);
                    }
                    string3 = "";
                    continue block5;
                }
                case -2: {
                    throw new RuntimeException("Internal error: Found TT_NUMBER: '" + streamTokenizer.nval + "'.  We should not be " + "tokenizing numbers");
                }
                case -1: 
                case 10: {
                    continue block5;
                }
            }
            string3 = Character.toString((char)streamTokenizer.ttype);
            if (!string3.equals("\"")) continue;
            if (bl) {
                linkedList.add(string2);
            }
            bl = !bl;
            string3 = "";
            string2 = "";
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public static String truncateString(String string, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_SEPARATOR, true);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n3 >= n2 * 2) {
                stringBuffer.append("...");
                break;
            }
            ++n3;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() > n) {
                string2 = string2.substring(0, n - 3) + "...";
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String unescapeForXML(String string) {
        string = StringUtilities.substitute(string, "&amp;", "&");
        string = StringUtilities.substitute(string, "&quot;", "\"");
        string = StringUtilities.substitute(string, "&lt;", "<");
        string = StringUtilities.substitute(string, "&gt;", ">");
        string = StringUtilities.substitute(string, "&#10;", "\n");
        string = StringUtilities.substitute(string, "&#13;", "\r");
        return string;
    }

    public static String usageString(String string, String[][] stringArray, String[] stringArray2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Usage: " + string + "\n\n" + "Options that take values:\n");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(" " + stringArray[n][0] + " " + stringArray[n][1] + "\n");
        }
        stringBuffer.append("\nBoolean flags:\n");
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuffer.append(" " + stringArray2[n]);
        }
        return stringBuffer.toString();
    }
}

