#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.main_loop import loop_init, loop_run, connectTCP
loop_init(True)

from winswitch.consts import LOCALHOST
from winswitch.net.conch_channels import ExecChannel
from winswitch.util.simple_logger import Logger
from winswitch.ui.dialog_util import get_dialog_util
from conch_test_common import make_factory
logger = Logger("conch_exec_test")


def ssh_exec(host, port, command):
	factory = make_factory(host, port)
	factory.dialog_util = get_dialog_util()
	echo_channel = lambda connection : ExecChannel(command, connection)
	factory.channel_constructors.append(echo_channel)
	connectTCP(host, port, factory)
	try:
		loop_run()
	except Exception, e:
		logger.serr(None, e, host, port, command)
	logger.slog("ended", host, port, command)


def main():
	ssh_exec(LOCALHOST, 22, "winswitch_server_portinfo")

if __name__ == "__main__":
	main()
