#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import gtk
import pygtk
pygtk.require("2.0")

from winswitch.ui.tray_util import setup_tray
from winswitch.util.main_loop import test_loop
from winswitch.util.simple_logger import Logger
import gobject


logger = Logger("tray_util_test")
ANIMATE = False
tray = None

def test_tray():
	global tray
	menu = gtk.Menu()
	menu.set_title("Test Tray")
	for i in range(10):
		menu.append(gtk.MenuItem("Item %s" % i))
	menu.show_all()

	def show_menu(button, time):
		logger.slog(None, button, time)
		logger.slog("position=%s" % str(tray.position_menu(menu, tray)), button, time)
		menu.popup(None, None, tray.position_menu, button, time, tray.getStatusIcon())
	def popup_menu(widget, button, time):
		logger.slog(None, widget, button, time)
		show_menu(button, time)
	def activate_menu(*args):
		logger.slog(None, *args)
		show_menu(1, 0)
	def exit_if_unclean(*args):
		logger.slog(None, *args)
	def ask_quit(*args):
		logger.slog(None, *args)
	def handle_session_event(*args):
		logger.slog(None, *args)

	def start_tray(*args):
		global tray
		logger.slog(None, *args)
		try:
			tray = setup_tray(False, False, popup_menu, activate_menu, exit_if_unclean, ask_quit, handle_session_event, "winswitch_indicator")
			# create a menu (appindicator does not show without one!)
			tray.set_menu(menu)
		except Exception, e:
			logger.serr(None, e, *args)
		logger.slog("tray=%s" % tray, *args)

	def request_attention():
		global tray
		tray.request_attention("hello", 10)

	def ready():
		global tray
		tray.ready()

	gobject.idle_add(start_tray)
	gobject.timeout_add(1000*2, ready)
	#gobject.timeout_add(1000*4, show_menu, 3, 0)
	if ANIMATE:
		gobject.timeout_add(1000*4, request_attention)

def main():
	test_loop(test_tray)

if __name__ == "__main__":
	main()
