#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.objects.common import ModifiedCallbackObject

class MountPoint(ModifiedCallbackObject):

	#options for type
	DISK = "Disk"
	PRINTER = "Printer"
	#options for protocol
	SMB = "smb"
	NFS = "nfs"
	SSHFS = "sshfs"
	#options for auth
	LOGIN = "login"

	PERSIST = ["protocol", "namespace", "host", "port", "path", "fs_type", "auth_mode", "username", "password", "comment", "options"]

	def __init__(self, protocol="", namespace="", host="", port=0, path="", fs_type="", auth_mode="", username="", password="", comment="", options={}):
		ModifiedCallbackObject.__init__(self)
		self.protocol = protocol			#ie: smb
		self.namespace = namespace			#ie: WORKGROUP
		self.host = host					#ie: localhost
		self.port = port					#ie: 138
		self.path = path					#ie: public
		self.fs_type = fs_type				#ie: Disk/Printer
		self.auth_mode = auth_mode			#ie: guest,login
		self.username = username			#ie: username
		self.password = password			#ie: password
		self.comment = comment				#ie: Public stuff
		self.options = options				#ie: {"read_only": True}
		self.mount_point = None

	def __str__(self):
		return	"MountPoint(%s %s://%s:%s/%s)" % (self.fs_type, self.protocol, self.host, self.port, self.path)
