#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import pygtk
pygtk.require("2.0")
import gtk.gdk

from winswitch.util.simple_logger import Logger
logger=Logger("gdk_debug", log_colour=Logger.HIGHLIGHTED_BLUE)

""" This is currently disabled as it breaks with KDE! """

GDK_EVENT_IDLE_WAKE = False			#monitor gdk events to wake up from idle state
GDK_EVENT_FILTER_DEBUG = False

IDLE_CHECK_CALLBACK = None

def set_gdk_debug(idle_check_cb=None):
	global IDLE_CHECK_CALLBACK
	""" Beware - this increases the CPU load and causes problems with KDE! """
	if GDK_EVENT_FILTER_DEBUG or GDK_EVENT_IDLE_WAKE:
		IDLE_CHECK_CALLBACK = idle_check_cb
		root = gtk.gdk.get_default_root_window()
		if GDK_EVENT_FILTER_DEBUG:
			root.set_events(gtk.gdk.ALL_EVENTS_MASK)
		elif GDK_EVENT_IDLE_WAKE:
			root.set_events(gtk.gdk.SUBSTRUCTURE_MASK)
		gtk.gdk.event_handler_set(gdk_event_debug)

def gdk_event_debug(event):
	gtk.main_do_event(event)
	global IDLE_CHECK_CALLBACK
	if IDLE_CHECK_CALLBACK:
		IDLE_CHECK_CALLBACK()
	if event.type==gtk.gdk.MAP:
		gdk_windows_changed(True, event)
	elif event.type==gtk.gdk.UNMAP:
		gdk_windows_changed(False, event)
	elif GDK_EVENT_FILTER_DEBUG:
		if event.type==gtk.gdk.PROPERTY_NOTIFY:
			logger.sdebug("type=%s, atom=%s, time=%s, state=%s" % (event.type, event.atom, event.time, event.state), event)
		else:
			logger.sdebug("type=%s" % event.type, event)

def gdk_windows_changed(mapped, event):
	if GDK_EVENT_FILTER_DEBUG:
		import inspect
		logger.sdebug("state=%s, event=%s" % (event.get_state(), inspect.getmembers(event)), event)

def main():
	global GDK_EVENT_FILTER_DEBUG
	GDK_EVENT_FILTER_DEBUG = True
	set_gdk_debug()
	gtk.main()

if __name__ == "__main__":
	main()
