/*
 * @(#)Hexagons.h
 *
 * Copyright 1994 - 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Hexagons */

#ifndef _XtHexagons_h
#define _XtHexagons_h

#define ANIMATE 1

/***********************************************************************
 *
 * Hexagons Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNtextColor ((char *) "textColor")
#define XtNstippleFrame ((char *) "stippleFrame")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNsizeX ((char *) "sizeX")
#define XtNsizeY ((char *) "sizeY")
#define XtNcorners ((char *) "corners")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCFrameColor ((char *) "FrameColor")
#define XtCBlockColor ((char *) "BlockColor")
#define XtCTextColor ((char *) "TextColor")
#define XtCStippleFrame ((char *) "StippleFrame")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCSizeX ((char *) "SizeX")
#define XtCSizeY ((char *) "SizeY")
#define XtCCorners ((char *) "Corners")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _HexagonsClassRec *HexagonsWidgetClass;

extern WidgetClass hexagonsWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} hexagonsCallbackStruct;
#endif

#define ACTION_GET 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_CLEAR_QUERY 104
#define ACTION_SOLVE_MESSAGE 105
#define ACTION_RESTORE 106
#define ACTION_RESET 107
#define ACTION_AMBIGUOUS 108
#define ACTION_BLOCKED 109
#define ACTION_SPACE 110
#define ACTION_MOVED 111
#define ACTION_CONTROL 112
#define ACTION_SOLVED 113
#define ACTION_COMPUTED 114
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_RANDOMIZE 203
#define ACTION_SOLVE 204
#define ACTION_CORNERS 205
#define ACTION_SPEED 206
#define ACTION_SLOW 207
#define ACTION_SOUND 208
#define ACTION_TR 300
#define ACTION_RIGHT 301
#define ACTION_BR 302
#define ACTION_BL 303
#define ACTION_LEFT 304
#define ACTION_TL 305
#define ACTION_INCX 401
#define ACTION_DECX 404
#define ACTION_INCY 400
#define ACTION_DECY 402
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define MIN_TILES 1
#define DEFAULT_TILESX 3
#define DEFAULT_TILESY 3
#define MAX_ORIENT 2
#define NOCORN 0
#define CORNERS 1
#define DEFAULT_CORNERS CORNERS
#define DEFAULT_DELAY 10
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE
#define MIN_BASE 2 /* Base 1 is ridiculous :) */
#define MAX_BASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULT_BASE 10

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _HexagonsRec *HexagonsWidget;

#endif /* _XtHexagons_h */
/* DON'T ADD STUFF AFTER THIS #endif */
