/*
 * Copyright 2020 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _sdma_4_4_0_OFFSET_HEADER
#define _sdma_4_4_0_OFFSET_HEADER


// addressBlock: sdma0_sdma0dec
// base address: 0x4980
#define regSDMA0_UCODE_ADDR                                                                             0x0000
#define regSDMA0_UCODE_ADDR_BASE_IDX                                                                    0
#define regSDMA0_UCODE_DATA                                                                             0x0001
#define regSDMA0_UCODE_DATA_BASE_IDX                                                                    0
#define regSDMA0_VF_ENABLE                                                                              0x000a
#define regSDMA0_VF_ENABLE_BASE_IDX                                                                     0
#define regSDMA0_CONTEXT_GROUP_BOUNDARY                                                                 0x0019
#define regSDMA0_CONTEXT_GROUP_BOUNDARY_BASE_IDX                                                        0
#define regSDMA0_POWER_CNTL                                                                             0x001a
#define regSDMA0_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA0_CLK_CTRL                                                                               0x001b
#define regSDMA0_CLK_CTRL_BASE_IDX                                                                      0
#define regSDMA0_CNTL                                                                                   0x001c
#define regSDMA0_CNTL_BASE_IDX                                                                          0
#define regSDMA0_CHICKEN_BITS                                                                           0x001d
#define regSDMA0_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA0_GB_ADDR_CONFIG                                                                         0x001e
#define regSDMA0_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define regSDMA0_GB_ADDR_CONFIG_READ                                                                    0x001f
#define regSDMA0_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define regSDMA0_RB_RPTR_FETCH_HI                                                                       0x0020
#define regSDMA0_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA0_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x0021
#define regSDMA0_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define regSDMA0_RB_RPTR_FETCH                                                                          0x0022
#define regSDMA0_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA0_IB_OFFSET_FETCH                                                                        0x0023
#define regSDMA0_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA0_PROGRAM                                                                                0x0024
#define regSDMA0_PROGRAM_BASE_IDX                                                                       0
#define regSDMA0_STATUS_REG                                                                             0x0025
#define regSDMA0_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA0_STATUS1_REG                                                                            0x0026
#define regSDMA0_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA0_RD_BURST_CNTL                                                                          0x0027
#define regSDMA0_RD_BURST_CNTL_BASE_IDX                                                                 0
#define regSDMA0_HBM_PAGE_CONFIG                                                                        0x0028
#define regSDMA0_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA0_UCODE_CHECKSUM                                                                         0x0029
#define regSDMA0_UCODE_CHECKSUM_BASE_IDX                                                                0
#define regSDMA0_F32_CNTL                                                                               0x002a
#define regSDMA0_F32_CNTL_BASE_IDX                                                                      0
#define regSDMA0_FREEZE                                                                                 0x002b
#define regSDMA0_FREEZE_BASE_IDX                                                                        0
#define regSDMA0_PHASE0_QUANTUM                                                                         0x002c
#define regSDMA0_PHASE0_QUANTUM_BASE_IDX                                                                0
#define regSDMA0_PHASE1_QUANTUM                                                                         0x002d
#define regSDMA0_PHASE1_QUANTUM_BASE_IDX                                                                0
#define regSDMA_POWER_GATING                                                                            0x002e
#define regSDMA_POWER_GATING_BASE_IDX                                                                   0
#define regSDMA_PGFSM_CONFIG                                                                            0x002f
#define regSDMA_PGFSM_CONFIG_BASE_IDX                                                                   0
#define regSDMA_PGFSM_WRITE                                                                             0x0030
#define regSDMA_PGFSM_WRITE_BASE_IDX                                                                    0
#define regSDMA_PGFSM_READ                                                                              0x0031
#define regSDMA_PGFSM_READ_BASE_IDX                                                                     0
#define regCC_SDMA0_EDC_CONFIG                                                                          0x0032
#define regCC_SDMA0_EDC_CONFIG_BASE_IDX                                                                 0
#define regSDMA0_BA_THRESHOLD                                                                           0x0033
#define regSDMA0_BA_THRESHOLD_BASE_IDX                                                                  0
#define regSDMA0_ID                                                                                     0x0034
#define regSDMA0_ID_BASE_IDX                                                                            0
#define regSDMA0_VERSION                                                                                0x0035
#define regSDMA0_VERSION_BASE_IDX                                                                       0
#define regSDMA0_EDC_COUNTER                                                                            0x0036
#define regSDMA0_EDC_COUNTER_BASE_IDX                                                                   0
#define regSDMA0_EDC_COUNTER2                                                                           0x0037
#define regSDMA0_EDC_COUNTER2_BASE_IDX                                                                  0
#define regSDMA0_STATUS2_REG                                                                            0x0038
#define regSDMA0_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA0_ATOMIC_CNTL                                                                            0x0039
#define regSDMA0_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA0_ATOMIC_PREOP_LO                                                                        0x003a
#define regSDMA0_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA0_ATOMIC_PREOP_HI                                                                        0x003b
#define regSDMA0_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA0_UTCL1_CNTL                                                                             0x003c
#define regSDMA0_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_WATERMK                                                                          0x003d
#define regSDMA0_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA0_UTCL1_RD_STATUS                                                                        0x003e
#define regSDMA0_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA0_UTCL1_WR_STATUS                                                                        0x003f
#define regSDMA0_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA0_UTCL1_INV0                                                                             0x0040
#define regSDMA0_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_INV1                                                                             0x0041
#define regSDMA0_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_INV2                                                                             0x0042
#define regSDMA0_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_RD_XNACK0                                                                        0x0043
#define regSDMA0_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA0_UTCL1_RD_XNACK1                                                                        0x0044
#define regSDMA0_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA0_UTCL1_WR_XNACK0                                                                        0x0045
#define regSDMA0_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA0_UTCL1_WR_XNACK1                                                                        0x0046
#define regSDMA0_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA0_UTCL1_TIMEOUT                                                                          0x0047
#define regSDMA0_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA0_UTCL1_PAGE                                                                             0x0048
#define regSDMA0_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA0_POWER_CNTL_IDLE                                                                        0x0049
#define regSDMA0_POWER_CNTL_IDLE_BASE_IDX                                                               0
#define regSDMA0_RELAX_ORDERING_LUT                                                                     0x004a
#define regSDMA0_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA0_CHICKEN_BITS_2                                                                         0x004b
#define regSDMA0_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA0_STATUS3_REG                                                                            0x004c
#define regSDMA0_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA0_PHYSICAL_ADDR_LO                                                                       0x004d
#define regSDMA0_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_PHYSICAL_ADDR_HI                                                                       0x004e
#define regSDMA0_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_PHASE2_QUANTUM                                                                         0x004f
#define regSDMA0_PHASE2_QUANTUM_BASE_IDX                                                                0
#define regSDMA0_ERROR_LOG                                                                              0x0050
#define regSDMA0_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA0_PUB_DUMMY_REG0                                                                         0x0051
#define regSDMA0_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA0_PUB_DUMMY_REG1                                                                         0x0052
#define regSDMA0_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA0_PUB_DUMMY_REG2                                                                         0x0053
#define regSDMA0_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA0_PUB_DUMMY_REG3                                                                         0x0054
#define regSDMA0_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA0_F32_COUNTER                                                                            0x0055
#define regSDMA0_F32_COUNTER_BASE_IDX                                                                   0
#define regSDMA0_PERFCNT_PERFCOUNTER0_CFG                                                               0x0057
#define regSDMA0_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      0
#define regSDMA0_PERFCNT_PERFCOUNTER1_CFG                                                               0x0058
#define regSDMA0_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      0
#define regSDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x0059
#define regSDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 0
#define regSDMA0_PERFCNT_MISC_CNTL                                                                      0x005a
#define regSDMA0_PERFCNT_MISC_CNTL_BASE_IDX                                                             0
#define regSDMA0_PERFCNT_PERFCOUNTER_LO                                                                 0x005b
#define regSDMA0_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        0
#define regSDMA0_PERFCNT_PERFCOUNTER_HI                                                                 0x005c
#define regSDMA0_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        0
#define regSDMA0_CRD_CNTL                                                                               0x005d
#define regSDMA0_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA0_ULV_CNTL                                                                               0x005f
#define regSDMA0_ULV_CNTL_BASE_IDX                                                                      0
#define regSDMA0_EA_DBIT_ADDR_DATA                                                                      0x0060
#define regSDMA0_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define regSDMA0_EA_DBIT_ADDR_INDEX                                                                     0x0061
#define regSDMA0_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define regSDMA0_STATUS4_REG                                                                            0x0063
#define regSDMA0_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA0_SCRATCH_RAM_DATA                                                                       0x0064
#define regSDMA0_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA0_SCRATCH_RAM_ADDR                                                                       0x0065
#define regSDMA0_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA0_CE_CTRL                                                                                0x0066
#define regSDMA0_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA0_RAS_STATUS                                                                             0x0067
#define regSDMA0_RAS_STATUS_BASE_IDX                                                                    0
#define regSDMA0_CLK_STATUS                                                                             0x0068
#define regSDMA0_CLK_STATUS_BASE_IDX                                                                    0
#define regSDMA0_GFX_RB_CNTL                                                                            0x0080
#define regSDMA0_GFX_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA0_GFX_RB_BASE                                                                            0x0081
#define regSDMA0_GFX_RB_BASE_BASE_IDX                                                                   0
#define regSDMA0_GFX_RB_BASE_HI                                                                         0x0082
#define regSDMA0_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA0_GFX_RB_RPTR                                                                            0x0083
#define regSDMA0_GFX_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA0_GFX_RB_RPTR_HI                                                                         0x0084
#define regSDMA0_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA0_GFX_RB_WPTR                                                                            0x0085
#define regSDMA0_GFX_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA0_GFX_RB_WPTR_HI                                                                         0x0086
#define regSDMA0_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA0_GFX_RB_WPTR_POLL_CNTL                                                                  0x0087
#define regSDMA0_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA0_GFX_RB_RPTR_ADDR_HI                                                                    0x0088
#define regSDMA0_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA0_GFX_RB_RPTR_ADDR_LO                                                                    0x0089
#define regSDMA0_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA0_GFX_IB_CNTL                                                                            0x008a
#define regSDMA0_GFX_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA0_GFX_IB_RPTR                                                                            0x008b
#define regSDMA0_GFX_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA0_GFX_IB_OFFSET                                                                          0x008c
#define regSDMA0_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA0_GFX_IB_BASE_LO                                                                         0x008d
#define regSDMA0_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA0_GFX_IB_BASE_HI                                                                         0x008e
#define regSDMA0_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA0_GFX_IB_SIZE                                                                            0x008f
#define regSDMA0_GFX_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA0_GFX_SKIP_CNTL                                                                          0x0090
#define regSDMA0_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA0_GFX_CONTEXT_STATUS                                                                     0x0091
#define regSDMA0_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA0_GFX_DOORBELL                                                                           0x0092
#define regSDMA0_GFX_DOORBELL_BASE_IDX                                                                  0
#define regSDMA0_GFX_CONTEXT_CNTL                                                                       0x0093
#define regSDMA0_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define regSDMA0_GFX_STATUS                                                                             0x00a8
#define regSDMA0_GFX_STATUS_BASE_IDX                                                                    0
#define regSDMA0_GFX_DOORBELL_LOG                                                                       0x00a9
#define regSDMA0_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA0_GFX_WATERMARK                                                                          0x00aa
#define regSDMA0_GFX_WATERMARK_BASE_IDX                                                                 0
#define regSDMA0_GFX_DOORBELL_OFFSET                                                                    0x00ab
#define regSDMA0_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA0_GFX_CSA_ADDR_LO                                                                        0x00ac
#define regSDMA0_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA0_GFX_CSA_ADDR_HI                                                                        0x00ad
#define regSDMA0_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA0_GFX_IB_SUB_REMAIN                                                                      0x00af
#define regSDMA0_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA0_GFX_PREEMPT                                                                            0x00b0
#define regSDMA0_GFX_PREEMPT_BASE_IDX                                                                   0
#define regSDMA0_GFX_DUMMY_REG                                                                          0x00b1
#define regSDMA0_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA0_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x00b2
#define regSDMA0_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA0_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x00b3
#define regSDMA0_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA0_GFX_RB_AQL_CNTL                                                                        0x00b4
#define regSDMA0_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA0_GFX_MINOR_PTR_UPDATE                                                                   0x00b5
#define regSDMA0_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA0_GFX_MIDCMD_DATA0                                                                       0x00c0
#define regSDMA0_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA1                                                                       0x00c1
#define regSDMA0_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA2                                                                       0x00c2
#define regSDMA0_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA3                                                                       0x00c3
#define regSDMA0_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA4                                                                       0x00c4
#define regSDMA0_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA5                                                                       0x00c5
#define regSDMA0_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA6                                                                       0x00c6
#define regSDMA0_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA7                                                                       0x00c7
#define regSDMA0_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA8                                                                       0x00c8
#define regSDMA0_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA9                                                                       0x00c9
#define regSDMA0_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA0_GFX_MIDCMD_DATA10                                                                      0x00ca
#define regSDMA0_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA0_GFX_MIDCMD_CNTL                                                                        0x00cb
#define regSDMA0_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA0_PAGE_RB_CNTL                                                                           0x00d8
#define regSDMA0_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_PAGE_RB_BASE                                                                           0x00d9
#define regSDMA0_PAGE_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_PAGE_RB_BASE_HI                                                                        0x00da
#define regSDMA0_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_PAGE_RB_RPTR                                                                           0x00db
#define regSDMA0_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_PAGE_RB_RPTR_HI                                                                        0x00dc
#define regSDMA0_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_PAGE_RB_WPTR                                                                           0x00dd
#define regSDMA0_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_PAGE_RB_WPTR_HI                                                                        0x00de
#define regSDMA0_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_PAGE_RB_WPTR_POLL_CNTL                                                                 0x00df
#define regSDMA0_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_PAGE_RB_RPTR_ADDR_HI                                                                   0x00e0
#define regSDMA0_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_PAGE_RB_RPTR_ADDR_LO                                                                   0x00e1
#define regSDMA0_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_PAGE_IB_CNTL                                                                           0x00e2
#define regSDMA0_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_PAGE_IB_RPTR                                                                           0x00e3
#define regSDMA0_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_PAGE_IB_OFFSET                                                                         0x00e4
#define regSDMA0_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_PAGE_IB_BASE_LO                                                                        0x00e5
#define regSDMA0_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_PAGE_IB_BASE_HI                                                                        0x00e6
#define regSDMA0_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_PAGE_IB_SIZE                                                                           0x00e7
#define regSDMA0_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_PAGE_SKIP_CNTL                                                                         0x00e8
#define regSDMA0_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_PAGE_CONTEXT_STATUS                                                                    0x00e9
#define regSDMA0_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_PAGE_DOORBELL                                                                          0x00ea
#define regSDMA0_PAGE_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_PAGE_STATUS                                                                            0x0100
#define regSDMA0_PAGE_STATUS_BASE_IDX                                                                   0
#define regSDMA0_PAGE_DOORBELL_LOG                                                                      0x0101
#define regSDMA0_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_PAGE_WATERMARK                                                                         0x0102
#define regSDMA0_PAGE_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_PAGE_DOORBELL_OFFSET                                                                   0x0103
#define regSDMA0_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_PAGE_CSA_ADDR_LO                                                                       0x0104
#define regSDMA0_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_PAGE_CSA_ADDR_HI                                                                       0x0105
#define regSDMA0_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_PAGE_IB_SUB_REMAIN                                                                     0x0107
#define regSDMA0_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_PAGE_PREEMPT                                                                           0x0108
#define regSDMA0_PAGE_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_PAGE_DUMMY_REG                                                                         0x0109
#define regSDMA0_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x010a
#define regSDMA0_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x010b
#define regSDMA0_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_PAGE_RB_AQL_CNTL                                                                       0x010c
#define regSDMA0_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_PAGE_MINOR_PTR_UPDATE                                                                  0x010d
#define regSDMA0_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_PAGE_MIDCMD_DATA0                                                                      0x0118
#define regSDMA0_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA1                                                                      0x0119
#define regSDMA0_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA2                                                                      0x011a
#define regSDMA0_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA3                                                                      0x011b
#define regSDMA0_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA4                                                                      0x011c
#define regSDMA0_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA5                                                                      0x011d
#define regSDMA0_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA6                                                                      0x011e
#define regSDMA0_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA7                                                                      0x011f
#define regSDMA0_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA8                                                                      0x0120
#define regSDMA0_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA9                                                                      0x0121
#define regSDMA0_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_PAGE_MIDCMD_DATA10                                                                     0x0122
#define regSDMA0_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_PAGE_MIDCMD_CNTL                                                                       0x0123
#define regSDMA0_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC0_RB_CNTL                                                                           0x0130
#define regSDMA0_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC0_RB_BASE                                                                           0x0131
#define regSDMA0_RLC0_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC0_RB_BASE_HI                                                                        0x0132
#define regSDMA0_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC0_RB_RPTR                                                                           0x0133
#define regSDMA0_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC0_RB_RPTR_HI                                                                        0x0134
#define regSDMA0_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC0_RB_WPTR                                                                           0x0135
#define regSDMA0_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC0_RB_WPTR_HI                                                                        0x0136
#define regSDMA0_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC0_RB_WPTR_POLL_CNTL                                                                 0x0137
#define regSDMA0_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC0_RB_RPTR_ADDR_HI                                                                   0x0138
#define regSDMA0_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC0_RB_RPTR_ADDR_LO                                                                   0x0139
#define regSDMA0_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC0_IB_CNTL                                                                           0x013a
#define regSDMA0_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC0_IB_RPTR                                                                           0x013b
#define regSDMA0_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC0_IB_OFFSET                                                                         0x013c
#define regSDMA0_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC0_IB_BASE_LO                                                                        0x013d
#define regSDMA0_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC0_IB_BASE_HI                                                                        0x013e
#define regSDMA0_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC0_IB_SIZE                                                                           0x013f
#define regSDMA0_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC0_SKIP_CNTL                                                                         0x0140
#define regSDMA0_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC0_CONTEXT_STATUS                                                                    0x0141
#define regSDMA0_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC0_DOORBELL                                                                          0x0142
#define regSDMA0_RLC0_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC0_STATUS                                                                            0x0158
#define regSDMA0_RLC0_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC0_DOORBELL_LOG                                                                      0x0159
#define regSDMA0_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC0_WATERMARK                                                                         0x015a
#define regSDMA0_RLC0_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC0_DOORBELL_OFFSET                                                                   0x015b
#define regSDMA0_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC0_CSA_ADDR_LO                                                                       0x015c
#define regSDMA0_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC0_CSA_ADDR_HI                                                                       0x015d
#define regSDMA0_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC0_IB_SUB_REMAIN                                                                     0x015f
#define regSDMA0_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC0_PREEMPT                                                                           0x0160
#define regSDMA0_RLC0_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC0_DUMMY_REG                                                                         0x0161
#define regSDMA0_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x0162
#define regSDMA0_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x0163
#define regSDMA0_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC0_RB_AQL_CNTL                                                                       0x0164
#define regSDMA0_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC0_MINOR_PTR_UPDATE                                                                  0x0165
#define regSDMA0_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC0_MIDCMD_DATA0                                                                      0x0170
#define regSDMA0_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA1                                                                      0x0171
#define regSDMA0_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA2                                                                      0x0172
#define regSDMA0_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA3                                                                      0x0173
#define regSDMA0_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA4                                                                      0x0174
#define regSDMA0_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA5                                                                      0x0175
#define regSDMA0_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA6                                                                      0x0176
#define regSDMA0_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA7                                                                      0x0177
#define regSDMA0_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA8                                                                      0x0178
#define regSDMA0_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA9                                                                      0x0179
#define regSDMA0_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC0_MIDCMD_DATA10                                                                     0x017a
#define regSDMA0_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC0_MIDCMD_CNTL                                                                       0x017b
#define regSDMA0_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC1_RB_CNTL                                                                           0x0188
#define regSDMA0_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC1_RB_BASE                                                                           0x0189
#define regSDMA0_RLC1_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC1_RB_BASE_HI                                                                        0x018a
#define regSDMA0_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC1_RB_RPTR                                                                           0x018b
#define regSDMA0_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC1_RB_RPTR_HI                                                                        0x018c
#define regSDMA0_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC1_RB_WPTR                                                                           0x018d
#define regSDMA0_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC1_RB_WPTR_HI                                                                        0x018e
#define regSDMA0_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC1_RB_WPTR_POLL_CNTL                                                                 0x018f
#define regSDMA0_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC1_RB_RPTR_ADDR_HI                                                                   0x0190
#define regSDMA0_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC1_RB_RPTR_ADDR_LO                                                                   0x0191
#define regSDMA0_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC1_IB_CNTL                                                                           0x0192
#define regSDMA0_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC1_IB_RPTR                                                                           0x0193
#define regSDMA0_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC1_IB_OFFSET                                                                         0x0194
#define regSDMA0_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC1_IB_BASE_LO                                                                        0x0195
#define regSDMA0_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC1_IB_BASE_HI                                                                        0x0196
#define regSDMA0_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC1_IB_SIZE                                                                           0x0197
#define regSDMA0_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC1_SKIP_CNTL                                                                         0x0198
#define regSDMA0_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC1_CONTEXT_STATUS                                                                    0x0199
#define regSDMA0_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC1_DOORBELL                                                                          0x019a
#define regSDMA0_RLC1_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC1_STATUS                                                                            0x01b0
#define regSDMA0_RLC1_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC1_DOORBELL_LOG                                                                      0x01b1
#define regSDMA0_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC1_WATERMARK                                                                         0x01b2
#define regSDMA0_RLC1_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC1_DOORBELL_OFFSET                                                                   0x01b3
#define regSDMA0_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC1_CSA_ADDR_LO                                                                       0x01b4
#define regSDMA0_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC1_CSA_ADDR_HI                                                                       0x01b5
#define regSDMA0_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC1_IB_SUB_REMAIN                                                                     0x01b7
#define regSDMA0_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC1_PREEMPT                                                                           0x01b8
#define regSDMA0_RLC1_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC1_DUMMY_REG                                                                         0x01b9
#define regSDMA0_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x01ba
#define regSDMA0_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x01bb
#define regSDMA0_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC1_RB_AQL_CNTL                                                                       0x01bc
#define regSDMA0_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC1_MINOR_PTR_UPDATE                                                                  0x01bd
#define regSDMA0_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC1_MIDCMD_DATA0                                                                      0x01c8
#define regSDMA0_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA1                                                                      0x01c9
#define regSDMA0_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA2                                                                      0x01ca
#define regSDMA0_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA3                                                                      0x01cb
#define regSDMA0_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA4                                                                      0x01cc
#define regSDMA0_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA5                                                                      0x01cd
#define regSDMA0_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA6                                                                      0x01ce
#define regSDMA0_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA7                                                                      0x01cf
#define regSDMA0_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA8                                                                      0x01d0
#define regSDMA0_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA9                                                                      0x01d1
#define regSDMA0_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC1_MIDCMD_DATA10                                                                     0x01d2
#define regSDMA0_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC1_MIDCMD_CNTL                                                                       0x01d3
#define regSDMA0_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC2_RB_CNTL                                                                           0x01e0
#define regSDMA0_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC2_RB_BASE                                                                           0x01e1
#define regSDMA0_RLC2_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC2_RB_BASE_HI                                                                        0x01e2
#define regSDMA0_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC2_RB_RPTR                                                                           0x01e3
#define regSDMA0_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC2_RB_RPTR_HI                                                                        0x01e4
#define regSDMA0_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC2_RB_WPTR                                                                           0x01e5
#define regSDMA0_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC2_RB_WPTR_HI                                                                        0x01e6
#define regSDMA0_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC2_RB_WPTR_POLL_CNTL                                                                 0x01e7
#define regSDMA0_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC2_RB_RPTR_ADDR_HI                                                                   0x01e8
#define regSDMA0_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC2_RB_RPTR_ADDR_LO                                                                   0x01e9
#define regSDMA0_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC2_IB_CNTL                                                                           0x01ea
#define regSDMA0_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC2_IB_RPTR                                                                           0x01eb
#define regSDMA0_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC2_IB_OFFSET                                                                         0x01ec
#define regSDMA0_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC2_IB_BASE_LO                                                                        0x01ed
#define regSDMA0_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC2_IB_BASE_HI                                                                        0x01ee
#define regSDMA0_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC2_IB_SIZE                                                                           0x01ef
#define regSDMA0_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC2_SKIP_CNTL                                                                         0x01f0
#define regSDMA0_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC2_CONTEXT_STATUS                                                                    0x01f1
#define regSDMA0_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC2_DOORBELL                                                                          0x01f2
#define regSDMA0_RLC2_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC2_STATUS                                                                            0x0208
#define regSDMA0_RLC2_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC2_DOORBELL_LOG                                                                      0x0209
#define regSDMA0_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC2_WATERMARK                                                                         0x020a
#define regSDMA0_RLC2_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC2_DOORBELL_OFFSET                                                                   0x020b
#define regSDMA0_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC2_CSA_ADDR_LO                                                                       0x020c
#define regSDMA0_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC2_CSA_ADDR_HI                                                                       0x020d
#define regSDMA0_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC2_IB_SUB_REMAIN                                                                     0x020f
#define regSDMA0_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC2_PREEMPT                                                                           0x0210
#define regSDMA0_RLC2_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC2_DUMMY_REG                                                                         0x0211
#define regSDMA0_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x0212
#define regSDMA0_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x0213
#define regSDMA0_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC2_RB_AQL_CNTL                                                                       0x0214
#define regSDMA0_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC2_MINOR_PTR_UPDATE                                                                  0x0215
#define regSDMA0_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC2_MIDCMD_DATA0                                                                      0x0220
#define regSDMA0_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA1                                                                      0x0221
#define regSDMA0_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA2                                                                      0x0222
#define regSDMA0_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA3                                                                      0x0223
#define regSDMA0_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA4                                                                      0x0224
#define regSDMA0_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA5                                                                      0x0225
#define regSDMA0_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA6                                                                      0x0226
#define regSDMA0_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA7                                                                      0x0227
#define regSDMA0_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA8                                                                      0x0228
#define regSDMA0_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA9                                                                      0x0229
#define regSDMA0_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC2_MIDCMD_DATA10                                                                     0x022a
#define regSDMA0_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC2_MIDCMD_CNTL                                                                       0x022b
#define regSDMA0_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC3_RB_CNTL                                                                           0x0238
#define regSDMA0_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC3_RB_BASE                                                                           0x0239
#define regSDMA0_RLC3_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC3_RB_BASE_HI                                                                        0x023a
#define regSDMA0_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC3_RB_RPTR                                                                           0x023b
#define regSDMA0_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC3_RB_RPTR_HI                                                                        0x023c
#define regSDMA0_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC3_RB_WPTR                                                                           0x023d
#define regSDMA0_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC3_RB_WPTR_HI                                                                        0x023e
#define regSDMA0_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC3_RB_WPTR_POLL_CNTL                                                                 0x023f
#define regSDMA0_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC3_RB_RPTR_ADDR_HI                                                                   0x0240
#define regSDMA0_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC3_RB_RPTR_ADDR_LO                                                                   0x0241
#define regSDMA0_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC3_IB_CNTL                                                                           0x0242
#define regSDMA0_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC3_IB_RPTR                                                                           0x0243
#define regSDMA0_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC3_IB_OFFSET                                                                         0x0244
#define regSDMA0_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC3_IB_BASE_LO                                                                        0x0245
#define regSDMA0_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC3_IB_BASE_HI                                                                        0x0246
#define regSDMA0_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC3_IB_SIZE                                                                           0x0247
#define regSDMA0_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC3_SKIP_CNTL                                                                         0x0248
#define regSDMA0_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC3_CONTEXT_STATUS                                                                    0x0249
#define regSDMA0_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC3_DOORBELL                                                                          0x024a
#define regSDMA0_RLC3_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC3_STATUS                                                                            0x0260
#define regSDMA0_RLC3_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC3_DOORBELL_LOG                                                                      0x0261
#define regSDMA0_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC3_WATERMARK                                                                         0x0262
#define regSDMA0_RLC3_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC3_DOORBELL_OFFSET                                                                   0x0263
#define regSDMA0_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC3_CSA_ADDR_LO                                                                       0x0264
#define regSDMA0_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC3_CSA_ADDR_HI                                                                       0x0265
#define regSDMA0_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC3_IB_SUB_REMAIN                                                                     0x0267
#define regSDMA0_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC3_PREEMPT                                                                           0x0268
#define regSDMA0_RLC3_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC3_DUMMY_REG                                                                         0x0269
#define regSDMA0_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x026a
#define regSDMA0_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x026b
#define regSDMA0_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC3_RB_AQL_CNTL                                                                       0x026c
#define regSDMA0_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC3_MINOR_PTR_UPDATE                                                                  0x026d
#define regSDMA0_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC3_MIDCMD_DATA0                                                                      0x0278
#define regSDMA0_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA1                                                                      0x0279
#define regSDMA0_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA2                                                                      0x027a
#define regSDMA0_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA3                                                                      0x027b
#define regSDMA0_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA4                                                                      0x027c
#define regSDMA0_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA5                                                                      0x027d
#define regSDMA0_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA6                                                                      0x027e
#define regSDMA0_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA7                                                                      0x027f
#define regSDMA0_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA8                                                                      0x0280
#define regSDMA0_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA9                                                                      0x0281
#define regSDMA0_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC3_MIDCMD_DATA10                                                                     0x0282
#define regSDMA0_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC3_MIDCMD_CNTL                                                                       0x0283
#define regSDMA0_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC4_RB_CNTL                                                                           0x0290
#define regSDMA0_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC4_RB_BASE                                                                           0x0291
#define regSDMA0_RLC4_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC4_RB_BASE_HI                                                                        0x0292
#define regSDMA0_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC4_RB_RPTR                                                                           0x0293
#define regSDMA0_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC4_RB_RPTR_HI                                                                        0x0294
#define regSDMA0_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC4_RB_WPTR                                                                           0x0295
#define regSDMA0_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC4_RB_WPTR_HI                                                                        0x0296
#define regSDMA0_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC4_RB_WPTR_POLL_CNTL                                                                 0x0297
#define regSDMA0_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC4_RB_RPTR_ADDR_HI                                                                   0x0298
#define regSDMA0_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC4_RB_RPTR_ADDR_LO                                                                   0x0299
#define regSDMA0_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC4_IB_CNTL                                                                           0x029a
#define regSDMA0_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC4_IB_RPTR                                                                           0x029b
#define regSDMA0_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC4_IB_OFFSET                                                                         0x029c
#define regSDMA0_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC4_IB_BASE_LO                                                                        0x029d
#define regSDMA0_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC4_IB_BASE_HI                                                                        0x029e
#define regSDMA0_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC4_IB_SIZE                                                                           0x029f
#define regSDMA0_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC4_SKIP_CNTL                                                                         0x02a0
#define regSDMA0_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC4_CONTEXT_STATUS                                                                    0x02a1
#define regSDMA0_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC4_DOORBELL                                                                          0x02a2
#define regSDMA0_RLC4_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC4_STATUS                                                                            0x02b8
#define regSDMA0_RLC4_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC4_DOORBELL_LOG                                                                      0x02b9
#define regSDMA0_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC4_WATERMARK                                                                         0x02ba
#define regSDMA0_RLC4_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC4_DOORBELL_OFFSET                                                                   0x02bb
#define regSDMA0_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC4_CSA_ADDR_LO                                                                       0x02bc
#define regSDMA0_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC4_CSA_ADDR_HI                                                                       0x02bd
#define regSDMA0_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC4_IB_SUB_REMAIN                                                                     0x02bf
#define regSDMA0_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC4_PREEMPT                                                                           0x02c0
#define regSDMA0_RLC4_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC4_DUMMY_REG                                                                         0x02c1
#define regSDMA0_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x02c2
#define regSDMA0_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x02c3
#define regSDMA0_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC4_RB_AQL_CNTL                                                                       0x02c4
#define regSDMA0_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC4_MINOR_PTR_UPDATE                                                                  0x02c5
#define regSDMA0_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC4_MIDCMD_DATA0                                                                      0x02d0
#define regSDMA0_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA1                                                                      0x02d1
#define regSDMA0_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA2                                                                      0x02d2
#define regSDMA0_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA3                                                                      0x02d3
#define regSDMA0_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA4                                                                      0x02d4
#define regSDMA0_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA5                                                                      0x02d5
#define regSDMA0_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA6                                                                      0x02d6
#define regSDMA0_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA7                                                                      0x02d7
#define regSDMA0_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA8                                                                      0x02d8
#define regSDMA0_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA9                                                                      0x02d9
#define regSDMA0_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC4_MIDCMD_DATA10                                                                     0x02da
#define regSDMA0_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC4_MIDCMD_CNTL                                                                       0x02db
#define regSDMA0_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC5_RB_CNTL                                                                           0x02e8
#define regSDMA0_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC5_RB_BASE                                                                           0x02e9
#define regSDMA0_RLC5_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC5_RB_BASE_HI                                                                        0x02ea
#define regSDMA0_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC5_RB_RPTR                                                                           0x02eb
#define regSDMA0_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC5_RB_RPTR_HI                                                                        0x02ec
#define regSDMA0_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC5_RB_WPTR                                                                           0x02ed
#define regSDMA0_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC5_RB_WPTR_HI                                                                        0x02ee
#define regSDMA0_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC5_RB_WPTR_POLL_CNTL                                                                 0x02ef
#define regSDMA0_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC5_RB_RPTR_ADDR_HI                                                                   0x02f0
#define regSDMA0_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC5_RB_RPTR_ADDR_LO                                                                   0x02f1
#define regSDMA0_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC5_IB_CNTL                                                                           0x02f2
#define regSDMA0_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC5_IB_RPTR                                                                           0x02f3
#define regSDMA0_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC5_IB_OFFSET                                                                         0x02f4
#define regSDMA0_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC5_IB_BASE_LO                                                                        0x02f5
#define regSDMA0_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC5_IB_BASE_HI                                                                        0x02f6
#define regSDMA0_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC5_IB_SIZE                                                                           0x02f7
#define regSDMA0_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC5_SKIP_CNTL                                                                         0x02f8
#define regSDMA0_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC5_CONTEXT_STATUS                                                                    0x02f9
#define regSDMA0_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC5_DOORBELL                                                                          0x02fa
#define regSDMA0_RLC5_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC5_STATUS                                                                            0x0310
#define regSDMA0_RLC5_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC5_DOORBELL_LOG                                                                      0x0311
#define regSDMA0_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC5_WATERMARK                                                                         0x0312
#define regSDMA0_RLC5_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC5_DOORBELL_OFFSET                                                                   0x0313
#define regSDMA0_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC5_CSA_ADDR_LO                                                                       0x0314
#define regSDMA0_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC5_CSA_ADDR_HI                                                                       0x0315
#define regSDMA0_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC5_IB_SUB_REMAIN                                                                     0x0317
#define regSDMA0_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC5_PREEMPT                                                                           0x0318
#define regSDMA0_RLC5_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC5_DUMMY_REG                                                                         0x0319
#define regSDMA0_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x031a
#define regSDMA0_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x031b
#define regSDMA0_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC5_RB_AQL_CNTL                                                                       0x031c
#define regSDMA0_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC5_MINOR_PTR_UPDATE                                                                  0x031d
#define regSDMA0_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC5_MIDCMD_DATA0                                                                      0x0328
#define regSDMA0_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA1                                                                      0x0329
#define regSDMA0_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA2                                                                      0x032a
#define regSDMA0_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA3                                                                      0x032b
#define regSDMA0_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA4                                                                      0x032c
#define regSDMA0_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA5                                                                      0x032d
#define regSDMA0_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA6                                                                      0x032e
#define regSDMA0_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA7                                                                      0x032f
#define regSDMA0_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA8                                                                      0x0330
#define regSDMA0_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA9                                                                      0x0331
#define regSDMA0_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC5_MIDCMD_DATA10                                                                     0x0332
#define regSDMA0_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC5_MIDCMD_CNTL                                                                       0x0333
#define regSDMA0_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC6_RB_CNTL                                                                           0x0340
#define regSDMA0_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC6_RB_BASE                                                                           0x0341
#define regSDMA0_RLC6_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC6_RB_BASE_HI                                                                        0x0342
#define regSDMA0_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC6_RB_RPTR                                                                           0x0343
#define regSDMA0_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC6_RB_RPTR_HI                                                                        0x0344
#define regSDMA0_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC6_RB_WPTR                                                                           0x0345
#define regSDMA0_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC6_RB_WPTR_HI                                                                        0x0346
#define regSDMA0_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC6_RB_WPTR_POLL_CNTL                                                                 0x0347
#define regSDMA0_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC6_RB_RPTR_ADDR_HI                                                                   0x0348
#define regSDMA0_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC6_RB_RPTR_ADDR_LO                                                                   0x0349
#define regSDMA0_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC6_IB_CNTL                                                                           0x034a
#define regSDMA0_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC6_IB_RPTR                                                                           0x034b
#define regSDMA0_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC6_IB_OFFSET                                                                         0x034c
#define regSDMA0_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC6_IB_BASE_LO                                                                        0x034d
#define regSDMA0_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC6_IB_BASE_HI                                                                        0x034e
#define regSDMA0_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC6_IB_SIZE                                                                           0x034f
#define regSDMA0_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC6_SKIP_CNTL                                                                         0x0350
#define regSDMA0_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC6_CONTEXT_STATUS                                                                    0x0351
#define regSDMA0_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC6_DOORBELL                                                                          0x0352
#define regSDMA0_RLC6_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC6_STATUS                                                                            0x0368
#define regSDMA0_RLC6_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC6_DOORBELL_LOG                                                                      0x0369
#define regSDMA0_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC6_WATERMARK                                                                         0x036a
#define regSDMA0_RLC6_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC6_DOORBELL_OFFSET                                                                   0x036b
#define regSDMA0_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC6_CSA_ADDR_LO                                                                       0x036c
#define regSDMA0_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC6_CSA_ADDR_HI                                                                       0x036d
#define regSDMA0_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC6_IB_SUB_REMAIN                                                                     0x036f
#define regSDMA0_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC6_PREEMPT                                                                           0x0370
#define regSDMA0_RLC6_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC6_DUMMY_REG                                                                         0x0371
#define regSDMA0_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x0372
#define regSDMA0_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x0373
#define regSDMA0_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC6_RB_AQL_CNTL                                                                       0x0374
#define regSDMA0_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC6_MINOR_PTR_UPDATE                                                                  0x0375
#define regSDMA0_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC6_MIDCMD_DATA0                                                                      0x0380
#define regSDMA0_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA1                                                                      0x0381
#define regSDMA0_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA2                                                                      0x0382
#define regSDMA0_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA3                                                                      0x0383
#define regSDMA0_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA4                                                                      0x0384
#define regSDMA0_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA5                                                                      0x0385
#define regSDMA0_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA6                                                                      0x0386
#define regSDMA0_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA7                                                                      0x0387
#define regSDMA0_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA8                                                                      0x0388
#define regSDMA0_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA9                                                                      0x0389
#define regSDMA0_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC6_MIDCMD_DATA10                                                                     0x038a
#define regSDMA0_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC6_MIDCMD_CNTL                                                                       0x038b
#define regSDMA0_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC7_RB_CNTL                                                                           0x0398
#define regSDMA0_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC7_RB_BASE                                                                           0x0399
#define regSDMA0_RLC7_RB_BASE_BASE_IDX                                                                  0
#define regSDMA0_RLC7_RB_BASE_HI                                                                        0x039a
#define regSDMA0_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC7_RB_RPTR                                                                           0x039b
#define regSDMA0_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC7_RB_RPTR_HI                                                                        0x039c
#define regSDMA0_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC7_RB_WPTR                                                                           0x039d
#define regSDMA0_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC7_RB_WPTR_HI                                                                        0x039e
#define regSDMA0_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA0_RLC7_RB_WPTR_POLL_CNTL                                                                 0x039f
#define regSDMA0_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA0_RLC7_RB_RPTR_ADDR_HI                                                                   0x03a0
#define regSDMA0_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA0_RLC7_RB_RPTR_ADDR_LO                                                                   0x03a1
#define regSDMA0_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA0_RLC7_IB_CNTL                                                                           0x03a2
#define regSDMA0_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA0_RLC7_IB_RPTR                                                                           0x03a3
#define regSDMA0_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA0_RLC7_IB_OFFSET                                                                         0x03a4
#define regSDMA0_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA0_RLC7_IB_BASE_LO                                                                        0x03a5
#define regSDMA0_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA0_RLC7_IB_BASE_HI                                                                        0x03a6
#define regSDMA0_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA0_RLC7_IB_SIZE                                                                           0x03a7
#define regSDMA0_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA0_RLC7_SKIP_CNTL                                                                         0x03a8
#define regSDMA0_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA0_RLC7_CONTEXT_STATUS                                                                    0x03a9
#define regSDMA0_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA0_RLC7_DOORBELL                                                                          0x03aa
#define regSDMA0_RLC7_DOORBELL_BASE_IDX                                                                 0
#define regSDMA0_RLC7_STATUS                                                                            0x03c0
#define regSDMA0_RLC7_STATUS_BASE_IDX                                                                   0
#define regSDMA0_RLC7_DOORBELL_LOG                                                                      0x03c1
#define regSDMA0_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA0_RLC7_WATERMARK                                                                         0x03c2
#define regSDMA0_RLC7_WATERMARK_BASE_IDX                                                                0
#define regSDMA0_RLC7_DOORBELL_OFFSET                                                                   0x03c3
#define regSDMA0_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA0_RLC7_CSA_ADDR_LO                                                                       0x03c4
#define regSDMA0_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA0_RLC7_CSA_ADDR_HI                                                                       0x03c5
#define regSDMA0_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA0_RLC7_IB_SUB_REMAIN                                                                     0x03c7
#define regSDMA0_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA0_RLC7_PREEMPT                                                                           0x03c8
#define regSDMA0_RLC7_PREEMPT_BASE_IDX                                                                  0
#define regSDMA0_RLC7_DUMMY_REG                                                                         0x03c9
#define regSDMA0_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA0_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x03ca
#define regSDMA0_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA0_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x03cb
#define regSDMA0_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA0_RLC7_RB_AQL_CNTL                                                                       0x03cc
#define regSDMA0_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA0_RLC7_MINOR_PTR_UPDATE                                                                  0x03cd
#define regSDMA0_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA0_RLC7_MIDCMD_DATA0                                                                      0x03d8
#define regSDMA0_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA1                                                                      0x03d9
#define regSDMA0_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA2                                                                      0x03da
#define regSDMA0_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA3                                                                      0x03db
#define regSDMA0_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA4                                                                      0x03dc
#define regSDMA0_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA5                                                                      0x03dd
#define regSDMA0_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA6                                                                      0x03de
#define regSDMA0_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA7                                                                      0x03df
#define regSDMA0_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA8                                                                      0x03e0
#define regSDMA0_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA9                                                                      0x03e1
#define regSDMA0_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA0_RLC7_MIDCMD_DATA10                                                                     0x03e2
#define regSDMA0_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA0_RLC7_MIDCMD_CNTL                                                                       0x03e3
#define regSDMA0_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0


// addressBlock: sdma0_sdma1dec
// base address: 0x6180
#define regSDMA1_UCODE_ADDR                                                                             0x0600
#define regSDMA1_UCODE_ADDR_BASE_IDX                                                                    0
#define regSDMA1_UCODE_DATA                                                                             0x0601
#define regSDMA1_UCODE_DATA_BASE_IDX                                                                    0
#define regSDMA1_VF_ENABLE                                                                              0x060a
#define regSDMA1_VF_ENABLE_BASE_IDX                                                                     0
#define regSDMA1_CONTEXT_GROUP_BOUNDARY                                                                 0x0619
#define regSDMA1_CONTEXT_GROUP_BOUNDARY_BASE_IDX                                                        0
#define regSDMA1_POWER_CNTL                                                                             0x061a
#define regSDMA1_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA1_CLK_CTRL                                                                               0x061b
#define regSDMA1_CLK_CTRL_BASE_IDX                                                                      0
#define regSDMA1_CNTL                                                                                   0x061c
#define regSDMA1_CNTL_BASE_IDX                                                                          0
#define regSDMA1_CHICKEN_BITS                                                                           0x061d
#define regSDMA1_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA1_GB_ADDR_CONFIG                                                                         0x061e
#define regSDMA1_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define regSDMA1_GB_ADDR_CONFIG_READ                                                                    0x061f
#define regSDMA1_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define regSDMA1_RB_RPTR_FETCH_HI                                                                       0x0620
#define regSDMA1_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA1_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x0621
#define regSDMA1_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define regSDMA1_RB_RPTR_FETCH                                                                          0x0622
#define regSDMA1_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA1_IB_OFFSET_FETCH                                                                        0x0623
#define regSDMA1_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA1_PROGRAM                                                                                0x0624
#define regSDMA1_PROGRAM_BASE_IDX                                                                       0
#define regSDMA1_STATUS_REG                                                                             0x0625
#define regSDMA1_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA1_STATUS1_REG                                                                            0x0626
#define regSDMA1_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA1_RD_BURST_CNTL                                                                          0x0627
#define regSDMA1_RD_BURST_CNTL_BASE_IDX                                                                 0
#define regSDMA1_HBM_PAGE_CONFIG                                                                        0x0628
#define regSDMA1_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA1_UCODE_CHECKSUM                                                                         0x0629
#define regSDMA1_UCODE_CHECKSUM_BASE_IDX                                                                0
#define regSDMA1_F32_CNTL                                                                               0x062a
#define regSDMA1_F32_CNTL_BASE_IDX                                                                      0
#define regSDMA1_FREEZE                                                                                 0x062b
#define regSDMA1_FREEZE_BASE_IDX                                                                        0
#define regSDMA1_PHASE0_QUANTUM                                                                         0x062c
#define regSDMA1_PHASE0_QUANTUM_BASE_IDX                                                                0
#define regSDMA1_PHASE1_QUANTUM                                                                         0x062d
#define regSDMA1_PHASE1_QUANTUM_BASE_IDX                                                                0
#define regCC_SDMA1_EDC_CONFIG                                                                          0x0632
#define regCC_SDMA1_EDC_CONFIG_BASE_IDX                                                                 0
#define regSDMA1_BA_THRESHOLD                                                                           0x0633
#define regSDMA1_BA_THRESHOLD_BASE_IDX                                                                  0
#define regSDMA1_ID                                                                                     0x0634
#define regSDMA1_ID_BASE_IDX                                                                            0
#define regSDMA1_VERSION                                                                                0x0635
#define regSDMA1_VERSION_BASE_IDX                                                                       0
#define regSDMA1_EDC_COUNTER                                                                            0x0636
#define regSDMA1_EDC_COUNTER_BASE_IDX                                                                   0
#define regSDMA1_EDC_COUNTER2                                                                           0x0637
#define regSDMA1_EDC_COUNTER2_BASE_IDX                                                                  0
#define regSDMA1_STATUS2_REG                                                                            0x0638
#define regSDMA1_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA1_ATOMIC_CNTL                                                                            0x0639
#define regSDMA1_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA1_ATOMIC_PREOP_LO                                                                        0x063a
#define regSDMA1_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA1_ATOMIC_PREOP_HI                                                                        0x063b
#define regSDMA1_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA1_UTCL1_CNTL                                                                             0x063c
#define regSDMA1_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_WATERMK                                                                          0x063d
#define regSDMA1_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA1_UTCL1_RD_STATUS                                                                        0x063e
#define regSDMA1_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA1_UTCL1_WR_STATUS                                                                        0x063f
#define regSDMA1_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA1_UTCL1_INV0                                                                             0x0640
#define regSDMA1_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_INV1                                                                             0x0641
#define regSDMA1_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_INV2                                                                             0x0642
#define regSDMA1_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_RD_XNACK0                                                                        0x0643
#define regSDMA1_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA1_UTCL1_RD_XNACK1                                                                        0x0644
#define regSDMA1_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA1_UTCL1_WR_XNACK0                                                                        0x0645
#define regSDMA1_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA1_UTCL1_WR_XNACK1                                                                        0x0646
#define regSDMA1_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA1_UTCL1_TIMEOUT                                                                          0x0647
#define regSDMA1_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA1_UTCL1_PAGE                                                                             0x0648
#define regSDMA1_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA1_POWER_CNTL_IDLE                                                                        0x0649
#define regSDMA1_POWER_CNTL_IDLE_BASE_IDX                                                               0
#define regSDMA1_RELAX_ORDERING_LUT                                                                     0x064a
#define regSDMA1_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA1_CHICKEN_BITS_2                                                                         0x064b
#define regSDMA1_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA1_STATUS3_REG                                                                            0x064c
#define regSDMA1_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA1_PHYSICAL_ADDR_LO                                                                       0x064d
#define regSDMA1_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_PHYSICAL_ADDR_HI                                                                       0x064e
#define regSDMA1_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_PHASE2_QUANTUM                                                                         0x064f
#define regSDMA1_PHASE2_QUANTUM_BASE_IDX                                                                0
#define regSDMA1_ERROR_LOG                                                                              0x0650
#define regSDMA1_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA1_PUB_DUMMY_REG0                                                                         0x0651
#define regSDMA1_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA1_PUB_DUMMY_REG1                                                                         0x0652
#define regSDMA1_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA1_PUB_DUMMY_REG2                                                                         0x0653
#define regSDMA1_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA1_PUB_DUMMY_REG3                                                                         0x0654
#define regSDMA1_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA1_F32_COUNTER                                                                            0x0655
#define regSDMA1_F32_COUNTER_BASE_IDX                                                                   0
#define regSDMA1_PERFCNT_PERFCOUNTER0_CFG                                                               0x0657
#define regSDMA1_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      0
#define regSDMA1_PERFCNT_PERFCOUNTER1_CFG                                                               0x0658
#define regSDMA1_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      0
#define regSDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x0659
#define regSDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 0
#define regSDMA1_PERFCNT_MISC_CNTL                                                                      0x065a
#define regSDMA1_PERFCNT_MISC_CNTL_BASE_IDX                                                             0
#define regSDMA1_PERFCNT_PERFCOUNTER_LO                                                                 0x065b
#define regSDMA1_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        0
#define regSDMA1_PERFCNT_PERFCOUNTER_HI                                                                 0x065c
#define regSDMA1_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        0
#define regSDMA1_CRD_CNTL                                                                               0x065d
#define regSDMA1_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA1_ULV_CNTL                                                                               0x065f
#define regSDMA1_ULV_CNTL_BASE_IDX                                                                      0
#define regSDMA1_EA_DBIT_ADDR_DATA                                                                      0x0660
#define regSDMA1_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define regSDMA1_EA_DBIT_ADDR_INDEX                                                                     0x0661
#define regSDMA1_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define regSDMA1_STATUS4_REG                                                                            0x0663
#define regSDMA1_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA1_SCRATCH_RAM_DATA                                                                       0x0664
#define regSDMA1_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA1_SCRATCH_RAM_ADDR                                                                       0x0665
#define regSDMA1_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA1_CE_CTRL                                                                                0x0666
#define regSDMA1_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA1_RAS_STATUS                                                                             0x0667
#define regSDMA1_RAS_STATUS_BASE_IDX                                                                    0
#define regSDMA1_CLK_STATUS                                                                             0x0668
#define regSDMA1_CLK_STATUS_BASE_IDX                                                                    0
#define regSDMA1_GFX_RB_CNTL                                                                            0x0680
#define regSDMA1_GFX_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA1_GFX_RB_BASE                                                                            0x0681
#define regSDMA1_GFX_RB_BASE_BASE_IDX                                                                   0
#define regSDMA1_GFX_RB_BASE_HI                                                                         0x0682
#define regSDMA1_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA1_GFX_RB_RPTR                                                                            0x0683
#define regSDMA1_GFX_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA1_GFX_RB_RPTR_HI                                                                         0x0684
#define regSDMA1_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA1_GFX_RB_WPTR                                                                            0x0685
#define regSDMA1_GFX_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA1_GFX_RB_WPTR_HI                                                                         0x0686
#define regSDMA1_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA1_GFX_RB_WPTR_POLL_CNTL                                                                  0x0687
#define regSDMA1_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA1_GFX_RB_RPTR_ADDR_HI                                                                    0x0688
#define regSDMA1_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA1_GFX_RB_RPTR_ADDR_LO                                                                    0x0689
#define regSDMA1_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA1_GFX_IB_CNTL                                                                            0x068a
#define regSDMA1_GFX_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA1_GFX_IB_RPTR                                                                            0x068b
#define regSDMA1_GFX_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA1_GFX_IB_OFFSET                                                                          0x068c
#define regSDMA1_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA1_GFX_IB_BASE_LO                                                                         0x068d
#define regSDMA1_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA1_GFX_IB_BASE_HI                                                                         0x068e
#define regSDMA1_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA1_GFX_IB_SIZE                                                                            0x068f
#define regSDMA1_GFX_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA1_GFX_SKIP_CNTL                                                                          0x0690
#define regSDMA1_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA1_GFX_CONTEXT_STATUS                                                                     0x0691
#define regSDMA1_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA1_GFX_DOORBELL                                                                           0x0692
#define regSDMA1_GFX_DOORBELL_BASE_IDX                                                                  0
#define regSDMA1_GFX_CONTEXT_CNTL                                                                       0x0693
#define regSDMA1_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define regSDMA1_GFX_STATUS                                                                             0x06a8
#define regSDMA1_GFX_STATUS_BASE_IDX                                                                    0
#define regSDMA1_GFX_DOORBELL_LOG                                                                       0x06a9
#define regSDMA1_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA1_GFX_WATERMARK                                                                          0x06aa
#define regSDMA1_GFX_WATERMARK_BASE_IDX                                                                 0
#define regSDMA1_GFX_DOORBELL_OFFSET                                                                    0x06ab
#define regSDMA1_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA1_GFX_CSA_ADDR_LO                                                                        0x06ac
#define regSDMA1_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA1_GFX_CSA_ADDR_HI                                                                        0x06ad
#define regSDMA1_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA1_GFX_IB_SUB_REMAIN                                                                      0x06af
#define regSDMA1_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA1_GFX_PREEMPT                                                                            0x06b0
#define regSDMA1_GFX_PREEMPT_BASE_IDX                                                                   0
#define regSDMA1_GFX_DUMMY_REG                                                                          0x06b1
#define regSDMA1_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA1_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x06b2
#define regSDMA1_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA1_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x06b3
#define regSDMA1_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA1_GFX_RB_AQL_CNTL                                                                        0x06b4
#define regSDMA1_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA1_GFX_MINOR_PTR_UPDATE                                                                   0x06b5
#define regSDMA1_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA1_GFX_MIDCMD_DATA0                                                                       0x06c0
#define regSDMA1_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA1                                                                       0x06c1
#define regSDMA1_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA2                                                                       0x06c2
#define regSDMA1_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA3                                                                       0x06c3
#define regSDMA1_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA4                                                                       0x06c4
#define regSDMA1_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA5                                                                       0x06c5
#define regSDMA1_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA6                                                                       0x06c6
#define regSDMA1_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA7                                                                       0x06c7
#define regSDMA1_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA8                                                                       0x06c8
#define regSDMA1_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA9                                                                       0x06c9
#define regSDMA1_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA1_GFX_MIDCMD_DATA10                                                                      0x06ca
#define regSDMA1_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA1_GFX_MIDCMD_CNTL                                                                        0x06cb
#define regSDMA1_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA1_PAGE_RB_CNTL                                                                           0x06d8
#define regSDMA1_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_PAGE_RB_BASE                                                                           0x06d9
#define regSDMA1_PAGE_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_PAGE_RB_BASE_HI                                                                        0x06da
#define regSDMA1_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_PAGE_RB_RPTR                                                                           0x06db
#define regSDMA1_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_PAGE_RB_RPTR_HI                                                                        0x06dc
#define regSDMA1_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_PAGE_RB_WPTR                                                                           0x06dd
#define regSDMA1_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_PAGE_RB_WPTR_HI                                                                        0x06de
#define regSDMA1_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_PAGE_RB_WPTR_POLL_CNTL                                                                 0x06df
#define regSDMA1_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_PAGE_RB_RPTR_ADDR_HI                                                                   0x06e0
#define regSDMA1_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_PAGE_RB_RPTR_ADDR_LO                                                                   0x06e1
#define regSDMA1_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_PAGE_IB_CNTL                                                                           0x06e2
#define regSDMA1_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_PAGE_IB_RPTR                                                                           0x06e3
#define regSDMA1_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_PAGE_IB_OFFSET                                                                         0x06e4
#define regSDMA1_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_PAGE_IB_BASE_LO                                                                        0x06e5
#define regSDMA1_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_PAGE_IB_BASE_HI                                                                        0x06e6
#define regSDMA1_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_PAGE_IB_SIZE                                                                           0x06e7
#define regSDMA1_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_PAGE_SKIP_CNTL                                                                         0x06e8
#define regSDMA1_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_PAGE_CONTEXT_STATUS                                                                    0x06e9
#define regSDMA1_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_PAGE_DOORBELL                                                                          0x06ea
#define regSDMA1_PAGE_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_PAGE_STATUS                                                                            0x0700
#define regSDMA1_PAGE_STATUS_BASE_IDX                                                                   0
#define regSDMA1_PAGE_DOORBELL_LOG                                                                      0x0701
#define regSDMA1_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_PAGE_WATERMARK                                                                         0x0702
#define regSDMA1_PAGE_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_PAGE_DOORBELL_OFFSET                                                                   0x0703
#define regSDMA1_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_PAGE_CSA_ADDR_LO                                                                       0x0704
#define regSDMA1_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_PAGE_CSA_ADDR_HI                                                                       0x0705
#define regSDMA1_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_PAGE_IB_SUB_REMAIN                                                                     0x0707
#define regSDMA1_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_PAGE_PREEMPT                                                                           0x0708
#define regSDMA1_PAGE_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_PAGE_DUMMY_REG                                                                         0x0709
#define regSDMA1_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x070a
#define regSDMA1_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x070b
#define regSDMA1_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_PAGE_RB_AQL_CNTL                                                                       0x070c
#define regSDMA1_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_PAGE_MINOR_PTR_UPDATE                                                                  0x070d
#define regSDMA1_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_PAGE_MIDCMD_DATA0                                                                      0x0718
#define regSDMA1_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA1                                                                      0x0719
#define regSDMA1_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA2                                                                      0x071a
#define regSDMA1_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA3                                                                      0x071b
#define regSDMA1_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA4                                                                      0x071c
#define regSDMA1_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA5                                                                      0x071d
#define regSDMA1_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA6                                                                      0x071e
#define regSDMA1_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA7                                                                      0x071f
#define regSDMA1_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA8                                                                      0x0720
#define regSDMA1_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA9                                                                      0x0721
#define regSDMA1_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_PAGE_MIDCMD_DATA10                                                                     0x0722
#define regSDMA1_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_PAGE_MIDCMD_CNTL                                                                       0x0723
#define regSDMA1_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC0_RB_CNTL                                                                           0x0730
#define regSDMA1_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC0_RB_BASE                                                                           0x0731
#define regSDMA1_RLC0_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC0_RB_BASE_HI                                                                        0x0732
#define regSDMA1_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC0_RB_RPTR                                                                           0x0733
#define regSDMA1_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC0_RB_RPTR_HI                                                                        0x0734
#define regSDMA1_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC0_RB_WPTR                                                                           0x0735
#define regSDMA1_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC0_RB_WPTR_HI                                                                        0x0736
#define regSDMA1_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC0_RB_WPTR_POLL_CNTL                                                                 0x0737
#define regSDMA1_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC0_RB_RPTR_ADDR_HI                                                                   0x0738
#define regSDMA1_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC0_RB_RPTR_ADDR_LO                                                                   0x0739
#define regSDMA1_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC0_IB_CNTL                                                                           0x073a
#define regSDMA1_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC0_IB_RPTR                                                                           0x073b
#define regSDMA1_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC0_IB_OFFSET                                                                         0x073c
#define regSDMA1_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC0_IB_BASE_LO                                                                        0x073d
#define regSDMA1_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC0_IB_BASE_HI                                                                        0x073e
#define regSDMA1_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC0_IB_SIZE                                                                           0x073f
#define regSDMA1_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC0_SKIP_CNTL                                                                         0x0740
#define regSDMA1_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC0_CONTEXT_STATUS                                                                    0x0741
#define regSDMA1_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC0_DOORBELL                                                                          0x0742
#define regSDMA1_RLC0_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC0_STATUS                                                                            0x0758
#define regSDMA1_RLC0_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC0_DOORBELL_LOG                                                                      0x0759
#define regSDMA1_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC0_WATERMARK                                                                         0x075a
#define regSDMA1_RLC0_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC0_DOORBELL_OFFSET                                                                   0x075b
#define regSDMA1_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC0_CSA_ADDR_LO                                                                       0x075c
#define regSDMA1_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC0_CSA_ADDR_HI                                                                       0x075d
#define regSDMA1_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC0_IB_SUB_REMAIN                                                                     0x075f
#define regSDMA1_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC0_PREEMPT                                                                           0x0760
#define regSDMA1_RLC0_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC0_DUMMY_REG                                                                         0x0761
#define regSDMA1_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x0762
#define regSDMA1_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x0763
#define regSDMA1_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC0_RB_AQL_CNTL                                                                       0x0764
#define regSDMA1_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC0_MINOR_PTR_UPDATE                                                                  0x0765
#define regSDMA1_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC0_MIDCMD_DATA0                                                                      0x0770
#define regSDMA1_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA1                                                                      0x0771
#define regSDMA1_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA2                                                                      0x0772
#define regSDMA1_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA3                                                                      0x0773
#define regSDMA1_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA4                                                                      0x0774
#define regSDMA1_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA5                                                                      0x0775
#define regSDMA1_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA6                                                                      0x0776
#define regSDMA1_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA7                                                                      0x0777
#define regSDMA1_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA8                                                                      0x0778
#define regSDMA1_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA9                                                                      0x0779
#define regSDMA1_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC0_MIDCMD_DATA10                                                                     0x077a
#define regSDMA1_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC0_MIDCMD_CNTL                                                                       0x077b
#define regSDMA1_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC1_RB_CNTL                                                                           0x0788
#define regSDMA1_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC1_RB_BASE                                                                           0x0789
#define regSDMA1_RLC1_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC1_RB_BASE_HI                                                                        0x078a
#define regSDMA1_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC1_RB_RPTR                                                                           0x078b
#define regSDMA1_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC1_RB_RPTR_HI                                                                        0x078c
#define regSDMA1_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC1_RB_WPTR                                                                           0x078d
#define regSDMA1_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC1_RB_WPTR_HI                                                                        0x078e
#define regSDMA1_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC1_RB_WPTR_POLL_CNTL                                                                 0x078f
#define regSDMA1_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC1_RB_RPTR_ADDR_HI                                                                   0x0790
#define regSDMA1_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC1_RB_RPTR_ADDR_LO                                                                   0x0791
#define regSDMA1_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC1_IB_CNTL                                                                           0x0792
#define regSDMA1_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC1_IB_RPTR                                                                           0x0793
#define regSDMA1_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC1_IB_OFFSET                                                                         0x0794
#define regSDMA1_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC1_IB_BASE_LO                                                                        0x0795
#define regSDMA1_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC1_IB_BASE_HI                                                                        0x0796
#define regSDMA1_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC1_IB_SIZE                                                                           0x0797
#define regSDMA1_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC1_SKIP_CNTL                                                                         0x0798
#define regSDMA1_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC1_CONTEXT_STATUS                                                                    0x0799
#define regSDMA1_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC1_DOORBELL                                                                          0x079a
#define regSDMA1_RLC1_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC1_STATUS                                                                            0x07b0
#define regSDMA1_RLC1_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC1_DOORBELL_LOG                                                                      0x07b1
#define regSDMA1_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC1_WATERMARK                                                                         0x07b2
#define regSDMA1_RLC1_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC1_DOORBELL_OFFSET                                                                   0x07b3
#define regSDMA1_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC1_CSA_ADDR_LO                                                                       0x07b4
#define regSDMA1_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC1_CSA_ADDR_HI                                                                       0x07b5
#define regSDMA1_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC1_IB_SUB_REMAIN                                                                     0x07b7
#define regSDMA1_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC1_PREEMPT                                                                           0x07b8
#define regSDMA1_RLC1_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC1_DUMMY_REG                                                                         0x07b9
#define regSDMA1_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x07ba
#define regSDMA1_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x07bb
#define regSDMA1_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC1_RB_AQL_CNTL                                                                       0x07bc
#define regSDMA1_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC1_MINOR_PTR_UPDATE                                                                  0x07bd
#define regSDMA1_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC1_MIDCMD_DATA0                                                                      0x07c8
#define regSDMA1_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA1                                                                      0x07c9
#define regSDMA1_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA2                                                                      0x07ca
#define regSDMA1_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA3                                                                      0x07cb
#define regSDMA1_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA4                                                                      0x07cc
#define regSDMA1_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA5                                                                      0x07cd
#define regSDMA1_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA6                                                                      0x07ce
#define regSDMA1_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA7                                                                      0x07cf
#define regSDMA1_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA8                                                                      0x07d0
#define regSDMA1_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA9                                                                      0x07d1
#define regSDMA1_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC1_MIDCMD_DATA10                                                                     0x07d2
#define regSDMA1_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC1_MIDCMD_CNTL                                                                       0x07d3
#define regSDMA1_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC2_RB_CNTL                                                                           0x07e0
#define regSDMA1_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC2_RB_BASE                                                                           0x07e1
#define regSDMA1_RLC2_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC2_RB_BASE_HI                                                                        0x07e2
#define regSDMA1_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC2_RB_RPTR                                                                           0x07e3
#define regSDMA1_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC2_RB_RPTR_HI                                                                        0x07e4
#define regSDMA1_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC2_RB_WPTR                                                                           0x07e5
#define regSDMA1_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC2_RB_WPTR_HI                                                                        0x07e6
#define regSDMA1_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC2_RB_WPTR_POLL_CNTL                                                                 0x07e7
#define regSDMA1_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC2_RB_RPTR_ADDR_HI                                                                   0x07e8
#define regSDMA1_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC2_RB_RPTR_ADDR_LO                                                                   0x07e9
#define regSDMA1_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC2_IB_CNTL                                                                           0x07ea
#define regSDMA1_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC2_IB_RPTR                                                                           0x07eb
#define regSDMA1_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC2_IB_OFFSET                                                                         0x07ec
#define regSDMA1_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC2_IB_BASE_LO                                                                        0x07ed
#define regSDMA1_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC2_IB_BASE_HI                                                                        0x07ee
#define regSDMA1_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC2_IB_SIZE                                                                           0x07ef
#define regSDMA1_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC2_SKIP_CNTL                                                                         0x07f0
#define regSDMA1_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC2_CONTEXT_STATUS                                                                    0x07f1
#define regSDMA1_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC2_DOORBELL                                                                          0x07f2
#define regSDMA1_RLC2_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC2_STATUS                                                                            0x0808
#define regSDMA1_RLC2_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC2_DOORBELL_LOG                                                                      0x0809
#define regSDMA1_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC2_WATERMARK                                                                         0x080a
#define regSDMA1_RLC2_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC2_DOORBELL_OFFSET                                                                   0x080b
#define regSDMA1_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC2_CSA_ADDR_LO                                                                       0x080c
#define regSDMA1_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC2_CSA_ADDR_HI                                                                       0x080d
#define regSDMA1_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC2_IB_SUB_REMAIN                                                                     0x080f
#define regSDMA1_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC2_PREEMPT                                                                           0x0810
#define regSDMA1_RLC2_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC2_DUMMY_REG                                                                         0x0811
#define regSDMA1_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x0812
#define regSDMA1_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x0813
#define regSDMA1_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC2_RB_AQL_CNTL                                                                       0x0814
#define regSDMA1_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC2_MINOR_PTR_UPDATE                                                                  0x0815
#define regSDMA1_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC2_MIDCMD_DATA0                                                                      0x0820
#define regSDMA1_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA1                                                                      0x0821
#define regSDMA1_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA2                                                                      0x0822
#define regSDMA1_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA3                                                                      0x0823
#define regSDMA1_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA4                                                                      0x0824
#define regSDMA1_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA5                                                                      0x0825
#define regSDMA1_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA6                                                                      0x0826
#define regSDMA1_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA7                                                                      0x0827
#define regSDMA1_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA8                                                                      0x0828
#define regSDMA1_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA9                                                                      0x0829
#define regSDMA1_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC2_MIDCMD_DATA10                                                                     0x082a
#define regSDMA1_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC2_MIDCMD_CNTL                                                                       0x082b
#define regSDMA1_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC3_RB_CNTL                                                                           0x0838
#define regSDMA1_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC3_RB_BASE                                                                           0x0839
#define regSDMA1_RLC3_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC3_RB_BASE_HI                                                                        0x083a
#define regSDMA1_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC3_RB_RPTR                                                                           0x083b
#define regSDMA1_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC3_RB_RPTR_HI                                                                        0x083c
#define regSDMA1_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC3_RB_WPTR                                                                           0x083d
#define regSDMA1_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC3_RB_WPTR_HI                                                                        0x083e
#define regSDMA1_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC3_RB_WPTR_POLL_CNTL                                                                 0x083f
#define regSDMA1_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC3_RB_RPTR_ADDR_HI                                                                   0x0840
#define regSDMA1_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC3_RB_RPTR_ADDR_LO                                                                   0x0841
#define regSDMA1_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC3_IB_CNTL                                                                           0x0842
#define regSDMA1_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC3_IB_RPTR                                                                           0x0843
#define regSDMA1_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC3_IB_OFFSET                                                                         0x0844
#define regSDMA1_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC3_IB_BASE_LO                                                                        0x0845
#define regSDMA1_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC3_IB_BASE_HI                                                                        0x0846
#define regSDMA1_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC3_IB_SIZE                                                                           0x0847
#define regSDMA1_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC3_SKIP_CNTL                                                                         0x0848
#define regSDMA1_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC3_CONTEXT_STATUS                                                                    0x0849
#define regSDMA1_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC3_DOORBELL                                                                          0x084a
#define regSDMA1_RLC3_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC3_STATUS                                                                            0x0860
#define regSDMA1_RLC3_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC3_DOORBELL_LOG                                                                      0x0861
#define regSDMA1_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC3_WATERMARK                                                                         0x0862
#define regSDMA1_RLC3_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC3_DOORBELL_OFFSET                                                                   0x0863
#define regSDMA1_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC3_CSA_ADDR_LO                                                                       0x0864
#define regSDMA1_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC3_CSA_ADDR_HI                                                                       0x0865
#define regSDMA1_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC3_IB_SUB_REMAIN                                                                     0x0867
#define regSDMA1_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC3_PREEMPT                                                                           0x0868
#define regSDMA1_RLC3_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC3_DUMMY_REG                                                                         0x0869
#define regSDMA1_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x086a
#define regSDMA1_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x086b
#define regSDMA1_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC3_RB_AQL_CNTL                                                                       0x086c
#define regSDMA1_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC3_MINOR_PTR_UPDATE                                                                  0x086d
#define regSDMA1_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC3_MIDCMD_DATA0                                                                      0x0878
#define regSDMA1_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA1                                                                      0x0879
#define regSDMA1_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA2                                                                      0x087a
#define regSDMA1_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA3                                                                      0x087b
#define regSDMA1_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA4                                                                      0x087c
#define regSDMA1_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA5                                                                      0x087d
#define regSDMA1_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA6                                                                      0x087e
#define regSDMA1_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA7                                                                      0x087f
#define regSDMA1_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA8                                                                      0x0880
#define regSDMA1_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA9                                                                      0x0881
#define regSDMA1_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC3_MIDCMD_DATA10                                                                     0x0882
#define regSDMA1_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC3_MIDCMD_CNTL                                                                       0x0883
#define regSDMA1_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC4_RB_CNTL                                                                           0x0890
#define regSDMA1_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC4_RB_BASE                                                                           0x0891
#define regSDMA1_RLC4_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC4_RB_BASE_HI                                                                        0x0892
#define regSDMA1_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC4_RB_RPTR                                                                           0x0893
#define regSDMA1_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC4_RB_RPTR_HI                                                                        0x0894
#define regSDMA1_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC4_RB_WPTR                                                                           0x0895
#define regSDMA1_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC4_RB_WPTR_HI                                                                        0x0896
#define regSDMA1_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC4_RB_WPTR_POLL_CNTL                                                                 0x0897
#define regSDMA1_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC4_RB_RPTR_ADDR_HI                                                                   0x0898
#define regSDMA1_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC4_RB_RPTR_ADDR_LO                                                                   0x0899
#define regSDMA1_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC4_IB_CNTL                                                                           0x089a
#define regSDMA1_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC4_IB_RPTR                                                                           0x089b
#define regSDMA1_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC4_IB_OFFSET                                                                         0x089c
#define regSDMA1_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC4_IB_BASE_LO                                                                        0x089d
#define regSDMA1_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC4_IB_BASE_HI                                                                        0x089e
#define regSDMA1_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC4_IB_SIZE                                                                           0x089f
#define regSDMA1_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC4_SKIP_CNTL                                                                         0x08a0
#define regSDMA1_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC4_CONTEXT_STATUS                                                                    0x08a1
#define regSDMA1_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC4_DOORBELL                                                                          0x08a2
#define regSDMA1_RLC4_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC4_STATUS                                                                            0x08b8
#define regSDMA1_RLC4_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC4_DOORBELL_LOG                                                                      0x08b9
#define regSDMA1_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC4_WATERMARK                                                                         0x08ba
#define regSDMA1_RLC4_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC4_DOORBELL_OFFSET                                                                   0x08bb
#define regSDMA1_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC4_CSA_ADDR_LO                                                                       0x08bc
#define regSDMA1_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC4_CSA_ADDR_HI                                                                       0x08bd
#define regSDMA1_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC4_IB_SUB_REMAIN                                                                     0x08bf
#define regSDMA1_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC4_PREEMPT                                                                           0x08c0
#define regSDMA1_RLC4_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC4_DUMMY_REG                                                                         0x08c1
#define regSDMA1_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x08c2
#define regSDMA1_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x08c3
#define regSDMA1_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC4_RB_AQL_CNTL                                                                       0x08c4
#define regSDMA1_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC4_MINOR_PTR_UPDATE                                                                  0x08c5
#define regSDMA1_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC4_MIDCMD_DATA0                                                                      0x08d0
#define regSDMA1_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA1                                                                      0x08d1
#define regSDMA1_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA2                                                                      0x08d2
#define regSDMA1_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA3                                                                      0x08d3
#define regSDMA1_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA4                                                                      0x08d4
#define regSDMA1_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA5                                                                      0x08d5
#define regSDMA1_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA6                                                                      0x08d6
#define regSDMA1_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA7                                                                      0x08d7
#define regSDMA1_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA8                                                                      0x08d8
#define regSDMA1_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA9                                                                      0x08d9
#define regSDMA1_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC4_MIDCMD_DATA10                                                                     0x08da
#define regSDMA1_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC4_MIDCMD_CNTL                                                                       0x08db
#define regSDMA1_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC5_RB_CNTL                                                                           0x08e8
#define regSDMA1_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC5_RB_BASE                                                                           0x08e9
#define regSDMA1_RLC5_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC5_RB_BASE_HI                                                                        0x08ea
#define regSDMA1_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC5_RB_RPTR                                                                           0x08eb
#define regSDMA1_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC5_RB_RPTR_HI                                                                        0x08ec
#define regSDMA1_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC5_RB_WPTR                                                                           0x08ed
#define regSDMA1_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC5_RB_WPTR_HI                                                                        0x08ee
#define regSDMA1_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC5_RB_WPTR_POLL_CNTL                                                                 0x08ef
#define regSDMA1_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC5_RB_RPTR_ADDR_HI                                                                   0x08f0
#define regSDMA1_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC5_RB_RPTR_ADDR_LO                                                                   0x08f1
#define regSDMA1_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC5_IB_CNTL                                                                           0x08f2
#define regSDMA1_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC5_IB_RPTR                                                                           0x08f3
#define regSDMA1_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC5_IB_OFFSET                                                                         0x08f4
#define regSDMA1_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC5_IB_BASE_LO                                                                        0x08f5
#define regSDMA1_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC5_IB_BASE_HI                                                                        0x08f6
#define regSDMA1_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC5_IB_SIZE                                                                           0x08f7
#define regSDMA1_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC5_SKIP_CNTL                                                                         0x08f8
#define regSDMA1_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC5_CONTEXT_STATUS                                                                    0x08f9
#define regSDMA1_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC5_DOORBELL                                                                          0x08fa
#define regSDMA1_RLC5_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC5_STATUS                                                                            0x0910
#define regSDMA1_RLC5_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC5_DOORBELL_LOG                                                                      0x0911
#define regSDMA1_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC5_WATERMARK                                                                         0x0912
#define regSDMA1_RLC5_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC5_DOORBELL_OFFSET                                                                   0x0913
#define regSDMA1_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC5_CSA_ADDR_LO                                                                       0x0914
#define regSDMA1_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC5_CSA_ADDR_HI                                                                       0x0915
#define regSDMA1_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC5_IB_SUB_REMAIN                                                                     0x0917
#define regSDMA1_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC5_PREEMPT                                                                           0x0918
#define regSDMA1_RLC5_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC5_DUMMY_REG                                                                         0x0919
#define regSDMA1_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x091a
#define regSDMA1_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x091b
#define regSDMA1_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC5_RB_AQL_CNTL                                                                       0x091c
#define regSDMA1_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC5_MINOR_PTR_UPDATE                                                                  0x091d
#define regSDMA1_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC5_MIDCMD_DATA0                                                                      0x0928
#define regSDMA1_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA1                                                                      0x0929
#define regSDMA1_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA2                                                                      0x092a
#define regSDMA1_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA3                                                                      0x092b
#define regSDMA1_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA4                                                                      0x092c
#define regSDMA1_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA5                                                                      0x092d
#define regSDMA1_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA6                                                                      0x092e
#define regSDMA1_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA7                                                                      0x092f
#define regSDMA1_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA8                                                                      0x0930
#define regSDMA1_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA9                                                                      0x0931
#define regSDMA1_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC5_MIDCMD_DATA10                                                                     0x0932
#define regSDMA1_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC5_MIDCMD_CNTL                                                                       0x0933
#define regSDMA1_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC6_RB_CNTL                                                                           0x0940
#define regSDMA1_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC6_RB_BASE                                                                           0x0941
#define regSDMA1_RLC6_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC6_RB_BASE_HI                                                                        0x0942
#define regSDMA1_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC6_RB_RPTR                                                                           0x0943
#define regSDMA1_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC6_RB_RPTR_HI                                                                        0x0944
#define regSDMA1_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC6_RB_WPTR                                                                           0x0945
#define regSDMA1_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC6_RB_WPTR_HI                                                                        0x0946
#define regSDMA1_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC6_RB_WPTR_POLL_CNTL                                                                 0x0947
#define regSDMA1_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC6_RB_RPTR_ADDR_HI                                                                   0x0948
#define regSDMA1_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC6_RB_RPTR_ADDR_LO                                                                   0x0949
#define regSDMA1_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC6_IB_CNTL                                                                           0x094a
#define regSDMA1_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC6_IB_RPTR                                                                           0x094b
#define regSDMA1_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC6_IB_OFFSET                                                                         0x094c
#define regSDMA1_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC6_IB_BASE_LO                                                                        0x094d
#define regSDMA1_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC6_IB_BASE_HI                                                                        0x094e
#define regSDMA1_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC6_IB_SIZE                                                                           0x094f
#define regSDMA1_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC6_SKIP_CNTL                                                                         0x0950
#define regSDMA1_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC6_CONTEXT_STATUS                                                                    0x0951
#define regSDMA1_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC6_DOORBELL                                                                          0x0952
#define regSDMA1_RLC6_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC6_STATUS                                                                            0x0968
#define regSDMA1_RLC6_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC6_DOORBELL_LOG                                                                      0x0969
#define regSDMA1_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC6_WATERMARK                                                                         0x096a
#define regSDMA1_RLC6_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC6_DOORBELL_OFFSET                                                                   0x096b
#define regSDMA1_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC6_CSA_ADDR_LO                                                                       0x096c
#define regSDMA1_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC6_CSA_ADDR_HI                                                                       0x096d
#define regSDMA1_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC6_IB_SUB_REMAIN                                                                     0x096f
#define regSDMA1_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC6_PREEMPT                                                                           0x0970
#define regSDMA1_RLC6_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC6_DUMMY_REG                                                                         0x0971
#define regSDMA1_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x0972
#define regSDMA1_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x0973
#define regSDMA1_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC6_RB_AQL_CNTL                                                                       0x0974
#define regSDMA1_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC6_MINOR_PTR_UPDATE                                                                  0x0975
#define regSDMA1_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC6_MIDCMD_DATA0                                                                      0x0980
#define regSDMA1_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA1                                                                      0x0981
#define regSDMA1_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA2                                                                      0x0982
#define regSDMA1_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA3                                                                      0x0983
#define regSDMA1_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA4                                                                      0x0984
#define regSDMA1_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA5                                                                      0x0985
#define regSDMA1_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA6                                                                      0x0986
#define regSDMA1_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA7                                                                      0x0987
#define regSDMA1_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA8                                                                      0x0988
#define regSDMA1_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA9                                                                      0x0989
#define regSDMA1_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC6_MIDCMD_DATA10                                                                     0x098a
#define regSDMA1_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC6_MIDCMD_CNTL                                                                       0x098b
#define regSDMA1_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC7_RB_CNTL                                                                           0x0998
#define regSDMA1_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC7_RB_BASE                                                                           0x0999
#define regSDMA1_RLC7_RB_BASE_BASE_IDX                                                                  0
#define regSDMA1_RLC7_RB_BASE_HI                                                                        0x099a
#define regSDMA1_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC7_RB_RPTR                                                                           0x099b
#define regSDMA1_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC7_RB_RPTR_HI                                                                        0x099c
#define regSDMA1_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC7_RB_WPTR                                                                           0x099d
#define regSDMA1_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC7_RB_WPTR_HI                                                                        0x099e
#define regSDMA1_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA1_RLC7_RB_WPTR_POLL_CNTL                                                                 0x099f
#define regSDMA1_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA1_RLC7_RB_RPTR_ADDR_HI                                                                   0x09a0
#define regSDMA1_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA1_RLC7_RB_RPTR_ADDR_LO                                                                   0x09a1
#define regSDMA1_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA1_RLC7_IB_CNTL                                                                           0x09a2
#define regSDMA1_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA1_RLC7_IB_RPTR                                                                           0x09a3
#define regSDMA1_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA1_RLC7_IB_OFFSET                                                                         0x09a4
#define regSDMA1_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA1_RLC7_IB_BASE_LO                                                                        0x09a5
#define regSDMA1_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA1_RLC7_IB_BASE_HI                                                                        0x09a6
#define regSDMA1_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA1_RLC7_IB_SIZE                                                                           0x09a7
#define regSDMA1_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA1_RLC7_SKIP_CNTL                                                                         0x09a8
#define regSDMA1_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA1_RLC7_CONTEXT_STATUS                                                                    0x09a9
#define regSDMA1_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA1_RLC7_DOORBELL                                                                          0x09aa
#define regSDMA1_RLC7_DOORBELL_BASE_IDX                                                                 0
#define regSDMA1_RLC7_STATUS                                                                            0x09c0
#define regSDMA1_RLC7_STATUS_BASE_IDX                                                                   0
#define regSDMA1_RLC7_DOORBELL_LOG                                                                      0x09c1
#define regSDMA1_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA1_RLC7_WATERMARK                                                                         0x09c2
#define regSDMA1_RLC7_WATERMARK_BASE_IDX                                                                0
#define regSDMA1_RLC7_DOORBELL_OFFSET                                                                   0x09c3
#define regSDMA1_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA1_RLC7_CSA_ADDR_LO                                                                       0x09c4
#define regSDMA1_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA1_RLC7_CSA_ADDR_HI                                                                       0x09c5
#define regSDMA1_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA1_RLC7_IB_SUB_REMAIN                                                                     0x09c7
#define regSDMA1_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA1_RLC7_PREEMPT                                                                           0x09c8
#define regSDMA1_RLC7_PREEMPT_BASE_IDX                                                                  0
#define regSDMA1_RLC7_DUMMY_REG                                                                         0x09c9
#define regSDMA1_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA1_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x09ca
#define regSDMA1_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA1_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x09cb
#define regSDMA1_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA1_RLC7_RB_AQL_CNTL                                                                       0x09cc
#define regSDMA1_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA1_RLC7_MINOR_PTR_UPDATE                                                                  0x09cd
#define regSDMA1_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA1_RLC7_MIDCMD_DATA0                                                                      0x09d8
#define regSDMA1_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA1                                                                      0x09d9
#define regSDMA1_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA2                                                                      0x09da
#define regSDMA1_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA3                                                                      0x09db
#define regSDMA1_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA4                                                                      0x09dc
#define regSDMA1_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA5                                                                      0x09dd
#define regSDMA1_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA6                                                                      0x09de
#define regSDMA1_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA7                                                                      0x09df
#define regSDMA1_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA8                                                                      0x09e0
#define regSDMA1_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA9                                                                      0x09e1
#define regSDMA1_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA1_RLC7_MIDCMD_DATA10                                                                     0x09e2
#define regSDMA1_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA1_RLC7_MIDCMD_CNTL                                                                       0x09e3
#define regSDMA1_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0


// addressBlock: sdma0_sdma2dec
// base address: 0x78000
#define regSDMA2_UCODE_ADDR                                                                             0x1cda0
#define regSDMA2_UCODE_ADDR_BASE_IDX                                                                    0
#define regSDMA2_UCODE_DATA                                                                             0x1cda1
#define regSDMA2_UCODE_DATA_BASE_IDX                                                                    0
#define regSDMA2_VF_ENABLE                                                                              0x1cdaa
#define regSDMA2_VF_ENABLE_BASE_IDX                                                                     0
#define regSDMA2_CONTEXT_GROUP_BOUNDARY                                                                 0x1cdb9
#define regSDMA2_CONTEXT_GROUP_BOUNDARY_BASE_IDX                                                        0
#define regSDMA2_POWER_CNTL                                                                             0x1cdba
#define regSDMA2_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA2_CLK_CTRL                                                                               0x1cdbb
#define regSDMA2_CLK_CTRL_BASE_IDX                                                                      0
#define regSDMA2_CNTL                                                                                   0x1cdbc
#define regSDMA2_CNTL_BASE_IDX                                                                          0
#define regSDMA2_CHICKEN_BITS                                                                           0x1cdbd
#define regSDMA2_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA2_GB_ADDR_CONFIG                                                                         0x1cdbe
#define regSDMA2_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define regSDMA2_GB_ADDR_CONFIG_READ                                                                    0x1cdbf
#define regSDMA2_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define regSDMA2_RB_RPTR_FETCH_HI                                                                       0x1cdc0
#define regSDMA2_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA2_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x1cdc1
#define regSDMA2_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define regSDMA2_RB_RPTR_FETCH                                                                          0x1cdc2
#define regSDMA2_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA2_IB_OFFSET_FETCH                                                                        0x1cdc3
#define regSDMA2_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA2_PROGRAM                                                                                0x1cdc4
#define regSDMA2_PROGRAM_BASE_IDX                                                                       0
#define regSDMA2_STATUS_REG                                                                             0x1cdc5
#define regSDMA2_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA2_STATUS1_REG                                                                            0x1cdc6
#define regSDMA2_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA2_RD_BURST_CNTL                                                                          0x1cdc7
#define regSDMA2_RD_BURST_CNTL_BASE_IDX                                                                 0
#define regSDMA2_HBM_PAGE_CONFIG                                                                        0x1cdc8
#define regSDMA2_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA2_UCODE_CHECKSUM                                                                         0x1cdc9
#define regSDMA2_UCODE_CHECKSUM_BASE_IDX                                                                0
#define regSDMA2_F32_CNTL                                                                               0x1cdca
#define regSDMA2_F32_CNTL_BASE_IDX                                                                      0
#define regSDMA2_FREEZE                                                                                 0x1cdcb
#define regSDMA2_FREEZE_BASE_IDX                                                                        0
#define regSDMA2_PHASE0_QUANTUM                                                                         0x1cdcc
#define regSDMA2_PHASE0_QUANTUM_BASE_IDX                                                                0
#define regSDMA2_PHASE1_QUANTUM                                                                         0x1cdcd
#define regSDMA2_PHASE1_QUANTUM_BASE_IDX                                                                0
#define regCC_SDMA2_EDC_CONFIG                                                                          0x1cdd2
#define regCC_SDMA2_EDC_CONFIG_BASE_IDX                                                                 0
#define regSDMA2_BA_THRESHOLD                                                                           0x1cdd3
#define regSDMA2_BA_THRESHOLD_BASE_IDX                                                                  0
#define regSDMA2_ID                                                                                     0x1cdd4
#define regSDMA2_ID_BASE_IDX                                                                            0
#define regSDMA2_VERSION                                                                                0x1cdd5
#define regSDMA2_VERSION_BASE_IDX                                                                       0
#define regSDMA2_EDC_COUNTER                                                                            0x1cdd6
#define regSDMA2_EDC_COUNTER_BASE_IDX                                                                   0
#define regSDMA2_EDC_COUNTER2                                                                           0x1cdd7
#define regSDMA2_EDC_COUNTER2_BASE_IDX                                                                  0
#define regSDMA2_STATUS2_REG                                                                            0x1cdd8
#define regSDMA2_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA2_ATOMIC_CNTL                                                                            0x1cdd9
#define regSDMA2_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA2_ATOMIC_PREOP_LO                                                                        0x1cdda
#define regSDMA2_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA2_ATOMIC_PREOP_HI                                                                        0x1cddb
#define regSDMA2_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA2_UTCL1_CNTL                                                                             0x1cddc
#define regSDMA2_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA2_UTCL1_WATERMK                                                                          0x1cddd
#define regSDMA2_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA2_UTCL1_RD_STATUS                                                                        0x1cdde
#define regSDMA2_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA2_UTCL1_WR_STATUS                                                                        0x1cddf
#define regSDMA2_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA2_UTCL1_INV0                                                                             0x1cde0
#define regSDMA2_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA2_UTCL1_INV1                                                                             0x1cde1
#define regSDMA2_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA2_UTCL1_INV2                                                                             0x1cde2
#define regSDMA2_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA2_UTCL1_RD_XNACK0                                                                        0x1cde3
#define regSDMA2_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA2_UTCL1_RD_XNACK1                                                                        0x1cde4
#define regSDMA2_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA2_UTCL1_WR_XNACK0                                                                        0x1cde5
#define regSDMA2_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA2_UTCL1_WR_XNACK1                                                                        0x1cde6
#define regSDMA2_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA2_UTCL1_TIMEOUT                                                                          0x1cde7
#define regSDMA2_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA2_UTCL1_PAGE                                                                             0x1cde8
#define regSDMA2_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA2_POWER_CNTL_IDLE                                                                        0x1cde9
#define regSDMA2_POWER_CNTL_IDLE_BASE_IDX                                                               0
#define regSDMA2_RELAX_ORDERING_LUT                                                                     0x1cdea
#define regSDMA2_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA2_CHICKEN_BITS_2                                                                         0x1cdeb
#define regSDMA2_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA2_STATUS3_REG                                                                            0x1cdec
#define regSDMA2_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA2_PHYSICAL_ADDR_LO                                                                       0x1cded
#define regSDMA2_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_PHYSICAL_ADDR_HI                                                                       0x1cdee
#define regSDMA2_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_PHASE2_QUANTUM                                                                         0x1cdef
#define regSDMA2_PHASE2_QUANTUM_BASE_IDX                                                                0
#define regSDMA2_ERROR_LOG                                                                              0x1cdf0
#define regSDMA2_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA2_PUB_DUMMY_REG0                                                                         0x1cdf1
#define regSDMA2_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA2_PUB_DUMMY_REG1                                                                         0x1cdf2
#define regSDMA2_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA2_PUB_DUMMY_REG2                                                                         0x1cdf3
#define regSDMA2_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA2_PUB_DUMMY_REG3                                                                         0x1cdf4
#define regSDMA2_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA2_F32_COUNTER                                                                            0x1cdf5
#define regSDMA2_F32_COUNTER_BASE_IDX                                                                   0
#define regSDMA2_PERFCNT_PERFCOUNTER0_CFG                                                               0x1cdf7
#define regSDMA2_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      0
#define regSDMA2_PERFCNT_PERFCOUNTER1_CFG                                                               0x1cdf8
#define regSDMA2_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      0
#define regSDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x1cdf9
#define regSDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 0
#define regSDMA2_PERFCNT_MISC_CNTL                                                                      0x1cdfa
#define regSDMA2_PERFCNT_MISC_CNTL_BASE_IDX                                                             0
#define regSDMA2_PERFCNT_PERFCOUNTER_LO                                                                 0x1cdfb
#define regSDMA2_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        0
#define regSDMA2_PERFCNT_PERFCOUNTER_HI                                                                 0x1cdfc
#define regSDMA2_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        0
#define regSDMA2_CRD_CNTL                                                                               0x1cdfd
#define regSDMA2_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA2_ULV_CNTL                                                                               0x1cdff
#define regSDMA2_ULV_CNTL_BASE_IDX                                                                      0
#define regSDMA2_EA_DBIT_ADDR_DATA                                                                      0x1ce00
#define regSDMA2_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define regSDMA2_EA_DBIT_ADDR_INDEX                                                                     0x1ce01
#define regSDMA2_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define regSDMA2_STATUS4_REG                                                                            0x1ce03
#define regSDMA2_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA2_SCRATCH_RAM_DATA                                                                       0x1ce04
#define regSDMA2_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA2_SCRATCH_RAM_ADDR                                                                       0x1ce05
#define regSDMA2_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA2_CE_CTRL                                                                                0x1ce06
#define regSDMA2_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA2_RAS_STATUS                                                                             0x1ce07
#define regSDMA2_RAS_STATUS_BASE_IDX                                                                    0
#define regSDMA2_CLK_STATUS                                                                             0x1ce08
#define regSDMA2_CLK_STATUS_BASE_IDX                                                                    0
#define regSDMA2_GFX_RB_CNTL                                                                            0x1ce20
#define regSDMA2_GFX_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA2_GFX_RB_BASE                                                                            0x1ce21
#define regSDMA2_GFX_RB_BASE_BASE_IDX                                                                   0
#define regSDMA2_GFX_RB_BASE_HI                                                                         0x1ce22
#define regSDMA2_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA2_GFX_RB_RPTR                                                                            0x1ce23
#define regSDMA2_GFX_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA2_GFX_RB_RPTR_HI                                                                         0x1ce24
#define regSDMA2_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA2_GFX_RB_WPTR                                                                            0x1ce25
#define regSDMA2_GFX_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA2_GFX_RB_WPTR_HI                                                                         0x1ce26
#define regSDMA2_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA2_GFX_RB_WPTR_POLL_CNTL                                                                  0x1ce27
#define regSDMA2_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA2_GFX_RB_RPTR_ADDR_HI                                                                    0x1ce28
#define regSDMA2_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA2_GFX_RB_RPTR_ADDR_LO                                                                    0x1ce29
#define regSDMA2_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA2_GFX_IB_CNTL                                                                            0x1ce2a
#define regSDMA2_GFX_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA2_GFX_IB_RPTR                                                                            0x1ce2b
#define regSDMA2_GFX_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA2_GFX_IB_OFFSET                                                                          0x1ce2c
#define regSDMA2_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA2_GFX_IB_BASE_LO                                                                         0x1ce2d
#define regSDMA2_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA2_GFX_IB_BASE_HI                                                                         0x1ce2e
#define regSDMA2_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA2_GFX_IB_SIZE                                                                            0x1ce2f
#define regSDMA2_GFX_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA2_GFX_SKIP_CNTL                                                                          0x1ce30
#define regSDMA2_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA2_GFX_CONTEXT_STATUS                                                                     0x1ce31
#define regSDMA2_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA2_GFX_DOORBELL                                                                           0x1ce32
#define regSDMA2_GFX_DOORBELL_BASE_IDX                                                                  0
#define regSDMA2_GFX_CONTEXT_CNTL                                                                       0x1ce33
#define regSDMA2_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define regSDMA2_GFX_STATUS                                                                             0x1ce48
#define regSDMA2_GFX_STATUS_BASE_IDX                                                                    0
#define regSDMA2_GFX_DOORBELL_LOG                                                                       0x1ce49
#define regSDMA2_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA2_GFX_WATERMARK                                                                          0x1ce4a
#define regSDMA2_GFX_WATERMARK_BASE_IDX                                                                 0
#define regSDMA2_GFX_DOORBELL_OFFSET                                                                    0x1ce4b
#define regSDMA2_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA2_GFX_CSA_ADDR_LO                                                                        0x1ce4c
#define regSDMA2_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA2_GFX_CSA_ADDR_HI                                                                        0x1ce4d
#define regSDMA2_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA2_GFX_IB_SUB_REMAIN                                                                      0x1ce4f
#define regSDMA2_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA2_GFX_PREEMPT                                                                            0x1ce50
#define regSDMA2_GFX_PREEMPT_BASE_IDX                                                                   0
#define regSDMA2_GFX_DUMMY_REG                                                                          0x1ce51
#define regSDMA2_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA2_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x1ce52
#define regSDMA2_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA2_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x1ce53
#define regSDMA2_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA2_GFX_RB_AQL_CNTL                                                                        0x1ce54
#define regSDMA2_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA2_GFX_MINOR_PTR_UPDATE                                                                   0x1ce55
#define regSDMA2_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA2_GFX_MIDCMD_DATA0                                                                       0x1ce60
#define regSDMA2_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA1                                                                       0x1ce61
#define regSDMA2_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA2                                                                       0x1ce62
#define regSDMA2_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA3                                                                       0x1ce63
#define regSDMA2_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA4                                                                       0x1ce64
#define regSDMA2_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA5                                                                       0x1ce65
#define regSDMA2_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA6                                                                       0x1ce66
#define regSDMA2_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA7                                                                       0x1ce67
#define regSDMA2_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA8                                                                       0x1ce68
#define regSDMA2_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA9                                                                       0x1ce69
#define regSDMA2_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA2_GFX_MIDCMD_DATA10                                                                      0x1ce6a
#define regSDMA2_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA2_GFX_MIDCMD_CNTL                                                                        0x1ce6b
#define regSDMA2_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA2_PAGE_RB_CNTL                                                                           0x1ce78
#define regSDMA2_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_PAGE_RB_BASE                                                                           0x1ce79
#define regSDMA2_PAGE_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_PAGE_RB_BASE_HI                                                                        0x1ce7a
#define regSDMA2_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_PAGE_RB_RPTR                                                                           0x1ce7b
#define regSDMA2_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_PAGE_RB_RPTR_HI                                                                        0x1ce7c
#define regSDMA2_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_PAGE_RB_WPTR                                                                           0x1ce7d
#define regSDMA2_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_PAGE_RB_WPTR_HI                                                                        0x1ce7e
#define regSDMA2_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_PAGE_RB_WPTR_POLL_CNTL                                                                 0x1ce7f
#define regSDMA2_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_PAGE_RB_RPTR_ADDR_HI                                                                   0x1ce80
#define regSDMA2_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_PAGE_RB_RPTR_ADDR_LO                                                                   0x1ce81
#define regSDMA2_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_PAGE_IB_CNTL                                                                           0x1ce82
#define regSDMA2_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_PAGE_IB_RPTR                                                                           0x1ce83
#define regSDMA2_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_PAGE_IB_OFFSET                                                                         0x1ce84
#define regSDMA2_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_PAGE_IB_BASE_LO                                                                        0x1ce85
#define regSDMA2_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_PAGE_IB_BASE_HI                                                                        0x1ce86
#define regSDMA2_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_PAGE_IB_SIZE                                                                           0x1ce87
#define regSDMA2_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_PAGE_SKIP_CNTL                                                                         0x1ce88
#define regSDMA2_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_PAGE_CONTEXT_STATUS                                                                    0x1ce89
#define regSDMA2_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_PAGE_DOORBELL                                                                          0x1ce8a
#define regSDMA2_PAGE_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_PAGE_STATUS                                                                            0x1cea0
#define regSDMA2_PAGE_STATUS_BASE_IDX                                                                   0
#define regSDMA2_PAGE_DOORBELL_LOG                                                                      0x1cea1
#define regSDMA2_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_PAGE_WATERMARK                                                                         0x1cea2
#define regSDMA2_PAGE_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_PAGE_DOORBELL_OFFSET                                                                   0x1cea3
#define regSDMA2_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_PAGE_CSA_ADDR_LO                                                                       0x1cea4
#define regSDMA2_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_PAGE_CSA_ADDR_HI                                                                       0x1cea5
#define regSDMA2_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_PAGE_IB_SUB_REMAIN                                                                     0x1cea7
#define regSDMA2_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_PAGE_PREEMPT                                                                           0x1cea8
#define regSDMA2_PAGE_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_PAGE_DUMMY_REG                                                                         0x1cea9
#define regSDMA2_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x1ceaa
#define regSDMA2_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x1ceab
#define regSDMA2_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_PAGE_RB_AQL_CNTL                                                                       0x1ceac
#define regSDMA2_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_PAGE_MINOR_PTR_UPDATE                                                                  0x1cead
#define regSDMA2_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_PAGE_MIDCMD_DATA0                                                                      0x1ceb8
#define regSDMA2_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA1                                                                      0x1ceb9
#define regSDMA2_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA2                                                                      0x1ceba
#define regSDMA2_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA3                                                                      0x1cebb
#define regSDMA2_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA4                                                                      0x1cebc
#define regSDMA2_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA5                                                                      0x1cebd
#define regSDMA2_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA6                                                                      0x1cebe
#define regSDMA2_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA7                                                                      0x1cebf
#define regSDMA2_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA8                                                                      0x1cec0
#define regSDMA2_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA9                                                                      0x1cec1
#define regSDMA2_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_PAGE_MIDCMD_DATA10                                                                     0x1cec2
#define regSDMA2_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_PAGE_MIDCMD_CNTL                                                                       0x1cec3
#define regSDMA2_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC0_RB_CNTL                                                                           0x1ced0
#define regSDMA2_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC0_RB_BASE                                                                           0x1ced1
#define regSDMA2_RLC0_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC0_RB_BASE_HI                                                                        0x1ced2
#define regSDMA2_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC0_RB_RPTR                                                                           0x1ced3
#define regSDMA2_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC0_RB_RPTR_HI                                                                        0x1ced4
#define regSDMA2_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC0_RB_WPTR                                                                           0x1ced5
#define regSDMA2_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC0_RB_WPTR_HI                                                                        0x1ced6
#define regSDMA2_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC0_RB_WPTR_POLL_CNTL                                                                 0x1ced7
#define regSDMA2_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC0_RB_RPTR_ADDR_HI                                                                   0x1ced8
#define regSDMA2_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC0_RB_RPTR_ADDR_LO                                                                   0x1ced9
#define regSDMA2_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC0_IB_CNTL                                                                           0x1ceda
#define regSDMA2_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC0_IB_RPTR                                                                           0x1cedb
#define regSDMA2_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC0_IB_OFFSET                                                                         0x1cedc
#define regSDMA2_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC0_IB_BASE_LO                                                                        0x1cedd
#define regSDMA2_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC0_IB_BASE_HI                                                                        0x1cede
#define regSDMA2_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC0_IB_SIZE                                                                           0x1cedf
#define regSDMA2_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC0_SKIP_CNTL                                                                         0x1cee0
#define regSDMA2_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC0_CONTEXT_STATUS                                                                    0x1cee1
#define regSDMA2_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC0_DOORBELL                                                                          0x1cee2
#define regSDMA2_RLC0_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC0_STATUS                                                                            0x1cef8
#define regSDMA2_RLC0_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC0_DOORBELL_LOG                                                                      0x1cef9
#define regSDMA2_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC0_WATERMARK                                                                         0x1cefa
#define regSDMA2_RLC0_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC0_DOORBELL_OFFSET                                                                   0x1cefb
#define regSDMA2_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC0_CSA_ADDR_LO                                                                       0x1cefc
#define regSDMA2_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC0_CSA_ADDR_HI                                                                       0x1cefd
#define regSDMA2_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC0_IB_SUB_REMAIN                                                                     0x1ceff
#define regSDMA2_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC0_PREEMPT                                                                           0x1cf00
#define regSDMA2_RLC0_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC0_DUMMY_REG                                                                         0x1cf01
#define regSDMA2_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x1cf02
#define regSDMA2_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x1cf03
#define regSDMA2_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC0_RB_AQL_CNTL                                                                       0x1cf04
#define regSDMA2_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC0_MINOR_PTR_UPDATE                                                                  0x1cf05
#define regSDMA2_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC0_MIDCMD_DATA0                                                                      0x1cf10
#define regSDMA2_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA1                                                                      0x1cf11
#define regSDMA2_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA2                                                                      0x1cf12
#define regSDMA2_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA3                                                                      0x1cf13
#define regSDMA2_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA4                                                                      0x1cf14
#define regSDMA2_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA5                                                                      0x1cf15
#define regSDMA2_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA6                                                                      0x1cf16
#define regSDMA2_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA7                                                                      0x1cf17
#define regSDMA2_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA8                                                                      0x1cf18
#define regSDMA2_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA9                                                                      0x1cf19
#define regSDMA2_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC0_MIDCMD_DATA10                                                                     0x1cf1a
#define regSDMA2_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC0_MIDCMD_CNTL                                                                       0x1cf1b
#define regSDMA2_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC1_RB_CNTL                                                                           0x1cf28
#define regSDMA2_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC1_RB_BASE                                                                           0x1cf29
#define regSDMA2_RLC1_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC1_RB_BASE_HI                                                                        0x1cf2a
#define regSDMA2_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC1_RB_RPTR                                                                           0x1cf2b
#define regSDMA2_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC1_RB_RPTR_HI                                                                        0x1cf2c
#define regSDMA2_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC1_RB_WPTR                                                                           0x1cf2d
#define regSDMA2_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC1_RB_WPTR_HI                                                                        0x1cf2e
#define regSDMA2_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC1_RB_WPTR_POLL_CNTL                                                                 0x1cf2f
#define regSDMA2_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC1_RB_RPTR_ADDR_HI                                                                   0x1cf30
#define regSDMA2_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC1_RB_RPTR_ADDR_LO                                                                   0x1cf31
#define regSDMA2_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC1_IB_CNTL                                                                           0x1cf32
#define regSDMA2_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC1_IB_RPTR                                                                           0x1cf33
#define regSDMA2_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC1_IB_OFFSET                                                                         0x1cf34
#define regSDMA2_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC1_IB_BASE_LO                                                                        0x1cf35
#define regSDMA2_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC1_IB_BASE_HI                                                                        0x1cf36
#define regSDMA2_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC1_IB_SIZE                                                                           0x1cf37
#define regSDMA2_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC1_SKIP_CNTL                                                                         0x1cf38
#define regSDMA2_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC1_CONTEXT_STATUS                                                                    0x1cf39
#define regSDMA2_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC1_DOORBELL                                                                          0x1cf3a
#define regSDMA2_RLC1_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC1_STATUS                                                                            0x1cf50
#define regSDMA2_RLC1_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC1_DOORBELL_LOG                                                                      0x1cf51
#define regSDMA2_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC1_WATERMARK                                                                         0x1cf52
#define regSDMA2_RLC1_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC1_DOORBELL_OFFSET                                                                   0x1cf53
#define regSDMA2_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC1_CSA_ADDR_LO                                                                       0x1cf54
#define regSDMA2_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC1_CSA_ADDR_HI                                                                       0x1cf55
#define regSDMA2_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC1_IB_SUB_REMAIN                                                                     0x1cf57
#define regSDMA2_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC1_PREEMPT                                                                           0x1cf58
#define regSDMA2_RLC1_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC1_DUMMY_REG                                                                         0x1cf59
#define regSDMA2_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x1cf5a
#define regSDMA2_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x1cf5b
#define regSDMA2_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC1_RB_AQL_CNTL                                                                       0x1cf5c
#define regSDMA2_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC1_MINOR_PTR_UPDATE                                                                  0x1cf5d
#define regSDMA2_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC1_MIDCMD_DATA0                                                                      0x1cf68
#define regSDMA2_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA1                                                                      0x1cf69
#define regSDMA2_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA2                                                                      0x1cf6a
#define regSDMA2_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA3                                                                      0x1cf6b
#define regSDMA2_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA4                                                                      0x1cf6c
#define regSDMA2_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA5                                                                      0x1cf6d
#define regSDMA2_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA6                                                                      0x1cf6e
#define regSDMA2_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA7                                                                      0x1cf6f
#define regSDMA2_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA8                                                                      0x1cf70
#define regSDMA2_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA9                                                                      0x1cf71
#define regSDMA2_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC1_MIDCMD_DATA10                                                                     0x1cf72
#define regSDMA2_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC1_MIDCMD_CNTL                                                                       0x1cf73
#define regSDMA2_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC2_RB_CNTL                                                                           0x1cf80
#define regSDMA2_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC2_RB_BASE                                                                           0x1cf81
#define regSDMA2_RLC2_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC2_RB_BASE_HI                                                                        0x1cf82
#define regSDMA2_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC2_RB_RPTR                                                                           0x1cf83
#define regSDMA2_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC2_RB_RPTR_HI                                                                        0x1cf84
#define regSDMA2_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC2_RB_WPTR                                                                           0x1cf85
#define regSDMA2_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC2_RB_WPTR_HI                                                                        0x1cf86
#define regSDMA2_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC2_RB_WPTR_POLL_CNTL                                                                 0x1cf87
#define regSDMA2_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC2_RB_RPTR_ADDR_HI                                                                   0x1cf88
#define regSDMA2_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC2_RB_RPTR_ADDR_LO                                                                   0x1cf89
#define regSDMA2_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC2_IB_CNTL                                                                           0x1cf8a
#define regSDMA2_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC2_IB_RPTR                                                                           0x1cf8b
#define regSDMA2_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC2_IB_OFFSET                                                                         0x1cf8c
#define regSDMA2_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC2_IB_BASE_LO                                                                        0x1cf8d
#define regSDMA2_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC2_IB_BASE_HI                                                                        0x1cf8e
#define regSDMA2_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC2_IB_SIZE                                                                           0x1cf8f
#define regSDMA2_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC2_SKIP_CNTL                                                                         0x1cf90
#define regSDMA2_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC2_CONTEXT_STATUS                                                                    0x1cf91
#define regSDMA2_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC2_DOORBELL                                                                          0x1cf92
#define regSDMA2_RLC2_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC2_STATUS                                                                            0x1cfa8
#define regSDMA2_RLC2_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC2_DOORBELL_LOG                                                                      0x1cfa9
#define regSDMA2_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC2_WATERMARK                                                                         0x1cfaa
#define regSDMA2_RLC2_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC2_DOORBELL_OFFSET                                                                   0x1cfab
#define regSDMA2_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC2_CSA_ADDR_LO                                                                       0x1cfac
#define regSDMA2_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC2_CSA_ADDR_HI                                                                       0x1cfad
#define regSDMA2_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC2_IB_SUB_REMAIN                                                                     0x1cfaf
#define regSDMA2_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC2_PREEMPT                                                                           0x1cfb0
#define regSDMA2_RLC2_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC2_DUMMY_REG                                                                         0x1cfb1
#define regSDMA2_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x1cfb2
#define regSDMA2_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x1cfb3
#define regSDMA2_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC2_RB_AQL_CNTL                                                                       0x1cfb4
#define regSDMA2_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC2_MINOR_PTR_UPDATE                                                                  0x1cfb5
#define regSDMA2_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC2_MIDCMD_DATA0                                                                      0x1cfc0
#define regSDMA2_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA1                                                                      0x1cfc1
#define regSDMA2_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA2                                                                      0x1cfc2
#define regSDMA2_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA3                                                                      0x1cfc3
#define regSDMA2_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA4                                                                      0x1cfc4
#define regSDMA2_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA5                                                                      0x1cfc5
#define regSDMA2_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA6                                                                      0x1cfc6
#define regSDMA2_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA7                                                                      0x1cfc7
#define regSDMA2_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA8                                                                      0x1cfc8
#define regSDMA2_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA9                                                                      0x1cfc9
#define regSDMA2_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC2_MIDCMD_DATA10                                                                     0x1cfca
#define regSDMA2_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC2_MIDCMD_CNTL                                                                       0x1cfcb
#define regSDMA2_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC3_RB_CNTL                                                                           0x1cfd8
#define regSDMA2_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC3_RB_BASE                                                                           0x1cfd9
#define regSDMA2_RLC3_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC3_RB_BASE_HI                                                                        0x1cfda
#define regSDMA2_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC3_RB_RPTR                                                                           0x1cfdb
#define regSDMA2_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC3_RB_RPTR_HI                                                                        0x1cfdc
#define regSDMA2_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC3_RB_WPTR                                                                           0x1cfdd
#define regSDMA2_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC3_RB_WPTR_HI                                                                        0x1cfde
#define regSDMA2_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC3_RB_WPTR_POLL_CNTL                                                                 0x1cfdf
#define regSDMA2_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC3_RB_RPTR_ADDR_HI                                                                   0x1cfe0
#define regSDMA2_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC3_RB_RPTR_ADDR_LO                                                                   0x1cfe1
#define regSDMA2_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC3_IB_CNTL                                                                           0x1cfe2
#define regSDMA2_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC3_IB_RPTR                                                                           0x1cfe3
#define regSDMA2_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC3_IB_OFFSET                                                                         0x1cfe4
#define regSDMA2_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC3_IB_BASE_LO                                                                        0x1cfe5
#define regSDMA2_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC3_IB_BASE_HI                                                                        0x1cfe6
#define regSDMA2_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC3_IB_SIZE                                                                           0x1cfe7
#define regSDMA2_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC3_SKIP_CNTL                                                                         0x1cfe8
#define regSDMA2_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC3_CONTEXT_STATUS                                                                    0x1cfe9
#define regSDMA2_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC3_DOORBELL                                                                          0x1cfea
#define regSDMA2_RLC3_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC3_STATUS                                                                            0x1d000
#define regSDMA2_RLC3_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC3_DOORBELL_LOG                                                                      0x1d001
#define regSDMA2_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC3_WATERMARK                                                                         0x1d002
#define regSDMA2_RLC3_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC3_DOORBELL_OFFSET                                                                   0x1d003
#define regSDMA2_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC3_CSA_ADDR_LO                                                                       0x1d004
#define regSDMA2_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC3_CSA_ADDR_HI                                                                       0x1d005
#define regSDMA2_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC3_IB_SUB_REMAIN                                                                     0x1d007
#define regSDMA2_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC3_PREEMPT                                                                           0x1d008
#define regSDMA2_RLC3_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC3_DUMMY_REG                                                                         0x1d009
#define regSDMA2_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x1d00a
#define regSDMA2_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x1d00b
#define regSDMA2_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC3_RB_AQL_CNTL                                                                       0x1d00c
#define regSDMA2_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC3_MINOR_PTR_UPDATE                                                                  0x1d00d
#define regSDMA2_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC3_MIDCMD_DATA0                                                                      0x1d018
#define regSDMA2_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA1                                                                      0x1d019
#define regSDMA2_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA2                                                                      0x1d01a
#define regSDMA2_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA3                                                                      0x1d01b
#define regSDMA2_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA4                                                                      0x1d01c
#define regSDMA2_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA5                                                                      0x1d01d
#define regSDMA2_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA6                                                                      0x1d01e
#define regSDMA2_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA7                                                                      0x1d01f
#define regSDMA2_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA8                                                                      0x1d020
#define regSDMA2_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA9                                                                      0x1d021
#define regSDMA2_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC3_MIDCMD_DATA10                                                                     0x1d022
#define regSDMA2_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC3_MIDCMD_CNTL                                                                       0x1d023
#define regSDMA2_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC4_RB_CNTL                                                                           0x1d030
#define regSDMA2_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC4_RB_BASE                                                                           0x1d031
#define regSDMA2_RLC4_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC4_RB_BASE_HI                                                                        0x1d032
#define regSDMA2_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC4_RB_RPTR                                                                           0x1d033
#define regSDMA2_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC4_RB_RPTR_HI                                                                        0x1d034
#define regSDMA2_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC4_RB_WPTR                                                                           0x1d035
#define regSDMA2_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC4_RB_WPTR_HI                                                                        0x1d036
#define regSDMA2_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC4_RB_WPTR_POLL_CNTL                                                                 0x1d037
#define regSDMA2_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC4_RB_RPTR_ADDR_HI                                                                   0x1d038
#define regSDMA2_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC4_RB_RPTR_ADDR_LO                                                                   0x1d039
#define regSDMA2_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC4_IB_CNTL                                                                           0x1d03a
#define regSDMA2_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC4_IB_RPTR                                                                           0x1d03b
#define regSDMA2_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC4_IB_OFFSET                                                                         0x1d03c
#define regSDMA2_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC4_IB_BASE_LO                                                                        0x1d03d
#define regSDMA2_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC4_IB_BASE_HI                                                                        0x1d03e
#define regSDMA2_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC4_IB_SIZE                                                                           0x1d03f
#define regSDMA2_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC4_SKIP_CNTL                                                                         0x1d040
#define regSDMA2_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC4_CONTEXT_STATUS                                                                    0x1d041
#define regSDMA2_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC4_DOORBELL                                                                          0x1d042
#define regSDMA2_RLC4_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC4_STATUS                                                                            0x1d058
#define regSDMA2_RLC4_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC4_DOORBELL_LOG                                                                      0x1d059
#define regSDMA2_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC4_WATERMARK                                                                         0x1d05a
#define regSDMA2_RLC4_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC4_DOORBELL_OFFSET                                                                   0x1d05b
#define regSDMA2_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC4_CSA_ADDR_LO                                                                       0x1d05c
#define regSDMA2_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC4_CSA_ADDR_HI                                                                       0x1d05d
#define regSDMA2_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC4_IB_SUB_REMAIN                                                                     0x1d05f
#define regSDMA2_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC4_PREEMPT                                                                           0x1d060
#define regSDMA2_RLC4_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC4_DUMMY_REG                                                                         0x1d061
#define regSDMA2_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x1d062
#define regSDMA2_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x1d063
#define regSDMA2_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC4_RB_AQL_CNTL                                                                       0x1d064
#define regSDMA2_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC4_MINOR_PTR_UPDATE                                                                  0x1d065
#define regSDMA2_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC4_MIDCMD_DATA0                                                                      0x1d070
#define regSDMA2_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA1                                                                      0x1d071
#define regSDMA2_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA2                                                                      0x1d072
#define regSDMA2_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA3                                                                      0x1d073
#define regSDMA2_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA4                                                                      0x1d074
#define regSDMA2_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA5                                                                      0x1d075
#define regSDMA2_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA6                                                                      0x1d076
#define regSDMA2_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA7                                                                      0x1d077
#define regSDMA2_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA8                                                                      0x1d078
#define regSDMA2_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA9                                                                      0x1d079
#define regSDMA2_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC4_MIDCMD_DATA10                                                                     0x1d07a
#define regSDMA2_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC4_MIDCMD_CNTL                                                                       0x1d07b
#define regSDMA2_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC5_RB_CNTL                                                                           0x1d088
#define regSDMA2_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC5_RB_BASE                                                                           0x1d089
#define regSDMA2_RLC5_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC5_RB_BASE_HI                                                                        0x1d08a
#define regSDMA2_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC5_RB_RPTR                                                                           0x1d08b
#define regSDMA2_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC5_RB_RPTR_HI                                                                        0x1d08c
#define regSDMA2_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC5_RB_WPTR                                                                           0x1d08d
#define regSDMA2_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC5_RB_WPTR_HI                                                                        0x1d08e
#define regSDMA2_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC5_RB_WPTR_POLL_CNTL                                                                 0x1d08f
#define regSDMA2_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC5_RB_RPTR_ADDR_HI                                                                   0x1d090
#define regSDMA2_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC5_RB_RPTR_ADDR_LO                                                                   0x1d091
#define regSDMA2_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC5_IB_CNTL                                                                           0x1d092
#define regSDMA2_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC5_IB_RPTR                                                                           0x1d093
#define regSDMA2_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC5_IB_OFFSET                                                                         0x1d094
#define regSDMA2_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC5_IB_BASE_LO                                                                        0x1d095
#define regSDMA2_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC5_IB_BASE_HI                                                                        0x1d096
#define regSDMA2_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC5_IB_SIZE                                                                           0x1d097
#define regSDMA2_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC5_SKIP_CNTL                                                                         0x1d098
#define regSDMA2_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC5_CONTEXT_STATUS                                                                    0x1d099
#define regSDMA2_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC5_DOORBELL                                                                          0x1d09a
#define regSDMA2_RLC5_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC5_STATUS                                                                            0x1d0b0
#define regSDMA2_RLC5_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC5_DOORBELL_LOG                                                                      0x1d0b1
#define regSDMA2_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC5_WATERMARK                                                                         0x1d0b2
#define regSDMA2_RLC5_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC5_DOORBELL_OFFSET                                                                   0x1d0b3
#define regSDMA2_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC5_CSA_ADDR_LO                                                                       0x1d0b4
#define regSDMA2_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC5_CSA_ADDR_HI                                                                       0x1d0b5
#define regSDMA2_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC5_IB_SUB_REMAIN                                                                     0x1d0b7
#define regSDMA2_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC5_PREEMPT                                                                           0x1d0b8
#define regSDMA2_RLC5_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC5_DUMMY_REG                                                                         0x1d0b9
#define regSDMA2_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x1d0ba
#define regSDMA2_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x1d0bb
#define regSDMA2_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC5_RB_AQL_CNTL                                                                       0x1d0bc
#define regSDMA2_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC5_MINOR_PTR_UPDATE                                                                  0x1d0bd
#define regSDMA2_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC5_MIDCMD_DATA0                                                                      0x1d0c8
#define regSDMA2_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA1                                                                      0x1d0c9
#define regSDMA2_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA2                                                                      0x1d0ca
#define regSDMA2_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA3                                                                      0x1d0cb
#define regSDMA2_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA4                                                                      0x1d0cc
#define regSDMA2_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA5                                                                      0x1d0cd
#define regSDMA2_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA6                                                                      0x1d0ce
#define regSDMA2_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA7                                                                      0x1d0cf
#define regSDMA2_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA8                                                                      0x1d0d0
#define regSDMA2_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA9                                                                      0x1d0d1
#define regSDMA2_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC5_MIDCMD_DATA10                                                                     0x1d0d2
#define regSDMA2_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC5_MIDCMD_CNTL                                                                       0x1d0d3
#define regSDMA2_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC6_RB_CNTL                                                                           0x1d0e0
#define regSDMA2_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC6_RB_BASE                                                                           0x1d0e1
#define regSDMA2_RLC6_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC6_RB_BASE_HI                                                                        0x1d0e2
#define regSDMA2_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC6_RB_RPTR                                                                           0x1d0e3
#define regSDMA2_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC6_RB_RPTR_HI                                                                        0x1d0e4
#define regSDMA2_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC6_RB_WPTR                                                                           0x1d0e5
#define regSDMA2_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC6_RB_WPTR_HI                                                                        0x1d0e6
#define regSDMA2_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC6_RB_WPTR_POLL_CNTL                                                                 0x1d0e7
#define regSDMA2_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC6_RB_RPTR_ADDR_HI                                                                   0x1d0e8
#define regSDMA2_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC6_RB_RPTR_ADDR_LO                                                                   0x1d0e9
#define regSDMA2_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC6_IB_CNTL                                                                           0x1d0ea
#define regSDMA2_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC6_IB_RPTR                                                                           0x1d0eb
#define regSDMA2_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC6_IB_OFFSET                                                                         0x1d0ec
#define regSDMA2_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC6_IB_BASE_LO                                                                        0x1d0ed
#define regSDMA2_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC6_IB_BASE_HI                                                                        0x1d0ee
#define regSDMA2_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC6_IB_SIZE                                                                           0x1d0ef
#define regSDMA2_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC6_SKIP_CNTL                                                                         0x1d0f0
#define regSDMA2_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC6_CONTEXT_STATUS                                                                    0x1d0f1
#define regSDMA2_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC6_DOORBELL                                                                          0x1d0f2
#define regSDMA2_RLC6_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC6_STATUS                                                                            0x1d108
#define regSDMA2_RLC6_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC6_DOORBELL_LOG                                                                      0x1d109
#define regSDMA2_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC6_WATERMARK                                                                         0x1d10a
#define regSDMA2_RLC6_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC6_DOORBELL_OFFSET                                                                   0x1d10b
#define regSDMA2_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC6_CSA_ADDR_LO                                                                       0x1d10c
#define regSDMA2_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC6_CSA_ADDR_HI                                                                       0x1d10d
#define regSDMA2_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC6_IB_SUB_REMAIN                                                                     0x1d10f
#define regSDMA2_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC6_PREEMPT                                                                           0x1d110
#define regSDMA2_RLC6_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC6_DUMMY_REG                                                                         0x1d111
#define regSDMA2_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x1d112
#define regSDMA2_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x1d113
#define regSDMA2_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC6_RB_AQL_CNTL                                                                       0x1d114
#define regSDMA2_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC6_MINOR_PTR_UPDATE                                                                  0x1d115
#define regSDMA2_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC6_MIDCMD_DATA0                                                                      0x1d120
#define regSDMA2_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA1                                                                      0x1d121
#define regSDMA2_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA2                                                                      0x1d122
#define regSDMA2_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA3                                                                      0x1d123
#define regSDMA2_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA4                                                                      0x1d124
#define regSDMA2_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA5                                                                      0x1d125
#define regSDMA2_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA6                                                                      0x1d126
#define regSDMA2_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA7                                                                      0x1d127
#define regSDMA2_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA8                                                                      0x1d128
#define regSDMA2_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA9                                                                      0x1d129
#define regSDMA2_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC6_MIDCMD_DATA10                                                                     0x1d12a
#define regSDMA2_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC6_MIDCMD_CNTL                                                                       0x1d12b
#define regSDMA2_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC7_RB_CNTL                                                                           0x1d138
#define regSDMA2_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC7_RB_BASE                                                                           0x1d139
#define regSDMA2_RLC7_RB_BASE_BASE_IDX                                                                  0
#define regSDMA2_RLC7_RB_BASE_HI                                                                        0x1d13a
#define regSDMA2_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC7_RB_RPTR                                                                           0x1d13b
#define regSDMA2_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC7_RB_RPTR_HI                                                                        0x1d13c
#define regSDMA2_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC7_RB_WPTR                                                                           0x1d13d
#define regSDMA2_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC7_RB_WPTR_HI                                                                        0x1d13e
#define regSDMA2_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA2_RLC7_RB_WPTR_POLL_CNTL                                                                 0x1d13f
#define regSDMA2_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA2_RLC7_RB_RPTR_ADDR_HI                                                                   0x1d140
#define regSDMA2_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA2_RLC7_RB_RPTR_ADDR_LO                                                                   0x1d141
#define regSDMA2_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA2_RLC7_IB_CNTL                                                                           0x1d142
#define regSDMA2_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA2_RLC7_IB_RPTR                                                                           0x1d143
#define regSDMA2_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA2_RLC7_IB_OFFSET                                                                         0x1d144
#define regSDMA2_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA2_RLC7_IB_BASE_LO                                                                        0x1d145
#define regSDMA2_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA2_RLC7_IB_BASE_HI                                                                        0x1d146
#define regSDMA2_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA2_RLC7_IB_SIZE                                                                           0x1d147
#define regSDMA2_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA2_RLC7_SKIP_CNTL                                                                         0x1d148
#define regSDMA2_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA2_RLC7_CONTEXT_STATUS                                                                    0x1d149
#define regSDMA2_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA2_RLC7_DOORBELL                                                                          0x1d14a
#define regSDMA2_RLC7_DOORBELL_BASE_IDX                                                                 0
#define regSDMA2_RLC7_STATUS                                                                            0x1d160
#define regSDMA2_RLC7_STATUS_BASE_IDX                                                                   0
#define regSDMA2_RLC7_DOORBELL_LOG                                                                      0x1d161
#define regSDMA2_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA2_RLC7_WATERMARK                                                                         0x1d162
#define regSDMA2_RLC7_WATERMARK_BASE_IDX                                                                0
#define regSDMA2_RLC7_DOORBELL_OFFSET                                                                   0x1d163
#define regSDMA2_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA2_RLC7_CSA_ADDR_LO                                                                       0x1d164
#define regSDMA2_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA2_RLC7_CSA_ADDR_HI                                                                       0x1d165
#define regSDMA2_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA2_RLC7_IB_SUB_REMAIN                                                                     0x1d167
#define regSDMA2_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA2_RLC7_PREEMPT                                                                           0x1d168
#define regSDMA2_RLC7_PREEMPT_BASE_IDX                                                                  0
#define regSDMA2_RLC7_DUMMY_REG                                                                         0x1d169
#define regSDMA2_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA2_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x1d16a
#define regSDMA2_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA2_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x1d16b
#define regSDMA2_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA2_RLC7_RB_AQL_CNTL                                                                       0x1d16c
#define regSDMA2_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA2_RLC7_MINOR_PTR_UPDATE                                                                  0x1d16d
#define regSDMA2_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA2_RLC7_MIDCMD_DATA0                                                                      0x1d178
#define regSDMA2_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA1                                                                      0x1d179
#define regSDMA2_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA2                                                                      0x1d17a
#define regSDMA2_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA3                                                                      0x1d17b
#define regSDMA2_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA4                                                                      0x1d17c
#define regSDMA2_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA5                                                                      0x1d17d
#define regSDMA2_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA6                                                                      0x1d17e
#define regSDMA2_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA7                                                                      0x1d17f
#define regSDMA2_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA8                                                                      0x1d180
#define regSDMA2_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA9                                                                      0x1d181
#define regSDMA2_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA2_RLC7_MIDCMD_DATA10                                                                     0x1d182
#define regSDMA2_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA2_RLC7_MIDCMD_CNTL                                                                       0x1d183
#define regSDMA2_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0


// addressBlock: sdma0_sdma3dec
// base address: 0x79000
#define regSDMA3_UCODE_ADDR                                                                             0x1d1a0
#define regSDMA3_UCODE_ADDR_BASE_IDX                                                                    0
#define regSDMA3_UCODE_DATA                                                                             0x1d1a1
#define regSDMA3_UCODE_DATA_BASE_IDX                                                                    0
#define regSDMA3_VF_ENABLE                                                                              0x1d1aa
#define regSDMA3_VF_ENABLE_BASE_IDX                                                                     0
#define regSDMA3_CONTEXT_GROUP_BOUNDARY                                                                 0x1d1b9
#define regSDMA3_CONTEXT_GROUP_BOUNDARY_BASE_IDX                                                        0
#define regSDMA3_POWER_CNTL                                                                             0x1d1ba
#define regSDMA3_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA3_CLK_CTRL                                                                               0x1d1bb
#define regSDMA3_CLK_CTRL_BASE_IDX                                                                      0
#define regSDMA3_CNTL                                                                                   0x1d1bc
#define regSDMA3_CNTL_BASE_IDX                                                                          0
#define regSDMA3_CHICKEN_BITS                                                                           0x1d1bd
#define regSDMA3_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA3_GB_ADDR_CONFIG                                                                         0x1d1be
#define regSDMA3_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define regSDMA3_GB_ADDR_CONFIG_READ                                                                    0x1d1bf
#define regSDMA3_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define regSDMA3_RB_RPTR_FETCH_HI                                                                       0x1d1c0
#define regSDMA3_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA3_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x1d1c1
#define regSDMA3_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define regSDMA3_RB_RPTR_FETCH                                                                          0x1d1c2
#define regSDMA3_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA3_IB_OFFSET_FETCH                                                                        0x1d1c3
#define regSDMA3_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA3_PROGRAM                                                                                0x1d1c4
#define regSDMA3_PROGRAM_BASE_IDX                                                                       0
#define regSDMA3_STATUS_REG                                                                             0x1d1c5
#define regSDMA3_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA3_STATUS1_REG                                                                            0x1d1c6
#define regSDMA3_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA3_RD_BURST_CNTL                                                                          0x1d1c7
#define regSDMA3_RD_BURST_CNTL_BASE_IDX                                                                 0
#define regSDMA3_HBM_PAGE_CONFIG                                                                        0x1d1c8
#define regSDMA3_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA3_UCODE_CHECKSUM                                                                         0x1d1c9
#define regSDMA3_UCODE_CHECKSUM_BASE_IDX                                                                0
#define regSDMA3_F32_CNTL                                                                               0x1d1ca
#define regSDMA3_F32_CNTL_BASE_IDX                                                                      0
#define regSDMA3_FREEZE                                                                                 0x1d1cb
#define regSDMA3_FREEZE_BASE_IDX                                                                        0
#define regSDMA3_PHASE0_QUANTUM                                                                         0x1d1cc
#define regSDMA3_PHASE0_QUANTUM_BASE_IDX                                                                0
#define regSDMA3_PHASE1_QUANTUM                                                                         0x1d1cd
#define regSDMA3_PHASE1_QUANTUM_BASE_IDX                                                                0
#define regCC_SDMA3_EDC_CONFIG                                                                          0x1d1d2
#define regCC_SDMA3_EDC_CONFIG_BASE_IDX                                                                 0
#define regSDMA3_BA_THRESHOLD                                                                           0x1d1d3
#define regSDMA3_BA_THRESHOLD_BASE_IDX                                                                  0
#define regSDMA3_ID                                                                                     0x1d1d4
#define regSDMA3_ID_BASE_IDX                                                                            0
#define regSDMA3_VERSION                                                                                0x1d1d5
#define regSDMA3_VERSION_BASE_IDX                                                                       0
#define regSDMA3_EDC_COUNTER                                                                            0x1d1d6
#define regSDMA3_EDC_COUNTER_BASE_IDX                                                                   0
#define regSDMA3_EDC_COUNTER2                                                                           0x1d1d7
#define regSDMA3_EDC_COUNTER2_BASE_IDX                                                                  0
#define regSDMA3_STATUS2_REG                                                                            0x1d1d8
#define regSDMA3_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA3_ATOMIC_CNTL                                                                            0x1d1d9
#define regSDMA3_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA3_ATOMIC_PREOP_LO                                                                        0x1d1da
#define regSDMA3_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA3_ATOMIC_PREOP_HI                                                                        0x1d1db
#define regSDMA3_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA3_UTCL1_CNTL                                                                             0x1d1dc
#define regSDMA3_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA3_UTCL1_WATERMK                                                                          0x1d1dd
#define regSDMA3_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA3_UTCL1_RD_STATUS                                                                        0x1d1de
#define regSDMA3_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA3_UTCL1_WR_STATUS                                                                        0x1d1df
#define regSDMA3_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA3_UTCL1_INV0                                                                             0x1d1e0
#define regSDMA3_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA3_UTCL1_INV1                                                                             0x1d1e1
#define regSDMA3_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA3_UTCL1_INV2                                                                             0x1d1e2
#define regSDMA3_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA3_UTCL1_RD_XNACK0                                                                        0x1d1e3
#define regSDMA3_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA3_UTCL1_RD_XNACK1                                                                        0x1d1e4
#define regSDMA3_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA3_UTCL1_WR_XNACK0                                                                        0x1d1e5
#define regSDMA3_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA3_UTCL1_WR_XNACK1                                                                        0x1d1e6
#define regSDMA3_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA3_UTCL1_TIMEOUT                                                                          0x1d1e7
#define regSDMA3_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA3_UTCL1_PAGE                                                                             0x1d1e8
#define regSDMA3_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA3_POWER_CNTL_IDLE                                                                        0x1d1e9
#define regSDMA3_POWER_CNTL_IDLE_BASE_IDX                                                               0
#define regSDMA3_RELAX_ORDERING_LUT                                                                     0x1d1ea
#define regSDMA3_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA3_CHICKEN_BITS_2                                                                         0x1d1eb
#define regSDMA3_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA3_STATUS3_REG                                                                            0x1d1ec
#define regSDMA3_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA3_PHYSICAL_ADDR_LO                                                                       0x1d1ed
#define regSDMA3_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_PHYSICAL_ADDR_HI                                                                       0x1d1ee
#define regSDMA3_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_PHASE2_QUANTUM                                                                         0x1d1ef
#define regSDMA3_PHASE2_QUANTUM_BASE_IDX                                                                0
#define regSDMA3_ERROR_LOG                                                                              0x1d1f0
#define regSDMA3_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA3_PUB_DUMMY_REG0                                                                         0x1d1f1
#define regSDMA3_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA3_PUB_DUMMY_REG1                                                                         0x1d1f2
#define regSDMA3_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA3_PUB_DUMMY_REG2                                                                         0x1d1f3
#define regSDMA3_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA3_PUB_DUMMY_REG3                                                                         0x1d1f4
#define regSDMA3_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA3_F32_COUNTER                                                                            0x1d1f5
#define regSDMA3_F32_COUNTER_BASE_IDX                                                                   0
#define regSDMA3_PERFCNT_PERFCOUNTER0_CFG                                                               0x1d1f7
#define regSDMA3_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      0
#define regSDMA3_PERFCNT_PERFCOUNTER1_CFG                                                               0x1d1f8
#define regSDMA3_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      0
#define regSDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x1d1f9
#define regSDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 0
#define regSDMA3_PERFCNT_MISC_CNTL                                                                      0x1d1fa
#define regSDMA3_PERFCNT_MISC_CNTL_BASE_IDX                                                             0
#define regSDMA3_PERFCNT_PERFCOUNTER_LO                                                                 0x1d1fb
#define regSDMA3_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        0
#define regSDMA3_PERFCNT_PERFCOUNTER_HI                                                                 0x1d1fc
#define regSDMA3_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        0
#define regSDMA3_CRD_CNTL                                                                               0x1d1fd
#define regSDMA3_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA3_ULV_CNTL                                                                               0x1d1ff
#define regSDMA3_ULV_CNTL_BASE_IDX                                                                      0
#define regSDMA3_EA_DBIT_ADDR_DATA                                                                      0x1d200
#define regSDMA3_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define regSDMA3_EA_DBIT_ADDR_INDEX                                                                     0x1d201
#define regSDMA3_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define regSDMA3_STATUS4_REG                                                                            0x1d203
#define regSDMA3_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA3_SCRATCH_RAM_DATA                                                                       0x1d204
#define regSDMA3_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA3_SCRATCH_RAM_ADDR                                                                       0x1d205
#define regSDMA3_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA3_CE_CTRL                                                                                0x1d206
#define regSDMA3_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA3_RAS_STATUS                                                                             0x1d207
#define regSDMA3_RAS_STATUS_BASE_IDX                                                                    0
#define regSDMA3_CLK_STATUS                                                                             0x1d208
#define regSDMA3_CLK_STATUS_BASE_IDX                                                                    0
#define regSDMA3_GFX_RB_CNTL                                                                            0x1d220
#define regSDMA3_GFX_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA3_GFX_RB_BASE                                                                            0x1d221
#define regSDMA3_GFX_RB_BASE_BASE_IDX                                                                   0
#define regSDMA3_GFX_RB_BASE_HI                                                                         0x1d222
#define regSDMA3_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA3_GFX_RB_RPTR                                                                            0x1d223
#define regSDMA3_GFX_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA3_GFX_RB_RPTR_HI                                                                         0x1d224
#define regSDMA3_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA3_GFX_RB_WPTR                                                                            0x1d225
#define regSDMA3_GFX_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA3_GFX_RB_WPTR_HI                                                                         0x1d226
#define regSDMA3_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA3_GFX_RB_WPTR_POLL_CNTL                                                                  0x1d227
#define regSDMA3_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA3_GFX_RB_RPTR_ADDR_HI                                                                    0x1d228
#define regSDMA3_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA3_GFX_RB_RPTR_ADDR_LO                                                                    0x1d229
#define regSDMA3_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA3_GFX_IB_CNTL                                                                            0x1d22a
#define regSDMA3_GFX_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA3_GFX_IB_RPTR                                                                            0x1d22b
#define regSDMA3_GFX_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA3_GFX_IB_OFFSET                                                                          0x1d22c
#define regSDMA3_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA3_GFX_IB_BASE_LO                                                                         0x1d22d
#define regSDMA3_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA3_GFX_IB_BASE_HI                                                                         0x1d22e
#define regSDMA3_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA3_GFX_IB_SIZE                                                                            0x1d22f
#define regSDMA3_GFX_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA3_GFX_SKIP_CNTL                                                                          0x1d230
#define regSDMA3_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA3_GFX_CONTEXT_STATUS                                                                     0x1d231
#define regSDMA3_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA3_GFX_DOORBELL                                                                           0x1d232
#define regSDMA3_GFX_DOORBELL_BASE_IDX                                                                  0
#define regSDMA3_GFX_CONTEXT_CNTL                                                                       0x1d233
#define regSDMA3_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define regSDMA3_GFX_STATUS                                                                             0x1d248
#define regSDMA3_GFX_STATUS_BASE_IDX                                                                    0
#define regSDMA3_GFX_DOORBELL_LOG                                                                       0x1d249
#define regSDMA3_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA3_GFX_WATERMARK                                                                          0x1d24a
#define regSDMA3_GFX_WATERMARK_BASE_IDX                                                                 0
#define regSDMA3_GFX_DOORBELL_OFFSET                                                                    0x1d24b
#define regSDMA3_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA3_GFX_CSA_ADDR_LO                                                                        0x1d24c
#define regSDMA3_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA3_GFX_CSA_ADDR_HI                                                                        0x1d24d
#define regSDMA3_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA3_GFX_IB_SUB_REMAIN                                                                      0x1d24f
#define regSDMA3_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA3_GFX_PREEMPT                                                                            0x1d250
#define regSDMA3_GFX_PREEMPT_BASE_IDX                                                                   0
#define regSDMA3_GFX_DUMMY_REG                                                                          0x1d251
#define regSDMA3_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA3_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x1d252
#define regSDMA3_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA3_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x1d253
#define regSDMA3_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA3_GFX_RB_AQL_CNTL                                                                        0x1d254
#define regSDMA3_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA3_GFX_MINOR_PTR_UPDATE                                                                   0x1d255
#define regSDMA3_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA3_GFX_MIDCMD_DATA0                                                                       0x1d260
#define regSDMA3_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA1                                                                       0x1d261
#define regSDMA3_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA2                                                                       0x1d262
#define regSDMA3_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA3                                                                       0x1d263
#define regSDMA3_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA4                                                                       0x1d264
#define regSDMA3_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA5                                                                       0x1d265
#define regSDMA3_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA6                                                                       0x1d266
#define regSDMA3_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA7                                                                       0x1d267
#define regSDMA3_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA8                                                                       0x1d268
#define regSDMA3_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA9                                                                       0x1d269
#define regSDMA3_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA3_GFX_MIDCMD_DATA10                                                                      0x1d26a
#define regSDMA3_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA3_GFX_MIDCMD_CNTL                                                                        0x1d26b
#define regSDMA3_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA3_PAGE_RB_CNTL                                                                           0x1d278
#define regSDMA3_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_PAGE_RB_BASE                                                                           0x1d279
#define regSDMA3_PAGE_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_PAGE_RB_BASE_HI                                                                        0x1d27a
#define regSDMA3_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_PAGE_RB_RPTR                                                                           0x1d27b
#define regSDMA3_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_PAGE_RB_RPTR_HI                                                                        0x1d27c
#define regSDMA3_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_PAGE_RB_WPTR                                                                           0x1d27d
#define regSDMA3_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_PAGE_RB_WPTR_HI                                                                        0x1d27e
#define regSDMA3_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_PAGE_RB_WPTR_POLL_CNTL                                                                 0x1d27f
#define regSDMA3_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_PAGE_RB_RPTR_ADDR_HI                                                                   0x1d280
#define regSDMA3_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_PAGE_RB_RPTR_ADDR_LO                                                                   0x1d281
#define regSDMA3_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_PAGE_IB_CNTL                                                                           0x1d282
#define regSDMA3_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_PAGE_IB_RPTR                                                                           0x1d283
#define regSDMA3_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_PAGE_IB_OFFSET                                                                         0x1d284
#define regSDMA3_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_PAGE_IB_BASE_LO                                                                        0x1d285
#define regSDMA3_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_PAGE_IB_BASE_HI                                                                        0x1d286
#define regSDMA3_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_PAGE_IB_SIZE                                                                           0x1d287
#define regSDMA3_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_PAGE_SKIP_CNTL                                                                         0x1d288
#define regSDMA3_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_PAGE_CONTEXT_STATUS                                                                    0x1d289
#define regSDMA3_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_PAGE_DOORBELL                                                                          0x1d28a
#define regSDMA3_PAGE_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_PAGE_STATUS                                                                            0x1d2a0
#define regSDMA3_PAGE_STATUS_BASE_IDX                                                                   0
#define regSDMA3_PAGE_DOORBELL_LOG                                                                      0x1d2a1
#define regSDMA3_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_PAGE_WATERMARK                                                                         0x1d2a2
#define regSDMA3_PAGE_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_PAGE_DOORBELL_OFFSET                                                                   0x1d2a3
#define regSDMA3_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_PAGE_CSA_ADDR_LO                                                                       0x1d2a4
#define regSDMA3_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_PAGE_CSA_ADDR_HI                                                                       0x1d2a5
#define regSDMA3_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_PAGE_IB_SUB_REMAIN                                                                     0x1d2a7
#define regSDMA3_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_PAGE_PREEMPT                                                                           0x1d2a8
#define regSDMA3_PAGE_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_PAGE_DUMMY_REG                                                                         0x1d2a9
#define regSDMA3_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x1d2aa
#define regSDMA3_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x1d2ab
#define regSDMA3_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_PAGE_RB_AQL_CNTL                                                                       0x1d2ac
#define regSDMA3_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_PAGE_MINOR_PTR_UPDATE                                                                  0x1d2ad
#define regSDMA3_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_PAGE_MIDCMD_DATA0                                                                      0x1d2b8
#define regSDMA3_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA1                                                                      0x1d2b9
#define regSDMA3_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA2                                                                      0x1d2ba
#define regSDMA3_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA3                                                                      0x1d2bb
#define regSDMA3_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA4                                                                      0x1d2bc
#define regSDMA3_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA5                                                                      0x1d2bd
#define regSDMA3_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA6                                                                      0x1d2be
#define regSDMA3_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA7                                                                      0x1d2bf
#define regSDMA3_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA8                                                                      0x1d2c0
#define regSDMA3_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA9                                                                      0x1d2c1
#define regSDMA3_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_PAGE_MIDCMD_DATA10                                                                     0x1d2c2
#define regSDMA3_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_PAGE_MIDCMD_CNTL                                                                       0x1d2c3
#define regSDMA3_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC0_RB_CNTL                                                                           0x1d2d0
#define regSDMA3_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC0_RB_BASE                                                                           0x1d2d1
#define regSDMA3_RLC0_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC0_RB_BASE_HI                                                                        0x1d2d2
#define regSDMA3_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC0_RB_RPTR                                                                           0x1d2d3
#define regSDMA3_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC0_RB_RPTR_HI                                                                        0x1d2d4
#define regSDMA3_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC0_RB_WPTR                                                                           0x1d2d5
#define regSDMA3_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC0_RB_WPTR_HI                                                                        0x1d2d6
#define regSDMA3_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC0_RB_WPTR_POLL_CNTL                                                                 0x1d2d7
#define regSDMA3_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC0_RB_RPTR_ADDR_HI                                                                   0x1d2d8
#define regSDMA3_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC0_RB_RPTR_ADDR_LO                                                                   0x1d2d9
#define regSDMA3_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC0_IB_CNTL                                                                           0x1d2da
#define regSDMA3_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC0_IB_RPTR                                                                           0x1d2db
#define regSDMA3_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC0_IB_OFFSET                                                                         0x1d2dc
#define regSDMA3_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC0_IB_BASE_LO                                                                        0x1d2dd
#define regSDMA3_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC0_IB_BASE_HI                                                                        0x1d2de
#define regSDMA3_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC0_IB_SIZE                                                                           0x1d2df
#define regSDMA3_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC0_SKIP_CNTL                                                                         0x1d2e0
#define regSDMA3_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC0_CONTEXT_STATUS                                                                    0x1d2e1
#define regSDMA3_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC0_DOORBELL                                                                          0x1d2e2
#define regSDMA3_RLC0_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC0_STATUS                                                                            0x1d2f8
#define regSDMA3_RLC0_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC0_DOORBELL_LOG                                                                      0x1d2f9
#define regSDMA3_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC0_WATERMARK                                                                         0x1d2fa
#define regSDMA3_RLC0_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC0_DOORBELL_OFFSET                                                                   0x1d2fb
#define regSDMA3_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC0_CSA_ADDR_LO                                                                       0x1d2fc
#define regSDMA3_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC0_CSA_ADDR_HI                                                                       0x1d2fd
#define regSDMA3_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC0_IB_SUB_REMAIN                                                                     0x1d2ff
#define regSDMA3_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC0_PREEMPT                                                                           0x1d300
#define regSDMA3_RLC0_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC0_DUMMY_REG                                                                         0x1d301
#define regSDMA3_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x1d302
#define regSDMA3_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x1d303
#define regSDMA3_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC0_RB_AQL_CNTL                                                                       0x1d304
#define regSDMA3_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC0_MINOR_PTR_UPDATE                                                                  0x1d305
#define regSDMA3_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC0_MIDCMD_DATA0                                                                      0x1d310
#define regSDMA3_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA1                                                                      0x1d311
#define regSDMA3_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA2                                                                      0x1d312
#define regSDMA3_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA3                                                                      0x1d313
#define regSDMA3_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA4                                                                      0x1d314
#define regSDMA3_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA5                                                                      0x1d315
#define regSDMA3_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA6                                                                      0x1d316
#define regSDMA3_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA7                                                                      0x1d317
#define regSDMA3_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA8                                                                      0x1d318
#define regSDMA3_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA9                                                                      0x1d319
#define regSDMA3_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC0_MIDCMD_DATA10                                                                     0x1d31a
#define regSDMA3_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC0_MIDCMD_CNTL                                                                       0x1d31b
#define regSDMA3_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC1_RB_CNTL                                                                           0x1d328
#define regSDMA3_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC1_RB_BASE                                                                           0x1d329
#define regSDMA3_RLC1_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC1_RB_BASE_HI                                                                        0x1d32a
#define regSDMA3_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC1_RB_RPTR                                                                           0x1d32b
#define regSDMA3_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC1_RB_RPTR_HI                                                                        0x1d32c
#define regSDMA3_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC1_RB_WPTR                                                                           0x1d32d
#define regSDMA3_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC1_RB_WPTR_HI                                                                        0x1d32e
#define regSDMA3_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC1_RB_WPTR_POLL_CNTL                                                                 0x1d32f
#define regSDMA3_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC1_RB_RPTR_ADDR_HI                                                                   0x1d330
#define regSDMA3_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC1_RB_RPTR_ADDR_LO                                                                   0x1d331
#define regSDMA3_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC1_IB_CNTL                                                                           0x1d332
#define regSDMA3_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC1_IB_RPTR                                                                           0x1d333
#define regSDMA3_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC1_IB_OFFSET                                                                         0x1d334
#define regSDMA3_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC1_IB_BASE_LO                                                                        0x1d335
#define regSDMA3_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC1_IB_BASE_HI                                                                        0x1d336
#define regSDMA3_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC1_IB_SIZE                                                                           0x1d337
#define regSDMA3_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC1_SKIP_CNTL                                                                         0x1d338
#define regSDMA3_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC1_CONTEXT_STATUS                                                                    0x1d339
#define regSDMA3_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC1_DOORBELL                                                                          0x1d33a
#define regSDMA3_RLC1_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC1_STATUS                                                                            0x1d350
#define regSDMA3_RLC1_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC1_DOORBELL_LOG                                                                      0x1d351
#define regSDMA3_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC1_WATERMARK                                                                         0x1d352
#define regSDMA3_RLC1_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC1_DOORBELL_OFFSET                                                                   0x1d353
#define regSDMA3_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC1_CSA_ADDR_LO                                                                       0x1d354
#define regSDMA3_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC1_CSA_ADDR_HI                                                                       0x1d355
#define regSDMA3_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC1_IB_SUB_REMAIN                                                                     0x1d357
#define regSDMA3_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC1_PREEMPT                                                                           0x1d358
#define regSDMA3_RLC1_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC1_DUMMY_REG                                                                         0x1d359
#define regSDMA3_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x1d35a
#define regSDMA3_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x1d35b
#define regSDMA3_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC1_RB_AQL_CNTL                                                                       0x1d35c
#define regSDMA3_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC1_MINOR_PTR_UPDATE                                                                  0x1d35d
#define regSDMA3_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC1_MIDCMD_DATA0                                                                      0x1d368
#define regSDMA3_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA1                                                                      0x1d369
#define regSDMA3_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA2                                                                      0x1d36a
#define regSDMA3_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA3                                                                      0x1d36b
#define regSDMA3_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA4                                                                      0x1d36c
#define regSDMA3_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA5                                                                      0x1d36d
#define regSDMA3_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA6                                                                      0x1d36e
#define regSDMA3_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA7                                                                      0x1d36f
#define regSDMA3_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA8                                                                      0x1d370
#define regSDMA3_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA9                                                                      0x1d371
#define regSDMA3_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC1_MIDCMD_DATA10                                                                     0x1d372
#define regSDMA3_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC1_MIDCMD_CNTL                                                                       0x1d373
#define regSDMA3_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC2_RB_CNTL                                                                           0x1d380
#define regSDMA3_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC2_RB_BASE                                                                           0x1d381
#define regSDMA3_RLC2_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC2_RB_BASE_HI                                                                        0x1d382
#define regSDMA3_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC2_RB_RPTR                                                                           0x1d383
#define regSDMA3_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC2_RB_RPTR_HI                                                                        0x1d384
#define regSDMA3_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC2_RB_WPTR                                                                           0x1d385
#define regSDMA3_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC2_RB_WPTR_HI                                                                        0x1d386
#define regSDMA3_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC2_RB_WPTR_POLL_CNTL                                                                 0x1d387
#define regSDMA3_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC2_RB_RPTR_ADDR_HI                                                                   0x1d388
#define regSDMA3_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC2_RB_RPTR_ADDR_LO                                                                   0x1d389
#define regSDMA3_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC2_IB_CNTL                                                                           0x1d38a
#define regSDMA3_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC2_IB_RPTR                                                                           0x1d38b
#define regSDMA3_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC2_IB_OFFSET                                                                         0x1d38c
#define regSDMA3_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC2_IB_BASE_LO                                                                        0x1d38d
#define regSDMA3_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC2_IB_BASE_HI                                                                        0x1d38e
#define regSDMA3_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC2_IB_SIZE                                                                           0x1d38f
#define regSDMA3_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC2_SKIP_CNTL                                                                         0x1d390
#define regSDMA3_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC2_CONTEXT_STATUS                                                                    0x1d391
#define regSDMA3_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC2_DOORBELL                                                                          0x1d392
#define regSDMA3_RLC2_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC2_STATUS                                                                            0x1d3a8
#define regSDMA3_RLC2_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC2_DOORBELL_LOG                                                                      0x1d3a9
#define regSDMA3_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC2_WATERMARK                                                                         0x1d3aa
#define regSDMA3_RLC2_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC2_DOORBELL_OFFSET                                                                   0x1d3ab
#define regSDMA3_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC2_CSA_ADDR_LO                                                                       0x1d3ac
#define regSDMA3_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC2_CSA_ADDR_HI                                                                       0x1d3ad
#define regSDMA3_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC2_IB_SUB_REMAIN                                                                     0x1d3af
#define regSDMA3_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC2_PREEMPT                                                                           0x1d3b0
#define regSDMA3_RLC2_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC2_DUMMY_REG                                                                         0x1d3b1
#define regSDMA3_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x1d3b2
#define regSDMA3_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x1d3b3
#define regSDMA3_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC2_RB_AQL_CNTL                                                                       0x1d3b4
#define regSDMA3_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC2_MINOR_PTR_UPDATE                                                                  0x1d3b5
#define regSDMA3_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC2_MIDCMD_DATA0                                                                      0x1d3c0
#define regSDMA3_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA1                                                                      0x1d3c1
#define regSDMA3_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA2                                                                      0x1d3c2
#define regSDMA3_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA3                                                                      0x1d3c3
#define regSDMA3_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA4                                                                      0x1d3c4
#define regSDMA3_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA5                                                                      0x1d3c5
#define regSDMA3_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA6                                                                      0x1d3c6
#define regSDMA3_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA7                                                                      0x1d3c7
#define regSDMA3_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA8                                                                      0x1d3c8
#define regSDMA3_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA9                                                                      0x1d3c9
#define regSDMA3_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC2_MIDCMD_DATA10                                                                     0x1d3ca
#define regSDMA3_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC2_MIDCMD_CNTL                                                                       0x1d3cb
#define regSDMA3_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC3_RB_CNTL                                                                           0x1d3d8
#define regSDMA3_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC3_RB_BASE                                                                           0x1d3d9
#define regSDMA3_RLC3_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC3_RB_BASE_HI                                                                        0x1d3da
#define regSDMA3_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC3_RB_RPTR                                                                           0x1d3db
#define regSDMA3_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC3_RB_RPTR_HI                                                                        0x1d3dc
#define regSDMA3_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC3_RB_WPTR                                                                           0x1d3dd
#define regSDMA3_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC3_RB_WPTR_HI                                                                        0x1d3de
#define regSDMA3_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC3_RB_WPTR_POLL_CNTL                                                                 0x1d3df
#define regSDMA3_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC3_RB_RPTR_ADDR_HI                                                                   0x1d3e0
#define regSDMA3_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC3_RB_RPTR_ADDR_LO                                                                   0x1d3e1
#define regSDMA3_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC3_IB_CNTL                                                                           0x1d3e2
#define regSDMA3_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC3_IB_RPTR                                                                           0x1d3e3
#define regSDMA3_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC3_IB_OFFSET                                                                         0x1d3e4
#define regSDMA3_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC3_IB_BASE_LO                                                                        0x1d3e5
#define regSDMA3_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC3_IB_BASE_HI                                                                        0x1d3e6
#define regSDMA3_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC3_IB_SIZE                                                                           0x1d3e7
#define regSDMA3_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC3_SKIP_CNTL                                                                         0x1d3e8
#define regSDMA3_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC3_CONTEXT_STATUS                                                                    0x1d3e9
#define regSDMA3_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC3_DOORBELL                                                                          0x1d3ea
#define regSDMA3_RLC3_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC3_STATUS                                                                            0x1d400
#define regSDMA3_RLC3_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC3_DOORBELL_LOG                                                                      0x1d401
#define regSDMA3_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC3_WATERMARK                                                                         0x1d402
#define regSDMA3_RLC3_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC3_DOORBELL_OFFSET                                                                   0x1d403
#define regSDMA3_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC3_CSA_ADDR_LO                                                                       0x1d404
#define regSDMA3_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC3_CSA_ADDR_HI                                                                       0x1d405
#define regSDMA3_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC3_IB_SUB_REMAIN                                                                     0x1d407
#define regSDMA3_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC3_PREEMPT                                                                           0x1d408
#define regSDMA3_RLC3_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC3_DUMMY_REG                                                                         0x1d409
#define regSDMA3_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x1d40a
#define regSDMA3_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x1d40b
#define regSDMA3_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC3_RB_AQL_CNTL                                                                       0x1d40c
#define regSDMA3_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC3_MINOR_PTR_UPDATE                                                                  0x1d40d
#define regSDMA3_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC3_MIDCMD_DATA0                                                                      0x1d418
#define regSDMA3_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA1                                                                      0x1d419
#define regSDMA3_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA2                                                                      0x1d41a
#define regSDMA3_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA3                                                                      0x1d41b
#define regSDMA3_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA4                                                                      0x1d41c
#define regSDMA3_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA5                                                                      0x1d41d
#define regSDMA3_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA6                                                                      0x1d41e
#define regSDMA3_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA7                                                                      0x1d41f
#define regSDMA3_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA8                                                                      0x1d420
#define regSDMA3_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA9                                                                      0x1d421
#define regSDMA3_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC3_MIDCMD_DATA10                                                                     0x1d422
#define regSDMA3_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC3_MIDCMD_CNTL                                                                       0x1d423
#define regSDMA3_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC4_RB_CNTL                                                                           0x1d430
#define regSDMA3_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC4_RB_BASE                                                                           0x1d431
#define regSDMA3_RLC4_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC4_RB_BASE_HI                                                                        0x1d432
#define regSDMA3_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC4_RB_RPTR                                                                           0x1d433
#define regSDMA3_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC4_RB_RPTR_HI                                                                        0x1d434
#define regSDMA3_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC4_RB_WPTR                                                                           0x1d435
#define regSDMA3_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC4_RB_WPTR_HI                                                                        0x1d436
#define regSDMA3_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC4_RB_WPTR_POLL_CNTL                                                                 0x1d437
#define regSDMA3_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC4_RB_RPTR_ADDR_HI                                                                   0x1d438
#define regSDMA3_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC4_RB_RPTR_ADDR_LO                                                                   0x1d439
#define regSDMA3_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC4_IB_CNTL                                                                           0x1d43a
#define regSDMA3_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC4_IB_RPTR                                                                           0x1d43b
#define regSDMA3_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC4_IB_OFFSET                                                                         0x1d43c
#define regSDMA3_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC4_IB_BASE_LO                                                                        0x1d43d
#define regSDMA3_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC4_IB_BASE_HI                                                                        0x1d43e
#define regSDMA3_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC4_IB_SIZE                                                                           0x1d43f
#define regSDMA3_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC4_SKIP_CNTL                                                                         0x1d440
#define regSDMA3_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC4_CONTEXT_STATUS                                                                    0x1d441
#define regSDMA3_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC4_DOORBELL                                                                          0x1d442
#define regSDMA3_RLC4_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC4_STATUS                                                                            0x1d458
#define regSDMA3_RLC4_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC4_DOORBELL_LOG                                                                      0x1d459
#define regSDMA3_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC4_WATERMARK                                                                         0x1d45a
#define regSDMA3_RLC4_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC4_DOORBELL_OFFSET                                                                   0x1d45b
#define regSDMA3_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC4_CSA_ADDR_LO                                                                       0x1d45c
#define regSDMA3_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC4_CSA_ADDR_HI                                                                       0x1d45d
#define regSDMA3_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC4_IB_SUB_REMAIN                                                                     0x1d45f
#define regSDMA3_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC4_PREEMPT                                                                           0x1d460
#define regSDMA3_RLC4_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC4_DUMMY_REG                                                                         0x1d461
#define regSDMA3_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x1d462
#define regSDMA3_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x1d463
#define regSDMA3_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC4_RB_AQL_CNTL                                                                       0x1d464
#define regSDMA3_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC4_MINOR_PTR_UPDATE                                                                  0x1d465
#define regSDMA3_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC4_MIDCMD_DATA0                                                                      0x1d470
#define regSDMA3_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA1                                                                      0x1d471
#define regSDMA3_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA2                                                                      0x1d472
#define regSDMA3_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA3                                                                      0x1d473
#define regSDMA3_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA4                                                                      0x1d474
#define regSDMA3_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA5                                                                      0x1d475
#define regSDMA3_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA6                                                                      0x1d476
#define regSDMA3_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA7                                                                      0x1d477
#define regSDMA3_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA8                                                                      0x1d478
#define regSDMA3_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA9                                                                      0x1d479
#define regSDMA3_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC4_MIDCMD_DATA10                                                                     0x1d47a
#define regSDMA3_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC4_MIDCMD_CNTL                                                                       0x1d47b
#define regSDMA3_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC5_RB_CNTL                                                                           0x1d488
#define regSDMA3_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC5_RB_BASE                                                                           0x1d489
#define regSDMA3_RLC5_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC5_RB_BASE_HI                                                                        0x1d48a
#define regSDMA3_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC5_RB_RPTR                                                                           0x1d48b
#define regSDMA3_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC5_RB_RPTR_HI                                                                        0x1d48c
#define regSDMA3_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC5_RB_WPTR                                                                           0x1d48d
#define regSDMA3_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC5_RB_WPTR_HI                                                                        0x1d48e
#define regSDMA3_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC5_RB_WPTR_POLL_CNTL                                                                 0x1d48f
#define regSDMA3_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC5_RB_RPTR_ADDR_HI                                                                   0x1d490
#define regSDMA3_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC5_RB_RPTR_ADDR_LO                                                                   0x1d491
#define regSDMA3_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC5_IB_CNTL                                                                           0x1d492
#define regSDMA3_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC5_IB_RPTR                                                                           0x1d493
#define regSDMA3_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC5_IB_OFFSET                                                                         0x1d494
#define regSDMA3_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC5_IB_BASE_LO                                                                        0x1d495
#define regSDMA3_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC5_IB_BASE_HI                                                                        0x1d496
#define regSDMA3_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC5_IB_SIZE                                                                           0x1d497
#define regSDMA3_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC5_SKIP_CNTL                                                                         0x1d498
#define regSDMA3_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC5_CONTEXT_STATUS                                                                    0x1d499
#define regSDMA3_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC5_DOORBELL                                                                          0x1d49a
#define regSDMA3_RLC5_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC5_STATUS                                                                            0x1d4b0
#define regSDMA3_RLC5_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC5_DOORBELL_LOG                                                                      0x1d4b1
#define regSDMA3_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC5_WATERMARK                                                                         0x1d4b2
#define regSDMA3_RLC5_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC5_DOORBELL_OFFSET                                                                   0x1d4b3
#define regSDMA3_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC5_CSA_ADDR_LO                                                                       0x1d4b4
#define regSDMA3_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC5_CSA_ADDR_HI                                                                       0x1d4b5
#define regSDMA3_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC5_IB_SUB_REMAIN                                                                     0x1d4b7
#define regSDMA3_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC5_PREEMPT                                                                           0x1d4b8
#define regSDMA3_RLC5_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC5_DUMMY_REG                                                                         0x1d4b9
#define regSDMA3_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x1d4ba
#define regSDMA3_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x1d4bb
#define regSDMA3_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC5_RB_AQL_CNTL                                                                       0x1d4bc
#define regSDMA3_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC5_MINOR_PTR_UPDATE                                                                  0x1d4bd
#define regSDMA3_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC5_MIDCMD_DATA0                                                                      0x1d4c8
#define regSDMA3_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA1                                                                      0x1d4c9
#define regSDMA3_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA2                                                                      0x1d4ca
#define regSDMA3_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA3                                                                      0x1d4cb
#define regSDMA3_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA4                                                                      0x1d4cc
#define regSDMA3_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA5                                                                      0x1d4cd
#define regSDMA3_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA6                                                                      0x1d4ce
#define regSDMA3_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA7                                                                      0x1d4cf
#define regSDMA3_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA8                                                                      0x1d4d0
#define regSDMA3_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA9                                                                      0x1d4d1
#define regSDMA3_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC5_MIDCMD_DATA10                                                                     0x1d4d2
#define regSDMA3_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC5_MIDCMD_CNTL                                                                       0x1d4d3
#define regSDMA3_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC6_RB_CNTL                                                                           0x1d4e0
#define regSDMA3_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC6_RB_BASE                                                                           0x1d4e1
#define regSDMA3_RLC6_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC6_RB_BASE_HI                                                                        0x1d4e2
#define regSDMA3_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC6_RB_RPTR                                                                           0x1d4e3
#define regSDMA3_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC6_RB_RPTR_HI                                                                        0x1d4e4
#define regSDMA3_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC6_RB_WPTR                                                                           0x1d4e5
#define regSDMA3_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC6_RB_WPTR_HI                                                                        0x1d4e6
#define regSDMA3_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC6_RB_WPTR_POLL_CNTL                                                                 0x1d4e7
#define regSDMA3_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC6_RB_RPTR_ADDR_HI                                                                   0x1d4e8
#define regSDMA3_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC6_RB_RPTR_ADDR_LO                                                                   0x1d4e9
#define regSDMA3_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC6_IB_CNTL                                                                           0x1d4ea
#define regSDMA3_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC6_IB_RPTR                                                                           0x1d4eb
#define regSDMA3_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC6_IB_OFFSET                                                                         0x1d4ec
#define regSDMA3_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC6_IB_BASE_LO                                                                        0x1d4ed
#define regSDMA3_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC6_IB_BASE_HI                                                                        0x1d4ee
#define regSDMA3_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC6_IB_SIZE                                                                           0x1d4ef
#define regSDMA3_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC6_SKIP_CNTL                                                                         0x1d4f0
#define regSDMA3_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC6_CONTEXT_STATUS                                                                    0x1d4f1
#define regSDMA3_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC6_DOORBELL                                                                          0x1d4f2
#define regSDMA3_RLC6_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC6_STATUS                                                                            0x1d508
#define regSDMA3_RLC6_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC6_DOORBELL_LOG                                                                      0x1d509
#define regSDMA3_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC6_WATERMARK                                                                         0x1d50a
#define regSDMA3_RLC6_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC6_DOORBELL_OFFSET                                                                   0x1d50b
#define regSDMA3_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC6_CSA_ADDR_LO                                                                       0x1d50c
#define regSDMA3_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC6_CSA_ADDR_HI                                                                       0x1d50d
#define regSDMA3_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC6_IB_SUB_REMAIN                                                                     0x1d50f
#define regSDMA3_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC6_PREEMPT                                                                           0x1d510
#define regSDMA3_RLC6_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC6_DUMMY_REG                                                                         0x1d511
#define regSDMA3_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x1d512
#define regSDMA3_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x1d513
#define regSDMA3_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC6_RB_AQL_CNTL                                                                       0x1d514
#define regSDMA3_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC6_MINOR_PTR_UPDATE                                                                  0x1d515
#define regSDMA3_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC6_MIDCMD_DATA0                                                                      0x1d520
#define regSDMA3_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA1                                                                      0x1d521
#define regSDMA3_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA2                                                                      0x1d522
#define regSDMA3_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA3                                                                      0x1d523
#define regSDMA3_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA4                                                                      0x1d524
#define regSDMA3_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA5                                                                      0x1d525
#define regSDMA3_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA6                                                                      0x1d526
#define regSDMA3_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA7                                                                      0x1d527
#define regSDMA3_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA8                                                                      0x1d528
#define regSDMA3_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA9                                                                      0x1d529
#define regSDMA3_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC6_MIDCMD_DATA10                                                                     0x1d52a
#define regSDMA3_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC6_MIDCMD_CNTL                                                                       0x1d52b
#define regSDMA3_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC7_RB_CNTL                                                                           0x1d538
#define regSDMA3_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC7_RB_BASE                                                                           0x1d539
#define regSDMA3_RLC7_RB_BASE_BASE_IDX                                                                  0
#define regSDMA3_RLC7_RB_BASE_HI                                                                        0x1d53a
#define regSDMA3_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC7_RB_RPTR                                                                           0x1d53b
#define regSDMA3_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC7_RB_RPTR_HI                                                                        0x1d53c
#define regSDMA3_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC7_RB_WPTR                                                                           0x1d53d
#define regSDMA3_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC7_RB_WPTR_HI                                                                        0x1d53e
#define regSDMA3_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA3_RLC7_RB_WPTR_POLL_CNTL                                                                 0x1d53f
#define regSDMA3_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA3_RLC7_RB_RPTR_ADDR_HI                                                                   0x1d540
#define regSDMA3_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA3_RLC7_RB_RPTR_ADDR_LO                                                                   0x1d541
#define regSDMA3_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA3_RLC7_IB_CNTL                                                                           0x1d542
#define regSDMA3_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA3_RLC7_IB_RPTR                                                                           0x1d543
#define regSDMA3_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA3_RLC7_IB_OFFSET                                                                         0x1d544
#define regSDMA3_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA3_RLC7_IB_BASE_LO                                                                        0x1d545
#define regSDMA3_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA3_RLC7_IB_BASE_HI                                                                        0x1d546
#define regSDMA3_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA3_RLC7_IB_SIZE                                                                           0x1d547
#define regSDMA3_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA3_RLC7_SKIP_CNTL                                                                         0x1d548
#define regSDMA3_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA3_RLC7_CONTEXT_STATUS                                                                    0x1d549
#define regSDMA3_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA3_RLC7_DOORBELL                                                                          0x1d54a
#define regSDMA3_RLC7_DOORBELL_BASE_IDX                                                                 0
#define regSDMA3_RLC7_STATUS                                                                            0x1d560
#define regSDMA3_RLC7_STATUS_BASE_IDX                                                                   0
#define regSDMA3_RLC7_DOORBELL_LOG                                                                      0x1d561
#define regSDMA3_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA3_RLC7_WATERMARK                                                                         0x1d562
#define regSDMA3_RLC7_WATERMARK_BASE_IDX                                                                0
#define regSDMA3_RLC7_DOORBELL_OFFSET                                                                   0x1d563
#define regSDMA3_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA3_RLC7_CSA_ADDR_LO                                                                       0x1d564
#define regSDMA3_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA3_RLC7_CSA_ADDR_HI                                                                       0x1d565
#define regSDMA3_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA3_RLC7_IB_SUB_REMAIN                                                                     0x1d567
#define regSDMA3_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA3_RLC7_PREEMPT                                                                           0x1d568
#define regSDMA3_RLC7_PREEMPT_BASE_IDX                                                                  0
#define regSDMA3_RLC7_DUMMY_REG                                                                         0x1d569
#define regSDMA3_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA3_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x1d56a
#define regSDMA3_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA3_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x1d56b
#define regSDMA3_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA3_RLC7_RB_AQL_CNTL                                                                       0x1d56c
#define regSDMA3_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA3_RLC7_MINOR_PTR_UPDATE                                                                  0x1d56d
#define regSDMA3_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA3_RLC7_MIDCMD_DATA0                                                                      0x1d578
#define regSDMA3_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA1                                                                      0x1d579
#define regSDMA3_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA2                                                                      0x1d57a
#define regSDMA3_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA3                                                                      0x1d57b
#define regSDMA3_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA4                                                                      0x1d57c
#define regSDMA3_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA5                                                                      0x1d57d
#define regSDMA3_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA6                                                                      0x1d57e
#define regSDMA3_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA7                                                                      0x1d57f
#define regSDMA3_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA8                                                                      0x1d580
#define regSDMA3_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA9                                                                      0x1d581
#define regSDMA3_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA3_RLC7_MIDCMD_DATA10                                                                     0x1d582
#define regSDMA3_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA3_RLC7_MIDCMD_CNTL                                                                       0x1d583
#define regSDMA3_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0


// addressBlock: sdma0_sdma4dec
// base address: 0x7a000
#define regSDMA4_UCODE_ADDR                                                                             0x1d5a0
#define regSDMA4_UCODE_ADDR_BASE_IDX                                                                    0
#define regSDMA4_UCODE_DATA                                                                             0x1d5a1
#define regSDMA4_UCODE_DATA_BASE_IDX                                                                    0
#define regSDMA4_VF_ENABLE                                                                              0x1d5aa
#define regSDMA4_VF_ENABLE_BASE_IDX                                                                     0
#define regSDMA4_CONTEXT_GROUP_BOUNDARY                                                                 0x1d5b9
#define regSDMA4_CONTEXT_GROUP_BOUNDARY_BASE_IDX                                                        0
#define regSDMA4_POWER_CNTL                                                                             0x1d5ba
#define regSDMA4_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA4_CLK_CTRL                                                                               0x1d5bb
#define regSDMA4_CLK_CTRL_BASE_IDX                                                                      0
#define regSDMA4_CNTL                                                                                   0x1d5bc
#define regSDMA4_CNTL_BASE_IDX                                                                          0
#define regSDMA4_CHICKEN_BITS                                                                           0x1d5bd
#define regSDMA4_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA4_GB_ADDR_CONFIG                                                                         0x1d5be
#define regSDMA4_GB_ADDR_CONFIG_BASE_IDX                                                                0
#define regSDMA4_GB_ADDR_CONFIG_READ                                                                    0x1d5bf
#define regSDMA4_GB_ADDR_CONFIG_READ_BASE_IDX                                                           0
#define regSDMA4_RB_RPTR_FETCH_HI                                                                       0x1d5c0
#define regSDMA4_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA4_SEM_WAIT_FAIL_TIMER_CNTL                                                               0x1d5c1
#define regSDMA4_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                      0
#define regSDMA4_RB_RPTR_FETCH                                                                          0x1d5c2
#define regSDMA4_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA4_IB_OFFSET_FETCH                                                                        0x1d5c3
#define regSDMA4_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA4_PROGRAM                                                                                0x1d5c4
#define regSDMA4_PROGRAM_BASE_IDX                                                                       0
#define regSDMA4_STATUS_REG                                                                             0x1d5c5
#define regSDMA4_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA4_STATUS1_REG                                                                            0x1d5c6
#define regSDMA4_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA4_RD_BURST_CNTL                                                                          0x1d5c7
#define regSDMA4_RD_BURST_CNTL_BASE_IDX                                                                 0
#define regSDMA4_HBM_PAGE_CONFIG                                                                        0x1d5c8
#define regSDMA4_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA4_UCODE_CHECKSUM                                                                         0x1d5c9
#define regSDMA4_UCODE_CHECKSUM_BASE_IDX                                                                0
#define regSDMA4_F32_CNTL                                                                               0x1d5ca
#define regSDMA4_F32_CNTL_BASE_IDX                                                                      0
#define regSDMA4_FREEZE                                                                                 0x1d5cb
#define regSDMA4_FREEZE_BASE_IDX                                                                        0
#define regSDMA4_PHASE0_QUANTUM                                                                         0x1d5cc
#define regSDMA4_PHASE0_QUANTUM_BASE_IDX                                                                0
#define regSDMA4_PHASE1_QUANTUM                                                                         0x1d5cd
#define regSDMA4_PHASE1_QUANTUM_BASE_IDX                                                                0
#define regCC_SDMA4_EDC_CONFIG                                                                          0x1d5d2
#define regCC_SDMA4_EDC_CONFIG_BASE_IDX                                                                 0
#define regSDMA4_BA_THRESHOLD                                                                           0x1d5d3
#define regSDMA4_BA_THRESHOLD_BASE_IDX                                                                  0
#define regSDMA4_ID                                                                                     0x1d5d4
#define regSDMA4_ID_BASE_IDX                                                                            0
#define regSDMA4_VERSION                                                                                0x1d5d5
#define regSDMA4_VERSION_BASE_IDX                                                                       0
#define regSDMA4_EDC_COUNTER                                                                            0x1d5d6
#define regSDMA4_EDC_COUNTER_BASE_IDX                                                                   0
#define regSDMA4_EDC_COUNTER2                                                                           0x1d5d7
#define regSDMA4_EDC_COUNTER2_BASE_IDX                                                                  0
#define regSDMA4_STATUS2_REG                                                                            0x1d5d8
#define regSDMA4_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA4_ATOMIC_CNTL                                                                            0x1d5d9
#define regSDMA4_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA4_ATOMIC_PREOP_LO                                                                        0x1d5da
#define regSDMA4_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA4_ATOMIC_PREOP_HI                                                                        0x1d5db
#define regSDMA4_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA4_UTCL1_CNTL                                                                             0x1d5dc
#define regSDMA4_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA4_UTCL1_WATERMK                                                                          0x1d5dd
#define regSDMA4_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA4_UTCL1_RD_STATUS                                                                        0x1d5de
#define regSDMA4_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA4_UTCL1_WR_STATUS                                                                        0x1d5df
#define regSDMA4_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA4_UTCL1_INV0                                                                             0x1d5e0
#define regSDMA4_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA4_UTCL1_INV1                                                                             0x1d5e1
#define regSDMA4_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA4_UTCL1_INV2                                                                             0x1d5e2
#define regSDMA4_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA4_UTCL1_RD_XNACK0                                                                        0x1d5e3
#define regSDMA4_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA4_UTCL1_RD_XNACK1                                                                        0x1d5e4
#define regSDMA4_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA4_UTCL1_WR_XNACK0                                                                        0x1d5e5
#define regSDMA4_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA4_UTCL1_WR_XNACK1                                                                        0x1d5e6
#define regSDMA4_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA4_UTCL1_TIMEOUT                                                                          0x1d5e7
#define regSDMA4_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA4_UTCL1_PAGE                                                                             0x1d5e8
#define regSDMA4_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA4_POWER_CNTL_IDLE                                                                        0x1d5e9
#define regSDMA4_POWER_CNTL_IDLE_BASE_IDX                                                               0
#define regSDMA4_RELAX_ORDERING_LUT                                                                     0x1d5ea
#define regSDMA4_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA4_CHICKEN_BITS_2                                                                         0x1d5eb
#define regSDMA4_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA4_STATUS3_REG                                                                            0x1d5ec
#define regSDMA4_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA4_PHYSICAL_ADDR_LO                                                                       0x1d5ed
#define regSDMA4_PHYSICAL_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_PHYSICAL_ADDR_HI                                                                       0x1d5ee
#define regSDMA4_PHYSICAL_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_PHASE2_QUANTUM                                                                         0x1d5ef
#define regSDMA4_PHASE2_QUANTUM_BASE_IDX                                                                0
#define regSDMA4_ERROR_LOG                                                                              0x1d5f0
#define regSDMA4_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA4_PUB_DUMMY_REG0                                                                         0x1d5f1
#define regSDMA4_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA4_PUB_DUMMY_REG1                                                                         0x1d5f2
#define regSDMA4_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA4_PUB_DUMMY_REG2                                                                         0x1d5f3
#define regSDMA4_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA4_PUB_DUMMY_REG3                                                                         0x1d5f4
#define regSDMA4_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA4_F32_COUNTER                                                                            0x1d5f5
#define regSDMA4_F32_COUNTER_BASE_IDX                                                                   0
#define regSDMA4_PERFCNT_PERFCOUNTER0_CFG                                                               0x1d5f7
#define regSDMA4_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      0
#define regSDMA4_PERFCNT_PERFCOUNTER1_CFG                                                               0x1d5f8
#define regSDMA4_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      0
#define regSDMA4_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x1d5f9
#define regSDMA4_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 0
#define regSDMA4_PERFCNT_MISC_CNTL                                                                      0x1d5fa
#define regSDMA4_PERFCNT_MISC_CNTL_BASE_IDX                                                             0
#define regSDMA4_PERFCNT_PERFCOUNTER_LO                                                                 0x1d5fb
#define regSDMA4_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        0
#define regSDMA4_PERFCNT_PERFCOUNTER_HI                                                                 0x1d5fc
#define regSDMA4_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        0
#define regSDMA4_CRD_CNTL                                                                               0x1d5fd
#define regSDMA4_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA4_ULV_CNTL                                                                               0x1d5ff
#define regSDMA4_ULV_CNTL_BASE_IDX                                                                      0
#define regSDMA4_EA_DBIT_ADDR_DATA                                                                      0x1d600
#define regSDMA4_EA_DBIT_ADDR_DATA_BASE_IDX                                                             0
#define regSDMA4_EA_DBIT_ADDR_INDEX                                                                     0x1d601
#define regSDMA4_EA_DBIT_ADDR_INDEX_BASE_IDX                                                            0
#define regSDMA4_STATUS4_REG                                                                            0x1d603
#define regSDMA4_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA4_SCRATCH_RAM_DATA                                                                       0x1d604
#define regSDMA4_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA4_SCRATCH_RAM_ADDR                                                                       0x1d605
#define regSDMA4_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA4_CE_CTRL                                                                                0x1d606
#define regSDMA4_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA4_RAS_STATUS                                                                             0x1d607
#define regSDMA4_RAS_STATUS_BASE_IDX                                                                    0
#define regSDMA4_CLK_STATUS                                                                             0x1d608
#define regSDMA4_CLK_STATUS_BASE_IDX                                                                    0
#define regSDMA4_GFX_RB_CNTL                                                                            0x1d620
#define regSDMA4_GFX_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA4_GFX_RB_BASE                                                                            0x1d621
#define regSDMA4_GFX_RB_BASE_BASE_IDX                                                                   0
#define regSDMA4_GFX_RB_BASE_HI                                                                         0x1d622
#define regSDMA4_GFX_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA4_GFX_RB_RPTR                                                                            0x1d623
#define regSDMA4_GFX_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA4_GFX_RB_RPTR_HI                                                                         0x1d624
#define regSDMA4_GFX_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA4_GFX_RB_WPTR                                                                            0x1d625
#define regSDMA4_GFX_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA4_GFX_RB_WPTR_HI                                                                         0x1d626
#define regSDMA4_GFX_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA4_GFX_RB_WPTR_POLL_CNTL                                                                  0x1d627
#define regSDMA4_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA4_GFX_RB_RPTR_ADDR_HI                                                                    0x1d628
#define regSDMA4_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA4_GFX_RB_RPTR_ADDR_LO                                                                    0x1d629
#define regSDMA4_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA4_GFX_IB_CNTL                                                                            0x1d62a
#define regSDMA4_GFX_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA4_GFX_IB_RPTR                                                                            0x1d62b
#define regSDMA4_GFX_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA4_GFX_IB_OFFSET                                                                          0x1d62c
#define regSDMA4_GFX_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA4_GFX_IB_BASE_LO                                                                         0x1d62d
#define regSDMA4_GFX_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA4_GFX_IB_BASE_HI                                                                         0x1d62e
#define regSDMA4_GFX_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA4_GFX_IB_SIZE                                                                            0x1d62f
#define regSDMA4_GFX_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA4_GFX_SKIP_CNTL                                                                          0x1d630
#define regSDMA4_GFX_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA4_GFX_CONTEXT_STATUS                                                                     0x1d631
#define regSDMA4_GFX_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA4_GFX_DOORBELL                                                                           0x1d632
#define regSDMA4_GFX_DOORBELL_BASE_IDX                                                                  0
#define regSDMA4_GFX_CONTEXT_CNTL                                                                       0x1d633
#define regSDMA4_GFX_CONTEXT_CNTL_BASE_IDX                                                              0
#define regSDMA4_GFX_STATUS                                                                             0x1d648
#define regSDMA4_GFX_STATUS_BASE_IDX                                                                    0
#define regSDMA4_GFX_DOORBELL_LOG                                                                       0x1d649
#define regSDMA4_GFX_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA4_GFX_WATERMARK                                                                          0x1d64a
#define regSDMA4_GFX_WATERMARK_BASE_IDX                                                                 0
#define regSDMA4_GFX_DOORBELL_OFFSET                                                                    0x1d64b
#define regSDMA4_GFX_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA4_GFX_CSA_ADDR_LO                                                                        0x1d64c
#define regSDMA4_GFX_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA4_GFX_CSA_ADDR_HI                                                                        0x1d64d
#define regSDMA4_GFX_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA4_GFX_IB_SUB_REMAIN                                                                      0x1d64f
#define regSDMA4_GFX_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA4_GFX_PREEMPT                                                                            0x1d650
#define regSDMA4_GFX_PREEMPT_BASE_IDX                                                                   0
#define regSDMA4_GFX_DUMMY_REG                                                                          0x1d651
#define regSDMA4_GFX_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA4_GFX_RB_WPTR_POLL_ADDR_HI                                                               0x1d652
#define regSDMA4_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA4_GFX_RB_WPTR_POLL_ADDR_LO                                                               0x1d653
#define regSDMA4_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA4_GFX_RB_AQL_CNTL                                                                        0x1d654
#define regSDMA4_GFX_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA4_GFX_MINOR_PTR_UPDATE                                                                   0x1d655
#define regSDMA4_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA4_GFX_MIDCMD_DATA0                                                                       0x1d660
#define regSDMA4_GFX_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA1                                                                       0x1d661
#define regSDMA4_GFX_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA2                                                                       0x1d662
#define regSDMA4_GFX_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA3                                                                       0x1d663
#define regSDMA4_GFX_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA4                                                                       0x1d664
#define regSDMA4_GFX_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA5                                                                       0x1d665
#define regSDMA4_GFX_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA6                                                                       0x1d666
#define regSDMA4_GFX_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA7                                                                       0x1d667
#define regSDMA4_GFX_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA8                                                                       0x1d668
#define regSDMA4_GFX_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA9                                                                       0x1d669
#define regSDMA4_GFX_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA4_GFX_MIDCMD_DATA10                                                                      0x1d66a
#define regSDMA4_GFX_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA4_GFX_MIDCMD_CNTL                                                                        0x1d66b
#define regSDMA4_GFX_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA4_PAGE_RB_CNTL                                                                           0x1d678
#define regSDMA4_PAGE_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_PAGE_RB_BASE                                                                           0x1d679
#define regSDMA4_PAGE_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_PAGE_RB_BASE_HI                                                                        0x1d67a
#define regSDMA4_PAGE_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_PAGE_RB_RPTR                                                                           0x1d67b
#define regSDMA4_PAGE_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_PAGE_RB_RPTR_HI                                                                        0x1d67c
#define regSDMA4_PAGE_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_PAGE_RB_WPTR                                                                           0x1d67d
#define regSDMA4_PAGE_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_PAGE_RB_WPTR_HI                                                                        0x1d67e
#define regSDMA4_PAGE_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_PAGE_RB_WPTR_POLL_CNTL                                                                 0x1d67f
#define regSDMA4_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_PAGE_RB_RPTR_ADDR_HI                                                                   0x1d680
#define regSDMA4_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_PAGE_RB_RPTR_ADDR_LO                                                                   0x1d681
#define regSDMA4_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_PAGE_IB_CNTL                                                                           0x1d682
#define regSDMA4_PAGE_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_PAGE_IB_RPTR                                                                           0x1d683
#define regSDMA4_PAGE_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_PAGE_IB_OFFSET                                                                         0x1d684
#define regSDMA4_PAGE_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_PAGE_IB_BASE_LO                                                                        0x1d685
#define regSDMA4_PAGE_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_PAGE_IB_BASE_HI                                                                        0x1d686
#define regSDMA4_PAGE_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_PAGE_IB_SIZE                                                                           0x1d687
#define regSDMA4_PAGE_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_PAGE_SKIP_CNTL                                                                         0x1d688
#define regSDMA4_PAGE_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_PAGE_CONTEXT_STATUS                                                                    0x1d689
#define regSDMA4_PAGE_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_PAGE_DOORBELL                                                                          0x1d68a
#define regSDMA4_PAGE_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_PAGE_STATUS                                                                            0x1d6a0
#define regSDMA4_PAGE_STATUS_BASE_IDX                                                                   0
#define regSDMA4_PAGE_DOORBELL_LOG                                                                      0x1d6a1
#define regSDMA4_PAGE_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_PAGE_WATERMARK                                                                         0x1d6a2
#define regSDMA4_PAGE_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_PAGE_DOORBELL_OFFSET                                                                   0x1d6a3
#define regSDMA4_PAGE_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_PAGE_CSA_ADDR_LO                                                                       0x1d6a4
#define regSDMA4_PAGE_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_PAGE_CSA_ADDR_HI                                                                       0x1d6a5
#define regSDMA4_PAGE_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_PAGE_IB_SUB_REMAIN                                                                     0x1d6a7
#define regSDMA4_PAGE_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_PAGE_PREEMPT                                                                           0x1d6a8
#define regSDMA4_PAGE_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_PAGE_DUMMY_REG                                                                         0x1d6a9
#define regSDMA4_PAGE_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_PAGE_RB_WPTR_POLL_ADDR_HI                                                              0x1d6aa
#define regSDMA4_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_PAGE_RB_WPTR_POLL_ADDR_LO                                                              0x1d6ab
#define regSDMA4_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_PAGE_RB_AQL_CNTL                                                                       0x1d6ac
#define regSDMA4_PAGE_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_PAGE_MINOR_PTR_UPDATE                                                                  0x1d6ad
#define regSDMA4_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_PAGE_MIDCMD_DATA0                                                                      0x1d6b8
#define regSDMA4_PAGE_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA1                                                                      0x1d6b9
#define regSDMA4_PAGE_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA2                                                                      0x1d6ba
#define regSDMA4_PAGE_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA3                                                                      0x1d6bb
#define regSDMA4_PAGE_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA4                                                                      0x1d6bc
#define regSDMA4_PAGE_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA5                                                                      0x1d6bd
#define regSDMA4_PAGE_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA6                                                                      0x1d6be
#define regSDMA4_PAGE_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA7                                                                      0x1d6bf
#define regSDMA4_PAGE_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA8                                                                      0x1d6c0
#define regSDMA4_PAGE_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA9                                                                      0x1d6c1
#define regSDMA4_PAGE_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_PAGE_MIDCMD_DATA10                                                                     0x1d6c2
#define regSDMA4_PAGE_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_PAGE_MIDCMD_CNTL                                                                       0x1d6c3
#define regSDMA4_PAGE_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC0_RB_CNTL                                                                           0x1d6d0
#define regSDMA4_RLC0_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC0_RB_BASE                                                                           0x1d6d1
#define regSDMA4_RLC0_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC0_RB_BASE_HI                                                                        0x1d6d2
#define regSDMA4_RLC0_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC0_RB_RPTR                                                                           0x1d6d3
#define regSDMA4_RLC0_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC0_RB_RPTR_HI                                                                        0x1d6d4
#define regSDMA4_RLC0_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC0_RB_WPTR                                                                           0x1d6d5
#define regSDMA4_RLC0_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC0_RB_WPTR_HI                                                                        0x1d6d6
#define regSDMA4_RLC0_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC0_RB_WPTR_POLL_CNTL                                                                 0x1d6d7
#define regSDMA4_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC0_RB_RPTR_ADDR_HI                                                                   0x1d6d8
#define regSDMA4_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC0_RB_RPTR_ADDR_LO                                                                   0x1d6d9
#define regSDMA4_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC0_IB_CNTL                                                                           0x1d6da
#define regSDMA4_RLC0_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC0_IB_RPTR                                                                           0x1d6db
#define regSDMA4_RLC0_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC0_IB_OFFSET                                                                         0x1d6dc
#define regSDMA4_RLC0_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC0_IB_BASE_LO                                                                        0x1d6dd
#define regSDMA4_RLC0_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC0_IB_BASE_HI                                                                        0x1d6de
#define regSDMA4_RLC0_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC0_IB_SIZE                                                                           0x1d6df
#define regSDMA4_RLC0_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC0_SKIP_CNTL                                                                         0x1d6e0
#define regSDMA4_RLC0_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC0_CONTEXT_STATUS                                                                    0x1d6e1
#define regSDMA4_RLC0_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC0_DOORBELL                                                                          0x1d6e2
#define regSDMA4_RLC0_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC0_STATUS                                                                            0x1d6f8
#define regSDMA4_RLC0_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC0_DOORBELL_LOG                                                                      0x1d6f9
#define regSDMA4_RLC0_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC0_WATERMARK                                                                         0x1d6fa
#define regSDMA4_RLC0_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC0_DOORBELL_OFFSET                                                                   0x1d6fb
#define regSDMA4_RLC0_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC0_CSA_ADDR_LO                                                                       0x1d6fc
#define regSDMA4_RLC0_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC0_CSA_ADDR_HI                                                                       0x1d6fd
#define regSDMA4_RLC0_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC0_IB_SUB_REMAIN                                                                     0x1d6ff
#define regSDMA4_RLC0_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC0_PREEMPT                                                                           0x1d700
#define regSDMA4_RLC0_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC0_DUMMY_REG                                                                         0x1d701
#define regSDMA4_RLC0_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC0_RB_WPTR_POLL_ADDR_HI                                                              0x1d702
#define regSDMA4_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC0_RB_WPTR_POLL_ADDR_LO                                                              0x1d703
#define regSDMA4_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC0_RB_AQL_CNTL                                                                       0x1d704
#define regSDMA4_RLC0_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC0_MINOR_PTR_UPDATE                                                                  0x1d705
#define regSDMA4_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC0_MIDCMD_DATA0                                                                      0x1d710
#define regSDMA4_RLC0_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA1                                                                      0x1d711
#define regSDMA4_RLC0_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA2                                                                      0x1d712
#define regSDMA4_RLC0_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA3                                                                      0x1d713
#define regSDMA4_RLC0_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA4                                                                      0x1d714
#define regSDMA4_RLC0_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA5                                                                      0x1d715
#define regSDMA4_RLC0_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA6                                                                      0x1d716
#define regSDMA4_RLC0_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA7                                                                      0x1d717
#define regSDMA4_RLC0_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA8                                                                      0x1d718
#define regSDMA4_RLC0_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA9                                                                      0x1d719
#define regSDMA4_RLC0_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC0_MIDCMD_DATA10                                                                     0x1d71a
#define regSDMA4_RLC0_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC0_MIDCMD_CNTL                                                                       0x1d71b
#define regSDMA4_RLC0_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC1_RB_CNTL                                                                           0x1d728
#define regSDMA4_RLC1_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC1_RB_BASE                                                                           0x1d729
#define regSDMA4_RLC1_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC1_RB_BASE_HI                                                                        0x1d72a
#define regSDMA4_RLC1_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC1_RB_RPTR                                                                           0x1d72b
#define regSDMA4_RLC1_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC1_RB_RPTR_HI                                                                        0x1d72c
#define regSDMA4_RLC1_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC1_RB_WPTR                                                                           0x1d72d
#define regSDMA4_RLC1_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC1_RB_WPTR_HI                                                                        0x1d72e
#define regSDMA4_RLC1_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC1_RB_WPTR_POLL_CNTL                                                                 0x1d72f
#define regSDMA4_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC1_RB_RPTR_ADDR_HI                                                                   0x1d730
#define regSDMA4_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC1_RB_RPTR_ADDR_LO                                                                   0x1d731
#define regSDMA4_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC1_IB_CNTL                                                                           0x1d732
#define regSDMA4_RLC1_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC1_IB_RPTR                                                                           0x1d733
#define regSDMA4_RLC1_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC1_IB_OFFSET                                                                         0x1d734
#define regSDMA4_RLC1_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC1_IB_BASE_LO                                                                        0x1d735
#define regSDMA4_RLC1_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC1_IB_BASE_HI                                                                        0x1d736
#define regSDMA4_RLC1_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC1_IB_SIZE                                                                           0x1d737
#define regSDMA4_RLC1_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC1_SKIP_CNTL                                                                         0x1d738
#define regSDMA4_RLC1_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC1_CONTEXT_STATUS                                                                    0x1d739
#define regSDMA4_RLC1_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC1_DOORBELL                                                                          0x1d73a
#define regSDMA4_RLC1_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC1_STATUS                                                                            0x1d750
#define regSDMA4_RLC1_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC1_DOORBELL_LOG                                                                      0x1d751
#define regSDMA4_RLC1_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC1_WATERMARK                                                                         0x1d752
#define regSDMA4_RLC1_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC1_DOORBELL_OFFSET                                                                   0x1d753
#define regSDMA4_RLC1_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC1_CSA_ADDR_LO                                                                       0x1d754
#define regSDMA4_RLC1_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC1_CSA_ADDR_HI                                                                       0x1d755
#define regSDMA4_RLC1_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC1_IB_SUB_REMAIN                                                                     0x1d757
#define regSDMA4_RLC1_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC1_PREEMPT                                                                           0x1d758
#define regSDMA4_RLC1_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC1_DUMMY_REG                                                                         0x1d759
#define regSDMA4_RLC1_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC1_RB_WPTR_POLL_ADDR_HI                                                              0x1d75a
#define regSDMA4_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC1_RB_WPTR_POLL_ADDR_LO                                                              0x1d75b
#define regSDMA4_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC1_RB_AQL_CNTL                                                                       0x1d75c
#define regSDMA4_RLC1_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC1_MINOR_PTR_UPDATE                                                                  0x1d75d
#define regSDMA4_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC1_MIDCMD_DATA0                                                                      0x1d768
#define regSDMA4_RLC1_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA1                                                                      0x1d769
#define regSDMA4_RLC1_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA2                                                                      0x1d76a
#define regSDMA4_RLC1_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA3                                                                      0x1d76b
#define regSDMA4_RLC1_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA4                                                                      0x1d76c
#define regSDMA4_RLC1_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA5                                                                      0x1d76d
#define regSDMA4_RLC1_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA6                                                                      0x1d76e
#define regSDMA4_RLC1_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA7                                                                      0x1d76f
#define regSDMA4_RLC1_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA8                                                                      0x1d770
#define regSDMA4_RLC1_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA9                                                                      0x1d771
#define regSDMA4_RLC1_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC1_MIDCMD_DATA10                                                                     0x1d772
#define regSDMA4_RLC1_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC1_MIDCMD_CNTL                                                                       0x1d773
#define regSDMA4_RLC1_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC2_RB_CNTL                                                                           0x1d780
#define regSDMA4_RLC2_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC2_RB_BASE                                                                           0x1d781
#define regSDMA4_RLC2_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC2_RB_BASE_HI                                                                        0x1d782
#define regSDMA4_RLC2_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC2_RB_RPTR                                                                           0x1d783
#define regSDMA4_RLC2_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC2_RB_RPTR_HI                                                                        0x1d784
#define regSDMA4_RLC2_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC2_RB_WPTR                                                                           0x1d785
#define regSDMA4_RLC2_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC2_RB_WPTR_HI                                                                        0x1d786
#define regSDMA4_RLC2_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC2_RB_WPTR_POLL_CNTL                                                                 0x1d787
#define regSDMA4_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC2_RB_RPTR_ADDR_HI                                                                   0x1d788
#define regSDMA4_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC2_RB_RPTR_ADDR_LO                                                                   0x1d789
#define regSDMA4_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC2_IB_CNTL                                                                           0x1d78a
#define regSDMA4_RLC2_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC2_IB_RPTR                                                                           0x1d78b
#define regSDMA4_RLC2_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC2_IB_OFFSET                                                                         0x1d78c
#define regSDMA4_RLC2_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC2_IB_BASE_LO                                                                        0x1d78d
#define regSDMA4_RLC2_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC2_IB_BASE_HI                                                                        0x1d78e
#define regSDMA4_RLC2_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC2_IB_SIZE                                                                           0x1d78f
#define regSDMA4_RLC2_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC2_SKIP_CNTL                                                                         0x1d790
#define regSDMA4_RLC2_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC2_CONTEXT_STATUS                                                                    0x1d791
#define regSDMA4_RLC2_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC2_DOORBELL                                                                          0x1d792
#define regSDMA4_RLC2_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC2_STATUS                                                                            0x1d7a8
#define regSDMA4_RLC2_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC2_DOORBELL_LOG                                                                      0x1d7a9
#define regSDMA4_RLC2_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC2_WATERMARK                                                                         0x1d7aa
#define regSDMA4_RLC2_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC2_DOORBELL_OFFSET                                                                   0x1d7ab
#define regSDMA4_RLC2_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC2_CSA_ADDR_LO                                                                       0x1d7ac
#define regSDMA4_RLC2_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC2_CSA_ADDR_HI                                                                       0x1d7ad
#define regSDMA4_RLC2_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC2_IB_SUB_REMAIN                                                                     0x1d7af
#define regSDMA4_RLC2_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC2_PREEMPT                                                                           0x1d7b0
#define regSDMA4_RLC2_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC2_DUMMY_REG                                                                         0x1d7b1
#define regSDMA4_RLC2_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC2_RB_WPTR_POLL_ADDR_HI                                                              0x1d7b2
#define regSDMA4_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC2_RB_WPTR_POLL_ADDR_LO                                                              0x1d7b3
#define regSDMA4_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC2_RB_AQL_CNTL                                                                       0x1d7b4
#define regSDMA4_RLC2_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC2_MINOR_PTR_UPDATE                                                                  0x1d7b5
#define regSDMA4_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC2_MIDCMD_DATA0                                                                      0x1d7c0
#define regSDMA4_RLC2_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA1                                                                      0x1d7c1
#define regSDMA4_RLC2_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA2                                                                      0x1d7c2
#define regSDMA4_RLC2_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA3                                                                      0x1d7c3
#define regSDMA4_RLC2_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA4                                                                      0x1d7c4
#define regSDMA4_RLC2_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA5                                                                      0x1d7c5
#define regSDMA4_RLC2_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA6                                                                      0x1d7c6
#define regSDMA4_RLC2_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA7                                                                      0x1d7c7
#define regSDMA4_RLC2_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA8                                                                      0x1d7c8
#define regSDMA4_RLC2_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA9                                                                      0x1d7c9
#define regSDMA4_RLC2_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC2_MIDCMD_DATA10                                                                     0x1d7ca
#define regSDMA4_RLC2_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC2_MIDCMD_CNTL                                                                       0x1d7cb
#define regSDMA4_RLC2_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC3_RB_CNTL                                                                           0x1d7d8
#define regSDMA4_RLC3_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC3_RB_BASE                                                                           0x1d7d9
#define regSDMA4_RLC3_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC3_RB_BASE_HI                                                                        0x1d7da
#define regSDMA4_RLC3_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC3_RB_RPTR                                                                           0x1d7db
#define regSDMA4_RLC3_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC3_RB_RPTR_HI                                                                        0x1d7dc
#define regSDMA4_RLC3_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC3_RB_WPTR                                                                           0x1d7dd
#define regSDMA4_RLC3_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC3_RB_WPTR_HI                                                                        0x1d7de
#define regSDMA4_RLC3_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC3_RB_WPTR_POLL_CNTL                                                                 0x1d7df
#define regSDMA4_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC3_RB_RPTR_ADDR_HI                                                                   0x1d7e0
#define regSDMA4_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC3_RB_RPTR_ADDR_LO                                                                   0x1d7e1
#define regSDMA4_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC3_IB_CNTL                                                                           0x1d7e2
#define regSDMA4_RLC3_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC3_IB_RPTR                                                                           0x1d7e3
#define regSDMA4_RLC3_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC3_IB_OFFSET                                                                         0x1d7e4
#define regSDMA4_RLC3_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC3_IB_BASE_LO                                                                        0x1d7e5
#define regSDMA4_RLC3_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC3_IB_BASE_HI                                                                        0x1d7e6
#define regSDMA4_RLC3_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC3_IB_SIZE                                                                           0x1d7e7
#define regSDMA4_RLC3_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC3_SKIP_CNTL                                                                         0x1d7e8
#define regSDMA4_RLC3_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC3_CONTEXT_STATUS                                                                    0x1d7e9
#define regSDMA4_RLC3_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC3_DOORBELL                                                                          0x1d7ea
#define regSDMA4_RLC3_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC3_STATUS                                                                            0x1d800
#define regSDMA4_RLC3_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC3_DOORBELL_LOG                                                                      0x1d801
#define regSDMA4_RLC3_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC3_WATERMARK                                                                         0x1d802
#define regSDMA4_RLC3_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC3_DOORBELL_OFFSET                                                                   0x1d803
#define regSDMA4_RLC3_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC3_CSA_ADDR_LO                                                                       0x1d804
#define regSDMA4_RLC3_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC3_CSA_ADDR_HI                                                                       0x1d805
#define regSDMA4_RLC3_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC3_IB_SUB_REMAIN                                                                     0x1d807
#define regSDMA4_RLC3_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC3_PREEMPT                                                                           0x1d808
#define regSDMA4_RLC3_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC3_DUMMY_REG                                                                         0x1d809
#define regSDMA4_RLC3_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC3_RB_WPTR_POLL_ADDR_HI                                                              0x1d80a
#define regSDMA4_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC3_RB_WPTR_POLL_ADDR_LO                                                              0x1d80b
#define regSDMA4_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC3_RB_AQL_CNTL                                                                       0x1d80c
#define regSDMA4_RLC3_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC3_MINOR_PTR_UPDATE                                                                  0x1d80d
#define regSDMA4_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC3_MIDCMD_DATA0                                                                      0x1d818
#define regSDMA4_RLC3_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA1                                                                      0x1d819
#define regSDMA4_RLC3_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA2                                                                      0x1d81a
#define regSDMA4_RLC3_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA3                                                                      0x1d81b
#define regSDMA4_RLC3_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA4                                                                      0x1d81c
#define regSDMA4_RLC3_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA5                                                                      0x1d81d
#define regSDMA4_RLC3_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA6                                                                      0x1d81e
#define regSDMA4_RLC3_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA7                                                                      0x1d81f
#define regSDMA4_RLC3_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA8                                                                      0x1d820
#define regSDMA4_RLC3_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA9                                                                      0x1d821
#define regSDMA4_RLC3_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC3_MIDCMD_DATA10                                                                     0x1d822
#define regSDMA4_RLC3_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC3_MIDCMD_CNTL                                                                       0x1d823
#define regSDMA4_RLC3_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC4_RB_CNTL                                                                           0x1d830
#define regSDMA4_RLC4_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC4_RB_BASE                                                                           0x1d831
#define regSDMA4_RLC4_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC4_RB_BASE_HI                                                                        0x1d832
#define regSDMA4_RLC4_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC4_RB_RPTR                                                                           0x1d833
#define regSDMA4_RLC4_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC4_RB_RPTR_HI                                                                        0x1d834
#define regSDMA4_RLC4_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC4_RB_WPTR                                                                           0x1d835
#define regSDMA4_RLC4_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC4_RB_WPTR_HI                                                                        0x1d836
#define regSDMA4_RLC4_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC4_RB_WPTR_POLL_CNTL                                                                 0x1d837
#define regSDMA4_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC4_RB_RPTR_ADDR_HI                                                                   0x1d838
#define regSDMA4_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC4_RB_RPTR_ADDR_LO                                                                   0x1d839
#define regSDMA4_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC4_IB_CNTL                                                                           0x1d83a
#define regSDMA4_RLC4_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC4_IB_RPTR                                                                           0x1d83b
#define regSDMA4_RLC4_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC4_IB_OFFSET                                                                         0x1d83c
#define regSDMA4_RLC4_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC4_IB_BASE_LO                                                                        0x1d83d
#define regSDMA4_RLC4_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC4_IB_BASE_HI                                                                        0x1d83e
#define regSDMA4_RLC4_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC4_IB_SIZE                                                                           0x1d83f
#define regSDMA4_RLC4_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC4_SKIP_CNTL                                                                         0x1d840
#define regSDMA4_RLC4_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC4_CONTEXT_STATUS                                                                    0x1d841
#define regSDMA4_RLC4_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC4_DOORBELL                                                                          0x1d842
#define regSDMA4_RLC4_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC4_STATUS                                                                            0x1d858
#define regSDMA4_RLC4_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC4_DOORBELL_LOG                                                                      0x1d859
#define regSDMA4_RLC4_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC4_WATERMARK                                                                         0x1d85a
#define regSDMA4_RLC4_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC4_DOORBELL_OFFSET                                                                   0x1d85b
#define regSDMA4_RLC4_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC4_CSA_ADDR_LO                                                                       0x1d85c
#define regSDMA4_RLC4_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC4_CSA_ADDR_HI                                                                       0x1d85d
#define regSDMA4_RLC4_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC4_IB_SUB_REMAIN                                                                     0x1d85f
#define regSDMA4_RLC4_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC4_PREEMPT                                                                           0x1d860
#define regSDMA4_RLC4_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC4_DUMMY_REG                                                                         0x1d861
#define regSDMA4_RLC4_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC4_RB_WPTR_POLL_ADDR_HI                                                              0x1d862
#define regSDMA4_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC4_RB_WPTR_POLL_ADDR_LO                                                              0x1d863
#define regSDMA4_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC4_RB_AQL_CNTL                                                                       0x1d864
#define regSDMA4_RLC4_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC4_MINOR_PTR_UPDATE                                                                  0x1d865
#define regSDMA4_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC4_MIDCMD_DATA0                                                                      0x1d870
#define regSDMA4_RLC4_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA1                                                                      0x1d871
#define regSDMA4_RLC4_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA2                                                                      0x1d872
#define regSDMA4_RLC4_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA3                                                                      0x1d873
#define regSDMA4_RLC4_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA4                                                                      0x1d874
#define regSDMA4_RLC4_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA5                                                                      0x1d875
#define regSDMA4_RLC4_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA6                                                                      0x1d876
#define regSDMA4_RLC4_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA7                                                                      0x1d877
#define regSDMA4_RLC4_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA8                                                                      0x1d878
#define regSDMA4_RLC4_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA9                                                                      0x1d879
#define regSDMA4_RLC4_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC4_MIDCMD_DATA10                                                                     0x1d87a
#define regSDMA4_RLC4_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC4_MIDCMD_CNTL                                                                       0x1d87b
#define regSDMA4_RLC4_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC5_RB_CNTL                                                                           0x1d888
#define regSDMA4_RLC5_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC5_RB_BASE                                                                           0x1d889
#define regSDMA4_RLC5_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC5_RB_BASE_HI                                                                        0x1d88a
#define regSDMA4_RLC5_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC5_RB_RPTR                                                                           0x1d88b
#define regSDMA4_RLC5_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC5_RB_RPTR_HI                                                                        0x1d88c
#define regSDMA4_RLC5_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC5_RB_WPTR                                                                           0x1d88d
#define regSDMA4_RLC5_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC5_RB_WPTR_HI                                                                        0x1d88e
#define regSDMA4_RLC5_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC5_RB_WPTR_POLL_CNTL                                                                 0x1d88f
#define regSDMA4_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC5_RB_RPTR_ADDR_HI                                                                   0x1d890
#define regSDMA4_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC5_RB_RPTR_ADDR_LO                                                                   0x1d891
#define regSDMA4_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC5_IB_CNTL                                                                           0x1d892
#define regSDMA4_RLC5_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC5_IB_RPTR                                                                           0x1d893
#define regSDMA4_RLC5_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC5_IB_OFFSET                                                                         0x1d894
#define regSDMA4_RLC5_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC5_IB_BASE_LO                                                                        0x1d895
#define regSDMA4_RLC5_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC5_IB_BASE_HI                                                                        0x1d896
#define regSDMA4_RLC5_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC5_IB_SIZE                                                                           0x1d897
#define regSDMA4_RLC5_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC5_SKIP_CNTL                                                                         0x1d898
#define regSDMA4_RLC5_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC5_CONTEXT_STATUS                                                                    0x1d899
#define regSDMA4_RLC5_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC5_DOORBELL                                                                          0x1d89a
#define regSDMA4_RLC5_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC5_STATUS                                                                            0x1d8b0
#define regSDMA4_RLC5_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC5_DOORBELL_LOG                                                                      0x1d8b1
#define regSDMA4_RLC5_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC5_WATERMARK                                                                         0x1d8b2
#define regSDMA4_RLC5_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC5_DOORBELL_OFFSET                                                                   0x1d8b3
#define regSDMA4_RLC5_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC5_CSA_ADDR_LO                                                                       0x1d8b4
#define regSDMA4_RLC5_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC5_CSA_ADDR_HI                                                                       0x1d8b5
#define regSDMA4_RLC5_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC5_IB_SUB_REMAIN                                                                     0x1d8b7
#define regSDMA4_RLC5_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC5_PREEMPT                                                                           0x1d8b8
#define regSDMA4_RLC5_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC5_DUMMY_REG                                                                         0x1d8b9
#define regSDMA4_RLC5_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC5_RB_WPTR_POLL_ADDR_HI                                                              0x1d8ba
#define regSDMA4_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC5_RB_WPTR_POLL_ADDR_LO                                                              0x1d8bb
#define regSDMA4_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC5_RB_AQL_CNTL                                                                       0x1d8bc
#define regSDMA4_RLC5_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC5_MINOR_PTR_UPDATE                                                                  0x1d8bd
#define regSDMA4_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC5_MIDCMD_DATA0                                                                      0x1d8c8
#define regSDMA4_RLC5_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA1                                                                      0x1d8c9
#define regSDMA4_RLC5_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA2                                                                      0x1d8ca
#define regSDMA4_RLC5_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA3                                                                      0x1d8cb
#define regSDMA4_RLC5_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA4                                                                      0x1d8cc
#define regSDMA4_RLC5_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA5                                                                      0x1d8cd
#define regSDMA4_RLC5_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA6                                                                      0x1d8ce
#define regSDMA4_RLC5_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA7                                                                      0x1d8cf
#define regSDMA4_RLC5_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA8                                                                      0x1d8d0
#define regSDMA4_RLC5_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA9                                                                      0x1d8d1
#define regSDMA4_RLC5_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC5_MIDCMD_DATA10                                                                     0x1d8d2
#define regSDMA4_RLC5_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC5_MIDCMD_CNTL                                                                       0x1d8d3
#define regSDMA4_RLC5_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC6_RB_CNTL                                                                           0x1d8e0
#define regSDMA4_RLC6_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC6_RB_BASE                                                                           0x1d8e1
#define regSDMA4_RLC6_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC6_RB_BASE_HI                                                                        0x1d8e2
#define regSDMA4_RLC6_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC6_RB_RPTR                                                                           0x1d8e3
#define regSDMA4_RLC6_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC6_RB_RPTR_HI                                                                        0x1d8e4
#define regSDMA4_RLC6_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC6_RB_WPTR                                                                           0x1d8e5
#define regSDMA4_RLC6_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC6_RB_WPTR_HI                                                                        0x1d8e6
#define regSDMA4_RLC6_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC6_RB_WPTR_POLL_CNTL                                                                 0x1d8e7
#define regSDMA4_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC6_RB_RPTR_ADDR_HI                                                                   0x1d8e8
#define regSDMA4_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC6_RB_RPTR_ADDR_LO                                                                   0x1d8e9
#define regSDMA4_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC6_IB_CNTL                                                                           0x1d8ea
#define regSDMA4_RLC6_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC6_IB_RPTR                                                                           0x1d8eb
#define regSDMA4_RLC6_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC6_IB_OFFSET                                                                         0x1d8ec
#define regSDMA4_RLC6_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC6_IB_BASE_LO                                                                        0x1d8ed
#define regSDMA4_RLC6_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC6_IB_BASE_HI                                                                        0x1d8ee
#define regSDMA4_RLC6_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC6_IB_SIZE                                                                           0x1d8ef
#define regSDMA4_RLC6_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC6_SKIP_CNTL                                                                         0x1d8f0
#define regSDMA4_RLC6_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC6_CONTEXT_STATUS                                                                    0x1d8f1
#define regSDMA4_RLC6_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC6_DOORBELL                                                                          0x1d8f2
#define regSDMA4_RLC6_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC6_STATUS                                                                            0x1d908
#define regSDMA4_RLC6_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC6_DOORBELL_LOG                                                                      0x1d909
#define regSDMA4_RLC6_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC6_WATERMARK                                                                         0x1d90a
#define regSDMA4_RLC6_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC6_DOORBELL_OFFSET                                                                   0x1d90b
#define regSDMA4_RLC6_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC6_CSA_ADDR_LO                                                                       0x1d90c
#define regSDMA4_RLC6_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC6_CSA_ADDR_HI                                                                       0x1d90d
#define regSDMA4_RLC6_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC6_IB_SUB_REMAIN                                                                     0x1d90f
#define regSDMA4_RLC6_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC6_PREEMPT                                                                           0x1d910
#define regSDMA4_RLC6_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC6_DUMMY_REG                                                                         0x1d911
#define regSDMA4_RLC6_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC6_RB_WPTR_POLL_ADDR_HI                                                              0x1d912
#define regSDMA4_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC6_RB_WPTR_POLL_ADDR_LO                                                              0x1d913
#define regSDMA4_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC6_RB_AQL_CNTL                                                                       0x1d914
#define regSDMA4_RLC6_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC6_MINOR_PTR_UPDATE                                                                  0x1d915
#define regSDMA4_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC6_MIDCMD_DATA0                                                                      0x1d920
#define regSDMA4_RLC6_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA1                                                                      0x1d921
#define regSDMA4_RLC6_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA2                                                                      0x1d922
#define regSDMA4_RLC6_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA3                                                                      0x1d923
#define regSDMA4_RLC6_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA4                                                                      0x1d924
#define regSDMA4_RLC6_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA5                                                                      0x1d925
#define regSDMA4_RLC6_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA6                                                                      0x1d926
#define regSDMA4_RLC6_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA7                                                                      0x1d927
#define regSDMA4_RLC6_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA8                                                                      0x1d928
#define regSDMA4_RLC6_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA9                                                                      0x1d929
#define regSDMA4_RLC6_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC6_MIDCMD_DATA10                                                                     0x1d92a
#define regSDMA4_RLC6_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC6_MIDCMD_CNTL                                                                       0x1d92b
#define regSDMA4_RLC6_MIDCMD_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC7_RB_CNTL                                                                           0x1d938
#define regSDMA4_RLC7_RB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC7_RB_BASE                                                                           0x1d939
#define regSDMA4_RLC7_RB_BASE_BASE_IDX                                                                  0
#define regSDMA4_RLC7_RB_BASE_HI                                                                        0x1d93a
#define regSDMA4_RLC7_RB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC7_RB_RPTR                                                                           0x1d93b
#define regSDMA4_RLC7_RB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC7_RB_RPTR_HI                                                                        0x1d93c
#define regSDMA4_RLC7_RB_RPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC7_RB_WPTR                                                                           0x1d93d
#define regSDMA4_RLC7_RB_WPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC7_RB_WPTR_HI                                                                        0x1d93e
#define regSDMA4_RLC7_RB_WPTR_HI_BASE_IDX                                                               0
#define regSDMA4_RLC7_RB_WPTR_POLL_CNTL                                                                 0x1d93f
#define regSDMA4_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                        0
#define regSDMA4_RLC7_RB_RPTR_ADDR_HI                                                                   0x1d940
#define regSDMA4_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                          0
#define regSDMA4_RLC7_RB_RPTR_ADDR_LO                                                                   0x1d941
#define regSDMA4_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                          0
#define regSDMA4_RLC7_IB_CNTL                                                                           0x1d942
#define regSDMA4_RLC7_IB_CNTL_BASE_IDX                                                                  0
#define regSDMA4_RLC7_IB_RPTR                                                                           0x1d943
#define regSDMA4_RLC7_IB_RPTR_BASE_IDX                                                                  0
#define regSDMA4_RLC7_IB_OFFSET                                                                         0x1d944
#define regSDMA4_RLC7_IB_OFFSET_BASE_IDX                                                                0
#define regSDMA4_RLC7_IB_BASE_LO                                                                        0x1d945
#define regSDMA4_RLC7_IB_BASE_LO_BASE_IDX                                                               0
#define regSDMA4_RLC7_IB_BASE_HI                                                                        0x1d946
#define regSDMA4_RLC7_IB_BASE_HI_BASE_IDX                                                               0
#define regSDMA4_RLC7_IB_SIZE                                                                           0x1d947
#define regSDMA4_RLC7_IB_SIZE_BASE_IDX                                                                  0
#define regSDMA4_RLC7_SKIP_CNTL                                                                         0x1d948
#define regSDMA4_RLC7_SKIP_CNTL_BASE_IDX                                                                0
#define regSDMA4_RLC7_CONTEXT_STATUS                                                                    0x1d949
#define regSDMA4_RLC7_CONTEXT_STATUS_BASE_IDX                                                           0
#define regSDMA4_RLC7_DOORBELL                                                                          0x1d94a
#define regSDMA4_RLC7_DOORBELL_BASE_IDX                                                                 0
#define regSDMA4_RLC7_STATUS                                                                            0x1d960
#define regSDMA4_RLC7_STATUS_BASE_IDX                                                                   0
#define regSDMA4_RLC7_DOORBELL_LOG                                                                      0x1d961
#define regSDMA4_RLC7_DOORBELL_LOG_BASE_IDX                                                             0
#define regSDMA4_RLC7_WATERMARK                                                                         0x1d962
#define regSDMA4_RLC7_WATERMARK_BASE_IDX                                                                0
#define regSDMA4_RLC7_DOORBELL_OFFSET                                                                   0x1d963
#define regSDMA4_RLC7_DOORBELL_OFFSET_BASE_IDX                                                          0
#define regSDMA4_RLC7_CSA_ADDR_LO                                                                       0x1d964
#define regSDMA4_RLC7_CSA_ADDR_LO_BASE_IDX                                                              0
#define regSDMA4_RLC7_CSA_ADDR_HI                                                                       0x1d965
#define regSDMA4_RLC7_CSA_ADDR_HI_BASE_IDX                                                              0
#define regSDMA4_RLC7_IB_SUB_REMAIN                                                                     0x1d967
#define regSDMA4_RLC7_IB_SUB_REMAIN_BASE_IDX                                                            0
#define regSDMA4_RLC7_PREEMPT                                                                           0x1d968
#define regSDMA4_RLC7_PREEMPT_BASE_IDX                                                                  0
#define regSDMA4_RLC7_DUMMY_REG                                                                         0x1d969
#define regSDMA4_RLC7_DUMMY_REG_BASE_IDX                                                                0
#define regSDMA4_RLC7_RB_WPTR_POLL_ADDR_HI                                                              0x1d96a
#define regSDMA4_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                     0
#define regSDMA4_RLC7_RB_WPTR_POLL_ADDR_LO                                                              0x1d96b
#define regSDMA4_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                     0
#define regSDMA4_RLC7_RB_AQL_CNTL                                                                       0x1d96c
#define regSDMA4_RLC7_RB_AQL_CNTL_BASE_IDX                                                              0
#define regSDMA4_RLC7_MINOR_PTR_UPDATE                                                                  0x1d96d
#define regSDMA4_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                         0
#define regSDMA4_RLC7_MIDCMD_DATA0                                                                      0x1d978
#define regSDMA4_RLC7_MIDCMD_DATA0_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA1                                                                      0x1d979
#define regSDMA4_RLC7_MIDCMD_DATA1_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA2                                                                      0x1d97a
#define regSDMA4_RLC7_MIDCMD_DATA2_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA3                                                                      0x1d97b
#define regSDMA4_RLC7_MIDCMD_DATA3_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA4                                                                      0x1d97c
#define regSDMA4_RLC7_MIDCMD_DATA4_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA5                                                                      0x1d97d
#define regSDMA4_RLC7_MIDCMD_DATA5_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA6                                                                      0x1d97e
#define regSDMA4_RLC7_MIDCMD_DATA6_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA7                                                                      0x1d97f
#define regSDMA4_RLC7_MIDCMD_DATA7_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA8                                                                      0x1d980
#define regSDMA4_RLC7_MIDCMD_DATA8_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA9                                                                      0x1d981
#define regSDMA4_RLC7_MIDCMD_DATA9_BASE_IDX                                                             0
#define regSDMA4_RLC7_MIDCMD_DATA10                                                                     0x1d982
#define regSDMA4_RLC7_MIDCMD_DATA10_BASE_IDX                                                            0
#define regSDMA4_RLC7_MIDCMD_CNTL                                                                       0x1d983
#define regSDMA4_RLC7_MIDCMD_CNTL_BASE_IDX                                                              0

#endif
