// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from egl.xml and egl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_egl_autogen.cpp:
//   Capture functions for the OpenGL ES all entry points.

#include "libANGLE/capture/capture_egl_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationEGL.h"

using namespace angle;

namespace egl
{
CallCapture CaptureChooseConfig(egl::Thread *thread,
                                bool isCallValid,
                                egl::Display *dpyPacked,
                                const AttributeMap &attrib_listPacked,
                                EGLConfig *configs,
                                EGLint config_size,
                                EGLint *num_config,
                                EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));
    paramBuffer.addValueParam("configs", ParamType::TEGLConfigPointer, configs);
    paramBuffer.addValueParam("config_size", ParamType::TEGLint, config_size);
    paramBuffer.addValueParam("num_config", ParamType::TEGLintPointer, num_config);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLChooseConfig, std::move(paramBuffer));
}

CallCapture CaptureCopyBuffers(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               SurfaceID surfacePacked,
                               EGLNativePixmapType target,
                               EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("target", ParamType::TEGLNativePixmapType, target);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCopyBuffers, std::move(paramBuffer));
}

CallCapture CaptureCreateContext(egl::Thread *thread,
                                 bool isCallValid,
                                 egl::Display *dpyPacked,
                                 egl::Config *configPacked,
                                 gl::ContextID share_contextPacked,
                                 const AttributeMap &attrib_listPacked,
                                 EGLContext returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("share_contextPacked", ParamType::TContextID, share_contextPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLContext);
    InitParamValue(ParamType::TEGLContext, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateContext, std::move(paramBuffer));
}

CallCapture CaptureCreatePbufferSurface(egl::Thread *thread,
                                        bool isCallValid,
                                        egl::Display *dpyPacked,
                                        egl::Config *configPacked,
                                        const AttributeMap &attrib_listPacked,
                                        EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePbufferSurface, std::move(paramBuffer));
}

CallCapture CaptureCreatePixmapSurface(egl::Thread *thread,
                                       bool isCallValid,
                                       egl::Display *dpyPacked,
                                       egl::Config *configPacked,
                                       EGLNativePixmapType pixmap,
                                       const AttributeMap &attrib_listPacked,
                                       EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("pixmap", ParamType::TEGLNativePixmapType, pixmap);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePixmapSurface, std::move(paramBuffer));
}

CallCapture CaptureCreateWindowSurface(egl::Thread *thread,
                                       bool isCallValid,
                                       egl::Display *dpyPacked,
                                       egl::Config *configPacked,
                                       EGLNativeWindowType win,
                                       const AttributeMap &attrib_listPacked,
                                       EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("win", ParamType::TEGLNativeWindowType, win);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateWindowSurface, std::move(paramBuffer));
}

CallCapture CaptureDestroyContext(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  gl::ContextID ctxPacked,
                                  EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroyContext, std::move(paramBuffer));
}

CallCapture CaptureDestroySurface(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  SurfaceID surfacePacked,
                                  EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroySurface, std::move(paramBuffer));
}

CallCapture CaptureGetConfigAttrib(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   egl::Config *configPacked,
                                   EGLint attribute,
                                   EGLint *value,
                                   EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLintPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetConfigAttrib, std::move(paramBuffer));
}

CallCapture CaptureGetConfigs(egl::Thread *thread,
                              bool isCallValid,
                              egl::Display *dpyPacked,
                              EGLConfig *configs,
                              EGLint config_size,
                              EGLint *num_config,
                              EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configs", ParamType::TEGLConfigPointer, configs);
    paramBuffer.addValueParam("config_size", ParamType::TEGLint, config_size);
    paramBuffer.addValueParam("num_config", ParamType::TEGLintPointer, num_config);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetConfigs, std::move(paramBuffer));
}

CallCapture CaptureGetCurrentDisplay(egl::Thread *thread, bool isCallValid, EGLDisplay returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLDisplay);
    InitParamValue(ParamType::TEGLDisplay, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetCurrentDisplay, std::move(paramBuffer));
}

CallCapture CaptureGetCurrentSurface(egl::Thread *thread,
                                     bool isCallValid,
                                     EGLint readdraw,
                                     EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("readdraw", ParamType::TEGLint, readdraw);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetCurrentSurface, std::move(paramBuffer));
}

CallCapture CaptureGetDisplay(egl::Thread *thread,
                              bool isCallValid,
                              EGLNativeDisplayType display_id,
                              EGLDisplay returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("display_id", ParamType::TEGLNativeDisplayType, display_id);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLDisplay);
    InitParamValue(ParamType::TEGLDisplay, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetDisplay, std::move(paramBuffer));
}

CallCapture CaptureGetError(egl::Thread *thread, bool isCallValid, EGLint returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetError, std::move(paramBuffer));
}

CallCapture CaptureGetProcAddress(egl::Thread *thread,
                                  bool isCallValid,
                                  const char *procname,
                                  __eglMustCastToProperFunctionPointerType returnValue)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::EGLGetProcAddress, std::move(paramBuffer));
}

CallCapture CaptureInitialize(egl::Thread *thread,
                              bool isCallValid,
                              egl::Display *dpyPacked,
                              EGLint *major,
                              EGLint *minor,
                              EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("major", ParamType::TEGLintPointer, major);
    paramBuffer.addValueParam("minor", ParamType::TEGLintPointer, minor);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLInitialize, std::move(paramBuffer));
}

CallCapture CaptureMakeCurrent(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               SurfaceID drawPacked,
                               SurfaceID readPacked,
                               gl::ContextID ctxPacked,
                               EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("drawPacked", ParamType::TSurfaceID, drawPacked);
    paramBuffer.addValueParam("readPacked", ParamType::TSurfaceID, readPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLMakeCurrent, std::move(paramBuffer));
}

CallCapture CaptureQueryContext(egl::Thread *thread,
                                bool isCallValid,
                                egl::Display *dpyPacked,
                                gl::ContextID ctxPacked,
                                EGLint attribute,
                                EGLint *value,
                                EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLintPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryContext, std::move(paramBuffer));
}

CallCapture CaptureQueryString(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               EGLint name,
                               const char *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("name", ParamType::TEGLint, name);

    ParamCapture returnValueCapture("returnValue", ParamType::TcharConstPointer);
    InitParamValue(ParamType::TcharConstPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryString, std::move(paramBuffer));
}

CallCapture CaptureQuerySurface(egl::Thread *thread,
                                bool isCallValid,
                                egl::Display *dpyPacked,
                                SurfaceID surfacePacked,
                                EGLint attribute,
                                EGLint *value,
                                EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLintPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQuerySurface, std::move(paramBuffer));
}

CallCapture CaptureSwapBuffers(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               SurfaceID surfacePacked,
                               EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSwapBuffers, std::move(paramBuffer));
}

CallCapture CaptureTerminate(egl::Thread *thread,
                             bool isCallValid,
                             egl::Display *dpyPacked,
                             EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLTerminate, std::move(paramBuffer));
}

CallCapture CaptureWaitGL(egl::Thread *thread, bool isCallValid, EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLWaitGL, std::move(paramBuffer));
}

CallCapture CaptureWaitNative(egl::Thread *thread,
                              bool isCallValid,
                              EGLint engine,
                              EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("engine", ParamType::TEGLint, engine);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLWaitNative, std::move(paramBuffer));
}

CallCapture CaptureBindTexImage(egl::Thread *thread,
                                bool isCallValid,
                                egl::Display *dpyPacked,
                                SurfaceID surfacePacked,
                                EGLint buffer,
                                EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("buffer", ParamType::TEGLint, buffer);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLBindTexImage, std::move(paramBuffer));
}

CallCapture CaptureReleaseTexImage(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   SurfaceID surfacePacked,
                                   EGLint buffer,
                                   EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("buffer", ParamType::TEGLint, buffer);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLReleaseTexImage, std::move(paramBuffer));
}

CallCapture CaptureSurfaceAttrib(egl::Thread *thread,
                                 bool isCallValid,
                                 egl::Display *dpyPacked,
                                 SurfaceID surfacePacked,
                                 EGLint attribute,
                                 EGLint value,
                                 EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLint, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSurfaceAttrib, std::move(paramBuffer));
}

CallCapture CaptureSwapInterval(egl::Thread *thread,
                                bool isCallValid,
                                egl::Display *dpyPacked,
                                EGLint interval,
                                EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("interval", ParamType::TEGLint, interval);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSwapInterval, std::move(paramBuffer));
}

CallCapture CaptureBindAPI(egl::Thread *thread,
                           bool isCallValid,
                           EGLenum api,
                           EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("api", ParamType::TEGLenum, api);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLBindAPI, std::move(paramBuffer));
}

CallCapture CaptureCreatePbufferFromClientBuffer(egl::Thread *thread,
                                                 bool isCallValid,
                                                 egl::Display *dpyPacked,
                                                 EGLenum buftype,
                                                 EGLClientBuffer buffer,
                                                 egl::Config *configPacked,
                                                 const AttributeMap &attrib_listPacked,
                                                 EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("buftype", ParamType::TEGLenum, buftype);
    paramBuffer.addValueParam("buffer", ParamType::TEGLClientBuffer, buffer);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePbufferFromClientBuffer, std::move(paramBuffer));
}

CallCapture CaptureQueryAPI(egl::Thread *thread, bool isCallValid, EGLenum returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLenum);
    InitParamValue(ParamType::TEGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryAPI, std::move(paramBuffer));
}

CallCapture CaptureReleaseThread(egl::Thread *thread, bool isCallValid, EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLReleaseThread, std::move(paramBuffer));
}

CallCapture CaptureWaitClient(egl::Thread *thread, bool isCallValid, EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLWaitClient, std::move(paramBuffer));
}

CallCapture CaptureGetCurrentContext(egl::Thread *thread, bool isCallValid, EGLContext returnValue)
{
    ParamBuffer paramBuffer;

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLContext);
    InitParamValue(ParamType::TEGLContext, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetCurrentContext, std::move(paramBuffer));
}

CallCapture CaptureClientWaitSync(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  egl::SyncID syncPacked,
                                  EGLint flags,
                                  EGLTime timeout,
                                  EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("flags", ParamType::TEGLint, flags);
    paramBuffer.addValueParam("timeout", ParamType::TEGLTime, timeout);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLClientWaitSync, std::move(paramBuffer));
}

CallCapture CaptureCreateImage(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               gl::ContextID ctxPacked,
                               EGLenum target,
                               EGLClientBuffer buffer,
                               const AttributeMap &attrib_listPacked,
                               EGLImage returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);
    paramBuffer.addValueParam("target", ParamType::TEGLenum, target);
    paramBuffer.addValueParam("buffer", ParamType::TEGLClientBuffer, buffer);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLImage);
    InitParamValue(ParamType::TEGLImage, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateImage, std::move(paramBuffer));
}

CallCapture CaptureCreatePlatformPixmapSurface(egl::Thread *thread,
                                               bool isCallValid,
                                               egl::Display *dpyPacked,
                                               egl::Config *configPacked,
                                               void *native_pixmap,
                                               const AttributeMap &attrib_listPacked,
                                               EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("native_pixmap", ParamType::TvoidPointer, native_pixmap);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePlatformPixmapSurface, std::move(paramBuffer));
}

CallCapture CaptureCreatePlatformWindowSurface(egl::Thread *thread,
                                               bool isCallValid,
                                               egl::Display *dpyPacked,
                                               egl::Config *configPacked,
                                               void *native_window,
                                               const AttributeMap &attrib_listPacked,
                                               EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("native_window", ParamType::TvoidPointer, native_window);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePlatformWindowSurface, std::move(paramBuffer));
}

CallCapture CaptureCreateSync(egl::Thread *thread,
                              bool isCallValid,
                              egl::Display *dpyPacked,
                              EGLenum type,
                              const AttributeMap &attrib_listPacked,
                              EGLSync returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("type", ParamType::TEGLenum, type);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSync);
    InitParamValue(ParamType::TEGLSync, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateSync, std::move(paramBuffer));
}

CallCapture CaptureDestroyImage(egl::Thread *thread,
                                bool isCallValid,
                                egl::Display *dpyPacked,
                                ImageID imagePacked,
                                EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("imagePacked", ParamType::TImageID, imagePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroyImage, std::move(paramBuffer));
}

CallCapture CaptureDestroySync(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               egl::SyncID syncPacked,
                               EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroySync, std::move(paramBuffer));
}

CallCapture CaptureGetPlatformDisplay(egl::Thread *thread,
                                      bool isCallValid,
                                      EGLenum platform,
                                      void *native_display,
                                      const AttributeMap &attrib_listPacked,
                                      EGLDisplay returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::TEGLenum, platform);
    paramBuffer.addValueParam("native_display", ParamType::TvoidPointer, native_display);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLDisplay);
    InitParamValue(ParamType::TEGLDisplay, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetPlatformDisplay, std::move(paramBuffer));
}

CallCapture CaptureGetSyncAttrib(egl::Thread *thread,
                                 bool isCallValid,
                                 egl::Display *dpyPacked,
                                 egl::SyncID syncPacked,
                                 EGLint attribute,
                                 EGLAttrib *value,
                                 EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLAttribPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetSyncAttrib, std::move(paramBuffer));
}

CallCapture CaptureWaitSync(egl::Thread *thread,
                            bool isCallValid,
                            egl::Display *dpyPacked,
                            egl::SyncID syncPacked,
                            EGLint flags,
                            EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("flags", ParamType::TEGLint, flags);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLWaitSync, std::move(paramBuffer));
}

CallCapture CaptureSetBlobCacheFuncsANDROID(egl::Thread *thread,
                                            bool isCallValid,
                                            egl::Display *dpyPacked,
                                            EGLSetBlobFuncANDROID set,
                                            EGLGetBlobFuncANDROID get)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("set", ParamType::TEGLSetBlobFuncANDROID, set);
    paramBuffer.addValueParam("get", ParamType::TEGLGetBlobFuncANDROID, get);

    return CallCapture(angle::EntryPoint::EGLSetBlobCacheFuncsANDROID, std::move(paramBuffer));
}

CallCapture CaptureCreateNativeClientBufferANDROID(egl::Thread *thread,
                                                   bool isCallValid,
                                                   const AttributeMap &attrib_listPacked,
                                                   EGLClientBuffer returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLClientBuffer);
    InitParamValue(ParamType::TEGLClientBuffer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateNativeClientBufferANDROID,
                       std::move(paramBuffer));
}

CallCapture CaptureGetCompositorTimingSupportedANDROID(egl::Thread *thread,
                                                       bool isCallValid,
                                                       egl::Display *dpyPacked,
                                                       SurfaceID surfacePacked,
                                                       CompositorTiming namePacked,
                                                       EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("namePacked", ParamType::TCompositorTiming, namePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetCompositorTimingSupportedANDROID,
                       std::move(paramBuffer));
}

CallCapture CaptureGetCompositorTimingANDROID(egl::Thread *thread,
                                              bool isCallValid,
                                              egl::Display *dpyPacked,
                                              SurfaceID surfacePacked,
                                              EGLint numTimestamps,
                                              const EGLint *names,
                                              EGLnsecsANDROID *values,
                                              EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("numTimestamps", ParamType::TEGLint, numTimestamps);
    paramBuffer.addValueParam("names", ParamType::TEGLintConstPointer, names);
    paramBuffer.addValueParam("values", ParamType::TEGLnsecsANDROIDPointer, values);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetCompositorTimingANDROID, std::move(paramBuffer));
}

CallCapture CaptureGetNextFrameIdANDROID(egl::Thread *thread,
                                         bool isCallValid,
                                         egl::Display *dpyPacked,
                                         SurfaceID surfacePacked,
                                         EGLuint64KHR *frameId,
                                         EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("frameId", ParamType::TEGLuint64KHRPointer, frameId);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetNextFrameIdANDROID, std::move(paramBuffer));
}

CallCapture CaptureGetFrameTimestampSupportedANDROID(egl::Thread *thread,
                                                     bool isCallValid,
                                                     egl::Display *dpyPacked,
                                                     SurfaceID surfacePacked,
                                                     Timestamp timestampPacked,
                                                     EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("timestampPacked", ParamType::TTimestamp, timestampPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetFrameTimestampSupportedANDROID,
                       std::move(paramBuffer));
}

CallCapture CaptureGetFrameTimestampsANDROID(egl::Thread *thread,
                                             bool isCallValid,
                                             egl::Display *dpyPacked,
                                             SurfaceID surfacePacked,
                                             EGLuint64KHR frameId,
                                             EGLint numTimestamps,
                                             const EGLint *timestamps,
                                             EGLnsecsANDROID *values,
                                             EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("frameId", ParamType::TEGLuint64KHR, frameId);
    paramBuffer.addValueParam("numTimestamps", ParamType::TEGLint, numTimestamps);
    paramBuffer.addValueParam("timestamps", ParamType::TEGLintConstPointer, timestamps);
    paramBuffer.addValueParam("values", ParamType::TEGLnsecsANDROIDPointer, values);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetFrameTimestampsANDROID, std::move(paramBuffer));
}

CallCapture CaptureGetNativeClientBufferANDROID(egl::Thread *thread,
                                                bool isCallValid,
                                                const struct AHardwareBuffer *buffer,
                                                EGLClientBuffer returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("buffer", ParamType::TAHardwareBufferConstPointer, buffer);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLClientBuffer);
    InitParamValue(ParamType::TEGLClientBuffer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetNativeClientBufferANDROID, std::move(paramBuffer));
}

CallCapture CaptureDupNativeFenceFDANDROID(egl::Thread *thread,
                                           bool isCallValid,
                                           egl::Display *dpyPacked,
                                           egl::SyncID syncPacked,
                                           EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDupNativeFenceFDANDROID, std::move(paramBuffer));
}

CallCapture CapturePresentationTimeANDROID(egl::Thread *thread,
                                           bool isCallValid,
                                           egl::Display *dpyPacked,
                                           SurfaceID surfacePacked,
                                           EGLnsecsANDROID time,
                                           EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("time", ParamType::TEGLnsecsANDROID, time);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLPresentationTimeANDROID, std::move(paramBuffer));
}

CallCapture CaptureCreateDeviceANGLE(egl::Thread *thread,
                                     bool isCallValid,
                                     EGLint device_type,
                                     void *native_device,
                                     const EGLAttrib *attrib_list,
                                     EGLDeviceEXT returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("device_type", ParamType::TEGLint, device_type);
    paramBuffer.addValueParam("native_device", ParamType::TvoidPointer, native_device);
    paramBuffer.addValueParam("attrib_list", ParamType::TEGLAttribConstPointer, attrib_list);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLDeviceEXT);
    InitParamValue(ParamType::TEGLDeviceEXT, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateDeviceANGLE, std::move(paramBuffer));
}

CallCapture CaptureReleaseDeviceANGLE(egl::Thread *thread,
                                      bool isCallValid,
                                      egl::Device *devicePacked,
                                      EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("devicePacked", ParamType::Tegl_DevicePointer, devicePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLReleaseDeviceANGLE, std::move(paramBuffer));
}

CallCapture CaptureAcquireExternalContextANGLE(egl::Thread *thread,
                                               bool isCallValid,
                                               egl::Display *dpyPacked,
                                               SurfaceID drawAndReadPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("drawAndReadPacked", ParamType::TSurfaceID, drawAndReadPacked);

    return CallCapture(angle::EntryPoint::EGLAcquireExternalContextANGLE, std::move(paramBuffer));
}

CallCapture CaptureReleaseExternalContextANGLE(egl::Thread *thread,
                                               bool isCallValid,
                                               egl::Display *dpyPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);

    return CallCapture(angle::EntryPoint::EGLReleaseExternalContextANGLE, std::move(paramBuffer));
}

CallCapture CaptureQueryStringiANGLE(egl::Thread *thread,
                                     bool isCallValid,
                                     egl::Display *dpyPacked,
                                     EGLint name,
                                     EGLint index,
                                     const char *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("name", ParamType::TEGLint, name);
    paramBuffer.addValueParam("index", ParamType::TEGLint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TcharConstPointer);
    InitParamValue(ParamType::TcharConstPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryStringiANGLE, std::move(paramBuffer));
}

CallCapture CaptureQueryDisplayAttribANGLE(egl::Thread *thread,
                                           bool isCallValid,
                                           egl::Display *dpyPacked,
                                           EGLint attribute,
                                           EGLAttrib *value,
                                           EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLAttribPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDisplayAttribANGLE, std::move(paramBuffer));
}

CallCapture CaptureCopyMetalSharedEventANGLE(egl::Thread *thread,
                                             bool isCallValid,
                                             egl::Display *dpyPacked,
                                             egl::SyncID syncPacked,
                                             void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCopyMetalSharedEventANGLE, std::move(paramBuffer));
}

CallCapture CaptureReleaseHighPowerGPUANGLE(egl::Thread *thread,
                                            bool isCallValid,
                                            egl::Display *dpyPacked,
                                            gl::ContextID ctxPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);

    return CallCapture(angle::EntryPoint::EGLReleaseHighPowerGPUANGLE, std::move(paramBuffer));
}

CallCapture CaptureReacquireHighPowerGPUANGLE(egl::Thread *thread,
                                              bool isCallValid,
                                              egl::Display *dpyPacked,
                                              gl::ContextID ctxPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);

    return CallCapture(angle::EntryPoint::EGLReacquireHighPowerGPUANGLE, std::move(paramBuffer));
}

CallCapture CaptureHandleGPUSwitchANGLE(egl::Thread *thread,
                                        bool isCallValid,
                                        egl::Display *dpyPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);

    return CallCapture(angle::EntryPoint::EGLHandleGPUSwitchANGLE, std::move(paramBuffer));
}

CallCapture CaptureForceGPUSwitchANGLE(egl::Thread *thread,
                                       bool isCallValid,
                                       egl::Display *dpyPacked,
                                       EGLint gpuIDHigh,
                                       EGLint gpuIDLow)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("gpuIDHigh", ParamType::TEGLint, gpuIDHigh);
    paramBuffer.addValueParam("gpuIDLow", ParamType::TEGLint, gpuIDLow);

    return CallCapture(angle::EntryPoint::EGLForceGPUSwitchANGLE, std::move(paramBuffer));
}

CallCapture CapturePrepareSwapBuffersANGLE(egl::Thread *thread,
                                           bool isCallValid,
                                           egl::Display *dpyPacked,
                                           SurfaceID surfacePacked,
                                           EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLPrepareSwapBuffersANGLE, std::move(paramBuffer));
}

CallCapture CaptureProgramCacheGetAttribANGLE(egl::Thread *thread,
                                              bool isCallValid,
                                              egl::Display *dpyPacked,
                                              EGLenum attrib,
                                              EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("attrib", ParamType::TEGLenum, attrib);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLProgramCacheGetAttribANGLE, std::move(paramBuffer));
}

CallCapture CaptureProgramCacheQueryANGLE(egl::Thread *thread,
                                          bool isCallValid,
                                          egl::Display *dpyPacked,
                                          EGLint index,
                                          void *key,
                                          EGLint *keysize,
                                          void *binary,
                                          EGLint *binarysize)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("index", ParamType::TEGLint, index);
    paramBuffer.addValueParam("key", ParamType::TvoidPointer, key);
    paramBuffer.addValueParam("keysize", ParamType::TEGLintPointer, keysize);
    paramBuffer.addValueParam("binary", ParamType::TvoidPointer, binary);
    paramBuffer.addValueParam("binarysize", ParamType::TEGLintPointer, binarysize);

    return CallCapture(angle::EntryPoint::EGLProgramCacheQueryANGLE, std::move(paramBuffer));
}

CallCapture CaptureProgramCachePopulateANGLE(egl::Thread *thread,
                                             bool isCallValid,
                                             egl::Display *dpyPacked,
                                             const void *key,
                                             EGLint keysize,
                                             const void *binary,
                                             EGLint binarysize)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("key", ParamType::TvoidConstPointer, key);
    paramBuffer.addValueParam("keysize", ParamType::TEGLint, keysize);
    paramBuffer.addValueParam("binary", ParamType::TvoidConstPointer, binary);
    paramBuffer.addValueParam("binarysize", ParamType::TEGLint, binarysize);

    return CallCapture(angle::EntryPoint::EGLProgramCachePopulateANGLE, std::move(paramBuffer));
}

CallCapture CaptureProgramCacheResizeANGLE(egl::Thread *thread,
                                           bool isCallValid,
                                           egl::Display *dpyPacked,
                                           EGLint limit,
                                           EGLint mode,
                                           EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("limit", ParamType::TEGLint, limit);
    paramBuffer.addValueParam("mode", ParamType::TEGLint, mode);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLProgramCacheResizeANGLE, std::move(paramBuffer));
}

CallCapture CaptureQuerySurfacePointerANGLE(egl::Thread *thread,
                                            bool isCallValid,
                                            egl::Display *dpyPacked,
                                            SurfaceID surfacePacked,
                                            EGLint attribute,
                                            void **value,
                                            EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TvoidPointerPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQuerySurfacePointerANGLE, std::move(paramBuffer));
}

CallCapture CaptureCreateStreamProducerD3DTextureANGLE(egl::Thread *thread,
                                                       bool isCallValid,
                                                       egl::Display *dpyPacked,
                                                       egl::Stream *streamPacked,
                                                       const AttributeMap &attrib_listPacked,
                                                       EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateStreamProducerD3DTextureANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureStreamPostD3DTextureANGLE(egl::Thread *thread,
                                             bool isCallValid,
                                             egl::Display *dpyPacked,
                                             egl::Stream *streamPacked,
                                             void *texture,
                                             const AttributeMap &attrib_listPacked,
                                             EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);
    paramBuffer.addValueParam("texture", ParamType::TvoidPointer, texture);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLStreamPostD3DTextureANGLE, std::move(paramBuffer));
}

CallCapture CaptureSwapBuffersWithFrameTokenANGLE(egl::Thread *thread,
                                                  bool isCallValid,
                                                  egl::Display *dpyPacked,
                                                  SurfaceID surfacePacked,
                                                  EGLFrameTokenANGLE frametoken,
                                                  EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("frametoken", ParamType::TEGLFrameTokenANGLE, frametoken);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSwapBuffersWithFrameTokenANGLE,
                       std::move(paramBuffer));
}

CallCapture CaptureGetMscRateANGLE(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   SurfaceID surfacePacked,
                                   EGLint *numerator,
                                   EGLint *denominator,
                                   EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("numerator", ParamType::TEGLintPointer, numerator);
    paramBuffer.addValueParam("denominator", ParamType::TEGLintPointer, denominator);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetMscRateANGLE, std::move(paramBuffer));
}

CallCapture CaptureExportVkImageANGLE(egl::Thread *thread,
                                      bool isCallValid,
                                      egl::Display *dpyPacked,
                                      ImageID imagePacked,
                                      void *vk_image,
                                      void *vk_image_create_info,
                                      EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("imagePacked", ParamType::TImageID, imagePacked);
    paramBuffer.addValueParam("vk_image", ParamType::TvoidPointer, vk_image);
    paramBuffer.addValueParam("vk_image_create_info", ParamType::TvoidPointer,
                              vk_image_create_info);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLExportVkImageANGLE, std::move(paramBuffer));
}

CallCapture CaptureWaitUntilWorkScheduledANGLE(egl::Thread *thread,
                                               bool isCallValid,
                                               egl::Display *dpyPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);

    return CallCapture(angle::EntryPoint::EGLWaitUntilWorkScheduledANGLE, std::move(paramBuffer));
}

CallCapture CaptureGetSyncValuesCHROMIUM(egl::Thread *thread,
                                         bool isCallValid,
                                         egl::Display *dpyPacked,
                                         SurfaceID surfacePacked,
                                         EGLuint64KHR *ust,
                                         EGLuint64KHR *msc,
                                         EGLuint64KHR *sbc,
                                         EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("ust", ParamType::TEGLuint64KHRPointer, ust);
    paramBuffer.addValueParam("msc", ParamType::TEGLuint64KHRPointer, msc);
    paramBuffer.addValueParam("sbc", ParamType::TEGLuint64KHRPointer, sbc);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetSyncValuesCHROMIUM, std::move(paramBuffer));
}

CallCapture CaptureQueryDeviceAttribEXT(egl::Thread *thread,
                                        bool isCallValid,
                                        egl::Device *devicePacked,
                                        EGLint attribute,
                                        EGLAttrib *value,
                                        EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("devicePacked", ParamType::Tegl_DevicePointer, devicePacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLAttribPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDeviceAttribEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryDeviceStringEXT(egl::Thread *thread,
                                        bool isCallValid,
                                        egl::Device *devicePacked,
                                        EGLint name,
                                        const char *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("devicePacked", ParamType::Tegl_DevicePointer, devicePacked);
    paramBuffer.addValueParam("name", ParamType::TEGLint, name);

    ParamCapture returnValueCapture("returnValue", ParamType::TcharConstPointer);
    InitParamValue(ParamType::TcharConstPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDeviceStringEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryDisplayAttribEXT(egl::Thread *thread,
                                         bool isCallValid,
                                         egl::Display *dpyPacked,
                                         EGLint attribute,
                                         EGLAttrib *value,
                                         EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLAttribPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDisplayAttribEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryDmaBufFormatsEXT(egl::Thread *thread,
                                         bool isCallValid,
                                         egl::Display *dpyPacked,
                                         EGLint max_formats,
                                         EGLint *formats,
                                         EGLint *num_formats,
                                         EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("max_formats", ParamType::TEGLint, max_formats);
    paramBuffer.addValueParam("formats", ParamType::TEGLintPointer, formats);
    paramBuffer.addValueParam("num_formats", ParamType::TEGLintPointer, num_formats);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDmaBufFormatsEXT, std::move(paramBuffer));
}

CallCapture CaptureQueryDmaBufModifiersEXT(egl::Thread *thread,
                                           bool isCallValid,
                                           egl::Display *dpyPacked,
                                           EGLint format,
                                           EGLint max_modifiers,
                                           EGLuint64KHR *modifiers,
                                           EGLBoolean *external_only,
                                           EGLint *num_modifiers,
                                           EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("format", ParamType::TEGLint, format);
    paramBuffer.addValueParam("max_modifiers", ParamType::TEGLint, max_modifiers);
    paramBuffer.addValueParam("modifiers", ParamType::TEGLuint64KHRPointer, modifiers);
    paramBuffer.addValueParam("external_only", ParamType::TEGLBooleanPointer, external_only);
    paramBuffer.addValueParam("num_modifiers", ParamType::TEGLintPointer, num_modifiers);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDmaBufModifiersEXT, std::move(paramBuffer));
}

CallCapture CaptureCreatePlatformPixmapSurfaceEXT(egl::Thread *thread,
                                                  bool isCallValid,
                                                  egl::Display *dpyPacked,
                                                  egl::Config *configPacked,
                                                  void *native_pixmap,
                                                  const AttributeMap &attrib_listPacked,
                                                  EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("native_pixmap", ParamType::TvoidPointer, native_pixmap);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePlatformPixmapSurfaceEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureCreatePlatformWindowSurfaceEXT(egl::Thread *thread,
                                                  bool isCallValid,
                                                  egl::Display *dpyPacked,
                                                  egl::Config *configPacked,
                                                  void *native_window,
                                                  const AttributeMap &attrib_listPacked,
                                                  EGLSurface returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("configPacked", ParamType::Tegl_ConfigPointer, configPacked);
    paramBuffer.addValueParam("native_window", ParamType::TvoidPointer, native_window);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSurface);
    InitParamValue(ParamType::TEGLSurface, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreatePlatformWindowSurfaceEXT,
                       std::move(paramBuffer));
}

CallCapture CaptureGetPlatformDisplayEXT(egl::Thread *thread,
                                         bool isCallValid,
                                         EGLenum platform,
                                         void *native_display,
                                         const AttributeMap &attrib_listPacked,
                                         EGLDisplay returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("platform", ParamType::TEGLenum, platform);
    paramBuffer.addValueParam("native_display", ParamType::TvoidPointer, native_display);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLDisplay);
    InitParamValue(ParamType::TEGLDisplay, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetPlatformDisplayEXT, std::move(paramBuffer));
}

CallCapture CaptureDebugMessageControlKHR(egl::Thread *thread,
                                          bool isCallValid,
                                          EGLDEBUGPROCKHR callback,
                                          const AttributeMap &attrib_listPacked,
                                          EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("callback", ParamType::TEGLDEBUGPROCKHR, callback);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDebugMessageControlKHR, std::move(paramBuffer));
}

CallCapture CaptureLabelObjectKHR(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *displayPacked,
                                  ObjectType objectTypePacked,
                                  EGLObjectKHR object,
                                  EGLLabelKHR label,
                                  EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("displayPacked", ParamType::Tegl_DisplayPointer, displayPacked);
    paramBuffer.addValueParam("objectTypePacked", ParamType::TObjectType, objectTypePacked);
    paramBuffer.addValueParam("object", ParamType::TEGLObjectKHR, object);
    paramBuffer.addValueParam("label", ParamType::TEGLLabelKHR, label);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLLabelObjectKHR, std::move(paramBuffer));
}

CallCapture CaptureQueryDebugKHR(egl::Thread *thread,
                                 bool isCallValid,
                                 EGLint attribute,
                                 EGLAttrib *value,
                                 EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLAttribPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryDebugKHR, std::move(paramBuffer));
}

CallCapture CaptureClientWaitSyncKHR(egl::Thread *thread,
                                     bool isCallValid,
                                     egl::Display *dpyPacked,
                                     egl::SyncID syncPacked,
                                     EGLint flags,
                                     EGLTimeKHR timeout,
                                     EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("flags", ParamType::TEGLint, flags);
    paramBuffer.addValueParam("timeout", ParamType::TEGLTimeKHR, timeout);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLClientWaitSyncKHR, std::move(paramBuffer));
}

CallCapture CaptureCreateSyncKHR(egl::Thread *thread,
                                 bool isCallValid,
                                 egl::Display *dpyPacked,
                                 EGLenum type,
                                 const AttributeMap &attrib_listPacked,
                                 EGLSyncKHR returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("type", ParamType::TEGLenum, type);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLSyncKHR);
    InitParamValue(ParamType::TEGLSyncKHR, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateSyncKHR, std::move(paramBuffer));
}

CallCapture CaptureDestroySyncKHR(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  egl::SyncID syncPacked,
                                  EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroySyncKHR, std::move(paramBuffer));
}

CallCapture CaptureGetSyncAttribKHR(egl::Thread *thread,
                                    bool isCallValid,
                                    egl::Display *dpyPacked,
                                    egl::SyncID syncPacked,
                                    EGLint attribute,
                                    EGLint *value,
                                    EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLintPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLGetSyncAttribKHR, std::move(paramBuffer));
}

CallCapture CaptureCreateImageKHR(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  gl::ContextID ctxPacked,
                                  EGLenum target,
                                  EGLClientBuffer buffer,
                                  const AttributeMap &attrib_listPacked,
                                  EGLImageKHR returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("ctxPacked", ParamType::TContextID, ctxPacked);
    paramBuffer.addValueParam("target", ParamType::TEGLenum, target);
    paramBuffer.addValueParam("buffer", ParamType::TEGLClientBuffer, buffer);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLImageKHR);
    InitParamValue(ParamType::TEGLImageKHR, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateImageKHR, std::move(paramBuffer));
}

CallCapture CaptureDestroyImageKHR(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   ImageID imagePacked,
                                   EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("imagePacked", ParamType::TImageID, imagePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroyImageKHR, std::move(paramBuffer));
}

CallCapture CaptureLockSurfaceKHR(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  SurfaceID surfacePacked,
                                  const AttributeMap &attrib_listPacked,
                                  EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLLockSurfaceKHR, std::move(paramBuffer));
}

CallCapture CaptureQuerySurface64KHR(egl::Thread *thread,
                                     bool isCallValid,
                                     egl::Display *dpyPacked,
                                     SurfaceID surfacePacked,
                                     EGLint attribute,
                                     EGLAttribKHR *value,
                                     EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLint, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLAttribKHRPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQuerySurface64KHR, std::move(paramBuffer));
}

CallCapture CaptureUnlockSurfaceKHR(egl::Thread *thread,
                                    bool isCallValid,
                                    egl::Display *dpyPacked,
                                    SurfaceID surfacePacked,
                                    EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLUnlockSurfaceKHR, std::move(paramBuffer));
}

CallCapture CaptureSetDamageRegionKHR(egl::Thread *thread,
                                      bool isCallValid,
                                      egl::Display *dpyPacked,
                                      SurfaceID surfacePacked,
                                      EGLint *rects,
                                      EGLint n_rects,
                                      EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("rects", ParamType::TEGLintPointer, rects);
    paramBuffer.addValueParam("n_rects", ParamType::TEGLint, n_rects);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSetDamageRegionKHR, std::move(paramBuffer));
}

CallCapture CaptureSignalSyncKHR(egl::Thread *thread,
                                 bool isCallValid,
                                 egl::Display *dpyPacked,
                                 egl::SyncID syncPacked,
                                 EGLenum mode,
                                 EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("mode", ParamType::TEGLenum, mode);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSignalSyncKHR, std::move(paramBuffer));
}

CallCapture CaptureCreateStreamKHR(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   const AttributeMap &attrib_listPacked,
                                   EGLStreamKHR returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLStreamKHR);
    InitParamValue(ParamType::TEGLStreamKHR, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLCreateStreamKHR, std::move(paramBuffer));
}

CallCapture CaptureDestroyStreamKHR(egl::Thread *thread,
                                    bool isCallValid,
                                    egl::Display *dpyPacked,
                                    egl::Stream *streamPacked,
                                    EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLDestroyStreamKHR, std::move(paramBuffer));
}

CallCapture CaptureQueryStreamKHR(egl::Thread *thread,
                                  bool isCallValid,
                                  egl::Display *dpyPacked,
                                  egl::Stream *streamPacked,
                                  EGLenum attribute,
                                  EGLint *value,
                                  EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLenum, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLintPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryStreamKHR, std::move(paramBuffer));
}

CallCapture CaptureQueryStreamu64KHR(egl::Thread *thread,
                                     bool isCallValid,
                                     egl::Display *dpyPacked,
                                     egl::Stream *streamPacked,
                                     EGLenum attribute,
                                     EGLuint64KHR *value,
                                     EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLenum, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLuint64KHRPointer, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLQueryStreamu64KHR, std::move(paramBuffer));
}

CallCapture CaptureStreamAttribKHR(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   egl::Stream *streamPacked,
                                   EGLenum attribute,
                                   EGLint value,
                                   EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);
    paramBuffer.addValueParam("attribute", ParamType::TEGLenum, attribute);
    paramBuffer.addValueParam("value", ParamType::TEGLint, value);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLStreamAttribKHR, std::move(paramBuffer));
}

CallCapture CaptureStreamConsumerAcquireKHR(egl::Thread *thread,
                                            bool isCallValid,
                                            egl::Display *dpyPacked,
                                            egl::Stream *streamPacked,
                                            EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLStreamConsumerAcquireKHR, std::move(paramBuffer));
}

CallCapture CaptureStreamConsumerGLTextureExternalKHR(egl::Thread *thread,
                                                      bool isCallValid,
                                                      egl::Display *dpyPacked,
                                                      egl::Stream *streamPacked,
                                                      EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLStreamConsumerGLTextureExternalKHR,
                       std::move(paramBuffer));
}

CallCapture CaptureStreamConsumerReleaseKHR(egl::Thread *thread,
                                            bool isCallValid,
                                            egl::Display *dpyPacked,
                                            egl::Stream *streamPacked,
                                            EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLStreamConsumerReleaseKHR, std::move(paramBuffer));
}

CallCapture CaptureSwapBuffersWithDamageKHR(egl::Thread *thread,
                                            bool isCallValid,
                                            egl::Display *dpyPacked,
                                            SurfaceID surfacePacked,
                                            const EGLint *rects,
                                            EGLint n_rects,
                                            EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("rects", ParamType::TEGLintConstPointer, rects);
    paramBuffer.addValueParam("n_rects", ParamType::TEGLint, n_rects);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLSwapBuffersWithDamageKHR, std::move(paramBuffer));
}

CallCapture CaptureWaitSyncKHR(egl::Thread *thread,
                               bool isCallValid,
                               egl::Display *dpyPacked,
                               egl::SyncID syncPacked,
                               EGLint flags,
                               EGLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("syncPacked", ParamType::Tegl_SyncID, syncPacked);
    paramBuffer.addValueParam("flags", ParamType::TEGLint, flags);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLint);
    InitParamValue(ParamType::TEGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLWaitSyncKHR, std::move(paramBuffer));
}

CallCapture CapturePostSubBufferNV(egl::Thread *thread,
                                   bool isCallValid,
                                   egl::Display *dpyPacked,
                                   SurfaceID surfacePacked,
                                   EGLint x,
                                   EGLint y,
                                   EGLint width,
                                   EGLint height,
                                   EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("surfacePacked", ParamType::TSurfaceID, surfacePacked);
    paramBuffer.addValueParam("x", ParamType::TEGLint, x);
    paramBuffer.addValueParam("y", ParamType::TEGLint, y);
    paramBuffer.addValueParam("width", ParamType::TEGLint, width);
    paramBuffer.addValueParam("height", ParamType::TEGLint, height);

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLPostSubBufferNV, std::move(paramBuffer));
}

CallCapture CaptureStreamConsumerGLTextureExternalAttribsNV(egl::Thread *thread,
                                                            bool isCallValid,
                                                            egl::Display *dpyPacked,
                                                            egl::Stream *streamPacked,
                                                            const AttributeMap &attrib_listPacked,
                                                            EGLBoolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("dpyPacked", ParamType::Tegl_DisplayPointer, dpyPacked);
    paramBuffer.addValueParam("streamPacked", ParamType::Tegl_StreamPointer, streamPacked);
    paramBuffer.addParam(CaptureAttributeMap(attrib_listPacked));

    ParamCapture returnValueCapture("returnValue", ParamType::TEGLBoolean);
    InitParamValue(ParamType::TEGLBoolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::EGLStreamConsumerGLTextureExternalAttribsNV,
                       std::move(paramBuffer));
}

}  // namespace egl
