// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Xunit;
// Generated by Fuzzlyn v1.5 on 2023-02-26 16:54:59
// Run on X64 Linux
// Seed: 15812590312404596729
// Note: This test is to make sure we do not remove a 'mov eax, eax' instruction if the trailing instructions like 'cwde' modifies 'eax'.
public class C0
{
    public ulong F2;
    public C0(ulong f2)
    {
        F2 = f2;
    }
}

public class Program
{
    public static ushort s_2;
    public static C0 s_7;
    [Fact]
    public static int TestEntryPoint()
    {
        ulong result = 1234;
        for (int vr0 = 0; vr0 < 2; vr0++)
        {
            s_7 = M5();
            ulong vr1 = s_7.F2;
            result = vr1;
        }

        if (result != 18446744069414584320)
            return 0;

        return 100;
    }

    public static C0 M5()
    {
        return new C0(~(ulong)(4294967295U & (-(1 % (s_2-- | 1)))));
    }
}