// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//
//
//
//  Contents:  Class abstraction of lexical breaks generated by the lexical 
//             service component.
//
//


using System;
using System.Globalization;
using MS.Internal.PresentationCore;


namespace System.Windows.Media.TextFormatting
{
    /// <summary>
    /// Object encapsulating the lexical breaks of text produced by the lexical services
    /// component. TextFormatter uses this info to determine proper line-breaking position
    /// 
    /// TextFormatter may also decide to cache this info for better text formatting 
    /// performance on repeated query of the same character index.
    /// </summary>
#if HYPHENATION_API
    public abstract class TextLexicalBreaks
#else
    [FriendAccessAllowed]   // used by Framework
    internal abstract class TextLexicalBreaks
#endif
    {
        /// <summary>
        /// TextFormatter to query the number of characters represented by this break object
        /// </summary>
        public abstract int Length { get; }


        /// <summary>
        /// TextFormatter to get the break position after the character identified by the character index.
        /// </summary>
        /// <remarks>A break after the speicfied character is identified by the index of that character plus one.</remarks>
        /// <param name="currentIndex">current character index</param>
        /// <returns>character index of the next break. Returning negative index if no break is found.</returns>
        public abstract int GetNextBreak(int currentIndex);


        /// <summary>
        /// TextFormatter to get the break position before the character identified by the character index.
        /// </summary>
        /// <remarks>A break before the speicfied character is identified by the index of that character.</remarks>
        /// <param name="currentIndex">current character index</param>
        /// <returns>character index of the previous break. Returning negative index if no break is found.</returns>
        public abstract int GetPreviousBreak(int currentIndex);
    }
}

