

#ifndef _INS_H
#define _INS_H


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>



#include "CGetParam.h"

#define insOK 1
#define insError -1

#define ANSWER_LENGTH  100

#define FILTERA 0.65
#define DELTAT  1/20

#define   C_PI                     3.1415927
#define   C_TWO_PI                 (C_PI * 2.0)
#define   C_PI_HALF                (C_PI / 2.0)


#define C_TRACE_LEVEL_MENU_ELEMENT_LENGTH 40
#define C_MAX_NO_OF_TRACE_LEVELS          10
#define C_MAX_LIST_STR 20


typedef struct {
  bool      levels[C_MAX_NO_OF_TRACE_LEVELS];
  int       level;
  char      Id[C_MAX_LIST_STR];
  char      sub_unit[C_MAX_LIST_STR];
} m_trace_level;


typedef struct {
  char sub_unit[C_MAX_LIST_STR];
} m_req_trace_levels;


typedef struct {
  bool      level_used;
  char      level_description[C_TRACE_LEVEL_MENU_ELEMENT_LENGTH];
} t_trace_level_menu_element;


typedef struct {
  char                       Id[C_MAX_LIST_STR];
  t_trace_level_menu_element menu[C_MAX_NO_OF_TRACE_LEVELS];
} m_trace_levels_menu;






class Cins
{

public:
  Cins(char *Device,bool ErrorReported, void *rmutex);
  ~Cins();

  void  Serial_Callback(const char* signal,const char* bytes);

  bool  INS_GetBitData();
  bool  INS_GetPositionData(unsigned short int  *Spheroid,
			    short int *Hemisphere,
			    unsigned int *Easting,
			    unsigned int *Northing,
			    short int *Altitude);

  bool  INS_GetPointingDeviceAttitudeData(float *azim,float *tilt,float *roll);
  void  INS_GetVelocityData(float *velazim,float *veltilt,float *velroll);

  int  INS_GetAnswer(int num);
  void INS_GetStatusBit(unsigned short int Status);
  void INS_GetBitData(unsigned short int Status);
  void INS_SetDebug(bool newdebug);
  void INS_SetDebugHangup(bool newdebug);
  bool INS_ERROR();
  bool INS_GetOpenErrorReported(void);

  bool INS_GetDruNeedsZeroVelocityUpdate(void);
  bool INS_GetDruNeedsPositionUpdate(void);
  bool INS_GetBitMalFunction(void);
  bool INS_GetDruAlert(void);
  bool INS_GetDruFailure(void);
  bool INS_GetVmsFailure(void);
  bool INS_GetVmsDriveFailure(void);

  bool   StopWatchDog;
  bool    debug;
  bool   InsUsed;

  char  *DeviceName;
  int    WatchDogSleepTime;
  bool   bTimedOut;

  int datalen;



 private:

  bool    debughangup;
  void*    insWatchDogId;


  CGetParam *myParam;
  bool   StatusBit[16];
  bool   BitData[16];
  bool OpenErrorReported;

  long INSPosLatency;
  long INSAttLatency;
  long INSBitLatency;
  long INSContextSwitchLatency;

  float filterB;
  int   nummeasured;

  float vazim;
  float vtilt;
  float vroll;

  float oldazim;
  float oldtilt;
  float oldroll;


  int Write_Serial(char * msg, int datalen);



};
#endif
