import unittest
from support import GNATCOLL_TestCase, chdir, pathsep, requires_sqlite, requires_postgresql
import os
import sys


class Test(GNATCOLL_TestCase):
    @chdir("sql1")
    def test_sql(self):
        self.runexec(['gnatcoll_db2ada', '-dbmodel', '../descr.txt'])
        self.gprbuild()
        self.runexec("obj/test_sql", "")

    @chdir("sql3")
    def test_sql3(self):
        self.unlink_if_exists(["test.db", "pkg.ads"])
        try:
            self.runexec(["sqlite3", "test.db"], input=file("test.sql").read())
            self.runexec(["gnatcoll_db2ada", "-dbname=test.db",
                          "-dbtype=sqlite", "-api=PKG"])
            self.gprbuild()
        except AssertionError:
            # sqlite3 not found
            pass

    @requires_sqlite
    @chdir("sql2")
    def test_sql2(self):
        try:
            os.unlink("tmp.db")
        except:
            pass

        # Create a tmp sqlite database
        self.runexec(['gnatcoll_db2ada',
                      '-dbmodel', '../descr.txt',
                      '-dbname', 'tmp.db',
                      '-dbtype', 'sqlite',
                      '-createdb'])
        self.runexec(['sqlite3', 'tmp.db'],
                     input="INSERT INTO config VALUES (0,'f');")
        # Extra info from it, to check that "max(id)" is correctly
        # interpreted. Also check that we know how to read the
        # schema from a live sqlite database.
        self.runexec(['gnatcoll_db2ada',
                      '-dbmodel', '../descr.txt',
                      '-dbname', 'tmp.db',
                      '-dbtype', 'sqlite',
                      '-api', 'DB',
                      '-enum', 'config,id,id,config_enum,',
                      '-var', 'max_config,config,max(id),,'])

        self.diff('db.ads.out', file('db.ads').read())

    @requires_sqlite
    @chdir("prepared")
    def test_prepared(self):
        self.unlink_if_exists("test.db")
        self.runexec(['gnatcoll_db2ada', '-dbmodel', 'dbschema.txt',
                      '-api', 'dbschema'])
        self.gprbuild()
        self.runexec("obj/prepared", "test.out")

    @requires_sqlite
    @chdir("../../examples/library")
    def test_check_doc(self):
        """Run the library example from the doc to detect errors"""
        self.runexec(["sh", "./build.sh"])

    @requires_postgresql
    @chdir("prepared_postgres")
    def test_postgres_prepared(self):
        self.runexec(['gnatcoll_db2ada',
                      '-dbmodel', '../prepared/dbschema.txt',
                      '-api', 'dbschema'])
        self.gprbuild()
        self.runexec("obj/preparedpsql", "test.out")

    @chdir("orm")
    def test_orm(self):
        os.environ["PATH"] = "." + pathsep + os.getenv("PATH")
        self.runexec(["gnatcoll_db2ada", "-orm=Queries",
                      "-api=ORM_Database", "-dbmodel=descr.txt"])
        self.runexec(["gnatcoll_db2ada", "-dot",
                      "-dbmodel=descr.txt",
                      "Group1:red:elements,properties"],
                    "test.out")
        self.gprbuild()

    @chdir("orm_views")
    def test_orm_views(self):
        os.environ["PATH"] = "." + pathsep + os.getenv("PATH")
        self.runexec(["gnatcoll_db2ada", "-orm=Queries",
                      "-api=ORM_Database", "-dbmodel=descr.txt"])
        self.gprbuild()

    @chdir("json")
    def test_json(self):
        self.runexec(["gnatcoll_db2ada", "-orm=Queries",
                      "-api=DB", "-dbmodel=descr.txt"])
        self.gprbuild()

    # requires -lpthread on command line
    @requires_sqlite
    @chdir("check_sqlite")
    def DISABLED_test_check_sqlite(self):
        self.gprbuild()
        self.runexec("sqlite_test", "")

