#include <cstddef>

// See http://en.wikibooks.org/wiki/C%2B%2B_Programming/Operators/Operator_Overloading

class Bar {

   // Assignment operator
   int operator=(Bar a);

   // Subscript operator
   Bar operator[](int c);
   
   // Function call operator
   Bar operator()();

   // Smart pointer operators
   Bar operator&();
   Bar operator*();
   Bar* operator->();
   
   // Member access operators
   Bar* operator->() const;

   // Conversion operators
   operator int() const;
   operator float() const;
};

// Arithmetic operators
Bar operator+(Bar a, Bar b);
Bar operator+(Bar a);
Bar operator-(Bar a, Bar b);
Bar operator-(Bar a);
Bar operator/(Bar a, Bar b);
Bar operator*(Bar a, Bar b);
Bar operator%(Bar a, int modulus);

// Bitwise operators
Bar operator^(Bar a, Bar b);   //  Xor
Bar operator|(Bar a, Bar b);   //  or
Bar operator&(Bar a, Bar b);   //  and
Bar operator~(Bar a);          //  complement
Bar operator<<(Bar a, int b);  //  shift left
Bar operator>>(Bar a, int b);  //  shift right

// Relational operators
int operator<(Bar a, Bar b);
int operator<=(Bar a, Bar b);
int operator>(Bar a, Bar b);
int operator>=(Bar a, Bar b);
int operator==(Bar a, Bar b);
int operator!=(Bar a, Bar b);

// Logical operators
bool operator!(Bar a);         // not
bool operator&&(Bar a, Bar b); // and
bool operator||(Bar a, Bar b); // or

// Compound assignment operators
Bar operator+=(Bar a, Bar b);  //  addition assignment
Bar operator-=(Bar a, Bar b);  //  substraction assignment
Bar operator*=(Bar a, Bar b);  //  multiplication assignment
Bar operator/=(Bar a, Bar b);  //  division assignment
Bar operator%=(Bar a, Bar b);  //  modulus assignment
Bar operator&=(Bar a, Bar b);  //  and assignment
Bar operator|=(Bar a, Bar b);  //  or assignment
Bar operator^=(Bar a, Bar b);  //  xor assignment
Bar operator<<=(Bar a, Bar b); //  shift-left assignment
Bar operator>>=(Bar a, Bar b); //  shift-right assignment

// Increment and decrement operators
void operator++(Bar a);
void operator--(Bar a);

// Comma operator
Bar operator,(Bar const &, Bar const &);

// Member access operators
Bar* operator->*(Bar a, Bar b);

// Memory management operators
void* operator new(size_t size);
void operator delete(void* a);
void* operator new     [](size_t size);
void operator delete         [](void* a);
