export{"ipp"}

ipp = method()
ipp (Ring) := kk -> (
    x := symbol x;
    R := kk[x_1..x_8];
   { x_1^2+x_2^2-1,
       x_3^2+x_4^2-1,
       x_5^2+x_6^2-1,
       x_7^2+x_8^2-1,
       -2.49150680000000e-01*x_1*x_3+ 1.60913540000000*x_1*x_4+ 2.79423430000000e-01*x_2*x_3+ 1.43480160000000*x_2*x_4+ 4.00263840000000e-01*x_5*x_8-8.00527680000000e-01*x_6*x_7+ 7.40523880000000e-02*x_1-8.30500310000000e-02*x_2-3.86159610000000e-01*x_3-7.55266030000000e-01*x_4+ 5.04201680000000e-01*x_5-1.09162870000000*x_6+ 4.00263840000000e-01*x_8+ 4.92072900000000e-02,
       1.25016350000000e-01*x_1*x_3-6.86607360000000e-01*x_1*x_4-1.19228120000000e-01*x_2*x_3-7.19940470000000e-01*x_2*x_4-4.32419270000000e-01*x_5*x_7-8.64838550000000e-01*x_6*x_8-3.71572700000000e-02*x_1+ 3.54368960000000e-02*x_2+8.53834820000000e-02*x_3-3.92519670000000e-02*x_5-4.32419270000000e-01*x_7+1.38730100000000e-02,
       -6.35550070000000e-01*x_1*x_3-1.15719920000000e-01*x_1*x_4-6.66404480000000e-01*x_2*x_3+ 1.10362110000000e-01*x_2*x_4+ 2.90702030000000e-01*x_5*x_7+1.25877670000000*x_5*x_8-6.29388360000000e-01*x_6*x_7+ 5.81404060000000e-01*
       x_6*x_8+ 1.95946620000000e-01*x_1-1.22803420000000*x_2-7.90342210000000e-02*x_4+ 2.63878770000000e-02*x_5-5.71314300000000e-02*x_6-1.16280810000000*x_7+1.25877670000000*x_8+ 2.16257500000000,
       1.489477300*x_1*x_3+ 2.30623410000000e-01*x_1*x_4+ 1.32810730000000*x_2*x_3-2.58645030000000e-01*x_2*x_4+ 1.16517200000000*x_5*x_7-2.69084940000000e-01*x_5*x_8+ 5.38169870000000e-01*x_6*x_7+ 5.82585980000000e-01*x_6*x_8-2.08169850000000e-01*x_1+ 2.68683200000000*x_2-6.99103170000000e-01*x_3+ 3.57444130000000e-01*x_4+ 1.24991170000000*x_5+ 1.46773600000000*x_6+ 1.16517200000000*x_7+ 1.10763397000000*x_8-6.96868090000000e-01
    }					
 )

    beginDocumentation()

doc /// 
    Key
    	ipp
	(ipp,Ring)
    Headline
    	six-revolute-joint problem of mechanics
    Usage
    	ipp(kk)
    Inputs
    	kk:Ring
	    the coefficient ring
    Outputs
    	:List
	    of the polynomials in the system 
    Description
    	Text
	    This system was solved in May 2020, using @TO solveSystem@ in Macaulay2 v1.15
	     with an Intel(R) Core(TM) i5-5250U CPU at 1.60GHz.
	   
	    There were 48 solutions found in 1.708 seconds (with a Bezout bound of 256).
	     
	    Reference: "Computing all solutions to polynomial systems using
	     homotopy continuation" by A. Morgan and A. Sommese (pages 115-138).
	     
	    See also: http://homepages.math.uic.edu/~jan/Demo/ipp.html.
	Example
	    ipp(RR_53)
    ///