// Copyright (C) 2017 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: prod-NumericLiteralSeparator
description: NumericLiteralSeparator is not valid on string conversions for ToNumber operations
info: |
  `0b` | `0B` BinaryDigit NumericLiteralSeparator BinaryDigit

  NumericLiteralSeparator ::
    _

  BinaryIntegerLiteral ::
    0b BinaryDigits
    0B BinaryDigits

  BinaryDigits ::
    BinaryDigit
    BinaryDigits BinaryDigit
    BinaryDigits NumericLiteralSeparator BinaryDigit

  BinaryDigit :: one of
    0 1

features: [numeric-separator-literal]
---*/

assert.sameValue(Number("0b0_10"), NaN, "0b0_10");
assert.sameValue(Number("0B0_10"), NaN, "0B0_10");

reportCompare(0, 0);
