#ifndef __QZIONCOMMON_H__
#define __QZIONCOMMON_H__

#include <QPoint>
#include <QColor>
#include <QMouseEvent>
#include <QGraphicsSceneMouseEvent>


/*!
  \internal

  Composes two colors and returns the final color.
*/
static inline QColor composeColorClass(QColor cc, QColor cn)
{
    int cc_r, cc_g, cc_b, cc_a;
    int cn_r, cn_g, cn_b, cn_a;

    cc.getRgb(&cc_r, &cc_g, &cc_b, &cc_a);
    cn.getRgb(&cn_r, &cn_g, &cn_b, &cn_a);

    int r = ((cc_r + 1) * cn_r) >> 8;
    int g = ((cc_g + 1) * cn_g) >> 8;
    int b = ((cc_b + 1) * cn_b) >> 8;
    int a = ((cc_a + 1) * cn_a) >> 8;
    return QColor(r, g, b, a);
}


#define QZINIT(class_name, cv) {                                        \
        _##class_name##_data = new class_name##Private(0);              \
        _QZionObject_data->item = this->_##class_name##_data;           \
        _##class_name##_data->owner = this;                             \
        if (cv) cv->addObject(this);                                    \
    }


#define QZDELETE(class_name) delete this->_##class_name##_data;


#define QGV_EFFECTIVE_SHAPE(class_name)                            \
    virtual QPainterPath shape() const                             \
    {                                                              \
        if (owner->clipper()) {                                    \
            QRect baseClipper = owner->clipper()->effectiveRect(); \
            QRect paintClipper = boundingRect().toRect() &         \
                baseClipper.translated(-owner->pos());             \
            QPainterPath path;                                     \
            path.addRect(paintClipper);                            \
            return path;                                           \
        } else {                                                   \
            return class_name::shape();                            \
        }                                                          \
    };


#define QGV_MOUSE_EVENT_HANDLERS()                                      \
    void mousePressEvent(QGraphicsSceneMouseEvent *) {}                \
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *) {}              \
    void hoverMoveEvent(QGraphicsSceneHoverEvent *) {}

#endif
